/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.response.steps;

import java.time.Duration;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.BuilderStep;
import org.grpcmock.definitions.response.Delay;

public interface DelayBuilderStep<BUILDER extends BuilderStep>
extends BuilderStep {
    public BUILDER withDelay(@Nonnull Delay var1);

    default public BUILDER withFixedDelay(long milliseconds) {
        return this.withDelay(Delay.fixedDelay(milliseconds));
    }

    default public BUILDER withFixedDelay(Duration duration) {
        return this.withDelay(Delay.fixedDelay(duration.toMillis()));
    }

    default public BUILDER withRandomDelay(long minMilliseconds, long maxMilliseconds) {
        return this.withDelay(Delay.randomDelay(minMilliseconds, maxMilliseconds));
    }

    default public BUILDER withRandomDelay(Duration minDuration, Duration maxDuration) {
        return this.withDelay(Delay.randomDelay(minDuration.toMillis(), maxDuration.toMillis()));
    }

    default public BUILDER withRandomDelay(long maxMilliseconds) {
        return this.withRandomDelay(0L, maxMilliseconds);
    }

    default public BUILDER withRandomDelay(Duration maxDuration) {
        return this.withRandomDelay(Duration.ZERO, maxDuration);
    }
}

