/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.internal;

import java.net.URL;
import java.util.Map;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.TimeoutBehaviorConfiguration;
import org.hibernate.boot.spi.SessionFactoryOptions;

public final class HibernateEhcacheUtils {
    private HibernateEhcacheUtils() {
    }

    public static Configuration loadAndCorrectConfiguration(URL url) {
        Configuration config = ConfigurationFactory.parseConfiguration((URL)url);
        if (config == null) {
            return null;
        }
        if (config.getDefaultCacheConfiguration() != null && config.getDefaultCacheConfiguration().isTerracottaClustered()) {
            HibernateEhcacheUtils.setupHibernateTimeoutBehavior(config.getDefaultCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration());
        }
        for (CacheConfiguration cacheConfig : config.getCacheConfigurations().values()) {
            if (!cacheConfig.isTerracottaClustered()) continue;
            HibernateEhcacheUtils.setupHibernateTimeoutBehavior(cacheConfig.getTerracottaConfiguration().getNonstopConfiguration());
        }
        return config;
    }

    static void setCacheManagerNameIfNeeded(SessionFactoryOptions settings, Configuration configuration, Map properties) {
        HibernateEhcacheUtils.overwriteCacheManagerIfConfigured(configuration, properties);
        if (configuration.getName() == null) {
            String sessionFactoryName = settings.getSessionFactoryName();
            if (sessionFactoryName != null) {
                configuration.setName(sessionFactoryName);
            } else {
                configuration.setName("Hibernate " + settings.getUuid());
            }
        }
    }

    static Configuration overwriteCacheManagerIfConfigured(Configuration configuration, Map properties) {
        String cacheManagerName;
        if (properties != null && (cacheManagerName = (String)properties.get("net.sf.ehcache.cacheManagerName")) != null) {
            configuration.setName(cacheManagerName);
        }
        return configuration;
    }

    private static void setupHibernateTimeoutBehavior(NonstopConfiguration nonstopConfig) {
        nonstopConfig.getTimeoutBehavior().setType(TimeoutBehaviorConfiguration.TimeoutBehaviorType.EXCEPTION.getTypeName());
    }
}

