/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query;

import org.hibernate.envers.RevisionType;
import org.hibernate.envers.query.criteria.AuditConjunction;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.AuditDisjunction;
import org.hibernate.envers.query.criteria.AuditId;
import org.hibernate.envers.query.criteria.AuditProperty;
import org.hibernate.envers.query.criteria.AuditRelatedId;
import org.hibernate.envers.query.criteria.internal.LogicalAuditExpression;
import org.hibernate.envers.query.criteria.internal.NotAuditExpression;
import org.hibernate.envers.query.internal.property.EntityPropertyName;
import org.hibernate.envers.query.internal.property.RevisionNumberPropertyName;
import org.hibernate.envers.query.internal.property.RevisionPropertyPropertyName;
import org.hibernate.envers.query.internal.property.RevisionTypePropertyName;
import org.hibernate.envers.query.projection.AuditProjection;
import org.hibernate.envers.query.projection.internal.EntityAuditProjection;

public class AuditEntity {
    private AuditEntity() {
    }

    public static AuditId id() {
        return AuditEntity.id(null);
    }

    public static AuditId id(String alias) {
        return new AuditId(alias);
    }

    public static AuditProperty<Object> property(String propertyName) {
        return AuditEntity.property(null, propertyName);
    }

    public static AuditProperty<Object> property(String alias, String propertyName) {
        return new AuditProperty<Object>(alias, new EntityPropertyName(propertyName));
    }

    public static AuditProperty<Number> revisionNumber() {
        return AuditEntity.revisionNumber(null);
    }

    public static AuditProperty<Number> revisionNumber(String alias) {
        return new AuditProperty<Number>(alias, new RevisionNumberPropertyName());
    }

    public static AuditProperty<Object> revisionProperty(String propertyName) {
        return AuditEntity.revisionProperty(null, propertyName);
    }

    public static AuditProperty<Object> revisionProperty(String alias, String propertyName) {
        return new AuditProperty<Object>(alias, new RevisionPropertyPropertyName(propertyName));
    }

    public static AuditProperty<RevisionType> revisionType() {
        return AuditEntity.revisionType(null);
    }

    public static AuditProperty<RevisionType> revisionType(String alias) {
        return new AuditProperty<RevisionType>(alias, new RevisionTypePropertyName());
    }

    public static AuditRelatedId relatedId(String propertyName) {
        return AuditEntity.relatedId(null, propertyName);
    }

    public static AuditRelatedId relatedId(String alias, String propertyName) {
        return new AuditRelatedId(alias, new EntityPropertyName(propertyName));
    }

    public static AuditCriterion and(AuditCriterion lhs, AuditCriterion rhs) {
        return new LogicalAuditExpression(lhs, rhs, "and");
    }

    public static AuditCriterion or(AuditCriterion lhs, AuditCriterion rhs) {
        return new LogicalAuditExpression(lhs, rhs, "or");
    }

    public static AuditCriterion not(AuditCriterion expression) {
        return new NotAuditExpression(expression);
    }

    public static AuditConjunction conjunction() {
        return new AuditConjunction();
    }

    public static AuditDisjunction disjunction() {
        return new AuditDisjunction();
    }

    public static AuditProjection selectEntity(boolean distinct) {
        return new EntityAuditProjection(null, distinct);
    }
}

