/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;

public class DefaultDatabaseCollector
implements DatabaseCollector {
    Map tables = new HashMap();
    Map qualifiers = new HashMap();
    private Map oneToManyCandidates;

    public Iterator iterateTables() {
        return this.tables.values().iterator();
    }

    public Table addTable(String schema, String catalog, String name) {
        String key = Table.qualify((String)catalog, (String)schema, (String)name);
        Table table = (Table)this.tables.get(key);
        if (table == null) {
            table = new Table();
            table.setAbstract(false);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            this.tables.put(key, table);
            String qualifier = StringHelper.qualifier((String)key);
            ArrayList<Table> schemaList = (ArrayList<Table>)this.qualifiers.get(qualifier);
            if (schemaList == null) {
                schemaList = new ArrayList<Table>();
                this.qualifiers.put(qualifier, schemaList);
            }
            schemaList.add(table);
        } else {
            table.setAbstract(false);
        }
        return table;
    }

    public void setOneToManyCandidates(Map oneToManyCandidates) {
        this.oneToManyCandidates = oneToManyCandidates;
    }

    public Table getTable(String schema, String catalog, String name) {
        String key = Table.qualify((String)catalog, (String)schema, (String)name);
        return (Table)this.tables.get(key);
    }

    public Map getOneToManyCandidates() {
        return this.oneToManyCandidates;
    }

    public Iterator getQualifierEntries() {
        return this.qualifiers.entrySet().iterator();
    }

    static class TableContainer {
        List tables = new ArrayList();

        TableContainer() {
        }
    }
}

