/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.tool.hbm2x.ArtifactCollector;
import org.hibernate.tool.hbm2x.ExporterException;
import org.hibernate.tool.hbm2x.TemplateHelper;

public class TemplateProducer {
    private static final Log log = LogFactory.getLog((Class)TemplateProducer.class);
    private final TemplateHelper th;
    private ArtifactCollector ac;

    public TemplateProducer(TemplateHelper th, ArtifactCollector ac) {
        this.th = th;
        this.ac = ac;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void produce(Map additionalContext, String templateName, File destination, String identifier, String fileType) {
        String tempResult = this.produceToString(additionalContext, templateName);
        if (tempResult.trim().length() == 0) {
            log.warn((Object)("Generated output is empty. Skipped creation for file " + destination));
            return;
        }
        OutputStreamWriter fileWriter = null;
        this.th.ensureExistence(destination);
        this.ac.addFile(destination, fileType);
        log.debug((Object)("Writing " + identifier + " to " + destination.getAbsolutePath()));
        fileWriter = new FileWriter(destination);
        fileWriter.write(tempResult);
        Object var10_8 = null;
        if (fileWriter == null) return;
        try {
            fileWriter.flush();
            fileWriter.close();
            return;
        }
        catch (IOException e) {
            log.warn((Object)("Exception while flushing/closing " + destination), (Throwable)e);
        }
        return;
        {
            catch (Exception e) {
                throw new ExporterException("Error while writing result to file", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.flush();
                fileWriter.close();
                throw throwable;
            }
            catch (IOException e) {
                log.warn((Object)("Exception while flushing/closing " + destination), (Throwable)e);
            }
            throw throwable;
        }
    }

    private String produceToString(Map additionalContext, String templateName) {
        Map contextForFirstPass = additionalContext;
        this.putInContext(this.th, contextForFirstPass);
        StringWriter tempWriter = new StringWriter();
        BufferedWriter bw = new BufferedWriter(tempWriter);
        this.th.processTemplate(templateName, bw);
        this.removeFromContext(this.th, contextForFirstPass);
        try {
            bw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while flushing to string", e);
        }
        return tempWriter.toString();
    }

    private void removeFromContext(TemplateHelper th, Map context) {
        Iterator iterator = context.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element = iterator.next();
            th.removeFromContext((String)element.getKey(), element.getValue());
        }
    }

    private void putInContext(TemplateHelper th, Map context) {
        Iterator iterator = context.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element = iterator.next();
            th.putInContext((String)element.getKey(), element.getValue());
        }
    }

    public void produce(Map additionalContext, String templateName, File outputFile, String identifier) {
        String fileType = outputFile.getName();
        fileType = fileType.substring(fileType.indexOf(46) + 1);
        this.produce(additionalContext, templateName, outputFile, identifier, fileType);
    }
}

