/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.doc;

import java.io.File;
import java.util.List;
import org.hibernate.tool.hbm2x.doc.DocFolder;

public class DocFile {
    private String name;
    private DocFolder folder;
    private File file;

    public DocFile(String pName, DocFolder pFolder) {
        if (pName == null) {
            throw new IllegalArgumentException("The name cannot be null");
        }
        if (pFolder == null) {
            throw new IllegalArgumentException("The parent folder cannot be null");
        }
        this.name = pName;
        this.folder = pFolder;
        this.file = new File(this.folder.getFile(), pName);
    }

    public String getName() {
        return this.name;
    }

    public DocFolder getFolder() {
        return this.folder;
    }

    public File getFile() {
        return this.file;
    }

    public List getPathFolders() {
        return this.folder.getPathFolders();
    }

    private String buildRefFromFolder(DocFolder folder) {
        StringBuffer result = new StringBuffer();
        List folders = this.getPathFolders();
        int index = folders.indexOf(folder);
        if (index == -1) {
            throw new IllegalArgumentException("The specified folder is not on this file's path: " + folder);
        }
        ++index;
        while (index < folders.size()) {
            DocFolder f = (DocFolder)folders.get(index);
            result.append(f.getName() + '/');
            ++index;
        }
        result.append(this.getName());
        return result.toString();
    }

    public String buildRefTo(DocFile target) {
        List tgtFileFolders = target.getPathFolders();
        StringBuffer ref = new StringBuffer();
        for (DocFolder parentFolder = this.folder; parentFolder != null; parentFolder = parentFolder.getParent()) {
            if (tgtFileFolders.contains(parentFolder)) {
                ref.append(target.buildRefFromFolder(parentFolder));
                String result = ref.toString();
                return result;
            }
            ref.append("../");
        }
        throw new IllegalArgumentException("No parent folder in common");
    }

    public String toString() {
        return this.name;
    }
}

