/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.checks;

import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.util.Types;
import org.hibernate.validator.ap.checks.AnnotationTypeCheck;
import org.hibernate.validator.ap.checks.AnnotationTypeMemberCheck;
import org.hibernate.validator.ap.checks.ConstraintCheck;
import org.hibernate.validator.ap.checks.ConstraintChecks;
import org.hibernate.validator.ap.checks.ConstraintValidatorCheck;
import org.hibernate.validator.ap.checks.GetterCheck;
import org.hibernate.validator.ap.checks.GroupSequenceProviderCheck;
import org.hibernate.validator.ap.checks.MultiValuedChecks;
import org.hibernate.validator.ap.checks.PrimitiveCheck;
import org.hibernate.validator.ap.checks.RetentionPolicyCheck;
import org.hibernate.validator.ap.checks.SingleValuedChecks;
import org.hibernate.validator.ap.checks.StaticCheck;
import org.hibernate.validator.ap.checks.TargetCheck;
import org.hibernate.validator.ap.checks.TypeCheck;
import org.hibernate.validator.ap.util.AnnotationApiHelper;
import org.hibernate.validator.ap.util.CollectionHelper;
import org.hibernate.validator.ap.util.ConstraintHelper;

public class ConstraintCheckFactory {
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> fieldChecks;
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> methodChecks;
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> annotationTypeChecks;
    private final Map<ConstraintHelper.AnnotationType, ConstraintChecks> nonAnnotationTypeChecks;
    private ConstraintHelper constraintHelper;
    private static final SingleValuedChecks NULL_CHECKS = new SingleValuedChecks(new ConstraintCheck[0]);

    public ConstraintCheckFactory(Types typeUtils, ConstraintHelper constraintHelper, AnnotationApiHelper annotationApiHelper, boolean methodConstraintsSupported) {
        this.constraintHelper = constraintHelper;
        this.fieldChecks = CollectionHelper.newHashMap();
        this.fieldChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new StaticCheck(), new TypeCheck(constraintHelper)));
        this.fieldChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new StaticCheck(), new TypeCheck(constraintHelper)));
        this.fieldChecks.put(ConstraintHelper.AnnotationType.GRAPH_VALIDATION_ANNOTATION, new SingleValuedChecks(new StaticCheck(), new PrimitiveCheck()));
        this.fieldChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.methodChecks = CollectionHelper.newHashMap();
        this.methodChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new GetterCheck(methodConstraintsSupported), new StaticCheck(), new TypeCheck(constraintHelper)));
        this.methodChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new GetterCheck(methodConstraintsSupported), new StaticCheck(), new TypeCheck(constraintHelper)));
        this.methodChecks.put(ConstraintHelper.AnnotationType.GRAPH_VALIDATION_ANNOTATION, new SingleValuedChecks(new GetterCheck(methodConstraintsSupported), new StaticCheck(), new PrimitiveCheck()));
        this.methodChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.annotationTypeChecks = CollectionHelper.newHashMap();
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new AnnotationTypeCheck(constraintHelper)));
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new AnnotationTypeCheck(constraintHelper)));
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_META_ANNOTATION, new SingleValuedChecks(new RetentionPolicyCheck(annotationApiHelper), new TargetCheck(annotationApiHelper), new ConstraintValidatorCheck(constraintHelper, annotationApiHelper), new AnnotationTypeMemberCheck(annotationApiHelper, typeUtils)));
        this.annotationTypeChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.nonAnnotationTypeChecks = CollectionHelper.newHashMap();
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.CONSTRAINT_ANNOTATION, new SingleValuedChecks(new TypeCheck(constraintHelper)));
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.MULTI_VALUED_CONSTRAINT_ANNOTATION, new MultiValuedChecks(constraintHelper, new TypeCheck(constraintHelper)));
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.NO_CONSTRAINT_ANNOTATION, NULL_CHECKS);
        this.nonAnnotationTypeChecks.put(ConstraintHelper.AnnotationType.GROUP_SEQUENCE_PROVIDER_ANNOTATION, new SingleValuedChecks(new GroupSequenceProviderCheck(annotationApiHelper, typeUtils)));
    }

    public ConstraintChecks getConstraintChecks(Element annotatedElement, AnnotationMirror annotation) {
        ConstraintHelper.AnnotationType annotationType = this.constraintHelper.getAnnotationType(annotation);
        switch (annotatedElement.getKind()) {
            case FIELD: {
                return this.fieldChecks.get((Object)annotationType);
            }
            case METHOD: {
                return this.methodChecks.get((Object)annotationType);
            }
            case ANNOTATION_TYPE: {
                return this.annotationTypeChecks.get((Object)annotationType);
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: {
                return this.nonAnnotationTypeChecks.get((Object)annotationType);
            }
        }
        return NULL_CHECKS;
    }
}

