// $ANTLR 3.4 org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g 2016-08-09 12:19:09

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.hql.ast.origin.hql.resolve;

import org.antlr.runtime.tree.CommonTree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.tree.PropertyPathTree;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class GeneratedHQLResolver extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "A", "ABS", "ALIAS_NAME", "ALIAS_REF", "ALL", "AMPERSAND", "AND", "ANY", "ARROW", "AS", "ASTERISK", "AVG", "B", "BETWEEN", "BETWEEN_LIST", "BIT_LENGTH", "BOTH", "C", "CAST", "CHARACTER_LENGTH", "CHARACTER_LITERAL", "CLASS", "COALESCE", "COLLATE", "COLLECTION_EXPRESSION", "COLON", "COLUMN", "COLUMN_LIST", "COMMA", "CONCAT", "CONST_STRING_VALUE", "COUNT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "D", "DAY", "DECIMAL_LITERAL", "DELETE", "DISTINCT", "DOT", "DOT_CLASS", "DOUBLE_PIPE", "DYNAMIC_INSTANTIATION", "DYNAMIC_INSTANTIATION_ARG", "E", "ELEMENTS", "ELSE", "END", "ENTITY_NAME", "ENTITY_PERSISTER_REF", "EOL", "EQUALS", "ESCAPE", "ESCAPE_SEQUENCE", "EXCEPT", "EXISTS", "EXPONENT", "EXTRACT", "F", "FALSE", "FETCH", "FILTER", "FLOATING_POINT_LITERAL", "FLOAT_TYPE_SUFFIX", "FROM", "FULL", "FUNCTION", "G", "GREATER", "GREATER_EQUAL", "GROUPING_VALUE", "GROUP_BY", "H", "HAVING", "HEX_DIGIT", "HEX_LITERAL", "HOUR", "I", "IDENTIFIER", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSERTABILITY_SPEC", "INTEGER_LITERAL", "INTEGER_TYPE_SUFFIX", "INTERSECT", "INTO", "IN_LIST", "IS", "IS_EMPTY", "IS_NOT_EMPTY", "IS_NOT_NULL", "IS_NULL", "J", "JAVA_CONSTANT", "JOIN", "JPA_PARAM", "K", "L", "LEADING", "LEFT", "LEFT_PAREN", "LEFT_SQUARE", "LENGTH", "LESS", "LESS_EQUAL", "LIKE", "LOCATE", "LOWER", "M", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER_OF", "MIN", "MINELEMENT", "MININDEX", "MINUS", "MINUTE", "MOD", "MONTH", "N", "NAMED_PARAM", "NEW", "NOT", "NOT_BETWEEN", "NOT_EQUAL", "NOT_IN", "NOT_LIKE", "NOT_MEMBER_OF", "NULL", "NULLIF", "O", "OCTAL_ESCAPE", "OCTAL_LITERAL", "OCTET_LENGTH", "ON", "OR", "ORDER_BY", "ORDER_SPEC", "OUTER", "P", "PARAM", "PATH", "PERCENT", "PERSISTER_JOIN", "PERSISTER_SPACE", "PIPE", "PLUS", "POSITION", "PROPERTIES", "PROPERTY_JOIN", "PROPERTY_REFERENCE", "PROP_FETCH", "Q", "QUALIFIED_JOIN", "QUERY", "QUERY_SPEC", "QUOTED_IDENTIFIER", "R", "RIGHT", "RIGHT_PAREN", "RIGHT_SQUARE", "S", "SEARCHED_CASE", "SECOND", "SELECT", "SELECT_FROM", "SELECT_ITEM", "SELECT_LIST", "SEMICOLON", "SET", "SIMPLE_CASE", "SIZE", "SOLIDUS", "SOME", "SORT_SPEC", "SQRT", "STRING_LITERAL", "SUBSTRING", "SUB_QUERY", "SUM", "T", "TABLE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRIM", "TRUE", "U", "UNARY_MINUS", "UNARY_PLUS", "UNICODE_ESCAPE", "UNION", "UPDATE", "UPPER", "V", "VECTOR_EXPR", "VERSIONED", "VERSIONED_VALUE", "W", "WHEN", "WHERE", "WITH", "WS", "X", "Y", "YEAR", "Z"
    };

    public static final int EOF=-1;
    public static final int A=4;
    public static final int ABS=5;
    public static final int ALIAS_NAME=6;
    public static final int ALIAS_REF=7;
    public static final int ALL=8;
    public static final int AMPERSAND=9;
    public static final int AND=10;
    public static final int ANY=11;
    public static final int ARROW=12;
    public static final int AS=13;
    public static final int ASTERISK=14;
    public static final int AVG=15;
    public static final int B=16;
    public static final int BETWEEN=17;
    public static final int BETWEEN_LIST=18;
    public static final int BIT_LENGTH=19;
    public static final int BOTH=20;
    public static final int C=21;
    public static final int CAST=22;
    public static final int CHARACTER_LENGTH=23;
    public static final int CHARACTER_LITERAL=24;
    public static final int CLASS=25;
    public static final int COALESCE=26;
    public static final int COLLATE=27;
    public static final int COLLECTION_EXPRESSION=28;
    public static final int COLON=29;
    public static final int COLUMN=30;
    public static final int COLUMN_LIST=31;
    public static final int COMMA=32;
    public static final int CONCAT=33;
    public static final int CONST_STRING_VALUE=34;
    public static final int COUNT=35;
    public static final int CROSS=36;
    public static final int CURRENT_DATE=37;
    public static final int CURRENT_TIME=38;
    public static final int CURRENT_TIMESTAMP=39;
    public static final int D=40;
    public static final int DAY=41;
    public static final int DECIMAL_LITERAL=42;
    public static final int DELETE=43;
    public static final int DISTINCT=44;
    public static final int DOT=45;
    public static final int DOT_CLASS=46;
    public static final int DOUBLE_PIPE=47;
    public static final int DYNAMIC_INSTANTIATION=48;
    public static final int DYNAMIC_INSTANTIATION_ARG=49;
    public static final int E=50;
    public static final int ELEMENTS=51;
    public static final int ELSE=52;
    public static final int END=53;
    public static final int ENTITY_NAME=54;
    public static final int ENTITY_PERSISTER_REF=55;
    public static final int EOL=56;
    public static final int EQUALS=57;
    public static final int ESCAPE=58;
    public static final int ESCAPE_SEQUENCE=59;
    public static final int EXCEPT=60;
    public static final int EXISTS=61;
    public static final int EXPONENT=62;
    public static final int EXTRACT=63;
    public static final int F=64;
    public static final int FALSE=65;
    public static final int FETCH=66;
    public static final int FILTER=67;
    public static final int FLOATING_POINT_LITERAL=68;
    public static final int FLOAT_TYPE_SUFFIX=69;
    public static final int FROM=70;
    public static final int FULL=71;
    public static final int FUNCTION=72;
    public static final int G=73;
    public static final int GREATER=74;
    public static final int GREATER_EQUAL=75;
    public static final int GROUPING_VALUE=76;
    public static final int GROUP_BY=77;
    public static final int H=78;
    public static final int HAVING=79;
    public static final int HEX_DIGIT=80;
    public static final int HEX_LITERAL=81;
    public static final int HOUR=82;
    public static final int I=83;
    public static final int IDENTIFIER=84;
    public static final int IN=85;
    public static final int INDEX=86;
    public static final int INDICES=87;
    public static final int INNER=88;
    public static final int INSERT=89;
    public static final int INSERTABILITY_SPEC=90;
    public static final int INTEGER_LITERAL=91;
    public static final int INTEGER_TYPE_SUFFIX=92;
    public static final int INTERSECT=93;
    public static final int INTO=94;
    public static final int IN_LIST=95;
    public static final int IS=96;
    public static final int IS_EMPTY=97;
    public static final int IS_NOT_EMPTY=98;
    public static final int IS_NOT_NULL=99;
    public static final int IS_NULL=100;
    public static final int J=101;
    public static final int JAVA_CONSTANT=102;
    public static final int JOIN=103;
    public static final int JPA_PARAM=104;
    public static final int K=105;
    public static final int L=106;
    public static final int LEADING=107;
    public static final int LEFT=108;
    public static final int LEFT_PAREN=109;
    public static final int LEFT_SQUARE=110;
    public static final int LENGTH=111;
    public static final int LESS=112;
    public static final int LESS_EQUAL=113;
    public static final int LIKE=114;
    public static final int LOCATE=115;
    public static final int LOWER=116;
    public static final int M=117;
    public static final int MAX=118;
    public static final int MAXELEMENT=119;
    public static final int MAXINDEX=120;
    public static final int MEMBER_OF=121;
    public static final int MIN=122;
    public static final int MINELEMENT=123;
    public static final int MININDEX=124;
    public static final int MINUS=125;
    public static final int MINUTE=126;
    public static final int MOD=127;
    public static final int MONTH=128;
    public static final int N=129;
    public static final int NAMED_PARAM=130;
    public static final int NEW=131;
    public static final int NOT=132;
    public static final int NOT_BETWEEN=133;
    public static final int NOT_EQUAL=134;
    public static final int NOT_IN=135;
    public static final int NOT_LIKE=136;
    public static final int NOT_MEMBER_OF=137;
    public static final int NULL=138;
    public static final int NULLIF=139;
    public static final int O=140;
    public static final int OCTAL_ESCAPE=141;
    public static final int OCTAL_LITERAL=142;
    public static final int OCTET_LENGTH=143;
    public static final int ON=144;
    public static final int OR=145;
    public static final int ORDER_BY=146;
    public static final int ORDER_SPEC=147;
    public static final int OUTER=148;
    public static final int P=149;
    public static final int PARAM=150;
    public static final int PATH=151;
    public static final int PERCENT=152;
    public static final int PERSISTER_JOIN=153;
    public static final int PERSISTER_SPACE=154;
    public static final int PIPE=155;
    public static final int PLUS=156;
    public static final int POSITION=157;
    public static final int PROPERTIES=158;
    public static final int PROPERTY_JOIN=159;
    public static final int PROPERTY_REFERENCE=160;
    public static final int PROP_FETCH=161;
    public static final int Q=162;
    public static final int QUALIFIED_JOIN=163;
    public static final int QUERY=164;
    public static final int QUERY_SPEC=165;
    public static final int QUOTED_IDENTIFIER=166;
    public static final int R=167;
    public static final int RIGHT=168;
    public static final int RIGHT_PAREN=169;
    public static final int RIGHT_SQUARE=170;
    public static final int S=171;
    public static final int SEARCHED_CASE=172;
    public static final int SECOND=173;
    public static final int SELECT=174;
    public static final int SELECT_FROM=175;
    public static final int SELECT_ITEM=176;
    public static final int SELECT_LIST=177;
    public static final int SEMICOLON=178;
    public static final int SET=179;
    public static final int SIMPLE_CASE=180;
    public static final int SIZE=181;
    public static final int SOLIDUS=182;
    public static final int SOME=183;
    public static final int SORT_SPEC=184;
    public static final int SQRT=185;
    public static final int STRING_LITERAL=186;
    public static final int SUBSTRING=187;
    public static final int SUB_QUERY=188;
    public static final int SUM=189;
    public static final int T=190;
    public static final int TABLE=191;
    public static final int THEN=192;
    public static final int TIMEZONE_HOUR=193;
    public static final int TIMEZONE_MINUTE=194;
    public static final int TRAILING=195;
    public static final int TRIM=196;
    public static final int TRUE=197;
    public static final int U=198;
    public static final int UNARY_MINUS=199;
    public static final int UNARY_PLUS=200;
    public static final int UNICODE_ESCAPE=201;
    public static final int UNION=202;
    public static final int UPDATE=203;
    public static final int UPPER=204;
    public static final int V=205;
    public static final int VECTOR_EXPR=206;
    public static final int VERSIONED=207;
    public static final int VERSIONED_VALUE=208;
    public static final int W=209;
    public static final int WHEN=210;
    public static final int WHERE=211;
    public static final int WITH=212;
    public static final int WS=213;
    public static final int X=214;
    public static final int Y=215;
    public static final int YEAR=216;
    public static final int Z=217;

    // delegates
    public TreeParser[] getDelegates() {
        return new TreeParser[] {};
    }

    // delegators


    public GeneratedHQLResolver(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }
    public GeneratedHQLResolver(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return GeneratedHQLResolver.tokenNames; }
    public String getGrammarFileName() { return "org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g"; }


      private QueryResolverDelegate delegate;

      public GeneratedHQLResolver(TreeNodeStream input, QueryResolverDelegate delegate) {
        this(input, new RecognizerSharedState());
        this.delegate = delegate;
      }


    public static class filterStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "filterStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:60:1: filterStatement[String collectionRole] : ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) ;
    public final GeneratedHQLResolver.filterStatement_return filterStatement(String collectionRole) throws RecognitionException {
        GeneratedHQLResolver.filterStatement_return retval = new GeneratedHQLResolver.filterStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY1=null;
        CommonTree QUERY_SPEC2=null;
        CommonTree FILTER3=null;
        GeneratedHQLResolver.selectClause_return selectClause4 =null;

        GeneratedHQLResolver.whereClause_return whereClause5 =null;

        GeneratedHQLResolver.groupByClause_return groupByClause6 =null;

        GeneratedHQLResolver.havingClause_return havingClause7 =null;

        GeneratedHQLResolver.orderByClause_return orderByClause8 =null;


        CommonTree QUERY1_tree=null;
        CommonTree QUERY_SPEC2_tree=null;
        CommonTree FILTER3_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:61:2: ( ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:61:4: ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY1=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_filterStatement62); 


            if ( _first_0==null ) _first_0 = QUERY1;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            QUERY_SPEC2=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_filterStatement65); 


            if ( _first_1==null ) _first_1 = QUERY_SPEC2;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            FILTER3=(CommonTree)match(input,FILTER,FOLLOW_FILTER_in_filterStatement67); 
             
            if ( _first_2==null ) _first_2 = FILTER3;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:5: ( selectClause )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==SELECT) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:5: selectClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_selectClause_in_filterStatement73);
                    selectClause4=selectClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = selectClause4.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:19: ( whereClause )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==WHERE) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:19: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_filterStatement76);
                    whereClause5=whereClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = whereClause5.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:32: ( groupByClause ( havingClause )? )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==GROUP_BY) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:34: groupByClause ( havingClause )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupByClause_in_filterStatement81);
                    groupByClause6=groupByClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = groupByClause6.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:48: ( havingClause )?
                    int alt3=2;
                    int LA3_0 = input.LA(1);

                    if ( (LA3_0==HAVING) ) {
                        alt3=1;
                    }
                    switch (alt3) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:48: havingClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_havingClause_in_filterStatement83);
                            havingClause7=havingClause();

                            state._fsp--;

                             
                            if ( _first_2==null ) _first_2 = havingClause7.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:64: ( orderByClause )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==ORDER_BY) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:64: orderByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderByClause_in_filterStatement88);
                    orderByClause8=orderByClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = orderByClause8.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "filterStatement"


    public static class statement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:65:1: statement : ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet );
    public final GeneratedHQLResolver.statement_return statement() throws RecognitionException {
        GeneratedHQLResolver.statement_return retval = new GeneratedHQLResolver.statement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.updateStatementSet_return updateStatementSet9 =null;

        GeneratedHQLResolver.deleteStatementSet_return deleteStatementSet10 =null;

        GeneratedHQLResolver.insertStatementSet_return insertStatementSet11 =null;

        GeneratedHQLResolver.queryStatementSet_return queryStatementSet12 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:66:2: ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet )
            int alt6=4;
            switch ( input.LA(1) ) {
            case UPDATE:
                {
                alt6=1;
                }
                break;
            case DELETE:
                {
                alt6=2;
                }
                break;
            case INSERT:
                {
                alt6=3;
                }
                break;
            case QUERY:
                {
                alt6=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:66:4: updateStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_updateStatementSet_in_statement102);
                    updateStatementSet9=updateStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = updateStatementSet9.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:67:4: deleteStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_deleteStatementSet_in_statement107);
                    deleteStatementSet10=deleteStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = deleteStatementSet10.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:68:4: insertStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_insertStatementSet_in_statement112);
                    insertStatementSet11=insertStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = insertStatementSet11.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:69:4: queryStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryStatementSet_in_statement117);
                    queryStatementSet12=queryStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = queryStatementSet12.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class updateStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "updateStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:72:1: updateStatementSet : ( updateStatement )+ ;
    public final GeneratedHQLResolver.updateStatementSet_return updateStatementSet() throws RecognitionException {
        GeneratedHQLResolver.updateStatementSet_return retval = new GeneratedHQLResolver.updateStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.updateStatement_return updateStatement13 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:2: ( ( updateStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:4: ( updateStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:4: ( updateStatement )+
            int cnt7=0;
            loop7:
            do {
                int alt7=2;
                int LA7_0 = input.LA(1);

                if ( (LA7_0==UPDATE) ) {
                    alt7=1;
                }


                switch (alt7) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:4: updateStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_updateStatement_in_updateStatementSet128);
            	    updateStatement13=updateStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = updateStatement13.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt7 >= 1 ) break loop7;
                        EarlyExitException eee =
                            new EarlyExitException(7, input);
                        throw eee;
                }
                cnt7++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "updateStatementSet"


    public static class updateStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "updateStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:76:1: updateStatement : ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) ;
    public final GeneratedHQLResolver.updateStatement_return updateStatement() throws RecognitionException {
        GeneratedHQLResolver.updateStatement_return retval = new GeneratedHQLResolver.updateStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UPDATE14=null;
        CommonTree SET16=null;
        GeneratedHQLResolver.entityName_return entityName15 =null;

        GeneratedHQLResolver.assignment_return assignment17 =null;

        GeneratedHQLResolver.whereClause_return whereClause18 =null;


        CommonTree UPDATE14_tree=null;
        CommonTree SET16_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:2: ( ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:4: ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            UPDATE14=(CommonTree)match(input,UPDATE,FOLLOW_UPDATE_in_updateStatement141); 


            if ( _first_0==null ) _first_0 = UPDATE14;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_updateStatement143);
            entityName15=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName15.tree;


            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            SET16=(CommonTree)match(input,SET,FOLLOW_SET_in_updateStatement146); 


            if ( _first_1==null ) _first_1 = SET16;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:30: ( assignment )+
            int cnt8=0;
            loop8:
            do {
                int alt8=2;
                int LA8_0 = input.LA(1);

                if ( (LA8_0==EQUALS) ) {
                    alt8=1;
                }


                switch (alt8) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:30: assignment
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_assignment_in_updateStatement148);
            	    assignment17=assignment();

            	    state._fsp--;

            	     
            	    if ( _first_2==null ) _first_2 = assignment17.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt8 >= 1 ) break loop8;
                        EarlyExitException eee =
                            new EarlyExitException(8, input);
                        throw eee;
                }
                cnt8++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:43: ( whereClause )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==WHERE) ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:43: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_updateStatement152);
                    whereClause18=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause18.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "updateStatement"


    public static class assignment_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "assignment"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:80:1: assignment : ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) );
    public final GeneratedHQLResolver.assignment_return assignment() throws RecognitionException {
        GeneratedHQLResolver.assignment_return retval = new GeneratedHQLResolver.assignment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EQUALS19=null;
        CommonTree EQUALS22=null;
        CommonTree VERSIONED_VALUE23=null;
        CommonTree STRING_LITERAL24=null;
        GeneratedHQLResolver.propertyReference_return propertyReference20 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression21 =null;


        CommonTree EQUALS19_tree=null;
        CommonTree EQUALS22_tree=null;
        CommonTree VERSIONED_VALUE23_tree=null;
        CommonTree STRING_LITERAL24_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:81:2: ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) )
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==EQUALS) ) {
                int LA10_1 = input.LA(2);

                if ( (LA10_1==DOWN) ) {
                    int LA10_2 = input.LA(3);

                    if ( (LA10_2==VERSIONED_VALUE) ) {
                        alt10=2;
                    }
                    else if ( (LA10_2==PROPERTY_REFERENCE) ) {
                        alt10=1;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 2, input);

                        throw nvae;

                    }
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 10, 1, input);

                    throw nvae;

                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;

            }
            switch (alt10) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:81:4: ^( EQUALS propertyReference valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS19=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment166); 


                    if ( _first_0==null ) _first_0 = EQUALS19;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_assignment168);
                    propertyReference20=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference20.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_assignment170);
                    valueExpression21=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression21.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:82:4: ^( EQUALS VERSIONED_VALUE STRING_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS22=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment177); 


                    if ( _first_0==null ) _first_0 = EQUALS22;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    VERSIONED_VALUE23=(CommonTree)match(input,VERSIONED_VALUE,FOLLOW_VERSIONED_VALUE_in_assignment179); 
                     
                    if ( _first_1==null ) _first_1 = VERSIONED_VALUE23;


                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL24=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_assignment181); 
                     
                    if ( _first_1==null ) _first_1 = STRING_LITERAL24;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "assignment"


    public static class deleteStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "deleteStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:85:1: deleteStatementSet : ( deleteStatement )+ ;
    public final GeneratedHQLResolver.deleteStatementSet_return deleteStatementSet() throws RecognitionException {
        GeneratedHQLResolver.deleteStatementSet_return retval = new GeneratedHQLResolver.deleteStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.deleteStatement_return deleteStatement25 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:2: ( ( deleteStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:4: ( deleteStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:4: ( deleteStatement )+
            int cnt11=0;
            loop11:
            do {
                int alt11=2;
                int LA11_0 = input.LA(1);

                if ( (LA11_0==DELETE) ) {
                    alt11=1;
                }


                switch (alt11) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:4: deleteStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_deleteStatement_in_deleteStatementSet193);
            	    deleteStatement25=deleteStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = deleteStatement25.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt11 >= 1 ) break loop11;
                        EarlyExitException eee =
                            new EarlyExitException(11, input);
                        throw eee;
                }
                cnt11++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "deleteStatementSet"


    public static class deleteStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "deleteStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:89:1: deleteStatement : ^( DELETE entityName ( whereClause )? ) ;
    public final GeneratedHQLResolver.deleteStatement_return deleteStatement() throws RecognitionException {
        GeneratedHQLResolver.deleteStatement_return retval = new GeneratedHQLResolver.deleteStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DELETE26=null;
        GeneratedHQLResolver.entityName_return entityName27 =null;

        GeneratedHQLResolver.whereClause_return whereClause28 =null;


        CommonTree DELETE26_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:2: ( ^( DELETE entityName ( whereClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:4: ^( DELETE entityName ( whereClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DELETE26=(CommonTree)match(input,DELETE,FOLLOW_DELETE_in_deleteStatement206); 


            if ( _first_0==null ) _first_0 = DELETE26;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_deleteStatement208);
            entityName27=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName27.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:24: ( whereClause )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==WHERE) ) {
                alt12=1;
            }
            switch (alt12) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:24: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_deleteStatement210);
                    whereClause28=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause28.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "deleteStatement"


    public static class insertStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:93:1: insertStatementSet : ( insertStatement )+ ;
    public final GeneratedHQLResolver.insertStatementSet_return insertStatementSet() throws RecognitionException {
        GeneratedHQLResolver.insertStatementSet_return retval = new GeneratedHQLResolver.insertStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.insertStatement_return insertStatement29 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:2: ( ( insertStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:4: ( insertStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:4: ( insertStatement )+
            int cnt13=0;
            loop13:
            do {
                int alt13=2;
                int LA13_0 = input.LA(1);

                if ( (LA13_0==INSERT) ) {
                    alt13=1;
                }


                switch (alt13) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:4: insertStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_insertStatement_in_insertStatementSet223);
            	    insertStatement29=insertStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = insertStatement29.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt13 >= 1 ) break loop13;
                        EarlyExitException eee =
                            new EarlyExitException(13, input);
                        throw eee;
                }
                cnt13++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertStatementSet"


    public static class insertStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:97:1: insertStatement : ^( INSERT intoClause queryStatementSet ) ;
    public final GeneratedHQLResolver.insertStatement_return insertStatement() throws RecognitionException {
        GeneratedHQLResolver.insertStatement_return retval = new GeneratedHQLResolver.insertStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INSERT30=null;
        GeneratedHQLResolver.intoClause_return intoClause31 =null;

        GeneratedHQLResolver.queryStatementSet_return queryStatementSet32 =null;


        CommonTree INSERT30_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:98:2: ( ^( INSERT intoClause queryStatementSet ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:98:4: ^( INSERT intoClause queryStatementSet )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INSERT30=(CommonTree)match(input,INSERT,FOLLOW_INSERT_in_insertStatement236); 


            if ( _first_0==null ) _first_0 = INSERT30;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_intoClause_in_insertStatement238);
            intoClause31=intoClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = intoClause31.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_queryStatementSet_in_insertStatement240);
            queryStatementSet32=queryStatementSet();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = queryStatementSet32.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertStatement"


    public static class intoClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intoClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:101:1: intoClause : ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) ;
    public final GeneratedHQLResolver.intoClause_return intoClause() throws RecognitionException {
        GeneratedHQLResolver.intoClause_return retval = new GeneratedHQLResolver.intoClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INTO33=null;
        CommonTree INSERTABILITY_SPEC35=null;
        GeneratedHQLResolver.entityName_return entityName34 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference36 =null;


        CommonTree INTO33_tree=null;
        CommonTree INSERTABILITY_SPEC35_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:2: ( ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:4: ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INTO33=(CommonTree)match(input,INTO,FOLLOW_INTO_in_intoClause253); 


            if ( _first_0==null ) _first_0 = INTO33;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_intoClause255);
            entityName34=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName34.tree;


            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            INSERTABILITY_SPEC35=(CommonTree)match(input,INSERTABILITY_SPEC,FOLLOW_INSERTABILITY_SPEC_in_intoClause258); 


            if ( _first_1==null ) _first_1 = INSERTABILITY_SPEC35;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:43: ( propertyReference )+
            int cnt14=0;
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( (LA14_0==PROPERTY_REFERENCE) ) {
                    alt14=1;
                }


                switch (alt14) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:43: propertyReference
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_propertyReference_in_intoClause260);
            	    propertyReference36=propertyReference();

            	    state._fsp--;

            	     
            	    if ( _first_2==null ) _first_2 = propertyReference36.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt14 >= 1 ) break loop14;
                        EarlyExitException eee =
                            new EarlyExitException(14, input);
                        throw eee;
                }
                cnt14++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intoClause"


    public static class queryStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:105:1: queryStatementSet : ( queryStatement )+ ;
    public final GeneratedHQLResolver.queryStatementSet_return queryStatementSet() throws RecognitionException {
        GeneratedHQLResolver.queryStatementSet_return retval = new GeneratedHQLResolver.queryStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.queryStatement_return queryStatement37 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:2: ( ( queryStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:4: ( queryStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:4: ( queryStatement )+
            int cnt15=0;
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( (LA15_0==QUERY) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:4: queryStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_queryStatement_in_queryStatementSet276);
            	    queryStatement37=queryStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = queryStatement37.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt15 >= 1 ) break loop15;
                        EarlyExitException eee =
                            new EarlyExitException(15, input);
                        throw eee;
                }
                cnt15++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryStatementSet"


    public static class queryStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:109:1: queryStatement : ^( QUERY queryExpression ( orderByClause )? ) ;
    public final GeneratedHQLResolver.queryStatement_return queryStatement() throws RecognitionException {
        GeneratedHQLResolver.queryStatement_return retval = new GeneratedHQLResolver.queryStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY38=null;
        GeneratedHQLResolver.queryExpression_return queryExpression39 =null;

        GeneratedHQLResolver.orderByClause_return orderByClause40 =null;


        CommonTree QUERY38_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:2: ( ^( QUERY queryExpression ( orderByClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:4: ^( QUERY queryExpression ( orderByClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY38=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_queryStatement289); 


            if ( _first_0==null ) _first_0 = QUERY38;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_queryExpression_in_queryStatement291);
            queryExpression39=queryExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = queryExpression39.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:28: ( orderByClause )?
            int alt16=2;
            int LA16_0 = input.LA(1);

            if ( (LA16_0==ORDER_BY) ) {
                alt16=1;
            }
            switch (alt16) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:28: orderByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderByClause_in_queryStatement293);
                    orderByClause40=orderByClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = orderByClause40.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryStatement"


    public static class queryExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:113:1: queryExpression : ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec );
    public final GeneratedHQLResolver.queryExpression_return queryExpression() throws RecognitionException {
        GeneratedHQLResolver.queryExpression_return retval = new GeneratedHQLResolver.queryExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UNION41=null;
        CommonTree ALL42=null;
        CommonTree INTERSECT45=null;
        CommonTree ALL46=null;
        CommonTree EXCEPT49=null;
        CommonTree ALL50=null;
        GeneratedHQLResolver.queryExpression_return queryExpression43 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression44 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression47 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression48 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression51 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression52 =null;

        GeneratedHQLResolver.querySpec_return querySpec53 =null;


        CommonTree UNION41_tree=null;
        CommonTree ALL42_tree=null;
        CommonTree INTERSECT45_tree=null;
        CommonTree ALL46_tree=null;
        CommonTree EXCEPT49_tree=null;
        CommonTree ALL50_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:2: ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec )
            int alt20=4;
            switch ( input.LA(1) ) {
            case UNION:
                {
                alt20=1;
                }
                break;
            case INTERSECT:
                {
                alt20=2;
                }
                break;
            case EXCEPT:
                {
                alt20=3;
                }
                break;
            case QUERY_SPEC:
                {
                alt20=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;

            }

            switch (alt20) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:4: ^( UNION ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNION41=(CommonTree)match(input,UNION,FOLLOW_UNION_in_queryExpression307); 


                    if ( _first_0==null ) _first_0 = UNION41;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:12: ( ALL )?
                    int alt17=2;
                    int LA17_0 = input.LA(1);

                    if ( (LA17_0==ALL) ) {
                        alt17=1;
                    }
                    switch (alt17) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:12: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL42=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression309); 
                             
                            if ( _first_1==null ) _first_1 = ALL42;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression312);
                    queryExpression43=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression43.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression314);
                    queryExpression44=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression44.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:115:4: ^( INTERSECT ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    INTERSECT45=(CommonTree)match(input,INTERSECT,FOLLOW_INTERSECT_in_queryExpression321); 


                    if ( _first_0==null ) _first_0 = INTERSECT45;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:115:16: ( ALL )?
                    int alt18=2;
                    int LA18_0 = input.LA(1);

                    if ( (LA18_0==ALL) ) {
                        alt18=1;
                    }
                    switch (alt18) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:115:16: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL46=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression323); 
                             
                            if ( _first_1==null ) _first_1 = ALL46;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression326);
                    queryExpression47=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression47.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression328);
                    queryExpression48=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression48.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:116:4: ^( EXCEPT ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EXCEPT49=(CommonTree)match(input,EXCEPT,FOLLOW_EXCEPT_in_queryExpression335); 


                    if ( _first_0==null ) _first_0 = EXCEPT49;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:116:13: ( ALL )?
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( (LA19_0==ALL) ) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:116:13: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL50=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression337); 
                             
                            if ( _first_1==null ) _first_1 = ALL50;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression340);
                    queryExpression51=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression51.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression342);
                    queryExpression52=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression52.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:117:4: querySpec
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_querySpec_in_queryExpression348);
                    querySpec53=querySpec();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = querySpec53.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryExpression"


    public static class querySpec_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "querySpec"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:120:1: querySpec : ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) ;
    public final GeneratedHQLResolver.querySpec_return querySpec() throws RecognitionException {
        GeneratedHQLResolver.querySpec_return retval = new GeneratedHQLResolver.querySpec_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY_SPEC54=null;
        GeneratedHQLResolver.selectFrom_return selectFrom55 =null;

        GeneratedHQLResolver.whereClause_return whereClause56 =null;

        GeneratedHQLResolver.groupByClause_return groupByClause57 =null;

        GeneratedHQLResolver.havingClause_return havingClause58 =null;


        CommonTree QUERY_SPEC54_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:2: ( ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:4: ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY_SPEC54=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_querySpec360); 


            if ( _first_0==null ) _first_0 = QUERY_SPEC54;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_selectFrom_in_querySpec362);
            selectFrom55=selectFrom();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = selectFrom55.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:28: ( whereClause )?
            int alt21=2;
            int LA21_0 = input.LA(1);

            if ( (LA21_0==WHERE) ) {
                alt21=1;
            }
            switch (alt21) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:28: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_querySpec364);
                    whereClause56=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause56.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:41: ( groupByClause )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0==GROUP_BY) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:41: groupByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupByClause_in_querySpec367);
                    groupByClause57=groupByClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = groupByClause57.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:56: ( havingClause )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==HAVING) ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:56: havingClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_havingClause_in_querySpec370);
                    havingClause58=havingClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = havingClause58.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "querySpec"


    public static class whereClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "whereClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:124:1: whereClause : ^( WHERE searchCondition ) ;
    public final GeneratedHQLResolver.whereClause_return whereClause() throws RecognitionException {
        GeneratedHQLResolver.whereClause_return retval = new GeneratedHQLResolver.whereClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHERE59=null;
        GeneratedHQLResolver.searchCondition_return searchCondition60 =null;


        CommonTree WHERE59_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:125:2: ( ^( WHERE searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:125:4: ^( WHERE searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHERE59=(CommonTree)match(input,WHERE,FOLLOW_WHERE_in_whereClause384); 


            if ( _first_0==null ) _first_0 = WHERE59;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_whereClause386);
            searchCondition60=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition60.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "whereClause"


    public static class groupByClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupByClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:128:1: groupByClause : ^( GROUP_BY ( groupingValue )+ ) ;
    public final GeneratedHQLResolver.groupByClause_return groupByClause() throws RecognitionException {
        GeneratedHQLResolver.groupByClause_return retval = new GeneratedHQLResolver.groupByClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree GROUP_BY61=null;
        GeneratedHQLResolver.groupingValue_return groupingValue62 =null;


        CommonTree GROUP_BY61_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:2: ( ^( GROUP_BY ( groupingValue )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:4: ^( GROUP_BY ( groupingValue )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            GROUP_BY61=(CommonTree)match(input,GROUP_BY,FOLLOW_GROUP_BY_in_groupByClause399); 


            if ( _first_0==null ) _first_0 = GROUP_BY61;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:15: ( groupingValue )+
            int cnt24=0;
            loop24:
            do {
                int alt24=2;
                int LA24_0 = input.LA(1);

                if ( (LA24_0==GROUPING_VALUE) ) {
                    alt24=1;
                }


                switch (alt24) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:15: groupingValue
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_groupingValue_in_groupByClause401);
            	    groupingValue62=groupingValue();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = groupingValue62.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt24 >= 1 ) break loop24;
                        EarlyExitException eee =
                            new EarlyExitException(24, input);
                        throw eee;
                }
                cnt24++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupByClause"


    public static class groupingValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupingValue"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:132:1: groupingValue : ^( GROUPING_VALUE valueExpression ( COLLATE )? ) ;
    public final GeneratedHQLResolver.groupingValue_return groupingValue() throws RecognitionException {
        GeneratedHQLResolver.groupingValue_return retval = new GeneratedHQLResolver.groupingValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree GROUPING_VALUE63=null;
        CommonTree COLLATE65=null;
        GeneratedHQLResolver.valueExpression_return valueExpression64 =null;


        CommonTree GROUPING_VALUE63_tree=null;
        CommonTree COLLATE65_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:2: ( ^( GROUPING_VALUE valueExpression ( COLLATE )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:4: ^( GROUPING_VALUE valueExpression ( COLLATE )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            GROUPING_VALUE63=(CommonTree)match(input,GROUPING_VALUE,FOLLOW_GROUPING_VALUE_in_groupingValue415); 


            if ( _first_0==null ) _first_0 = GROUPING_VALUE63;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_groupingValue417);
            valueExpression64=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression64.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:37: ( COLLATE )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==COLLATE) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:37: COLLATE
                    {
                    _last = (CommonTree)input.LT(1);
                    COLLATE65=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_groupingValue419); 
                     
                    if ( _first_1==null ) _first_1 = COLLATE65;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupingValue"


    public static class havingClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "havingClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:1: havingClause : ^( HAVING searchCondition ) ;
    public final GeneratedHQLResolver.havingClause_return havingClause() throws RecognitionException {
        GeneratedHQLResolver.havingClause_return retval = new GeneratedHQLResolver.havingClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree HAVING66=null;
        GeneratedHQLResolver.searchCondition_return searchCondition67 =null;


        CommonTree HAVING66_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:137:2: ( ^( HAVING searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:137:4: ^( HAVING searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            HAVING66=(CommonTree)match(input,HAVING,FOLLOW_HAVING_in_havingClause433); 


            if ( _first_0==null ) _first_0 = HAVING66;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_havingClause435);
            searchCondition67=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition67.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "havingClause"


    public static class selectFrom_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectFrom"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:140:1: selectFrom : ^( SELECT_FROM fromClause selectClause ) ;
    public final GeneratedHQLResolver.selectFrom_return selectFrom() throws RecognitionException {
        GeneratedHQLResolver.selectFrom_return retval = new GeneratedHQLResolver.selectFrom_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT_FROM68=null;
        GeneratedHQLResolver.fromClause_return fromClause69 =null;

        GeneratedHQLResolver.selectClause_return selectClause70 =null;


        CommonTree SELECT_FROM68_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:141:2: ( ^( SELECT_FROM fromClause selectClause ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:141:4: ^( SELECT_FROM fromClause selectClause )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SELECT_FROM68=(CommonTree)match(input,SELECT_FROM,FOLLOW_SELECT_FROM_in_selectFrom448); 


            if ( _first_0==null ) _first_0 = SELECT_FROM68;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_fromClause_in_selectFrom450);
            fromClause69=fromClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = fromClause69.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_selectClause_in_selectFrom452);
            selectClause70=selectClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = selectClause70.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectFrom"


    public static class fromClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fromClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:144:1: fromClause : ^( FROM ( persisterSpaces )+ ) ;
    public final GeneratedHQLResolver.fromClause_return fromClause() throws RecognitionException {
        GeneratedHQLResolver.fromClause_return retval = new GeneratedHQLResolver.fromClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FROM71=null;
        GeneratedHQLResolver.persisterSpaces_return persisterSpaces72 =null;


        CommonTree FROM71_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:2: ( ^( FROM ( persisterSpaces )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:4: ^( FROM ( persisterSpaces )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            FROM71=(CommonTree)match(input,FROM,FOLLOW_FROM_in_fromClause465); 


            if ( _first_0==null ) _first_0 = FROM71;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:11: ( persisterSpaces )+
            int cnt26=0;
            loop26:
            do {
                int alt26=2;
                int LA26_0 = input.LA(1);

                if ( (LA26_0==PERSISTER_SPACE) ) {
                    alt26=1;
                }


                switch (alt26) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:11: persisterSpaces
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_persisterSpaces_in_fromClause467);
            	    persisterSpaces72=persisterSpaces();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = persisterSpaces72.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt26 >= 1 ) break loop26;
                        EarlyExitException eee =
                            new EarlyExitException(26, input);
                        throw eee;
                }
                cnt26++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fromClause"


    public static class persisterSpaces_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaces"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:148:1: persisterSpaces : ^( PERSISTER_SPACE persisterSpace ) ;
    public final GeneratedHQLResolver.persisterSpaces_return persisterSpaces() throws RecognitionException {
        GeneratedHQLResolver.persisterSpaces_return retval = new GeneratedHQLResolver.persisterSpaces_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PERSISTER_SPACE73=null;
        GeneratedHQLResolver.persisterSpace_return persisterSpace74 =null;


        CommonTree PERSISTER_SPACE73_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:149:2: ( ^( PERSISTER_SPACE persisterSpace ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:149:4: ^( PERSISTER_SPACE persisterSpace )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PERSISTER_SPACE73=(CommonTree)match(input,PERSISTER_SPACE,FOLLOW_PERSISTER_SPACE_in_persisterSpaces481); 


            if ( _first_0==null ) _first_0 = PERSISTER_SPACE73;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_persisterSpace_in_persisterSpaces483);
            persisterSpace74=persisterSpace();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = persisterSpace74.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaces"


    public static class persisterSpace_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpace"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:152:1: persisterSpace : persisterSpaceRoot ( joins )* ;
    public final GeneratedHQLResolver.persisterSpace_return persisterSpace() throws RecognitionException {
        GeneratedHQLResolver.persisterSpace_return retval = new GeneratedHQLResolver.persisterSpace_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.persisterSpaceRoot_return persisterSpaceRoot75 =null;

        GeneratedHQLResolver.joins_return joins76 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:2: ( persisterSpaceRoot ( joins )* )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:4: persisterSpaceRoot ( joins )*
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_persisterSpaceRoot_in_persisterSpace495);
            persisterSpaceRoot75=persisterSpaceRoot();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = persisterSpaceRoot75.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:23: ( joins )*
            loop27:
            do {
                int alt27=2;
                int LA27_0 = input.LA(1);

                if ( (LA27_0==PERSISTER_JOIN||LA27_0==PROPERTY_JOIN) ) {
                    alt27=1;
                }


                switch (alt27) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:23: joins
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_joins_in_persisterSpace497);
            	    joins76=joins();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = joins76.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    break loop27;
                }
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpace"


    public static class persisterSpaceRoot_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaceRoot"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:156:1: persisterSpaceRoot : ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) ;
    public final GeneratedHQLResolver.persisterSpaceRoot_return persisterSpaceRoot() throws RecognitionException {
        GeneratedHQLResolver.persisterSpaceRoot_return retval = new GeneratedHQLResolver.persisterSpaceRoot_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ENTITY_PERSISTER_REF77=null;
        CommonTree PROP_FETCH79=null;
        GeneratedHQLResolver.entityName_return entityName78 =null;


        CommonTree ENTITY_PERSISTER_REF77_tree=null;
        CommonTree PROP_FETCH79_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:2: ( ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:4: ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ENTITY_PERSISTER_REF77=(CommonTree)match(input,ENTITY_PERSISTER_REF,FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot510); 


            if ( _first_0==null ) _first_0 = ENTITY_PERSISTER_REF77;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_persisterSpaceRoot512);
            entityName78=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName78.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:38: ( PROP_FETCH )?
            int alt28=2;
            int LA28_0 = input.LA(1);

            if ( (LA28_0==PROP_FETCH) ) {
                alt28=1;
            }
            switch (alt28) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:38: PROP_FETCH
                    {
                    _last = (CommonTree)input.LT(1);
                    PROP_FETCH79=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_persisterSpaceRoot514); 
                     
                    if ( _first_1==null ) _first_1 = PROP_FETCH79;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaceRoot"


    public static class joins_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joins"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:160:1: joins : ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( joinProperty[$an] ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) );
    public final GeneratedHQLResolver.joins_return joins() throws RecognitionException {
        GeneratedHQLResolver.joins_return retval = new GeneratedHQLResolver.joins_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ft=null;
        CommonTree an=null;
        CommonTree pf=null;
        CommonTree PROPERTY_JOIN80=null;
        CommonTree PERSISTER_JOIN83=null;
        GeneratedHQLResolver.joinType_return jt =null;

        GeneratedHQLResolver.joinProperty_return joinProperty81 =null;

        GeneratedHQLResolver.withClause_return withClause82 =null;

        GeneratedHQLResolver.joinType_return joinType84 =null;

        GeneratedHQLResolver.persisterSpaceRoot_return persisterSpaceRoot85 =null;

        GeneratedHQLResolver.onClause_return onClause86 =null;


        CommonTree ft_tree=null;
        CommonTree an_tree=null;
        CommonTree pf_tree=null;
        CommonTree PROPERTY_JOIN80_tree=null;
        CommonTree PERSISTER_JOIN83_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:2: ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( joinProperty[$an] ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) )
            int alt33=2;
            int LA33_0 = input.LA(1);

            if ( (LA33_0==PROPERTY_JOIN) ) {
                alt33=1;
            }
            else if ( (LA33_0==PERSISTER_JOIN) ) {
                alt33=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;

            }
            switch (alt33) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:4: ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( joinProperty[$an] ) ( withClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PROPERTY_JOIN80=(CommonTree)match(input,PROPERTY_JOIN,FOLLOW_PROPERTY_JOIN_in_joins528); 


                    if ( _first_0==null ) _first_0 = PROPERTY_JOIN80;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinType_in_joins532);
                    jt=joinType();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = jt.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:34: (ft= FETCH )?
                    int alt29=2;
                    int LA29_0 = input.LA(1);

                    if ( (LA29_0==FETCH) ) {
                        alt29=1;
                    }
                    switch (alt29) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:34: ft= FETCH
                            {
                            _last = (CommonTree)input.LT(1);
                            ft=(CommonTree)match(input,FETCH,FOLLOW_FETCH_in_joins536); 
                             
                            if ( _first_1==null ) _first_1 = ft;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    an=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_joins541); 
                     
                    if ( _first_1==null ) _first_1 = an;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:58: (pf= PROP_FETCH )?
                    int alt30=2;
                    int LA30_0 = input.LA(1);

                    if ( (LA30_0==PROP_FETCH) ) {
                        alt30=1;
                    }
                    switch (alt30) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:58: pf= PROP_FETCH
                            {
                            _last = (CommonTree)input.LT(1);
                            pf=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_joins545); 
                             
                            if ( _first_1==null ) _first_1 = pf;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    	delegate.pushFromStrategy((jt!=null?jt.joinType:null), ft, pf, an );	

                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:3: ( joinProperty[$an] )
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:4: joinProperty[$an]
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinProperty_in_joins555);
                    joinProperty81=joinProperty(an);

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = joinProperty81.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:23: ( withClause )?
                    int alt31=2;
                    int LA31_0 = input.LA(1);

                    if ( (LA31_0==WITH) ) {
                        alt31=1;
                    }
                    switch (alt31) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:23: withClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_withClause_in_joins559);
                            withClause82=withClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = withClause82.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    	delegate.popStrategy();	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:165:4: ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PERSISTER_JOIN83=(CommonTree)match(input,PERSISTER_JOIN,FOLLOW_PERSISTER_JOIN_in_joins571); 


                    if ( _first_0==null ) _first_0 = PERSISTER_JOIN83;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinType_in_joins573);
                    joinType84=joinType();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = joinType84.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_persisterSpaceRoot_in_joins575);
                    persisterSpaceRoot85=persisterSpaceRoot();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = persisterSpaceRoot85.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:165:49: ( onClause )?
                    int alt32=2;
                    int LA32_0 = input.LA(1);

                    if ( (LA32_0==ON) ) {
                        alt32=1;
                    }
                    switch (alt32) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:165:49: onClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_onClause_in_joins577);
                            onClause86=onClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = onClause86.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joins"


    public static class joinProperty_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joinProperty"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:168:1: joinProperty[Tree an] : ( collectionExpression | joinPropertyReference[$an] );
    public final GeneratedHQLResolver.joinProperty_return joinProperty(Tree an) throws RecognitionException {
        GeneratedHQLResolver.joinProperty_return retval = new GeneratedHQLResolver.joinProperty_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.collectionExpression_return collectionExpression87 =null;

        GeneratedHQLResolver.joinPropertyReference_return joinPropertyReference88 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:169:2: ( collectionExpression | joinPropertyReference[$an] )
            int alt34=2;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==ELEMENTS||LA34_0==INDICES) ) {
                alt34=1;
            }
            else if ( (LA34_0==PATH) ) {
                alt34=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;

            }
            switch (alt34) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:169:4: collectionExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionExpression_in_joinProperty592);
                    collectionExpression87=collectionExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionExpression87.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:170:4: joinPropertyReference[$an]
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinPropertyReference_in_joinProperty597);
                    joinPropertyReference88=joinPropertyReference(an);

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = joinPropertyReference88.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joinProperty"


    public static class withClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "withClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:173:1: withClause : ^( WITH searchCondition ) ;
    public final GeneratedHQLResolver.withClause_return withClause() throws RecognitionException {
        GeneratedHQLResolver.withClause_return retval = new GeneratedHQLResolver.withClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WITH89=null;
        GeneratedHQLResolver.searchCondition_return searchCondition90 =null;


        CommonTree WITH89_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:174:2: ( ^( WITH searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:174:4: ^( WITH searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WITH89=(CommonTree)match(input,WITH,FOLLOW_WITH_in_withClause610); 


            if ( _first_0==null ) _first_0 = WITH89;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_withClause612);
            searchCondition90=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition90.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "withClause"


    public static class onClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "onClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:177:1: onClause : ^( ON searchCondition ) ;
    public final GeneratedHQLResolver.onClause_return onClause() throws RecognitionException {
        GeneratedHQLResolver.onClause_return retval = new GeneratedHQLResolver.onClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ON91=null;
        GeneratedHQLResolver.searchCondition_return searchCondition92 =null;


        CommonTree ON91_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:178:2: ( ^( ON searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:178:4: ^( ON searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ON91=(CommonTree)match(input,ON,FOLLOW_ON_in_onClause625); 


            if ( _first_0==null ) _first_0 = ON91;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_onClause627);
            searchCondition92=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition92.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "onClause"


    public static class joinType_return extends TreeRuleReturnScope {
        public JoinType joinType;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joinType"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:181:1: joinType returns [JoinType joinType] : ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? );
    public final GeneratedHQLResolver.joinType_return joinType() throws RecognitionException {
        GeneratedHQLResolver.joinType_return retval = new GeneratedHQLResolver.joinType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CROSS93=null;
        CommonTree INNER94=null;
        CommonTree LEFT95=null;
        CommonTree RIGHT96=null;
        CommonTree FULL97=null;
        CommonTree OUTER98=null;

        CommonTree CROSS93_tree=null;
        CommonTree INNER94_tree=null;
        CommonTree LEFT95_tree=null;
        CommonTree RIGHT96_tree=null;
        CommonTree FULL97_tree=null;
        CommonTree OUTER98_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:182:2: ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? )
            int alt37=3;
            switch ( input.LA(1) ) {
            case CROSS:
                {
                alt37=1;
                }
                break;
            case INNER:
                {
                alt37=2;
                }
                break;
            case FULL:
            case LEFT:
            case RIGHT:
                {
                alt37=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 37, 0, input);

                throw nvae;

            }

            switch (alt37) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:182:4: CROSS
                    {
                    _last = (CommonTree)input.LT(1);
                    CROSS93=(CommonTree)match(input,CROSS,FOLLOW_CROSS_in_joinType643); 
                     
                    if ( _first_0==null ) _first_0 = CROSS93;


                    	retval.joinType = JoinType.CROSS;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:183:4: INNER
                    {
                    _last = (CommonTree)input.LT(1);
                    INNER94=(CommonTree)match(input,INNER,FOLLOW_INNER_in_joinType650); 
                     
                    if ( _first_0==null ) _first_0 = INNER94;


                    	retval.joinType = JoinType.INNER;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:4: ( LEFT | RIGHT | FULL ) ( OUTER )?
                    {
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:4: ( LEFT | RIGHT | FULL )
                    int alt35=3;
                    switch ( input.LA(1) ) {
                    case LEFT:
                        {
                        alt35=1;
                        }
                        break;
                    case RIGHT:
                        {
                        alt35=2;
                        }
                        break;
                    case FULL:
                        {
                        alt35=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 35, 0, input);

                        throw nvae;

                    }

                    switch (alt35) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:5: LEFT
                            {
                            _last = (CommonTree)input.LT(1);
                            LEFT95=(CommonTree)match(input,LEFT,FOLLOW_LEFT_in_joinType658); 
                             
                            if ( _first_0==null ) _first_0 = LEFT95;


                            	retval.joinType = JoinType.LEFT;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:43: RIGHT
                            {
                            _last = (CommonTree)input.LT(1);
                            RIGHT96=(CommonTree)match(input,RIGHT,FOLLOW_RIGHT_in_joinType664); 
                             
                            if ( _first_0==null ) _first_0 = RIGHT96;


                            	retval.joinType = JoinType.RIGHT;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 3 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:83: FULL
                            {
                            _last = (CommonTree)input.LT(1);
                            FULL97=(CommonTree)match(input,FULL,FOLLOW_FULL_in_joinType670); 
                             
                            if ( _first_0==null ) _first_0 = FULL97;


                            	retval.joinType = JoinType.FULL;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:120: ( OUTER )?
                    int alt36=2;
                    int LA36_0 = input.LA(1);

                    if ( (LA36_0==OUTER) ) {
                        alt36=1;
                    }
                    switch (alt36) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:184:120: OUTER
                            {
                            _last = (CommonTree)input.LT(1);
                            OUTER98=(CommonTree)match(input,OUTER,FOLLOW_OUTER_in_joinType675); 
                             
                            if ( _first_0==null ) _first_0 = OUTER98;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joinType"


    public static class selectClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:187:1: selectClause : ^( SELECT ( DISTINCT )? rootSelectExpression ) ;
    public final GeneratedHQLResolver.selectClause_return selectClause() throws RecognitionException {
        GeneratedHQLResolver.selectClause_return retval = new GeneratedHQLResolver.selectClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT99=null;
        CommonTree DISTINCT100=null;
        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression101 =null;


        CommonTree SELECT99_tree=null;
        CommonTree DISTINCT100_tree=null;

        	if (state.backtracking == 0) delegate.pushSelectStrategy();	
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:2: ( ^( SELECT ( DISTINCT )? rootSelectExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:4: ^( SELECT ( DISTINCT )? rootSelectExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SELECT99=(CommonTree)match(input,SELECT,FOLLOW_SELECT_in_selectClause698); 


            if ( _first_0==null ) _first_0 = SELECT99;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:13: ( DISTINCT )?
            int alt38=2;
            int LA38_0 = input.LA(1);

            if ( (LA38_0==DISTINCT) ) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:13: DISTINCT
                    {
                    _last = (CommonTree)input.LT(1);
                    DISTINCT100=(CommonTree)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause700); 
                     
                    if ( _first_1==null ) _first_1 = DISTINCT100;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rootSelectExpression_in_selectClause703);
            rootSelectExpression101=rootSelectExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = rootSelectExpression101.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

            	delegate.popStrategy();	
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectClause"


    public static class rootSelectExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rootSelectExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:193:1: rootSelectExpression : ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? );
    public final GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression() throws RecognitionException {
        GeneratedHQLResolver.rootSelectExpression_return retval = new GeneratedHQLResolver.rootSelectExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT_LIST102=null;
        CommonTree SELECT_ITEM104=null;
        CommonTree DYNAMIC_INSTANTIATION106=null;
        CommonTree DYNAMIC_INSTANTIATION_ARG108=null;
        CommonTree ALIAS_NAME111=null;
        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression103 =null;

        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression105 =null;

        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression107 =null;

        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression109 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression110 =null;


        CommonTree SELECT_LIST102_tree=null;
        CommonTree SELECT_ITEM104_tree=null;
        CommonTree DYNAMIC_INSTANTIATION106_tree=null;
        CommonTree DYNAMIC_INSTANTIATION_ARG108_tree=null;
        CommonTree ALIAS_NAME111_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:194:2: ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? )
            int alt42=5;
            switch ( input.LA(1) ) {
            case SELECT_LIST:
                {
                alt42=1;
                }
                break;
            case SELECT_ITEM:
                {
                alt42=2;
                }
                break;
            case DYNAMIC_INSTANTIATION:
                {
                alt42=3;
                }
                break;
            case DYNAMIC_INSTANTIATION_ARG:
                {
                alt42=4;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt42=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 42, 0, input);

                throw nvae;

            }

            switch (alt42) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:194:4: ^( SELECT_LIST ( rootSelectExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SELECT_LIST102=(CommonTree)match(input,SELECT_LIST,FOLLOW_SELECT_LIST_in_rootSelectExpression716); 


                    if ( _first_0==null ) _first_0 = SELECT_LIST102;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:194:18: ( rootSelectExpression )+
                    int cnt39=0;
                    loop39:
                    do {
                        int alt39=2;
                        int LA39_0 = input.LA(1);

                        if ( (LA39_0==ABS||(LA39_0 >= ALIAS_REF && LA39_0 <= ALL)||LA39_0==ANY||(LA39_0 >= ASTERISK && LA39_0 <= AVG)||LA39_0==BIT_LENGTH||(LA39_0 >= CAST && LA39_0 <= CHARACTER_LITERAL)||LA39_0==COALESCE||(LA39_0 >= CONCAT && LA39_0 <= COUNT)||(LA39_0 >= CURRENT_DATE && LA39_0 <= CURRENT_TIMESTAMP)||LA39_0==DECIMAL_LITERAL||(LA39_0 >= DOT_CLASS && LA39_0 <= DYNAMIC_INSTANTIATION_ARG)||LA39_0==ELEMENTS||LA39_0==EXISTS||LA39_0==EXTRACT||LA39_0==FALSE||LA39_0==FLOATING_POINT_LITERAL||LA39_0==FUNCTION||LA39_0==HEX_LITERAL||(LA39_0 >= INDEX && LA39_0 <= INDICES)||LA39_0==INTEGER_LITERAL||LA39_0==JAVA_CONSTANT||LA39_0==JPA_PARAM||LA39_0==LENGTH||(LA39_0 >= LOCATE && LA39_0 <= LOWER)||(LA39_0 >= MAX && LA39_0 <= MAXINDEX)||(LA39_0 >= MIN && LA39_0 <= MINUS)||LA39_0==MOD||LA39_0==NAMED_PARAM||(LA39_0 >= NULL && LA39_0 <= NULLIF)||(LA39_0 >= OCTAL_LITERAL && LA39_0 <= OCTET_LENGTH)||(LA39_0 >= PARAM && LA39_0 <= PATH)||(LA39_0 >= PLUS && LA39_0 <= POSITION)||LA39_0==PROPERTY_REFERENCE||LA39_0==SEARCHED_CASE||(LA39_0 >= SELECT_ITEM && LA39_0 <= SELECT_LIST)||(LA39_0 >= SIMPLE_CASE && LA39_0 <= SOME)||(LA39_0 >= SQRT && LA39_0 <= SUM)||(LA39_0 >= TRIM && LA39_0 <= TRUE)||(LA39_0 >= UNARY_MINUS && LA39_0 <= UNARY_PLUS)||LA39_0==UPPER||LA39_0==VECTOR_EXPR) ) {
                            alt39=1;
                        }


                        switch (alt39) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:194:18: rootSelectExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression718);
                    	    rootSelectExpression103=rootSelectExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = rootSelectExpression103.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt39 >= 1 ) break loop39;
                                EarlyExitException eee =
                                    new EarlyExitException(39, input);
                                throw eee;
                        }
                        cnt39++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:195:4: ^( SELECT_ITEM rootSelectExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SELECT_ITEM104=(CommonTree)match(input,SELECT_ITEM,FOLLOW_SELECT_ITEM_in_rootSelectExpression726); 


                    if ( _first_0==null ) _first_0 = SELECT_ITEM104;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression728);
                    rootSelectExpression105=rootSelectExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rootSelectExpression105.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:196:4: ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DYNAMIC_INSTANTIATION106=(CommonTree)match(input,DYNAMIC_INSTANTIATION,FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression735); 


                    if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION106;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:196:28: ( rootSelectExpression )+
                    int cnt40=0;
                    loop40:
                    do {
                        int alt40=2;
                        int LA40_0 = input.LA(1);

                        if ( (LA40_0==ABS||(LA40_0 >= ALIAS_REF && LA40_0 <= ALL)||LA40_0==ANY||(LA40_0 >= ASTERISK && LA40_0 <= AVG)||LA40_0==BIT_LENGTH||(LA40_0 >= CAST && LA40_0 <= CHARACTER_LITERAL)||LA40_0==COALESCE||(LA40_0 >= CONCAT && LA40_0 <= COUNT)||(LA40_0 >= CURRENT_DATE && LA40_0 <= CURRENT_TIMESTAMP)||LA40_0==DECIMAL_LITERAL||(LA40_0 >= DOT_CLASS && LA40_0 <= DYNAMIC_INSTANTIATION_ARG)||LA40_0==ELEMENTS||LA40_0==EXISTS||LA40_0==EXTRACT||LA40_0==FALSE||LA40_0==FLOATING_POINT_LITERAL||LA40_0==FUNCTION||LA40_0==HEX_LITERAL||(LA40_0 >= INDEX && LA40_0 <= INDICES)||LA40_0==INTEGER_LITERAL||LA40_0==JAVA_CONSTANT||LA40_0==JPA_PARAM||LA40_0==LENGTH||(LA40_0 >= LOCATE && LA40_0 <= LOWER)||(LA40_0 >= MAX && LA40_0 <= MAXINDEX)||(LA40_0 >= MIN && LA40_0 <= MINUS)||LA40_0==MOD||LA40_0==NAMED_PARAM||(LA40_0 >= NULL && LA40_0 <= NULLIF)||(LA40_0 >= OCTAL_LITERAL && LA40_0 <= OCTET_LENGTH)||(LA40_0 >= PARAM && LA40_0 <= PATH)||(LA40_0 >= PLUS && LA40_0 <= POSITION)||LA40_0==PROPERTY_REFERENCE||LA40_0==SEARCHED_CASE||(LA40_0 >= SELECT_ITEM && LA40_0 <= SELECT_LIST)||(LA40_0 >= SIMPLE_CASE && LA40_0 <= SOME)||(LA40_0 >= SQRT && LA40_0 <= SUM)||(LA40_0 >= TRIM && LA40_0 <= TRUE)||(LA40_0 >= UNARY_MINUS && LA40_0 <= UNARY_PLUS)||LA40_0==UPPER||LA40_0==VECTOR_EXPR) ) {
                            alt40=1;
                        }


                        switch (alt40) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:196:28: rootSelectExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression737);
                    	    rootSelectExpression107=rootSelectExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = rootSelectExpression107.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt40 >= 1 ) break loop40;
                                EarlyExitException eee =
                                    new EarlyExitException(40, input);
                                throw eee;
                        }
                        cnt40++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:197:4: ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DYNAMIC_INSTANTIATION_ARG108=(CommonTree)match(input,DYNAMIC_INSTANTIATION_ARG,FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression745); 


                    if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION_ARG108;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression747);
                    rootSelectExpression109=rootSelectExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rootSelectExpression109.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:198:4: valueExpression ( ALIAS_NAME )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_rootSelectExpression753);
                    valueExpression110=valueExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = valueExpression110.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:198:20: ( ALIAS_NAME )?
                    int alt41=2;
                    int LA41_0 = input.LA(1);

                    if ( (LA41_0==ALIAS_NAME) ) {
                        alt41=1;
                    }
                    switch (alt41) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:198:20: ALIAS_NAME
                            {
                            _last = (CommonTree)input.LT(1);
                            ALIAS_NAME111=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_rootSelectExpression755); 
                             
                            if ( _first_0==null ) _first_0 = ALIAS_NAME111;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rootSelectExpression"


    public static class orderByClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orderByClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:201:1: orderByClause : ^( ORDER_BY ( sortSpecification )+ ) ;
    public final GeneratedHQLResolver.orderByClause_return orderByClause() throws RecognitionException {
        GeneratedHQLResolver.orderByClause_return retval = new GeneratedHQLResolver.orderByClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ORDER_BY112=null;
        GeneratedHQLResolver.sortSpecification_return sortSpecification113 =null;


        CommonTree ORDER_BY112_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:202:2: ( ^( ORDER_BY ( sortSpecification )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:202:4: ^( ORDER_BY ( sortSpecification )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ORDER_BY112=(CommonTree)match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderByClause768); 


            if ( _first_0==null ) _first_0 = ORDER_BY112;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:202:15: ( sortSpecification )+
            int cnt43=0;
            loop43:
            do {
                int alt43=2;
                int LA43_0 = input.LA(1);

                if ( (LA43_0==SORT_SPEC) ) {
                    alt43=1;
                }


                switch (alt43) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:202:15: sortSpecification
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_sortSpecification_in_orderByClause770);
            	    sortSpecification113=sortSpecification();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = sortSpecification113.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt43 >= 1 ) break loop43;
                        EarlyExitException eee =
                            new EarlyExitException(43, input);
                        throw eee;
                }
                cnt43++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderByClause"


    public static class sortSpecification_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sortSpecification"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:205:1: sortSpecification : ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) ;
    public final GeneratedHQLResolver.sortSpecification_return sortSpecification() throws RecognitionException {
        GeneratedHQLResolver.sortSpecification_return retval = new GeneratedHQLResolver.sortSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SORT_SPEC114=null;
        CommonTree COLLATE116=null;
        CommonTree ORDER_SPEC117=null;
        GeneratedHQLResolver.valueExpression_return valueExpression115 =null;


        CommonTree SORT_SPEC114_tree=null;
        CommonTree COLLATE116_tree=null;
        CommonTree ORDER_SPEC117_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:206:2: ( ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:206:4: ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SORT_SPEC114=(CommonTree)match(input,SORT_SPEC,FOLLOW_SORT_SPEC_in_sortSpecification784); 


            if ( _first_0==null ) _first_0 = SORT_SPEC114;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_sortSpecification786);
            valueExpression115=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression115.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:206:32: ( COLLATE )?
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==COLLATE) ) {
                alt44=1;
            }
            switch (alt44) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:206:32: COLLATE
                    {
                    _last = (CommonTree)input.LT(1);
                    COLLATE116=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_sortSpecification788); 
                     
                    if ( _first_1==null ) _first_1 = COLLATE116;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            _last = (CommonTree)input.LT(1);
            ORDER_SPEC117=(CommonTree)match(input,ORDER_SPEC,FOLLOW_ORDER_SPEC_in_sortSpecification791); 
             
            if ( _first_1==null ) _first_1 = ORDER_SPEC117;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortSpecification"


    public static class searchCondition_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchCondition"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:209:1: searchCondition : ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate );
    public final GeneratedHQLResolver.searchCondition_return searchCondition() throws RecognitionException {
        GeneratedHQLResolver.searchCondition_return retval = new GeneratedHQLResolver.searchCondition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree OR118=null;
        CommonTree AND121=null;
        CommonTree NOT124=null;
        GeneratedHQLResolver.searchCondition_return searchCondition119 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition120 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition122 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition123 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition125 =null;

        GeneratedHQLResolver.predicate_return predicate126 =null;


        CommonTree OR118_tree=null;
        CommonTree AND121_tree=null;
        CommonTree NOT124_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:210:2: ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate )
            int alt45=4;
            switch ( input.LA(1) ) {
            case OR:
                {
                alt45=1;
                }
                break;
            case AND:
                {
                alt45=2;
                }
                break;
            case NOT:
                {
                alt45=3;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BETWEEN:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EQUALS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case GREATER:
            case GREATER_EQUAL:
            case HEX_LITERAL:
            case IN:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case IS_EMPTY:
            case IS_NOT_EMPTY:
            case IS_NOT_NULL:
            case IS_NULL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LESS:
            case LESS_EQUAL:
            case LIKE:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MEMBER_OF:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NOT_BETWEEN:
            case NOT_EQUAL:
            case NOT_IN:
            case NOT_LIKE:
            case NOT_MEMBER_OF:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt45=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 45, 0, input);

                throw nvae;

            }

            switch (alt45) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:210:4: ^( OR searchCondition searchCondition )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    OR118=(CommonTree)match(input,OR,FOLLOW_OR_in_searchCondition805); 


                    if ( _first_0==null ) _first_0 = OR118;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition807);
                    searchCondition119=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition119.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition809);
                    searchCondition120=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition120.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:211:4: ^( AND searchCondition searchCondition )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    AND121=(CommonTree)match(input,AND,FOLLOW_AND_in_searchCondition818); 


                    if ( _first_0==null ) _first_0 = AND121;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition820);
                    searchCondition122=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition122.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition822);
                    searchCondition123=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition123.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:212:4: ^( NOT searchCondition )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT124=(CommonTree)match(input,NOT,FOLLOW_NOT_in_searchCondition831); 


                    if ( _first_0==null ) _first_0 = NOT124;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition833);
                    searchCondition125=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition125.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:213:4: predicate
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_predicate_in_searchCondition840);
                    predicate126=predicate();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = predicate126.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchCondition"


    public static class predicate_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "predicate"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:216:1: predicate : ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( IS_NOT_NULL rowValueConstructor ) -> ^( NOT ^( IS_NULL rowValueConstructor ) ) | ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? ) -> ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( NOT_BETWEEN rowValueConstructor betweenList ) -> ^( NOT ^( BETWEEN rowValueConstructor betweenList ) ) | ^( IN rowValueConstructor inPredicateValue ) | ^( NOT_IN rowValueConstructor inPredicateValue ) -> ^( NOT ^( IN rowValueConstructor inPredicateValue ) ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor );
    public final GeneratedHQLResolver.predicate_return predicate() throws RecognitionException {
        GeneratedHQLResolver.predicate_return retval = new GeneratedHQLResolver.predicate_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EQUALS127=null;
        CommonTree NOT_EQUAL130=null;
        CommonTree LESS133=null;
        CommonTree LESS_EQUAL136=null;
        CommonTree GREATER139=null;
        CommonTree GREATER_EQUAL142=null;
        CommonTree IS_NULL145=null;
        CommonTree IS_NOT_NULL147=null;
        CommonTree LIKE149=null;
        CommonTree NOT_LIKE153=null;
        CommonTree BETWEEN157=null;
        CommonTree NOT_BETWEEN160=null;
        CommonTree IN163=null;
        CommonTree NOT_IN166=null;
        CommonTree MEMBER_OF169=null;
        CommonTree NOT_MEMBER_OF172=null;
        CommonTree IS_EMPTY175=null;
        CommonTree IS_NOT_EMPTY177=null;
        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor128 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue129 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor131 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue132 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor134 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue135 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor137 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue138 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor140 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue141 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor143 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue144 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor146 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor148 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression150 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression151 =null;

        GeneratedHQLResolver.escapeSpecification_return escapeSpecification152 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression154 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression155 =null;

        GeneratedHQLResolver.escapeSpecification_return escapeSpecification156 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor158 =null;

        GeneratedHQLResolver.betweenList_return betweenList159 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor161 =null;

        GeneratedHQLResolver.betweenList_return betweenList162 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor164 =null;

        GeneratedHQLResolver.inPredicateValue_return inPredicateValue165 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor167 =null;

        GeneratedHQLResolver.inPredicateValue_return inPredicateValue168 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor170 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor171 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor173 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor174 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor176 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor178 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor179 =null;


        CommonTree EQUALS127_tree=null;
        CommonTree NOT_EQUAL130_tree=null;
        CommonTree LESS133_tree=null;
        CommonTree LESS_EQUAL136_tree=null;
        CommonTree GREATER139_tree=null;
        CommonTree GREATER_EQUAL142_tree=null;
        CommonTree IS_NULL145_tree=null;
        CommonTree IS_NOT_NULL147_tree=null;
        CommonTree LIKE149_tree=null;
        CommonTree NOT_LIKE153_tree=null;
        CommonTree BETWEEN157_tree=null;
        CommonTree NOT_BETWEEN160_tree=null;
        CommonTree IN163_tree=null;
        CommonTree NOT_IN166_tree=null;
        CommonTree MEMBER_OF169_tree=null;
        CommonTree NOT_MEMBER_OF172_tree=null;
        CommonTree IS_EMPTY175_tree=null;
        CommonTree IS_NOT_EMPTY177_tree=null;
        RewriteRuleNodeStream stream_IS_NOT_NULL=new RewriteRuleNodeStream(adaptor,"token IS_NOT_NULL");
        RewriteRuleNodeStream stream_NOT_BETWEEN=new RewriteRuleNodeStream(adaptor,"token NOT_BETWEEN");
        RewriteRuleNodeStream stream_NOT_IN=new RewriteRuleNodeStream(adaptor,"token NOT_IN");
        RewriteRuleNodeStream stream_NOT_LIKE=new RewriteRuleNodeStream(adaptor,"token NOT_LIKE");
        RewriteRuleSubtreeStream stream_valueExpression=new RewriteRuleSubtreeStream(adaptor,"rule valueExpression");
        RewriteRuleSubtreeStream stream_inPredicateValue=new RewriteRuleSubtreeStream(adaptor,"rule inPredicateValue");
        RewriteRuleSubtreeStream stream_rowValueConstructor=new RewriteRuleSubtreeStream(adaptor,"rule rowValueConstructor");
        RewriteRuleSubtreeStream stream_betweenList=new RewriteRuleSubtreeStream(adaptor,"rule betweenList");
        RewriteRuleSubtreeStream stream_escapeSpecification=new RewriteRuleSubtreeStream(adaptor,"rule escapeSpecification");
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:217:2: ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( IS_NOT_NULL rowValueConstructor ) -> ^( NOT ^( IS_NULL rowValueConstructor ) ) | ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? ) -> ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( NOT_BETWEEN rowValueConstructor betweenList ) -> ^( NOT ^( BETWEEN rowValueConstructor betweenList ) ) | ^( IN rowValueConstructor inPredicateValue ) | ^( NOT_IN rowValueConstructor inPredicateValue ) -> ^( NOT ^( IN rowValueConstructor inPredicateValue ) ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor )
            int alt48=19;
            switch ( input.LA(1) ) {
            case EQUALS:
                {
                alt48=1;
                }
                break;
            case NOT_EQUAL:
                {
                alt48=2;
                }
                break;
            case LESS:
                {
                alt48=3;
                }
                break;
            case LESS_EQUAL:
                {
                alt48=4;
                }
                break;
            case GREATER:
                {
                alt48=5;
                }
                break;
            case GREATER_EQUAL:
                {
                alt48=6;
                }
                break;
            case IS_NULL:
                {
                alt48=7;
                }
                break;
            case IS_NOT_NULL:
                {
                alt48=8;
                }
                break;
            case LIKE:
                {
                alt48=9;
                }
                break;
            case NOT_LIKE:
                {
                alt48=10;
                }
                break;
            case BETWEEN:
                {
                alt48=11;
                }
                break;
            case NOT_BETWEEN:
                {
                alt48=12;
                }
                break;
            case IN:
                {
                alt48=13;
                }
                break;
            case NOT_IN:
                {
                alt48=14;
                }
                break;
            case MEMBER_OF:
                {
                alt48=15;
                }
                break;
            case NOT_MEMBER_OF:
                {
                alt48=16;
                }
                break;
            case IS_EMPTY:
                {
                alt48=17;
                }
                break;
            case IS_NOT_EMPTY:
                {
                alt48=18;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt48=19;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;

            }

            switch (alt48) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:217:4: ^( EQUALS rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS127=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_predicate853); 


                    if ( _first_0==null ) _first_0 = EQUALS127;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate855);
                    rowValueConstructor128=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor128.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate857);
                    comparativePredicateValue129=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue129.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:218:4: ^( NOT_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_EQUAL130=(CommonTree)match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_predicate866); 


                    if ( _first_0==null ) _first_0 = NOT_EQUAL130;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate868);
                    rowValueConstructor131=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor131.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate870);
                    comparativePredicateValue132=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue132.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:4: ^( LESS rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LESS133=(CommonTree)match(input,LESS,FOLLOW_LESS_in_predicate879); 


                    if ( _first_0==null ) _first_0 = LESS133;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate881);
                    rowValueConstructor134=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor134.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate883);
                    comparativePredicateValue135=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue135.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:220:4: ^( LESS_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LESS_EQUAL136=(CommonTree)match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_predicate892); 


                    if ( _first_0==null ) _first_0 = LESS_EQUAL136;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate894);
                    rowValueConstructor137=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor137.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate896);
                    comparativePredicateValue138=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue138.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:221:4: ^( GREATER rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    GREATER139=(CommonTree)match(input,GREATER,FOLLOW_GREATER_in_predicate905); 


                    if ( _first_0==null ) _first_0 = GREATER139;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate907);
                    rowValueConstructor140=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor140.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate909);
                    comparativePredicateValue141=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue141.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:222:4: ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    GREATER_EQUAL142=(CommonTree)match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_predicate918); 


                    if ( _first_0==null ) _first_0 = GREATER_EQUAL142;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate920);
                    rowValueConstructor143=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor143.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate922);
                    comparativePredicateValue144=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue144.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:223:4: ^( IS_NULL rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NULL145=(CommonTree)match(input,IS_NULL,FOLLOW_IS_NULL_in_predicate931); 


                    if ( _first_0==null ) _first_0 = IS_NULL145;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate933);
                    rowValueConstructor146=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor146.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:224:4: ^( IS_NOT_NULL rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NOT_NULL147=(CommonTree)match(input,IS_NOT_NULL,FOLLOW_IS_NOT_NULL_in_predicate942);  
                    stream_IS_NOT_NULL.add(IS_NOT_NULL147);


                    if ( _first_0==null ) _first_0 = IS_NOT_NULL147;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate944);
                    rowValueConstructor148=rowValueConstructor();

                    state._fsp--;

                    stream_rowValueConstructor.add(rowValueConstructor148.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: rowValueConstructor
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 224:41: -> ^( NOT ^( IS_NULL rowValueConstructor ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:224:44: ^( NOT ^( IS_NULL rowValueConstructor ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:224:51: ^( IS_NULL rowValueConstructor )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(IS_NULL, "IS_NULL")
                        , root_2);

                        adaptor.addChild(root_2, stream_rowValueConstructor.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:225:4: ^( LIKE valueExpression valueExpression ( escapeSpecification )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LIKE149=(CommonTree)match(input,LIKE,FOLLOW_LIKE_in_predicate969); 


                    if ( _first_0==null ) _first_0 = LIKE149;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate971);
                    valueExpression150=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression150.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate973);
                    valueExpression151=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression151.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:225:44: ( escapeSpecification )?
                    int alt46=2;
                    int LA46_0 = input.LA(1);

                    if ( (LA46_0==ESCAPE) ) {
                        alt46=1;
                    }
                    switch (alt46) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:225:44: escapeSpecification
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_escapeSpecification_in_predicate975);
                            escapeSpecification152=escapeSpecification();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = escapeSpecification152.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:4: ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_LIKE153=(CommonTree)match(input,NOT_LIKE,FOLLOW_NOT_LIKE_in_predicate985);  
                    stream_NOT_LIKE.add(NOT_LIKE153);


                    if ( _first_0==null ) _first_0 = NOT_LIKE153;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate987);
                    valueExpression154=valueExpression();

                    state._fsp--;

                    stream_valueExpression.add(valueExpression154.getTree());

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate989);
                    valueExpression155=valueExpression();

                    state._fsp--;

                    stream_valueExpression.add(valueExpression155.getTree());

                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:48: ( escapeSpecification )?
                    int alt47=2;
                    int LA47_0 = input.LA(1);

                    if ( (LA47_0==ESCAPE) ) {
                        alt47=1;
                    }
                    switch (alt47) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:48: escapeSpecification
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_escapeSpecification_in_predicate991);
                            escapeSpecification156=escapeSpecification();

                            state._fsp--;

                            stream_escapeSpecification.add(escapeSpecification156.getTree());

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: valueExpression, escapeSpecification, valueExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 226:71: -> ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:74: ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:81: ^( LIKE valueExpression valueExpression ( escapeSpecification )? )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(LIKE, "LIKE")
                        , root_2);

                        adaptor.addChild(root_2, stream_valueExpression.nextTree());

                        adaptor.addChild(root_2, stream_valueExpression.nextTree());

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:121: ( escapeSpecification )?
                        if ( stream_escapeSpecification.hasNext() ) {
                            adaptor.addChild(root_2, stream_escapeSpecification.nextTree());

                        }
                        stream_escapeSpecification.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:227:4: ^( BETWEEN rowValueConstructor betweenList )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    BETWEEN157=(CommonTree)match(input,BETWEEN,FOLLOW_BETWEEN_in_predicate1022); 


                    if ( _first_0==null ) _first_0 = BETWEEN157;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1024);
                    rowValueConstructor158=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor158.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_betweenList_in_predicate1026);
                    betweenList159=betweenList();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = betweenList159.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:228:4: ^( NOT_BETWEEN rowValueConstructor betweenList )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_BETWEEN160=(CommonTree)match(input,NOT_BETWEEN,FOLLOW_NOT_BETWEEN_in_predicate1035);  
                    stream_NOT_BETWEEN.add(NOT_BETWEEN160);


                    if ( _first_0==null ) _first_0 = NOT_BETWEEN160;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1037);
                    rowValueConstructor161=rowValueConstructor();

                    state._fsp--;

                    stream_rowValueConstructor.add(rowValueConstructor161.getTree());

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_betweenList_in_predicate1039);
                    betweenList162=betweenList();

                    state._fsp--;

                    stream_betweenList.add(betweenList162.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: rowValueConstructor, betweenList
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 228:53: -> ^( NOT ^( BETWEEN rowValueConstructor betweenList ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:228:56: ^( NOT ^( BETWEEN rowValueConstructor betweenList ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:228:63: ^( BETWEEN rowValueConstructor betweenList )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(BETWEEN, "BETWEEN")
                        , root_2);

                        adaptor.addChild(root_2, stream_rowValueConstructor.nextTree());

                        adaptor.addChild(root_2, stream_betweenList.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:229:4: ^( IN rowValueConstructor inPredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IN163=(CommonTree)match(input,IN,FOLLOW_IN_in_predicate1066); 


                    if ( _first_0==null ) _first_0 = IN163;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1068);
                    rowValueConstructor164=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor164.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_inPredicateValue_in_predicate1070);
                    inPredicateValue165=inPredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = inPredicateValue165.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:230:4: ^( NOT_IN rowValueConstructor inPredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_IN166=(CommonTree)match(input,NOT_IN,FOLLOW_NOT_IN_in_predicate1079);  
                    stream_NOT_IN.add(NOT_IN166);


                    if ( _first_0==null ) _first_0 = NOT_IN166;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1081);
                    rowValueConstructor167=rowValueConstructor();

                    state._fsp--;

                    stream_rowValueConstructor.add(rowValueConstructor167.getTree());

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_inPredicateValue_in_predicate1083);
                    inPredicateValue168=inPredicateValue();

                    state._fsp--;

                    stream_inPredicateValue.add(inPredicateValue168.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: rowValueConstructor, inPredicateValue
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 230:53: -> ^( NOT ^( IN rowValueConstructor inPredicateValue ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:230:56: ^( NOT ^( IN rowValueConstructor inPredicateValue ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:230:63: ^( IN rowValueConstructor inPredicateValue )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(IN, "IN")
                        , root_2);

                        adaptor.addChild(root_2, stream_rowValueConstructor.nextTree());

                        adaptor.addChild(root_2, stream_inPredicateValue.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:231:4: ^( MEMBER_OF rowValueConstructor rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MEMBER_OF169=(CommonTree)match(input,MEMBER_OF,FOLLOW_MEMBER_OF_in_predicate1110); 


                    if ( _first_0==null ) _first_0 = MEMBER_OF169;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1112);
                    rowValueConstructor170=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor170.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1114);
                    rowValueConstructor171=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor171.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:232:4: ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_MEMBER_OF172=(CommonTree)match(input,NOT_MEMBER_OF,FOLLOW_NOT_MEMBER_OF_in_predicate1123); 


                    if ( _first_0==null ) _first_0 = NOT_MEMBER_OF172;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1125);
                    rowValueConstructor173=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor173.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1127);
                    rowValueConstructor174=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor174.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:233:4: ^( IS_EMPTY rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_EMPTY175=(CommonTree)match(input,IS_EMPTY,FOLLOW_IS_EMPTY_in_predicate1137); 


                    if ( _first_0==null ) _first_0 = IS_EMPTY175;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1139);
                    rowValueConstructor176=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor176.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:234:4: ^( IS_NOT_EMPTY rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NOT_EMPTY177=(CommonTree)match(input,IS_NOT_EMPTY,FOLLOW_IS_NOT_EMPTY_in_predicate1148); 


                    if ( _first_0==null ) _first_0 = IS_NOT_EMPTY177;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1150);
                    rowValueConstructor178=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor178.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:235:4: rowValueConstructor
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1157);
                    rowValueConstructor179=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = rowValueConstructor179.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "predicate"


    public static class betweenList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "betweenList"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:238:1: betweenList : ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor ) ;
    public final GeneratedHQLResolver.betweenList_return betweenList() throws RecognitionException {
        GeneratedHQLResolver.betweenList_return retval = new GeneratedHQLResolver.betweenList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BETWEEN_LIST180=null;
        GeneratedHQLResolver.rowValueConstructor_return lower =null;

        GeneratedHQLResolver.rowValueConstructor_return upper =null;


        CommonTree BETWEEN_LIST180_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:239:2: ( ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:239:4: ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            BETWEEN_LIST180=(CommonTree)match(input,BETWEEN_LIST,FOLLOW_BETWEEN_LIST_in_betweenList1170); 


            if ( _first_0==null ) _first_0 = BETWEEN_LIST180;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_betweenList1174);
            lower=rowValueConstructor();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = lower.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_betweenList1178);
            upper=rowValueConstructor();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = upper.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "betweenList"


    public static class comparativePredicateValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "comparativePredicateValue"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:242:1: comparativePredicateValue : rowValueConstructor ;
    public final GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue() throws RecognitionException {
        GeneratedHQLResolver.comparativePredicateValue_return retval = new GeneratedHQLResolver.comparativePredicateValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor181 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:243:2: ( rowValueConstructor )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:243:4: rowValueConstructor
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_comparativePredicateValue1191);
            rowValueConstructor181=rowValueConstructor();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = rowValueConstructor181.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "comparativePredicateValue"


    public static class rowValueConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rowValueConstructor"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:246:1: rowValueConstructor : valueExpression ;
    public final GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor() throws RecognitionException {
        GeneratedHQLResolver.rowValueConstructor_return retval = new GeneratedHQLResolver.rowValueConstructor_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression182 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:247:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:247:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_rowValueConstructor1202);
            valueExpression182=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression182.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rowValueConstructor"


    public static class escapeSpecification_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "escapeSpecification"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:250:1: escapeSpecification : ^( ESCAPE characterValueExpression ) ;
    public final GeneratedHQLResolver.escapeSpecification_return escapeSpecification() throws RecognitionException {
        GeneratedHQLResolver.escapeSpecification_return retval = new GeneratedHQLResolver.escapeSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ESCAPE183=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression184 =null;


        CommonTree ESCAPE183_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:251:2: ( ^( ESCAPE characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:251:4: ^( ESCAPE characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ESCAPE183=(CommonTree)match(input,ESCAPE,FOLLOW_ESCAPE_in_escapeSpecification1214); 


            if ( _first_0==null ) _first_0 = ESCAPE183;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_escapeSpecification1216);
            characterValueExpression184=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression184.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "escapeSpecification"


    public static class inPredicateValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "inPredicateValue"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:254:1: inPredicateValue : ^( IN_LIST ( valueExpression )+ ) ;
    public final GeneratedHQLResolver.inPredicateValue_return inPredicateValue() throws RecognitionException {
        GeneratedHQLResolver.inPredicateValue_return retval = new GeneratedHQLResolver.inPredicateValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IN_LIST185=null;
        GeneratedHQLResolver.valueExpression_return valueExpression186 =null;


        CommonTree IN_LIST185_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:255:2: ( ^( IN_LIST ( valueExpression )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:255:4: ^( IN_LIST ( valueExpression )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            IN_LIST185=(CommonTree)match(input,IN_LIST,FOLLOW_IN_LIST_in_inPredicateValue1229); 


            if ( _first_0==null ) _first_0 = IN_LIST185;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:255:14: ( valueExpression )+
            int cnt49=0;
            loop49:
            do {
                int alt49=2;
                int LA49_0 = input.LA(1);

                if ( (LA49_0==ABS||(LA49_0 >= ALIAS_REF && LA49_0 <= ALL)||LA49_0==ANY||(LA49_0 >= ASTERISK && LA49_0 <= AVG)||LA49_0==BIT_LENGTH||(LA49_0 >= CAST && LA49_0 <= CHARACTER_LITERAL)||LA49_0==COALESCE||(LA49_0 >= CONCAT && LA49_0 <= COUNT)||(LA49_0 >= CURRENT_DATE && LA49_0 <= CURRENT_TIMESTAMP)||LA49_0==DECIMAL_LITERAL||(LA49_0 >= DOT_CLASS && LA49_0 <= DOUBLE_PIPE)||LA49_0==ELEMENTS||LA49_0==EXISTS||LA49_0==EXTRACT||LA49_0==FALSE||LA49_0==FLOATING_POINT_LITERAL||LA49_0==FUNCTION||LA49_0==HEX_LITERAL||(LA49_0 >= INDEX && LA49_0 <= INDICES)||LA49_0==INTEGER_LITERAL||LA49_0==JAVA_CONSTANT||LA49_0==JPA_PARAM||LA49_0==LENGTH||(LA49_0 >= LOCATE && LA49_0 <= LOWER)||(LA49_0 >= MAX && LA49_0 <= MAXINDEX)||(LA49_0 >= MIN && LA49_0 <= MINUS)||LA49_0==MOD||LA49_0==NAMED_PARAM||(LA49_0 >= NULL && LA49_0 <= NULLIF)||(LA49_0 >= OCTAL_LITERAL && LA49_0 <= OCTET_LENGTH)||(LA49_0 >= PARAM && LA49_0 <= PATH)||(LA49_0 >= PLUS && LA49_0 <= POSITION)||LA49_0==PROPERTY_REFERENCE||LA49_0==SEARCHED_CASE||(LA49_0 >= SIMPLE_CASE && LA49_0 <= SOME)||(LA49_0 >= SQRT && LA49_0 <= SUM)||(LA49_0 >= TRIM && LA49_0 <= TRUE)||(LA49_0 >= UNARY_MINUS && LA49_0 <= UNARY_PLUS)||LA49_0==UPPER||LA49_0==VECTOR_EXPR) ) {
                    alt49=1;
                }


                switch (alt49) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:255:14: valueExpression
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_valueExpression_in_inPredicateValue1231);
            	    valueExpression186=valueExpression();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = valueExpression186.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt49 >= 1 ) break loop49;
                        EarlyExitException eee =
                            new EarlyExitException(49, input);
                        throw eee;
                }
                cnt49++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "inPredicateValue"


    public static class numericValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numericValueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:258:1: numericValueExpression : valueExpression ;
    public final GeneratedHQLResolver.numericValueExpression_return numericValueExpression() throws RecognitionException {
        GeneratedHQLResolver.numericValueExpression_return retval = new GeneratedHQLResolver.numericValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression187 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:259:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:259:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_numericValueExpression1244);
            valueExpression187=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression187.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numericValueExpression"


    public static class characterValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "characterValueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:262:1: characterValueExpression : valueExpression ;
    public final GeneratedHQLResolver.characterValueExpression_return characterValueExpression() throws RecognitionException {
        GeneratedHQLResolver.characterValueExpression_return retval = new GeneratedHQLResolver.characterValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression188 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:263:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:263:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_characterValueExpression1255);
            valueExpression188=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression188.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "characterValueExpression"


    public static class datetimeValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeValueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:266:1: datetimeValueExpression : valueExpression ;
    public final GeneratedHQLResolver.datetimeValueExpression_return datetimeValueExpression() throws RecognitionException {
        GeneratedHQLResolver.datetimeValueExpression_return retval = new GeneratedHQLResolver.datetimeValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression189 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:267:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:267:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_datetimeValueExpression1266);
            valueExpression189=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression189.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeValueExpression"


    public static class valueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "valueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:270:1: valueExpression : ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary );
    public final GeneratedHQLResolver.valueExpression_return valueExpression() throws RecognitionException {
        GeneratedHQLResolver.valueExpression_return retval = new GeneratedHQLResolver.valueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOUBLE_PIPE190=null;
        CommonTree UNARY_MINUS192=null;
        CommonTree UNARY_PLUS194=null;
        CommonTree PLUS196=null;
        CommonTree MINUS199=null;
        CommonTree ASTERISK202=null;
        CommonTree SOLIDUS205=null;
        CommonTree EXISTS208=null;
        CommonTree SOME210=null;
        CommonTree ALL212=null;
        CommonTree ANY214=null;
        CommonTree VECTOR_EXPR216=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression191 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression193 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression195 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression197 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression198 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression200 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression201 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression203 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression204 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression206 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression207 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor209 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression211 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression213 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression215 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression217 =null;

        GeneratedHQLResolver.valueExpressionPrimary_return valueExpressionPrimary218 =null;


        CommonTree DOUBLE_PIPE190_tree=null;
        CommonTree UNARY_MINUS192_tree=null;
        CommonTree UNARY_PLUS194_tree=null;
        CommonTree PLUS196_tree=null;
        CommonTree MINUS199_tree=null;
        CommonTree ASTERISK202_tree=null;
        CommonTree SOLIDUS205_tree=null;
        CommonTree EXISTS208_tree=null;
        CommonTree SOME210_tree=null;
        CommonTree ALL212_tree=null;
        CommonTree ANY214_tree=null;
        CommonTree VECTOR_EXPR216_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:2: ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary )
            int alt52=13;
            switch ( input.LA(1) ) {
            case DOUBLE_PIPE:
                {
                alt52=1;
                }
                break;
            case UNARY_MINUS:
                {
                alt52=2;
                }
                break;
            case UNARY_PLUS:
                {
                alt52=3;
                }
                break;
            case PLUS:
                {
                alt52=4;
                }
                break;
            case MINUS:
                {
                alt52=5;
                }
                break;
            case ASTERISK:
                {
                alt52=6;
                }
                break;
            case SOLIDUS:
                {
                alt52=7;
                }
                break;
            case EXISTS:
                {
                alt52=8;
                }
                break;
            case SOME:
                {
                alt52=9;
                }
                break;
            case ALL:
                {
                alt52=10;
                }
                break;
            case ANY:
                {
                alt52=11;
                }
                break;
            case VECTOR_EXPR:
                {
                alt52=12;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case ELEMENTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UPPER:
                {
                alt52=13;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 52, 0, input);

                throw nvae;

            }

            switch (alt52) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:4: ^( DOUBLE_PIPE ( characterValueExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOUBLE_PIPE190=(CommonTree)match(input,DOUBLE_PIPE,FOLLOW_DOUBLE_PIPE_in_valueExpression1279); 


                    if ( _first_0==null ) _first_0 = DOUBLE_PIPE190;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:19: ( characterValueExpression )+
                    int cnt50=0;
                    loop50:
                    do {
                        int alt50=2;
                        int LA50_0 = input.LA(1);

                        if ( (LA50_0==ABS||(LA50_0 >= ALIAS_REF && LA50_0 <= ALL)||LA50_0==ANY||(LA50_0 >= ASTERISK && LA50_0 <= AVG)||LA50_0==BIT_LENGTH||(LA50_0 >= CAST && LA50_0 <= CHARACTER_LITERAL)||LA50_0==COALESCE||(LA50_0 >= CONCAT && LA50_0 <= COUNT)||(LA50_0 >= CURRENT_DATE && LA50_0 <= CURRENT_TIMESTAMP)||LA50_0==DECIMAL_LITERAL||(LA50_0 >= DOT_CLASS && LA50_0 <= DOUBLE_PIPE)||LA50_0==ELEMENTS||LA50_0==EXISTS||LA50_0==EXTRACT||LA50_0==FALSE||LA50_0==FLOATING_POINT_LITERAL||LA50_0==FUNCTION||LA50_0==HEX_LITERAL||(LA50_0 >= INDEX && LA50_0 <= INDICES)||LA50_0==INTEGER_LITERAL||LA50_0==JAVA_CONSTANT||LA50_0==JPA_PARAM||LA50_0==LENGTH||(LA50_0 >= LOCATE && LA50_0 <= LOWER)||(LA50_0 >= MAX && LA50_0 <= MAXINDEX)||(LA50_0 >= MIN && LA50_0 <= MINUS)||LA50_0==MOD||LA50_0==NAMED_PARAM||(LA50_0 >= NULL && LA50_0 <= NULLIF)||(LA50_0 >= OCTAL_LITERAL && LA50_0 <= OCTET_LENGTH)||(LA50_0 >= PARAM && LA50_0 <= PATH)||(LA50_0 >= PLUS && LA50_0 <= POSITION)||LA50_0==PROPERTY_REFERENCE||LA50_0==SEARCHED_CASE||(LA50_0 >= SIMPLE_CASE && LA50_0 <= SOME)||(LA50_0 >= SQRT && LA50_0 <= SUM)||(LA50_0 >= TRIM && LA50_0 <= TRUE)||(LA50_0 >= UNARY_MINUS && LA50_0 <= UNARY_PLUS)||LA50_0==UPPER||LA50_0==VECTOR_EXPR) ) {
                            alt50=1;
                        }


                        switch (alt50) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:19: characterValueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_characterValueExpression_in_valueExpression1281);
                    	    characterValueExpression191=characterValueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = characterValueExpression191.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt50 >= 1 ) break loop50;
                                EarlyExitException eee =
                                    new EarlyExitException(50, input);
                                throw eee;
                        }
                        cnt50++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:272:4: ^( UNARY_MINUS numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNARY_MINUS192=(CommonTree)match(input,UNARY_MINUS,FOLLOW_UNARY_MINUS_in_valueExpression1291); 


                    if ( _first_0==null ) _first_0 = UNARY_MINUS192;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1293);
                    numericValueExpression193=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression193.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:273:4: ^( UNARY_PLUS numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNARY_PLUS194=(CommonTree)match(input,UNARY_PLUS,FOLLOW_UNARY_PLUS_in_valueExpression1302); 


                    if ( _first_0==null ) _first_0 = UNARY_PLUS194;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1304);
                    numericValueExpression195=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression195.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:274:4: ^( PLUS valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PLUS196=(CommonTree)match(input,PLUS,FOLLOW_PLUS_in_valueExpression1313); 


                    if ( _first_0==null ) _first_0 = PLUS196;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1315);
                    valueExpression197=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression197.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1317);
                    valueExpression198=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression198.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:275:4: ^( MINUS valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MINUS199=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_valueExpression1326); 


                    if ( _first_0==null ) _first_0 = MINUS199;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1328);
                    valueExpression200=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression200.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1330);
                    valueExpression201=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression201.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:276:4: ^( ASTERISK numericValueExpression numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ASTERISK202=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_valueExpression1339); 


                    if ( _first_0==null ) _first_0 = ASTERISK202;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1341);
                    numericValueExpression203=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression203.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1343);
                    numericValueExpression204=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression204.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:277:4: ^( SOLIDUS numericValueExpression numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SOLIDUS205=(CommonTree)match(input,SOLIDUS,FOLLOW_SOLIDUS_in_valueExpression1352); 


                    if ( _first_0==null ) _first_0 = SOLIDUS205;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1354);
                    numericValueExpression206=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression206.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1356);
                    numericValueExpression207=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression207.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:278:4: ^( EXISTS rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EXISTS208=(CommonTree)match(input,EXISTS,FOLLOW_EXISTS_in_valueExpression1365); 


                    if ( _first_0==null ) _first_0 = EXISTS208;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_valueExpression1367);
                    rowValueConstructor209=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor209.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:279:4: ^( SOME valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SOME210=(CommonTree)match(input,SOME,FOLLOW_SOME_in_valueExpression1375); 


                    if ( _first_0==null ) _first_0 = SOME210;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1377);
                    valueExpression211=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression211.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:280:4: ^( ALL valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ALL212=(CommonTree)match(input,ALL,FOLLOW_ALL_in_valueExpression1386); 


                    if ( _first_0==null ) _first_0 = ALL212;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1388);
                    valueExpression213=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression213.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:281:4: ^( ANY valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ANY214=(CommonTree)match(input,ANY,FOLLOW_ANY_in_valueExpression1397); 


                    if ( _first_0==null ) _first_0 = ANY214;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1399);
                    valueExpression215=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression215.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:282:4: ^( VECTOR_EXPR ( valueExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    VECTOR_EXPR216=(CommonTree)match(input,VECTOR_EXPR,FOLLOW_VECTOR_EXPR_in_valueExpression1408); 


                    if ( _first_0==null ) _first_0 = VECTOR_EXPR216;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:282:19: ( valueExpression )+
                    int cnt51=0;
                    loop51:
                    do {
                        int alt51=2;
                        int LA51_0 = input.LA(1);

                        if ( (LA51_0==ABS||(LA51_0 >= ALIAS_REF && LA51_0 <= ALL)||LA51_0==ANY||(LA51_0 >= ASTERISK && LA51_0 <= AVG)||LA51_0==BIT_LENGTH||(LA51_0 >= CAST && LA51_0 <= CHARACTER_LITERAL)||LA51_0==COALESCE||(LA51_0 >= CONCAT && LA51_0 <= COUNT)||(LA51_0 >= CURRENT_DATE && LA51_0 <= CURRENT_TIMESTAMP)||LA51_0==DECIMAL_LITERAL||(LA51_0 >= DOT_CLASS && LA51_0 <= DOUBLE_PIPE)||LA51_0==ELEMENTS||LA51_0==EXISTS||LA51_0==EXTRACT||LA51_0==FALSE||LA51_0==FLOATING_POINT_LITERAL||LA51_0==FUNCTION||LA51_0==HEX_LITERAL||(LA51_0 >= INDEX && LA51_0 <= INDICES)||LA51_0==INTEGER_LITERAL||LA51_0==JAVA_CONSTANT||LA51_0==JPA_PARAM||LA51_0==LENGTH||(LA51_0 >= LOCATE && LA51_0 <= LOWER)||(LA51_0 >= MAX && LA51_0 <= MAXINDEX)||(LA51_0 >= MIN && LA51_0 <= MINUS)||LA51_0==MOD||LA51_0==NAMED_PARAM||(LA51_0 >= NULL && LA51_0 <= NULLIF)||(LA51_0 >= OCTAL_LITERAL && LA51_0 <= OCTET_LENGTH)||(LA51_0 >= PARAM && LA51_0 <= PATH)||(LA51_0 >= PLUS && LA51_0 <= POSITION)||LA51_0==PROPERTY_REFERENCE||LA51_0==SEARCHED_CASE||(LA51_0 >= SIMPLE_CASE && LA51_0 <= SOME)||(LA51_0 >= SQRT && LA51_0 <= SUM)||(LA51_0 >= TRIM && LA51_0 <= TRUE)||(LA51_0 >= UNARY_MINUS && LA51_0 <= UNARY_PLUS)||LA51_0==UPPER||LA51_0==VECTOR_EXPR) ) {
                            alt51=1;
                        }


                        switch (alt51) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:282:19: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_valueExpression1410);
                    	    valueExpression217=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression217.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt51 >= 1 ) break loop51;
                                EarlyExitException eee =
                                    new EarlyExitException(51, input);
                                throw eee;
                        }
                        cnt51++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:283:4: valueExpressionPrimary
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpressionPrimary_in_valueExpression1418);
                    valueExpressionPrimary218=valueExpressionPrimary();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = valueExpressionPrimary218.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "valueExpression"


    public static class valueExpressionPrimary_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "valueExpressionPrimary"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:286:1: valueExpressionPrimary : ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH ret= propertyReferencePath ) -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath ) );
    public final GeneratedHQLResolver.valueExpressionPrimary_return valueExpressionPrimary() throws RecognitionException {
        GeneratedHQLResolver.valueExpressionPrimary_return retval = new GeneratedHQLResolver.valueExpressionPrimary_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUB_QUERY226=null;
        CommonTree ALIAS_REF228=null;
        CommonTree DOT_CLASS229=null;
        CommonTree JAVA_CONSTANT231=null;
        CommonTree PATH233=null;
        GeneratedHQLResolver.propertyReferencePath_return ret =null;

        GeneratedHQLResolver.caseExpression_return caseExpression219 =null;

        GeneratedHQLResolver.function_return function220 =null;

        GeneratedHQLResolver.collectionFunction_return collectionFunction221 =null;

        GeneratedHQLResolver.collectionExpression_return collectionExpression222 =null;

        GeneratedHQLResolver.constant_return constant223 =null;

        GeneratedHQLResolver.parameter_return parameter224 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference225 =null;

        GeneratedHQLResolver.queryStatementSet_return queryStatementSet227 =null;

        GeneratedHQLResolver.path_return path230 =null;

        GeneratedHQLResolver.path_return path232 =null;


        CommonTree SUB_QUERY226_tree=null;
        CommonTree ALIAS_REF228_tree=null;
        CommonTree DOT_CLASS229_tree=null;
        CommonTree JAVA_CONSTANT231_tree=null;
        CommonTree PATH233_tree=null;
        RewriteRuleNodeStream stream_PATH=new RewriteRuleNodeStream(adaptor,"token PATH");
        RewriteRuleSubtreeStream stream_propertyReferencePath=new RewriteRuleSubtreeStream(adaptor,"rule propertyReferencePath");
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:287:2: ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH ret= propertyReferencePath ) -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath ) )
            int alt53=12;
            switch ( input.LA(1) ) {
            case COALESCE:
            case NULLIF:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
                {
                alt53=1;
                }
                break;
            case ABS:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CONCAT:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case EXTRACT:
            case FUNCTION:
            case INDEX:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MIN:
            case MOD:
            case OCTET_LENGTH:
            case POSITION:
            case SIZE:
            case SQRT:
            case SUBSTRING:
            case SUM:
            case TRIM:
            case UPPER:
                {
                alt53=2;
                }
                break;
            case MAXELEMENT:
            case MAXINDEX:
            case MINELEMENT:
            case MININDEX:
                {
                alt53=3;
                }
                break;
            case ELEMENTS:
            case INDICES:
                {
                alt53=4;
                }
                break;
            case CHARACTER_LITERAL:
            case CONST_STRING_VALUE:
            case DECIMAL_LITERAL:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case NULL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
            case TRUE:
                {
                alt53=5;
                }
                break;
            case JPA_PARAM:
            case NAMED_PARAM:
            case PARAM:
                {
                alt53=6;
                }
                break;
            case PROPERTY_REFERENCE:
                {
                alt53=7;
                }
                break;
            case SUB_QUERY:
                {
                alt53=8;
                }
                break;
            case ALIAS_REF:
                {
                alt53=9;
                }
                break;
            case DOT_CLASS:
                {
                alt53=10;
                }
                break;
            case JAVA_CONSTANT:
                {
                alt53=11;
                }
                break;
            case PATH:
                {
                alt53=12;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;

            }

            switch (alt53) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:287:4: caseExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_caseExpression_in_valueExpressionPrimary1429);
                    caseExpression219=caseExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = caseExpression219.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:288:4: function
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_function_in_valueExpressionPrimary1434);
                    function220=function();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = function220.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:289:4: collectionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionFunction_in_valueExpressionPrimary1439);
                    collectionFunction221=collectionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionFunction221.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:290:4: collectionExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionExpression_in_valueExpressionPrimary1444);
                    collectionExpression222=collectionExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionExpression222.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:291:4: constant
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_constant_in_valueExpressionPrimary1449);
                    constant223=constant();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = constant223.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:292:4: parameter
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_parameter_in_valueExpressionPrimary1454);
                    parameter224=parameter();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = parameter224.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:293:4: propertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_valueExpressionPrimary1459);
                    propertyReference225=propertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = propertyReference225.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:294:4: ^( SUB_QUERY queryStatementSet )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SUB_QUERY226=(CommonTree)match(input,SUB_QUERY,FOLLOW_SUB_QUERY_in_valueExpressionPrimary1465); 


                    if ( _first_0==null ) _first_0 = SUB_QUERY226;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryStatementSet_in_valueExpressionPrimary1467);
                    queryStatementSet227=queryStatementSet();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryStatementSet227.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:295:4: ALIAS_REF
                    {
                    _last = (CommonTree)input.LT(1);
                    ALIAS_REF228=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_valueExpressionPrimary1473); 
                     
                    if ( _first_0==null ) _first_0 = ALIAS_REF228;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:296:4: ^( DOT_CLASS path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT_CLASS229=(CommonTree)match(input,DOT_CLASS,FOLLOW_DOT_CLASS_in_valueExpressionPrimary1480); 


                    if ( _first_0==null ) _first_0 = DOT_CLASS229;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_valueExpressionPrimary1482);
                    path230=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path230.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:297:4: ^( JAVA_CONSTANT path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    JAVA_CONSTANT231=(CommonTree)match(input,JAVA_CONSTANT,FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1490); 


                    if ( _first_0==null ) _first_0 = JAVA_CONSTANT231;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_valueExpressionPrimary1492);
                    path232=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path232.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:298:4: ^( PATH ret= propertyReferencePath )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PATH233=(CommonTree)match(input,PATH,FOLLOW_PATH_in_valueExpressionPrimary1500);  
                    stream_PATH.add(PATH233);


                    if ( _first_0==null ) _first_0 = PATH233;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReferencePath_in_valueExpressionPrimary1504);
                    ret=propertyReferencePath();

                    state._fsp--;

                    stream_propertyReferencePath.add(ret.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: propertyReferencePath, PATH
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 298:38: -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:298:41: ^( PATH[$PATH, $ret.retPath] propertyReferencePath )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        new PropertyPathTree(PATH, PATH233, (ret!=null?ret.retPath:null))
                        , root_1);

                        adaptor.addChild(root_1, stream_propertyReferencePath.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "valueExpressionPrimary"


    public static class caseExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "caseExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:301:1: caseExpression : ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) );
    public final GeneratedHQLResolver.caseExpression_return caseExpression() throws RecognitionException {
        GeneratedHQLResolver.caseExpression_return retval = new GeneratedHQLResolver.caseExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree NULLIF234=null;
        CommonTree COALESCE237=null;
        CommonTree SIMPLE_CASE240=null;
        CommonTree SEARCHED_CASE244=null;
        GeneratedHQLResolver.valueExpression_return valueExpression235 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression236 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression238 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression239 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression241 =null;

        GeneratedHQLResolver.simpleCaseWhenClause_return simpleCaseWhenClause242 =null;

        GeneratedHQLResolver.elseClause_return elseClause243 =null;

        GeneratedHQLResolver.searchedWhenClause_return searchedWhenClause245 =null;

        GeneratedHQLResolver.elseClause_return elseClause246 =null;


        CommonTree NULLIF234_tree=null;
        CommonTree COALESCE237_tree=null;
        CommonTree SIMPLE_CASE240_tree=null;
        CommonTree SEARCHED_CASE244_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:302:2: ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) )
            int alt59=4;
            switch ( input.LA(1) ) {
            case NULLIF:
                {
                alt59=1;
                }
                break;
            case COALESCE:
                {
                alt59=2;
                }
                break;
            case SIMPLE_CASE:
                {
                alt59=3;
                }
                break;
            case SEARCHED_CASE:
                {
                alt59=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 59, 0, input);

                throw nvae;

            }

            switch (alt59) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:302:4: ^( NULLIF valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NULLIF234=(CommonTree)match(input,NULLIF,FOLLOW_NULLIF_in_caseExpression1531); 


                    if ( _first_0==null ) _first_0 = NULLIF234;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1533);
                    valueExpression235=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression235.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1535);
                    valueExpression236=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression236.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:303:4: ^( COALESCE valueExpression ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    COALESCE237=(CommonTree)match(input,COALESCE,FOLLOW_COALESCE_in_caseExpression1542); 


                    if ( _first_0==null ) _first_0 = COALESCE237;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1544);
                    valueExpression238=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression238.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:303:31: ( valueExpression )*
                    loop54:
                    do {
                        int alt54=2;
                        int LA54_0 = input.LA(1);

                        if ( (LA54_0==ABS||(LA54_0 >= ALIAS_REF && LA54_0 <= ALL)||LA54_0==ANY||(LA54_0 >= ASTERISK && LA54_0 <= AVG)||LA54_0==BIT_LENGTH||(LA54_0 >= CAST && LA54_0 <= CHARACTER_LITERAL)||LA54_0==COALESCE||(LA54_0 >= CONCAT && LA54_0 <= COUNT)||(LA54_0 >= CURRENT_DATE && LA54_0 <= CURRENT_TIMESTAMP)||LA54_0==DECIMAL_LITERAL||(LA54_0 >= DOT_CLASS && LA54_0 <= DOUBLE_PIPE)||LA54_0==ELEMENTS||LA54_0==EXISTS||LA54_0==EXTRACT||LA54_0==FALSE||LA54_0==FLOATING_POINT_LITERAL||LA54_0==FUNCTION||LA54_0==HEX_LITERAL||(LA54_0 >= INDEX && LA54_0 <= INDICES)||LA54_0==INTEGER_LITERAL||LA54_0==JAVA_CONSTANT||LA54_0==JPA_PARAM||LA54_0==LENGTH||(LA54_0 >= LOCATE && LA54_0 <= LOWER)||(LA54_0 >= MAX && LA54_0 <= MAXINDEX)||(LA54_0 >= MIN && LA54_0 <= MINUS)||LA54_0==MOD||LA54_0==NAMED_PARAM||(LA54_0 >= NULL && LA54_0 <= NULLIF)||(LA54_0 >= OCTAL_LITERAL && LA54_0 <= OCTET_LENGTH)||(LA54_0 >= PARAM && LA54_0 <= PATH)||(LA54_0 >= PLUS && LA54_0 <= POSITION)||LA54_0==PROPERTY_REFERENCE||LA54_0==SEARCHED_CASE||(LA54_0 >= SIMPLE_CASE && LA54_0 <= SOME)||(LA54_0 >= SQRT && LA54_0 <= SUM)||(LA54_0 >= TRIM && LA54_0 <= TRUE)||(LA54_0 >= UNARY_MINUS && LA54_0 <= UNARY_PLUS)||LA54_0==UPPER||LA54_0==VECTOR_EXPR) ) {
                            alt54=1;
                        }


                        switch (alt54) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:303:31: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_caseExpression1546);
                    	    valueExpression239=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression239.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop54;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:4: ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SIMPLE_CASE240=(CommonTree)match(input,SIMPLE_CASE,FOLLOW_SIMPLE_CASE_in_caseExpression1554); 


                    if ( _first_0==null ) _first_0 = SIMPLE_CASE240;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1556);
                    valueExpression241=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression241.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:34: ( simpleCaseWhenClause )+
                    int cnt55=0;
                    loop55:
                    do {
                        int alt55=2;
                        int LA55_0 = input.LA(1);

                        if ( (LA55_0==WHEN) ) {
                            alt55=1;
                        }


                        switch (alt55) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:34: simpleCaseWhenClause
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_simpleCaseWhenClause_in_caseExpression1558);
                    	    simpleCaseWhenClause242=simpleCaseWhenClause();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = simpleCaseWhenClause242.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt55 >= 1 ) break loop55;
                                EarlyExitException eee =
                                    new EarlyExitException(55, input);
                                throw eee;
                        }
                        cnt55++;
                    } while (true);


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:56: ( elseClause )?
                    int alt56=2;
                    int LA56_0 = input.LA(1);

                    if ( (LA56_0==ELSE) ) {
                        alt56=1;
                    }
                    switch (alt56) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:56: elseClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_elseClause_in_caseExpression1561);
                            elseClause243=elseClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = elseClause243.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:305:4: ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SEARCHED_CASE244=(CommonTree)match(input,SEARCHED_CASE,FOLLOW_SEARCHED_CASE_in_caseExpression1569); 


                    if ( _first_0==null ) _first_0 = SEARCHED_CASE244;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:305:20: ( searchedWhenClause )+
                    int cnt57=0;
                    loop57:
                    do {
                        int alt57=2;
                        int LA57_0 = input.LA(1);

                        if ( (LA57_0==WHEN) ) {
                            alt57=1;
                        }


                        switch (alt57) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:305:20: searchedWhenClause
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_searchedWhenClause_in_caseExpression1571);
                    	    searchedWhenClause245=searchedWhenClause();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = searchedWhenClause245.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt57 >= 1 ) break loop57;
                                EarlyExitException eee =
                                    new EarlyExitException(57, input);
                                throw eee;
                        }
                        cnt57++;
                    } while (true);


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:305:40: ( elseClause )?
                    int alt58=2;
                    int LA58_0 = input.LA(1);

                    if ( (LA58_0==ELSE) ) {
                        alt58=1;
                    }
                    switch (alt58) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:305:40: elseClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_elseClause_in_caseExpression1574);
                            elseClause246=elseClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = elseClause246.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "caseExpression"


    public static class simpleCaseWhenClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "simpleCaseWhenClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:308:1: simpleCaseWhenClause : ^( WHEN valueExpression valueExpression ) ;
    public final GeneratedHQLResolver.simpleCaseWhenClause_return simpleCaseWhenClause() throws RecognitionException {
        GeneratedHQLResolver.simpleCaseWhenClause_return retval = new GeneratedHQLResolver.simpleCaseWhenClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHEN247=null;
        GeneratedHQLResolver.valueExpression_return valueExpression248 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression249 =null;


        CommonTree WHEN247_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:309:2: ( ^( WHEN valueExpression valueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:309:4: ^( WHEN valueExpression valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHEN247=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_simpleCaseWhenClause1588); 


            if ( _first_0==null ) _first_0 = WHEN247;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1590);
            valueExpression248=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression248.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1592);
            valueExpression249=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression249.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "simpleCaseWhenClause"


    public static class searchedWhenClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchedWhenClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:312:1: searchedWhenClause : ^( WHEN searchCondition valueExpression ) ;
    public final GeneratedHQLResolver.searchedWhenClause_return searchedWhenClause() throws RecognitionException {
        GeneratedHQLResolver.searchedWhenClause_return retval = new GeneratedHQLResolver.searchedWhenClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHEN250=null;
        GeneratedHQLResolver.searchCondition_return searchCondition251 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression252 =null;


        CommonTree WHEN250_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:313:2: ( ^( WHEN searchCondition valueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:313:4: ^( WHEN searchCondition valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHEN250=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_searchedWhenClause1605); 


            if ( _first_0==null ) _first_0 = WHEN250;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_searchedWhenClause1607);
            searchCondition251=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition251.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_searchedWhenClause1609);
            valueExpression252=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression252.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchedWhenClause"


    public static class elseClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "elseClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:316:1: elseClause : ^( ELSE valueExpression ) ;
    public final GeneratedHQLResolver.elseClause_return elseClause() throws RecognitionException {
        GeneratedHQLResolver.elseClause_return retval = new GeneratedHQLResolver.elseClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELSE253=null;
        GeneratedHQLResolver.valueExpression_return valueExpression254 =null;


        CommonTree ELSE253_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:317:2: ( ^( ELSE valueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:317:4: ^( ELSE valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ELSE253=(CommonTree)match(input,ELSE,FOLLOW_ELSE_in_elseClause1622); 


            if ( _first_0==null ) _first_0 = ELSE253;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_elseClause1624);
            valueExpression254=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression254.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "elseClause"


    public static class function_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "function"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:320:1: function : ( setFunction | standardFunction );
    public final GeneratedHQLResolver.function_return function() throws RecognitionException {
        GeneratedHQLResolver.function_return retval = new GeneratedHQLResolver.function_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.setFunction_return setFunction255 =null;

        GeneratedHQLResolver.standardFunction_return standardFunction256 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:321:2: ( setFunction | standardFunction )
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( (LA60_0==AVG||LA60_0==COUNT||LA60_0==MAX||LA60_0==MIN||LA60_0==SUM) ) {
                alt60=1;
            }
            else if ( (LA60_0==ABS||LA60_0==BIT_LENGTH||(LA60_0 >= CAST && LA60_0 <= CHARACTER_LENGTH)||LA60_0==CONCAT||(LA60_0 >= CURRENT_DATE && LA60_0 <= CURRENT_TIMESTAMP)||LA60_0==EXTRACT||LA60_0==FUNCTION||LA60_0==INDEX||LA60_0==LENGTH||(LA60_0 >= LOCATE && LA60_0 <= LOWER)||LA60_0==MOD||LA60_0==OCTET_LENGTH||LA60_0==POSITION||LA60_0==SIZE||LA60_0==SQRT||LA60_0==SUBSTRING||LA60_0==TRIM||LA60_0==UPPER) ) {
                alt60=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 60, 0, input);

                throw nvae;

            }
            switch (alt60) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:321:4: setFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_setFunction_in_function1636);
                    setFunction255=setFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = setFunction255.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:322:4: standardFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_standardFunction_in_function1641);
                    standardFunction256=standardFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = standardFunction256.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "function"


    public static class setFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:325:1: setFunction : ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) );
    public final GeneratedHQLResolver.setFunction_return setFunction() throws RecognitionException {
        GeneratedHQLResolver.setFunction_return retval = new GeneratedHQLResolver.setFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUM257=null;
        CommonTree AVG259=null;
        CommonTree MAX261=null;
        CommonTree MIN263=null;
        CommonTree COUNT265=null;
        CommonTree ASTERISK266=null;
        CommonTree set267=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression258 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression260 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression262 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression264 =null;

        GeneratedHQLResolver.countFunctionArguments_return countFunctionArguments268 =null;


        CommonTree SUM257_tree=null;
        CommonTree AVG259_tree=null;
        CommonTree MAX261_tree=null;
        CommonTree MIN263_tree=null;
        CommonTree COUNT265_tree=null;
        CommonTree ASTERISK266_tree=null;
        CommonTree set267_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:326:2: ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) )
            int alt62=5;
            switch ( input.LA(1) ) {
            case SUM:
                {
                alt62=1;
                }
                break;
            case AVG:
                {
                alt62=2;
                }
                break;
            case MAX:
                {
                alt62=3;
                }
                break;
            case MIN:
                {
                alt62=4;
                }
                break;
            case COUNT:
                {
                alt62=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;

            }

            switch (alt62) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:326:4: ^( SUM numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SUM257=(CommonTree)match(input,SUM,FOLLOW_SUM_in_setFunction1653); 


                    if ( _first_0==null ) _first_0 = SUM257;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1655);
                    numericValueExpression258=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression258.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:327:4: ^( AVG numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    AVG259=(CommonTree)match(input,AVG,FOLLOW_AVG_in_setFunction1662); 


                    if ( _first_0==null ) _first_0 = AVG259;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1664);
                    numericValueExpression260=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression260.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:328:4: ^( MAX numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MAX261=(CommonTree)match(input,MAX,FOLLOW_MAX_in_setFunction1671); 


                    if ( _first_0==null ) _first_0 = MAX261;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1673);
                    numericValueExpression262=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression262.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:329:4: ^( MIN numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MIN263=(CommonTree)match(input,MIN,FOLLOW_MIN_in_setFunction1680); 


                    if ( _first_0==null ) _first_0 = MIN263;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1682);
                    numericValueExpression264=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression264.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:330:4: ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    COUNT265=(CommonTree)match(input,COUNT,FOLLOW_COUNT_in_setFunction1689); 


                    if ( _first_0==null ) _first_0 = COUNT265;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:330:12: ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments )
                    int alt61=2;
                    int LA61_0 = input.LA(1);

                    if ( (LA61_0==ASTERISK) ) {
                        alt61=1;
                    }
                    else if ( (LA61_0==ALL||LA61_0==DISTINCT) ) {
                        alt61=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 61, 0, input);

                        throw nvae;

                    }
                    switch (alt61) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:330:13: ASTERISK
                            {
                            _last = (CommonTree)input.LT(1);
                            ASTERISK266=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_setFunction1692); 
                             
                            if ( _first_1==null ) _first_1 = ASTERISK266;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:330:24: ( DISTINCT | ALL ) countFunctionArguments
                            {
                            _last = (CommonTree)input.LT(1);
                            set267=(CommonTree)input.LT(1);

                            if ( input.LA(1)==ALL||input.LA(1)==DISTINCT ) {
                                input.consume();
                                state.errorRecovery=false;
                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                throw mse;
                            }


                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_countFunctionArguments_in_setFunction1702);
                            countFunctionArguments268=countFunctionArguments();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = countFunctionArguments268.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setFunction"


    public static class standardFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "standardFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:333:1: standardFunction : ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction );
    public final GeneratedHQLResolver.standardFunction_return standardFunction() throws RecognitionException {
        GeneratedHQLResolver.standardFunction_return retval = new GeneratedHQLResolver.standardFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.functionFunction_return functionFunction269 =null;

        GeneratedHQLResolver.castFunction_return castFunction270 =null;

        GeneratedHQLResolver.concatFunction_return concatFunction271 =null;

        GeneratedHQLResolver.substringFunction_return substringFunction272 =null;

        GeneratedHQLResolver.trimFunction_return trimFunction273 =null;

        GeneratedHQLResolver.upperFunction_return upperFunction274 =null;

        GeneratedHQLResolver.lowerFunction_return lowerFunction275 =null;

        GeneratedHQLResolver.lengthFunction_return lengthFunction276 =null;

        GeneratedHQLResolver.locateFunction_return locateFunction277 =null;

        GeneratedHQLResolver.absFunction_return absFunction278 =null;

        GeneratedHQLResolver.sqrtFunction_return sqrtFunction279 =null;

        GeneratedHQLResolver.modFunction_return modFunction280 =null;

        GeneratedHQLResolver.sizeFunction_return sizeFunction281 =null;

        GeneratedHQLResolver.indexFunction_return indexFunction282 =null;

        GeneratedHQLResolver.currentDateFunction_return currentDateFunction283 =null;

        GeneratedHQLResolver.currentTimeFunction_return currentTimeFunction284 =null;

        GeneratedHQLResolver.currentTimestampFunction_return currentTimestampFunction285 =null;

        GeneratedHQLResolver.extractFunction_return extractFunction286 =null;

        GeneratedHQLResolver.positionFunction_return positionFunction287 =null;

        GeneratedHQLResolver.charLengthFunction_return charLengthFunction288 =null;

        GeneratedHQLResolver.octetLengthFunction_return octetLengthFunction289 =null;

        GeneratedHQLResolver.bitLengthFunction_return bitLengthFunction290 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:334:2: ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction )
            int alt63=22;
            switch ( input.LA(1) ) {
            case FUNCTION:
                {
                alt63=1;
                }
                break;
            case CAST:
                {
                alt63=2;
                }
                break;
            case CONCAT:
                {
                alt63=3;
                }
                break;
            case SUBSTRING:
                {
                alt63=4;
                }
                break;
            case TRIM:
                {
                alt63=5;
                }
                break;
            case UPPER:
                {
                alt63=6;
                }
                break;
            case LOWER:
                {
                alt63=7;
                }
                break;
            case LENGTH:
                {
                alt63=8;
                }
                break;
            case LOCATE:
                {
                alt63=9;
                }
                break;
            case ABS:
                {
                alt63=10;
                }
                break;
            case SQRT:
                {
                alt63=11;
                }
                break;
            case MOD:
                {
                alt63=12;
                }
                break;
            case SIZE:
                {
                alt63=13;
                }
                break;
            case INDEX:
                {
                alt63=14;
                }
                break;
            case CURRENT_DATE:
                {
                alt63=15;
                }
                break;
            case CURRENT_TIME:
                {
                alt63=16;
                }
                break;
            case CURRENT_TIMESTAMP:
                {
                alt63=17;
                }
                break;
            case EXTRACT:
                {
                alt63=18;
                }
                break;
            case POSITION:
                {
                alt63=19;
                }
                break;
            case CHARACTER_LENGTH:
                {
                alt63=20;
                }
                break;
            case OCTET_LENGTH:
                {
                alt63=21;
                }
                break;
            case BIT_LENGTH:
                {
                alt63=22;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 63, 0, input);

                throw nvae;

            }

            switch (alt63) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:334:4: functionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_functionFunction_in_standardFunction1715);
                    functionFunction269=functionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = functionFunction269.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:335:4: castFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_castFunction_in_standardFunction1720);
                    castFunction270=castFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = castFunction270.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:336:4: concatFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_concatFunction_in_standardFunction1725);
                    concatFunction271=concatFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = concatFunction271.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:337:4: substringFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_substringFunction_in_standardFunction1730);
                    substringFunction272=substringFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = substringFunction272.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:338:4: trimFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_trimFunction_in_standardFunction1735);
                    trimFunction273=trimFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = trimFunction273.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:339:4: upperFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_upperFunction_in_standardFunction1740);
                    upperFunction274=upperFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = upperFunction274.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:340:4: lowerFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_lowerFunction_in_standardFunction1745);
                    lowerFunction275=lowerFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = lowerFunction275.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:341:4: lengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_lengthFunction_in_standardFunction1750);
                    lengthFunction276=lengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = lengthFunction276.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:342:4: locateFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_locateFunction_in_standardFunction1755);
                    locateFunction277=locateFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = locateFunction277.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:343:4: absFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_absFunction_in_standardFunction1760);
                    absFunction278=absFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = absFunction278.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:344:4: sqrtFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqrtFunction_in_standardFunction1765);
                    sqrtFunction279=sqrtFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = sqrtFunction279.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:345:4: modFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_modFunction_in_standardFunction1770);
                    modFunction280=modFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = modFunction280.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:346:4: sizeFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sizeFunction_in_standardFunction1775);
                    sizeFunction281=sizeFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = sizeFunction281.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:347:4: indexFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_indexFunction_in_standardFunction1780);
                    indexFunction282=indexFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = indexFunction282.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:348:4: currentDateFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentDateFunction_in_standardFunction1785);
                    currentDateFunction283=currentDateFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentDateFunction283.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:349:4: currentTimeFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentTimeFunction_in_standardFunction1790);
                    currentTimeFunction284=currentTimeFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentTimeFunction284.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:350:4: currentTimestampFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentTimestampFunction_in_standardFunction1795);
                    currentTimestampFunction285=currentTimestampFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentTimestampFunction285.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:351:4: extractFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_extractFunction_in_standardFunction1800);
                    extractFunction286=extractFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = extractFunction286.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:352:4: positionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_positionFunction_in_standardFunction1805);
                    positionFunction287=positionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = positionFunction287.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 20 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:353:4: charLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_charLengthFunction_in_standardFunction1810);
                    charLengthFunction288=charLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = charLengthFunction288.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 21 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:354:4: octetLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_octetLengthFunction_in_standardFunction1815);
                    octetLengthFunction289=octetLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = octetLengthFunction289.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 22 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:355:4: bitLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_bitLengthFunction_in_standardFunction1820);
                    bitLengthFunction290=bitLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = bitLengthFunction290.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "standardFunction"


    public static class functionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "functionFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:358:1: functionFunction : ^( FUNCTION ( valueExpression )* ) ;
    public final GeneratedHQLResolver.functionFunction_return functionFunction() throws RecognitionException {
        GeneratedHQLResolver.functionFunction_return retval = new GeneratedHQLResolver.functionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FUNCTION291=null;
        GeneratedHQLResolver.valueExpression_return valueExpression292 =null;


        CommonTree FUNCTION291_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:359:2: ( ^( FUNCTION ( valueExpression )* ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:359:4: ^( FUNCTION ( valueExpression )* )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            FUNCTION291=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_functionFunction1833); 


            if ( _first_0==null ) _first_0 = FUNCTION291;
            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:359:16: ( valueExpression )*
                loop64:
                do {
                    int alt64=2;
                    int LA64_0 = input.LA(1);

                    if ( (LA64_0==ABS||(LA64_0 >= ALIAS_REF && LA64_0 <= ALL)||LA64_0==ANY||(LA64_0 >= ASTERISK && LA64_0 <= AVG)||LA64_0==BIT_LENGTH||(LA64_0 >= CAST && LA64_0 <= CHARACTER_LITERAL)||LA64_0==COALESCE||(LA64_0 >= CONCAT && LA64_0 <= COUNT)||(LA64_0 >= CURRENT_DATE && LA64_0 <= CURRENT_TIMESTAMP)||LA64_0==DECIMAL_LITERAL||(LA64_0 >= DOT_CLASS && LA64_0 <= DOUBLE_PIPE)||LA64_0==ELEMENTS||LA64_0==EXISTS||LA64_0==EXTRACT||LA64_0==FALSE||LA64_0==FLOATING_POINT_LITERAL||LA64_0==FUNCTION||LA64_0==HEX_LITERAL||(LA64_0 >= INDEX && LA64_0 <= INDICES)||LA64_0==INTEGER_LITERAL||LA64_0==JAVA_CONSTANT||LA64_0==JPA_PARAM||LA64_0==LENGTH||(LA64_0 >= LOCATE && LA64_0 <= LOWER)||(LA64_0 >= MAX && LA64_0 <= MAXINDEX)||(LA64_0 >= MIN && LA64_0 <= MINUS)||LA64_0==MOD||LA64_0==NAMED_PARAM||(LA64_0 >= NULL && LA64_0 <= NULLIF)||(LA64_0 >= OCTAL_LITERAL && LA64_0 <= OCTET_LENGTH)||(LA64_0 >= PARAM && LA64_0 <= PATH)||(LA64_0 >= PLUS && LA64_0 <= POSITION)||LA64_0==PROPERTY_REFERENCE||LA64_0==SEARCHED_CASE||(LA64_0 >= SIMPLE_CASE && LA64_0 <= SOME)||(LA64_0 >= SQRT && LA64_0 <= SUM)||(LA64_0 >= TRIM && LA64_0 <= TRUE)||(LA64_0 >= UNARY_MINUS && LA64_0 <= UNARY_PLUS)||LA64_0==UPPER||LA64_0==VECTOR_EXPR) ) {
                        alt64=1;
                    }


                    switch (alt64) {
                	case 1 :
                	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:359:16: valueExpression
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_valueExpression_in_functionFunction1835);
                	    valueExpression292=valueExpression();

                	    state._fsp--;

                	     
                	    if ( _first_1==null ) _first_1 = valueExpression292.tree;


                	    retval.tree = (CommonTree)_first_0;
                	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                	    }
                	    break;

                	default :
                	    break loop64;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "functionFunction"


    public static class castFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "castFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:362:1: castFunction : ^( CAST valueExpression IDENTIFIER ) ;
    public final GeneratedHQLResolver.castFunction_return castFunction() throws RecognitionException {
        GeneratedHQLResolver.castFunction_return retval = new GeneratedHQLResolver.castFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CAST293=null;
        CommonTree IDENTIFIER295=null;
        GeneratedHQLResolver.valueExpression_return valueExpression294 =null;


        CommonTree CAST293_tree=null;
        CommonTree IDENTIFIER295_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:363:2: ( ^( CAST valueExpression IDENTIFIER ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:363:4: ^( CAST valueExpression IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CAST293=(CommonTree)match(input,CAST,FOLLOW_CAST_in_castFunction1850); 


            if ( _first_0==null ) _first_0 = CAST293;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_castFunction1852);
            valueExpression294=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression294.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER295=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_castFunction1854); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER295;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "castFunction"


    public static class concatFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concatFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:367:1: concatFunction : ^( CONCAT ( valueExpression )+ ) ;
    public final GeneratedHQLResolver.concatFunction_return concatFunction() throws RecognitionException {
        GeneratedHQLResolver.concatFunction_return retval = new GeneratedHQLResolver.concatFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CONCAT296=null;
        GeneratedHQLResolver.valueExpression_return valueExpression297 =null;


        CommonTree CONCAT296_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:368:2: ( ^( CONCAT ( valueExpression )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:368:4: ^( CONCAT ( valueExpression )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CONCAT296=(CommonTree)match(input,CONCAT,FOLLOW_CONCAT_in_concatFunction1869); 


            if ( _first_0==null ) _first_0 = CONCAT296;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:368:13: ( valueExpression )+
            int cnt65=0;
            loop65:
            do {
                int alt65=2;
                int LA65_0 = input.LA(1);

                if ( (LA65_0==ABS||(LA65_0 >= ALIAS_REF && LA65_0 <= ALL)||LA65_0==ANY||(LA65_0 >= ASTERISK && LA65_0 <= AVG)||LA65_0==BIT_LENGTH||(LA65_0 >= CAST && LA65_0 <= CHARACTER_LITERAL)||LA65_0==COALESCE||(LA65_0 >= CONCAT && LA65_0 <= COUNT)||(LA65_0 >= CURRENT_DATE && LA65_0 <= CURRENT_TIMESTAMP)||LA65_0==DECIMAL_LITERAL||(LA65_0 >= DOT_CLASS && LA65_0 <= DOUBLE_PIPE)||LA65_0==ELEMENTS||LA65_0==EXISTS||LA65_0==EXTRACT||LA65_0==FALSE||LA65_0==FLOATING_POINT_LITERAL||LA65_0==FUNCTION||LA65_0==HEX_LITERAL||(LA65_0 >= INDEX && LA65_0 <= INDICES)||LA65_0==INTEGER_LITERAL||LA65_0==JAVA_CONSTANT||LA65_0==JPA_PARAM||LA65_0==LENGTH||(LA65_0 >= LOCATE && LA65_0 <= LOWER)||(LA65_0 >= MAX && LA65_0 <= MAXINDEX)||(LA65_0 >= MIN && LA65_0 <= MINUS)||LA65_0==MOD||LA65_0==NAMED_PARAM||(LA65_0 >= NULL && LA65_0 <= NULLIF)||(LA65_0 >= OCTAL_LITERAL && LA65_0 <= OCTET_LENGTH)||(LA65_0 >= PARAM && LA65_0 <= PATH)||(LA65_0 >= PLUS && LA65_0 <= POSITION)||LA65_0==PROPERTY_REFERENCE||LA65_0==SEARCHED_CASE||(LA65_0 >= SIMPLE_CASE && LA65_0 <= SOME)||(LA65_0 >= SQRT && LA65_0 <= SUM)||(LA65_0 >= TRIM && LA65_0 <= TRUE)||(LA65_0 >= UNARY_MINUS && LA65_0 <= UNARY_PLUS)||LA65_0==UPPER||LA65_0==VECTOR_EXPR) ) {
                    alt65=1;
                }


                switch (alt65) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:368:13: valueExpression
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_valueExpression_in_concatFunction1871);
            	    valueExpression297=valueExpression();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = valueExpression297.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt65 >= 1 ) break loop65;
                        EarlyExitException eee =
                            new EarlyExitException(65, input);
                        throw eee;
                }
                cnt65++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concatFunction"


    public static class substringFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "substringFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:371:1: substringFunction : ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) ;
    public final GeneratedHQLResolver.substringFunction_return substringFunction() throws RecognitionException {
        GeneratedHQLResolver.substringFunction_return retval = new GeneratedHQLResolver.substringFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUBSTRING298=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression299 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression300 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression301 =null;


        CommonTree SUBSTRING298_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:372:2: ( ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:372:4: ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SUBSTRING298=(CommonTree)match(input,SUBSTRING,FOLLOW_SUBSTRING_in_substringFunction1885); 


            if ( _first_0==null ) _first_0 = SUBSTRING298;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_substringFunction1887);
            characterValueExpression299=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression299.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_substringFunction1889);
            numericValueExpression300=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression300.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:372:64: ( numericValueExpression )?
            int alt66=2;
            int LA66_0 = input.LA(1);

            if ( (LA66_0==ABS||(LA66_0 >= ALIAS_REF && LA66_0 <= ALL)||LA66_0==ANY||(LA66_0 >= ASTERISK && LA66_0 <= AVG)||LA66_0==BIT_LENGTH||(LA66_0 >= CAST && LA66_0 <= CHARACTER_LITERAL)||LA66_0==COALESCE||(LA66_0 >= CONCAT && LA66_0 <= COUNT)||(LA66_0 >= CURRENT_DATE && LA66_0 <= CURRENT_TIMESTAMP)||LA66_0==DECIMAL_LITERAL||(LA66_0 >= DOT_CLASS && LA66_0 <= DOUBLE_PIPE)||LA66_0==ELEMENTS||LA66_0==EXISTS||LA66_0==EXTRACT||LA66_0==FALSE||LA66_0==FLOATING_POINT_LITERAL||LA66_0==FUNCTION||LA66_0==HEX_LITERAL||(LA66_0 >= INDEX && LA66_0 <= INDICES)||LA66_0==INTEGER_LITERAL||LA66_0==JAVA_CONSTANT||LA66_0==JPA_PARAM||LA66_0==LENGTH||(LA66_0 >= LOCATE && LA66_0 <= LOWER)||(LA66_0 >= MAX && LA66_0 <= MAXINDEX)||(LA66_0 >= MIN && LA66_0 <= MINUS)||LA66_0==MOD||LA66_0==NAMED_PARAM||(LA66_0 >= NULL && LA66_0 <= NULLIF)||(LA66_0 >= OCTAL_LITERAL && LA66_0 <= OCTET_LENGTH)||(LA66_0 >= PARAM && LA66_0 <= PATH)||(LA66_0 >= PLUS && LA66_0 <= POSITION)||LA66_0==PROPERTY_REFERENCE||LA66_0==SEARCHED_CASE||(LA66_0 >= SIMPLE_CASE && LA66_0 <= SOME)||(LA66_0 >= SQRT && LA66_0 <= SUM)||(LA66_0 >= TRIM && LA66_0 <= TRUE)||(LA66_0 >= UNARY_MINUS && LA66_0 <= UNARY_PLUS)||LA66_0==UPPER||LA66_0==VECTOR_EXPR) ) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:372:64: numericValueExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_substringFunction1891);
                    numericValueExpression301=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression301.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substringFunction"


    public static class trimFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:375:1: trimFunction : ^( TRIM trimOperands ) ;
    public final GeneratedHQLResolver.trimFunction_return trimFunction() throws RecognitionException {
        GeneratedHQLResolver.trimFunction_return retval = new GeneratedHQLResolver.trimFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree TRIM302=null;
        GeneratedHQLResolver.trimOperands_return trimOperands303 =null;


        CommonTree TRIM302_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:376:2: ( ^( TRIM trimOperands ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:376:4: ^( TRIM trimOperands )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            TRIM302=(CommonTree)match(input,TRIM,FOLLOW_TRIM_in_trimFunction1905); 


            if ( _first_0==null ) _first_0 = TRIM302;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_trimOperands_in_trimFunction1907);
            trimOperands303=trimOperands();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = trimOperands303.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimFunction"


    public static class trimOperands_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimOperands"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:379:1: trimOperands : ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) ;
    public final GeneratedHQLResolver.trimOperands_return trimOperands() throws RecognitionException {
        GeneratedHQLResolver.trimOperands_return retval = new GeneratedHQLResolver.trimOperands_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set304=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression305 =null;

        GeneratedHQLResolver.characterValueExpression_return characterValueExpression306 =null;


        CommonTree set304_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:380:2: ( ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:380:4: ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            set304=(CommonTree)input.LT(1);

            if ( input.LA(1)==BOTH||input.LA(1)==LEADING||input.LA(1)==TRAILING ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( _first_0==null ) _first_0 = set304;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_trimOperands1928);
            characterValueExpression305=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression305.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_trimOperands1930);
            characterValueExpression306=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression306.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimOperands"


    public static class upperFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upperFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:383:1: upperFunction : ^( UPPER characterValueExpression ) ;
    public final GeneratedHQLResolver.upperFunction_return upperFunction() throws RecognitionException {
        GeneratedHQLResolver.upperFunction_return retval = new GeneratedHQLResolver.upperFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UPPER307=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression308 =null;


        CommonTree UPPER307_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:384:2: ( ^( UPPER characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:384:4: ^( UPPER characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            UPPER307=(CommonTree)match(input,UPPER,FOLLOW_UPPER_in_upperFunction1943); 


            if ( _first_0==null ) _first_0 = UPPER307;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_upperFunction1945);
            characterValueExpression308=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression308.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upperFunction"


    public static class lowerFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lowerFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:387:1: lowerFunction : ^( LOWER characterValueExpression ) ;
    public final GeneratedHQLResolver.lowerFunction_return lowerFunction() throws RecognitionException {
        GeneratedHQLResolver.lowerFunction_return retval = new GeneratedHQLResolver.lowerFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LOWER309=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression310 =null;


        CommonTree LOWER309_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:388:2: ( ^( LOWER characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:388:4: ^( LOWER characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LOWER309=(CommonTree)match(input,LOWER,FOLLOW_LOWER_in_lowerFunction1958); 


            if ( _first_0==null ) _first_0 = LOWER309;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_lowerFunction1960);
            characterValueExpression310=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression310.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lowerFunction"


    public static class lengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:391:1: lengthFunction : ^( LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.lengthFunction_return lengthFunction() throws RecognitionException {
        GeneratedHQLResolver.lengthFunction_return retval = new GeneratedHQLResolver.lengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LENGTH311=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression312 =null;


        CommonTree LENGTH311_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:392:2: ( ^( LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:392:4: ^( LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LENGTH311=(CommonTree)match(input,LENGTH,FOLLOW_LENGTH_in_lengthFunction1973); 


            if ( _first_0==null ) _first_0 = LENGTH311;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_lengthFunction1975);
            characterValueExpression312=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression312.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lengthFunction"


    public static class locateFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:395:1: locateFunction : ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) ;
    public final GeneratedHQLResolver.locateFunction_return locateFunction() throws RecognitionException {
        GeneratedHQLResolver.locateFunction_return retval = new GeneratedHQLResolver.locateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LOCATE313=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression314 =null;

        GeneratedHQLResolver.characterValueExpression_return characterValueExpression315 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression316 =null;


        CommonTree LOCATE313_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:396:2: ( ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:396:4: ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LOCATE313=(CommonTree)match(input,LOCATE,FOLLOW_LOCATE_in_locateFunction1988); 


            if ( _first_0==null ) _first_0 = LOCATE313;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1990);
            characterValueExpression314=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression314.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1992);
            characterValueExpression315=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression315.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:396:63: ( numericValueExpression )?
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==ABS||(LA67_0 >= ALIAS_REF && LA67_0 <= ALL)||LA67_0==ANY||(LA67_0 >= ASTERISK && LA67_0 <= AVG)||LA67_0==BIT_LENGTH||(LA67_0 >= CAST && LA67_0 <= CHARACTER_LITERAL)||LA67_0==COALESCE||(LA67_0 >= CONCAT && LA67_0 <= COUNT)||(LA67_0 >= CURRENT_DATE && LA67_0 <= CURRENT_TIMESTAMP)||LA67_0==DECIMAL_LITERAL||(LA67_0 >= DOT_CLASS && LA67_0 <= DOUBLE_PIPE)||LA67_0==ELEMENTS||LA67_0==EXISTS||LA67_0==EXTRACT||LA67_0==FALSE||LA67_0==FLOATING_POINT_LITERAL||LA67_0==FUNCTION||LA67_0==HEX_LITERAL||(LA67_0 >= INDEX && LA67_0 <= INDICES)||LA67_0==INTEGER_LITERAL||LA67_0==JAVA_CONSTANT||LA67_0==JPA_PARAM||LA67_0==LENGTH||(LA67_0 >= LOCATE && LA67_0 <= LOWER)||(LA67_0 >= MAX && LA67_0 <= MAXINDEX)||(LA67_0 >= MIN && LA67_0 <= MINUS)||LA67_0==MOD||LA67_0==NAMED_PARAM||(LA67_0 >= NULL && LA67_0 <= NULLIF)||(LA67_0 >= OCTAL_LITERAL && LA67_0 <= OCTET_LENGTH)||(LA67_0 >= PARAM && LA67_0 <= PATH)||(LA67_0 >= PLUS && LA67_0 <= POSITION)||LA67_0==PROPERTY_REFERENCE||LA67_0==SEARCHED_CASE||(LA67_0 >= SIMPLE_CASE && LA67_0 <= SOME)||(LA67_0 >= SQRT && LA67_0 <= SUM)||(LA67_0 >= TRIM && LA67_0 <= TRUE)||(LA67_0 >= UNARY_MINUS && LA67_0 <= UNARY_PLUS)||LA67_0==UPPER||LA67_0==VECTOR_EXPR) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:396:63: numericValueExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_locateFunction1994);
                    numericValueExpression316=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression316.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateFunction"


    public static class absFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "absFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:399:1: absFunction : ^( ABS numericValueExpression ) ;
    public final GeneratedHQLResolver.absFunction_return absFunction() throws RecognitionException {
        GeneratedHQLResolver.absFunction_return retval = new GeneratedHQLResolver.absFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ABS317=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression318 =null;


        CommonTree ABS317_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:400:2: ( ^( ABS numericValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:400:4: ^( ABS numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ABS317=(CommonTree)match(input,ABS,FOLLOW_ABS_in_absFunction2008); 


            if ( _first_0==null ) _first_0 = ABS317;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_absFunction2010);
            numericValueExpression318=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression318.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "absFunction"


    public static class sqrtFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sqrtFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:403:1: sqrtFunction : ^( SQRT numericValueExpression ) ;
    public final GeneratedHQLResolver.sqrtFunction_return sqrtFunction() throws RecognitionException {
        GeneratedHQLResolver.sqrtFunction_return retval = new GeneratedHQLResolver.sqrtFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SQRT319=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression320 =null;


        CommonTree SQRT319_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:404:2: ( ^( SQRT numericValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:404:4: ^( SQRT numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SQRT319=(CommonTree)match(input,SQRT,FOLLOW_SQRT_in_sqrtFunction2023); 


            if ( _first_0==null ) _first_0 = SQRT319;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_sqrtFunction2025);
            numericValueExpression320=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression320.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrtFunction"


    public static class modFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "modFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:407:1: modFunction : ^( MOD numericValueExpression numericValueExpression ) ;
    public final GeneratedHQLResolver.modFunction_return modFunction() throws RecognitionException {
        GeneratedHQLResolver.modFunction_return retval = new GeneratedHQLResolver.modFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree MOD321=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression322 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression323 =null;


        CommonTree MOD321_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:408:2: ( ^( MOD numericValueExpression numericValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:408:4: ^( MOD numericValueExpression numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            MOD321=(CommonTree)match(input,MOD,FOLLOW_MOD_in_modFunction2038); 


            if ( _first_0==null ) _first_0 = MOD321;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_modFunction2040);
            numericValueExpression322=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression322.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_modFunction2042);
            numericValueExpression323=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression323.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "modFunction"


    public static class sizeFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sizeFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:411:1: sizeFunction : ^( SIZE propertyReference ) ;
    public final GeneratedHQLResolver.sizeFunction_return sizeFunction() throws RecognitionException {
        GeneratedHQLResolver.sizeFunction_return retval = new GeneratedHQLResolver.sizeFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SIZE324=null;
        GeneratedHQLResolver.propertyReference_return propertyReference325 =null;


        CommonTree SIZE324_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:412:2: ( ^( SIZE propertyReference ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:412:4: ^( SIZE propertyReference )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SIZE324=(CommonTree)match(input,SIZE,FOLLOW_SIZE_in_sizeFunction2055); 


            if ( _first_0==null ) _first_0 = SIZE324;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReference_in_sizeFunction2057);
            propertyReference325=propertyReference();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = propertyReference325.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sizeFunction"


    public static class indexFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:415:1: indexFunction : ^( INDEX ALIAS_REF ) ;
    public final GeneratedHQLResolver.indexFunction_return indexFunction() throws RecognitionException {
        GeneratedHQLResolver.indexFunction_return retval = new GeneratedHQLResolver.indexFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INDEX326=null;
        CommonTree ALIAS_REF327=null;

        CommonTree INDEX326_tree=null;
        CommonTree ALIAS_REF327_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:416:2: ( ^( INDEX ALIAS_REF ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:416:4: ^( INDEX ALIAS_REF )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INDEX326=(CommonTree)match(input,INDEX,FOLLOW_INDEX_in_indexFunction2070); 


            if ( _first_0==null ) _first_0 = INDEX326;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            ALIAS_REF327=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_indexFunction2072); 
             
            if ( _first_1==null ) _first_1 = ALIAS_REF327;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexFunction"


    public static class currentDateFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentDateFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:419:1: currentDateFunction : CURRENT_DATE ;
    public final GeneratedHQLResolver.currentDateFunction_return currentDateFunction() throws RecognitionException {
        GeneratedHQLResolver.currentDateFunction_return retval = new GeneratedHQLResolver.currentDateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_DATE328=null;

        CommonTree CURRENT_DATE328_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:420:2: ( CURRENT_DATE )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:420:4: CURRENT_DATE
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_DATE328=(CommonTree)match(input,CURRENT_DATE,FOLLOW_CURRENT_DATE_in_currentDateFunction2084); 
             
            if ( _first_0==null ) _first_0 = CURRENT_DATE328;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentDateFunction"


    public static class currentTimeFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimeFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:423:1: currentTimeFunction : CURRENT_TIME ;
    public final GeneratedHQLResolver.currentTimeFunction_return currentTimeFunction() throws RecognitionException {
        GeneratedHQLResolver.currentTimeFunction_return retval = new GeneratedHQLResolver.currentTimeFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_TIME329=null;

        CommonTree CURRENT_TIME329_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:424:2: ( CURRENT_TIME )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:424:4: CURRENT_TIME
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_TIME329=(CommonTree)match(input,CURRENT_TIME,FOLLOW_CURRENT_TIME_in_currentTimeFunction2095); 
             
            if ( _first_0==null ) _first_0 = CURRENT_TIME329;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimeFunction"


    public static class currentTimestampFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimestampFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:427:1: currentTimestampFunction : CURRENT_TIMESTAMP ;
    public final GeneratedHQLResolver.currentTimestampFunction_return currentTimestampFunction() throws RecognitionException {
        GeneratedHQLResolver.currentTimestampFunction_return retval = new GeneratedHQLResolver.currentTimestampFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_TIMESTAMP330=null;

        CommonTree CURRENT_TIMESTAMP330_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:428:2: ( CURRENT_TIMESTAMP )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:428:4: CURRENT_TIMESTAMP
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_TIMESTAMP330=(CommonTree)match(input,CURRENT_TIMESTAMP,FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2106); 
             
            if ( _first_0==null ) _first_0 = CURRENT_TIMESTAMP330;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimestampFunction"


    public static class extractFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:431:1: extractFunction : ^( EXTRACT extractField datetimeValueExpression ) ;
    public final GeneratedHQLResolver.extractFunction_return extractFunction() throws RecognitionException {
        GeneratedHQLResolver.extractFunction_return retval = new GeneratedHQLResolver.extractFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EXTRACT331=null;
        GeneratedHQLResolver.extractField_return extractField332 =null;

        GeneratedHQLResolver.datetimeValueExpression_return datetimeValueExpression333 =null;


        CommonTree EXTRACT331_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:432:2: ( ^( EXTRACT extractField datetimeValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:432:4: ^( EXTRACT extractField datetimeValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            EXTRACT331=(CommonTree)match(input,EXTRACT,FOLLOW_EXTRACT_in_extractFunction2118); 


            if ( _first_0==null ) _first_0 = EXTRACT331;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_extractField_in_extractFunction2120);
            extractField332=extractField();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = extractField332.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_datetimeValueExpression_in_extractFunction2122);
            datetimeValueExpression333=datetimeValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = datetimeValueExpression333.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractFunction"


    public static class extractField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractField"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:435:1: extractField : ( datetimeField | timeZoneField );
    public final GeneratedHQLResolver.extractField_return extractField() throws RecognitionException {
        GeneratedHQLResolver.extractField_return retval = new GeneratedHQLResolver.extractField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.datetimeField_return datetimeField334 =null;

        GeneratedHQLResolver.timeZoneField_return timeZoneField335 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:436:2: ( datetimeField | timeZoneField )
            int alt68=2;
            int LA68_0 = input.LA(1);

            if ( (LA68_0==DAY||LA68_0==HOUR||LA68_0==MINUTE||LA68_0==MONTH||LA68_0==SECOND||LA68_0==YEAR) ) {
                alt68=1;
            }
            else if ( ((LA68_0 >= TIMEZONE_HOUR && LA68_0 <= TIMEZONE_MINUTE)) ) {
                alt68=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;

            }
            switch (alt68) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:436:4: datetimeField
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_datetimeField_in_extractField2134);
                    datetimeField334=datetimeField();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = datetimeField334.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:437:4: timeZoneField
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_timeZoneField_in_extractField2139);
                    timeZoneField335=timeZoneField();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = timeZoneField335.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractField"


    public static class datetimeField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeField"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:440:1: datetimeField : ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND );
    public final GeneratedHQLResolver.datetimeField_return datetimeField() throws RecognitionException {
        GeneratedHQLResolver.datetimeField_return retval = new GeneratedHQLResolver.datetimeField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set336=null;

        CommonTree set336_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:441:2: ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set336=(CommonTree)input.LT(1);

            if ( input.LA(1)==DAY||input.LA(1)==HOUR||input.LA(1)==MINUTE||input.LA(1)==MONTH||input.LA(1)==SECOND||input.LA(1)==YEAR ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeField"


    public static class timeZoneField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeZoneField"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:449:1: timeZoneField : ( TIMEZONE_HOUR | TIMEZONE_MINUTE );
    public final GeneratedHQLResolver.timeZoneField_return timeZoneField() throws RecognitionException {
        GeneratedHQLResolver.timeZoneField_return retval = new GeneratedHQLResolver.timeZoneField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set337=null;

        CommonTree set337_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:450:2: ( TIMEZONE_HOUR | TIMEZONE_MINUTE )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set337=(CommonTree)input.LT(1);

            if ( (input.LA(1) >= TIMEZONE_HOUR && input.LA(1) <= TIMEZONE_MINUTE) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeZoneField"


    public static class positionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "positionFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:454:1: positionFunction : ^( POSITION characterValueExpression characterValueExpression ) ;
    public final GeneratedHQLResolver.positionFunction_return positionFunction() throws RecognitionException {
        GeneratedHQLResolver.positionFunction_return retval = new GeneratedHQLResolver.positionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree POSITION338=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression339 =null;

        GeneratedHQLResolver.characterValueExpression_return characterValueExpression340 =null;


        CommonTree POSITION338_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:455:2: ( ^( POSITION characterValueExpression characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:455:4: ^( POSITION characterValueExpression characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            POSITION338=(CommonTree)match(input,POSITION,FOLLOW_POSITION_in_positionFunction2203); 


            if ( _first_0==null ) _first_0 = POSITION338;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_positionFunction2205);
            characterValueExpression339=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression339.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_positionFunction2207);
            characterValueExpression340=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression340.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "positionFunction"


    public static class charLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "charLengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:458:1: charLengthFunction : ^( CHARACTER_LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.charLengthFunction_return charLengthFunction() throws RecognitionException {
        GeneratedHQLResolver.charLengthFunction_return retval = new GeneratedHQLResolver.charLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CHARACTER_LENGTH341=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression342 =null;


        CommonTree CHARACTER_LENGTH341_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:459:2: ( ^( CHARACTER_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:459:4: ^( CHARACTER_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CHARACTER_LENGTH341=(CommonTree)match(input,CHARACTER_LENGTH,FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2220); 


            if ( _first_0==null ) _first_0 = CHARACTER_LENGTH341;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_charLengthFunction2222);
            characterValueExpression342=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression342.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "charLengthFunction"


    public static class octetLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "octetLengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:462:1: octetLengthFunction : ^( OCTET_LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.octetLengthFunction_return octetLengthFunction() throws RecognitionException {
        GeneratedHQLResolver.octetLengthFunction_return retval = new GeneratedHQLResolver.octetLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree OCTET_LENGTH343=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression344 =null;


        CommonTree OCTET_LENGTH343_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:463:2: ( ^( OCTET_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:463:4: ^( OCTET_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            OCTET_LENGTH343=(CommonTree)match(input,OCTET_LENGTH,FOLLOW_OCTET_LENGTH_in_octetLengthFunction2235); 


            if ( _first_0==null ) _first_0 = OCTET_LENGTH343;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_octetLengthFunction2237);
            characterValueExpression344=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression344.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octetLengthFunction"


    public static class bitLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bitLengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:466:1: bitLengthFunction : ^( BIT_LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.bitLengthFunction_return bitLengthFunction() throws RecognitionException {
        GeneratedHQLResolver.bitLengthFunction_return retval = new GeneratedHQLResolver.bitLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BIT_LENGTH345=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression346 =null;


        CommonTree BIT_LENGTH345_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:467:2: ( ^( BIT_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:467:4: ^( BIT_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            BIT_LENGTH345=(CommonTree)match(input,BIT_LENGTH,FOLLOW_BIT_LENGTH_in_bitLengthFunction2250); 


            if ( _first_0==null ) _first_0 = BIT_LENGTH345;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_bitLengthFunction2252);
            characterValueExpression346=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression346.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bitLengthFunction"


    public static class countFunctionArguments_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "countFunctionArguments"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:471:1: countFunctionArguments : ( collectionExpression | propertyReference | numeric_literal );
    public final GeneratedHQLResolver.countFunctionArguments_return countFunctionArguments() throws RecognitionException {
        GeneratedHQLResolver.countFunctionArguments_return retval = new GeneratedHQLResolver.countFunctionArguments_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.collectionExpression_return collectionExpression347 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference348 =null;

        GeneratedHQLResolver.numeric_literal_return numeric_literal349 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:472:2: ( collectionExpression | propertyReference | numeric_literal )
            int alt69=3;
            switch ( input.LA(1) ) {
            case ELEMENTS:
            case INDICES:
                {
                alt69=1;
                }
                break;
            case PROPERTY_REFERENCE:
                {
                alt69=2;
                }
                break;
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt69=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 69, 0, input);

                throw nvae;

            }

            switch (alt69) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:472:4: collectionExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionExpression_in_countFunctionArguments2265);
                    collectionExpression347=collectionExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionExpression347.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:473:4: propertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_countFunctionArguments2270);
                    propertyReference348=propertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = propertyReference348.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:474:4: numeric_literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numeric_literal_in_countFunctionArguments2275);
                    numeric_literal349=numeric_literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = numeric_literal349.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "countFunctionArguments"


    public static class collectionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:477:1: collectionFunction : ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) ;
    public final GeneratedHQLResolver.collectionFunction_return collectionFunction() throws RecognitionException {
        GeneratedHQLResolver.collectionFunction_return retval = new GeneratedHQLResolver.collectionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set350=null;
        GeneratedHQLResolver.collectionPropertyReference_return collectionPropertyReference351 =null;


        CommonTree set350_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:478:2: ( ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:478:4: ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            set350=(CommonTree)input.LT(1);

            if ( (input.LA(1) >= MAXELEMENT && input.LA(1) <= MAXINDEX)||(input.LA(1) >= MINELEMENT && input.LA(1) <= MININDEX) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( _first_0==null ) _first_0 = set350;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_collectionPropertyReference_in_collectionFunction2297);
            collectionPropertyReference351=collectionPropertyReference();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = collectionPropertyReference351.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionFunction"


    public static class collectionPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:482:1: collectionPropertyReference : propertyReference ;
    public final GeneratedHQLResolver.collectionPropertyReference_return collectionPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.collectionPropertyReference_return retval = new GeneratedHQLResolver.collectionPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.propertyReference_return propertyReference352 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:483:2: ( propertyReference )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:483:4: propertyReference
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReference_in_collectionPropertyReference2312);
            propertyReference352=propertyReference();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = propertyReference352.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionPropertyReference"


    public static class collectionExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:486:1: collectionExpression : ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) );
    public final GeneratedHQLResolver.collectionExpression_return collectionExpression() throws RecognitionException {
        GeneratedHQLResolver.collectionExpression_return retval = new GeneratedHQLResolver.collectionExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELEMENTS353=null;
        CommonTree INDICES355=null;
        GeneratedHQLResolver.propertyReference_return propertyReference354 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference356 =null;


        CommonTree ELEMENTS353_tree=null;
        CommonTree INDICES355_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:487:2: ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) )
            int alt70=2;
            int LA70_0 = input.LA(1);

            if ( (LA70_0==ELEMENTS) ) {
                alt70=1;
            }
            else if ( (LA70_0==INDICES) ) {
                alt70=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;

            }
            switch (alt70) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:487:4: ^( ELEMENTS propertyReference )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ELEMENTS353=(CommonTree)match(input,ELEMENTS,FOLLOW_ELEMENTS_in_collectionExpression2324); 


                    if ( _first_0==null ) _first_0 = ELEMENTS353;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_collectionExpression2326);
                    propertyReference354=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference354.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:488:4: ^( INDICES propertyReference )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    INDICES355=(CommonTree)match(input,INDICES,FOLLOW_INDICES_in_collectionExpression2334); 


                    if ( _first_0==null ) _first_0 = INDICES355;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_collectionExpression2336);
                    propertyReference356=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference356.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionExpression"


    public static class parameter_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "parameter"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:491:1: parameter : ( NAMED_PARAM | JPA_PARAM | PARAM );
    public final GeneratedHQLResolver.parameter_return parameter() throws RecognitionException {
        GeneratedHQLResolver.parameter_return retval = new GeneratedHQLResolver.parameter_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set357=null;

        CommonTree set357_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:492:2: ( NAMED_PARAM | JPA_PARAM | PARAM )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set357=(CommonTree)input.LT(1);

            if ( input.LA(1)==JPA_PARAM||input.LA(1)==NAMED_PARAM||input.LA(1)==PARAM ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "parameter"


    public static class constant_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "constant"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:497:1: constant : ( literal | NULL | TRUE | FALSE );
    public final GeneratedHQLResolver.constant_return constant() throws RecognitionException {
        GeneratedHQLResolver.constant_return retval = new GeneratedHQLResolver.constant_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree NULL359=null;
        CommonTree TRUE360=null;
        CommonTree FALSE361=null;
        GeneratedHQLResolver.literal_return literal358 =null;


        CommonTree NULL359_tree=null;
        CommonTree TRUE360_tree=null;
        CommonTree FALSE361_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:498:2: ( literal | NULL | TRUE | FALSE )
            int alt71=4;
            switch ( input.LA(1) ) {
            case CHARACTER_LITERAL:
            case CONST_STRING_VALUE:
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
                {
                alt71=1;
                }
                break;
            case NULL:
                {
                alt71=2;
                }
                break;
            case TRUE:
                {
                alt71=3;
                }
                break;
            case FALSE:
                {
                alt71=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;

            }

            switch (alt71) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:498:4: literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_literal_in_constant2369);
                    literal358=literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = literal358.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:499:4: NULL
                    {
                    _last = (CommonTree)input.LT(1);
                    NULL359=(CommonTree)match(input,NULL,FOLLOW_NULL_in_constant2374); 
                     
                    if ( _first_0==null ) _first_0 = NULL359;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:500:4: TRUE
                    {
                    _last = (CommonTree)input.LT(1);
                    TRUE360=(CommonTree)match(input,TRUE,FOLLOW_TRUE_in_constant2379); 
                     
                    if ( _first_0==null ) _first_0 = TRUE360;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:501:4: FALSE
                    {
                    _last = (CommonTree)input.LT(1);
                    FALSE361=(CommonTree)match(input,FALSE,FOLLOW_FALSE_in_constant2384); 
                     
                    if ( _first_0==null ) _first_0 = FALSE361;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "constant"


    public static class literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:504:1: literal : ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | ^( CONST_STRING_VALUE STRING_LITERAL ) );
    public final GeneratedHQLResolver.literal_return literal() throws RecognitionException {
        GeneratedHQLResolver.literal_return retval = new GeneratedHQLResolver.literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree HEX_LITERAL363=null;
        CommonTree OCTAL_LITERAL364=null;
        CommonTree CHARACTER_LITERAL365=null;
        CommonTree STRING_LITERAL366=null;
        CommonTree CONST_STRING_VALUE367=null;
        CommonTree CHARACTER_LITERAL368=null;
        CommonTree CONST_STRING_VALUE369=null;
        CommonTree STRING_LITERAL370=null;
        GeneratedHQLResolver.numeric_literal_return numeric_literal362 =null;


        CommonTree HEX_LITERAL363_tree=null;
        CommonTree OCTAL_LITERAL364_tree=null;
        CommonTree CHARACTER_LITERAL365_tree=null;
        CommonTree STRING_LITERAL366_tree=null;
        CommonTree CONST_STRING_VALUE367_tree=null;
        CommonTree CHARACTER_LITERAL368_tree=null;
        CommonTree CONST_STRING_VALUE369_tree=null;
        CommonTree STRING_LITERAL370_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:505:2: ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | ^( CONST_STRING_VALUE STRING_LITERAL ) )
            int alt72=7;
            switch ( input.LA(1) ) {
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt72=1;
                }
                break;
            case HEX_LITERAL:
                {
                alt72=2;
                }
                break;
            case OCTAL_LITERAL:
                {
                alt72=3;
                }
                break;
            case CHARACTER_LITERAL:
                {
                alt72=4;
                }
                break;
            case STRING_LITERAL:
                {
                alt72=5;
                }
                break;
            case CONST_STRING_VALUE:
                {
                int LA72_6 = input.LA(2);

                if ( (LA72_6==DOWN) ) {
                    int LA72_7 = input.LA(3);

                    if ( (LA72_7==CHARACTER_LITERAL) ) {
                        alt72=6;
                    }
                    else if ( (LA72_7==STRING_LITERAL) ) {
                        alt72=7;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 72, 7, input);

                        throw nvae;

                    }
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 72, 6, input);

                    throw nvae;

                }
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 72, 0, input);

                throw nvae;

            }

            switch (alt72) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:505:4: numeric_literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numeric_literal_in_literal2395);
                    numeric_literal362=numeric_literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = numeric_literal362.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:506:4: HEX_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    HEX_LITERAL363=(CommonTree)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_literal2400); 
                     
                    if ( _first_0==null ) _first_0 = HEX_LITERAL363;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:507:4: OCTAL_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    OCTAL_LITERAL364=(CommonTree)match(input,OCTAL_LITERAL,FOLLOW_OCTAL_LITERAL_in_literal2405); 
                     
                    if ( _first_0==null ) _first_0 = OCTAL_LITERAL364;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:508:4: CHARACTER_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    CHARACTER_LITERAL365=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal2410); 
                     
                    if ( _first_0==null ) _first_0 = CHARACTER_LITERAL365;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:509:4: STRING_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL366=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2415); 
                     
                    if ( _first_0==null ) _first_0 = STRING_LITERAL366;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:510:4: ^( CONST_STRING_VALUE CHARACTER_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    CONST_STRING_VALUE367=(CommonTree)match(input,CONST_STRING_VALUE,FOLLOW_CONST_STRING_VALUE_in_literal2421); 


                    if ( _first_0==null ) _first_0 = CONST_STRING_VALUE367;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    CHARACTER_LITERAL368=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal2423); 
                     
                    if ( _first_1==null ) _first_1 = CHARACTER_LITERAL368;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:511:4: ^( CONST_STRING_VALUE STRING_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    CONST_STRING_VALUE369=(CommonTree)match(input,CONST_STRING_VALUE,FOLLOW_CONST_STRING_VALUE_in_literal2430); 


                    if ( _first_0==null ) _first_0 = CONST_STRING_VALUE369;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL370=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2432); 
                     
                    if ( _first_1==null ) _first_1 = STRING_LITERAL370;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class numeric_literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numeric_literal"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:514:1: numeric_literal : ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL );
    public final GeneratedHQLResolver.numeric_literal_return numeric_literal() throws RecognitionException {
        GeneratedHQLResolver.numeric_literal_return retval = new GeneratedHQLResolver.numeric_literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set371=null;

        CommonTree set371_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:515:2: ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set371=(CommonTree)input.LT(1);

            if ( input.LA(1)==DECIMAL_LITERAL||input.LA(1)==FLOATING_POINT_LITERAL||input.LA(1)==INTEGER_LITERAL ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numeric_literal"


    public static class entityName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "entityName"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:520:1: entityName : ENTITY_NAME ALIAS_NAME ;
    public final GeneratedHQLResolver.entityName_return entityName() throws RecognitionException {
        GeneratedHQLResolver.entityName_return retval = new GeneratedHQLResolver.entityName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ENTITY_NAME372=null;
        CommonTree ALIAS_NAME373=null;

        CommonTree ENTITY_NAME372_tree=null;
        CommonTree ALIAS_NAME373_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:521:2: ( ENTITY_NAME ALIAS_NAME )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:521:4: ENTITY_NAME ALIAS_NAME
            {
            _last = (CommonTree)input.LT(1);
            ENTITY_NAME372=(CommonTree)match(input,ENTITY_NAME,FOLLOW_ENTITY_NAME_in_entityName2465); 
             
            if ( _first_0==null ) _first_0 = ENTITY_NAME372;


            _last = (CommonTree)input.LT(1);
            ALIAS_NAME373=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_entityName2467); 
             
            if ( _first_0==null ) _first_0 = ALIAS_NAME373;


            	delegate.registerPersisterSpace(ENTITY_NAME372, ALIAS_NAME373);	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "entityName"


    public static class propertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:525:1: propertyReference : ^( PROPERTY_REFERENCE ret= propertyReferencePath ) -> ^( PROPERTY_REFERENCE[$PROPERTY_REFERENCE, $ret.retPath] propertyReferencePath ) ;
    public final GeneratedHQLResolver.propertyReference_return propertyReference() throws RecognitionException {
        GeneratedHQLResolver.propertyReference_return retval = new GeneratedHQLResolver.propertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PROPERTY_REFERENCE374=null;
        GeneratedHQLResolver.propertyReferencePath_return ret =null;


        CommonTree PROPERTY_REFERENCE374_tree=null;
        RewriteRuleNodeStream stream_PROPERTY_REFERENCE=new RewriteRuleNodeStream(adaptor,"token PROPERTY_REFERENCE");
        RewriteRuleSubtreeStream stream_propertyReferencePath=new RewriteRuleSubtreeStream(adaptor,"rule propertyReferencePath");
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:526:2: ( ^( PROPERTY_REFERENCE ret= propertyReferencePath ) -> ^( PROPERTY_REFERENCE[$PROPERTY_REFERENCE, $ret.retPath] propertyReferencePath ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:526:4: ^( PROPERTY_REFERENCE ret= propertyReferencePath )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PROPERTY_REFERENCE374=(CommonTree)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_propertyReference2482);  
            stream_PROPERTY_REFERENCE.add(PROPERTY_REFERENCE374);


            if ( _first_0==null ) _first_0 = PROPERTY_REFERENCE374;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReferencePath_in_propertyReference2486);
            ret=propertyReferencePath();

            state._fsp--;

            stream_propertyReferencePath.add(ret.getTree());

            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            // AST REWRITE
            // elements: propertyReferencePath, PROPERTY_REFERENCE
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 526:52: -> ^( PROPERTY_REFERENCE[$PROPERTY_REFERENCE, $ret.retPath] propertyReferencePath )
            {
                // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:526:55: ^( PROPERTY_REFERENCE[$PROPERTY_REFERENCE, $ret.retPath] propertyReferencePath )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                new PropertyPathTree(PROPERTY_REFERENCE, PROPERTY_REFERENCE374, (ret!=null?ret.retPath:null))
                , root_1);

                adaptor.addChild(root_1, stream_propertyReferencePath.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            input.replaceChildren(adaptor.getParent(retval.start),
                                  adaptor.getChildIndex(retval.start),
                                  adaptor.getChildIndex(_last),
                                  retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "propertyReference"


    public static class joinPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joinPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:529:1: joinPropertyReference[Tree an] : ^( PATH ret= propertyReferencePath ) -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath ) ;
    public final GeneratedHQLResolver.joinPropertyReference_return joinPropertyReference(Tree an) throws RecognitionException {
        GeneratedHQLResolver.joinPropertyReference_return retval = new GeneratedHQLResolver.joinPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PATH375=null;
        GeneratedHQLResolver.propertyReferencePath_return ret =null;


        CommonTree PATH375_tree=null;
        RewriteRuleNodeStream stream_PATH=new RewriteRuleNodeStream(adaptor,"token PATH");
        RewriteRuleSubtreeStream stream_propertyReferencePath=new RewriteRuleSubtreeStream(adaptor,"rule propertyReferencePath");
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:531:2: ( ^( PATH ret= propertyReferencePath ) -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:531:4: ^( PATH ret= propertyReferencePath )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PATH375=(CommonTree)match(input,PATH,FOLLOW_PATH_in_joinPropertyReference2521);  
            stream_PATH.add(PATH375);


            if ( _first_0==null ) _first_0 = PATH375;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReferencePath_in_joinPropertyReference2525);
            ret=propertyReferencePath();

            state._fsp--;

            stream_propertyReferencePath.add(ret.getTree());

            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            // AST REWRITE
            // elements: PATH, propertyReferencePath
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 531:38: -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath )
            {
                // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:531:41: ^( PATH[$PATH, $ret.retPath] propertyReferencePath )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                new PropertyPathTree(PATH, PATH375, (ret!=null?ret.retPath:null))
                , root_1);

                adaptor.addChild(root_1, stream_propertyReferencePath.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            input.replaceChildren(adaptor.getParent(retval.start),
                                  adaptor.getChildIndex(retval.start),
                                  adaptor.getChildIndex(_last),
                                  retval.tree);

            }

            delegate.registerJoinAlias(an, (ret!=null?ret.retPath:null)); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joinPropertyReference"


    protected static class propertyReferencePath_scope {
        PropertyPath path;
    }
    protected Stack propertyReferencePath_stack = new Stack();


    public static class propertyReferencePath_return extends TreeRuleReturnScope {
        public PropertyPath retPath;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyReferencePath"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:534:1: propertyReferencePath returns [PropertyPath retPath] : ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation );
    public final GeneratedHQLResolver.propertyReferencePath_return propertyReferencePath() throws RecognitionException {
        propertyReferencePath_stack.push(new propertyReferencePath_scope());
        GeneratedHQLResolver.propertyReferencePath_return retval = new GeneratedHQLResolver.propertyReferencePath_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.unqualifiedPropertyReference_return unqualifiedPropertyReference376 =null;

        GeneratedHQLResolver.pathedPropertyReference_return pathedPropertyReference377 =null;

        GeneratedHQLResolver.terminalIndexOperation_return terminalIndexOperation378 =null;




        		((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path = new PropertyPath();
        	
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:542:2: ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation )
            int alt73=3;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt73=1;
                }
                break;
            case DOT:
                {
                alt73=2;
                }
                break;
            case LEFT_SQUARE:
                {
                alt73=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;

            }

            switch (alt73) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:542:5: {...}? unqualifiedPropertyReference
                    {
                    if ( !((delegate.isUnqualifiedPropertyReference())) ) {
                        throw new FailedPredicateException(input, "propertyReferencePath", "delegate.isUnqualifiedPropertyReference()");
                    }

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2575);
                    unqualifiedPropertyReference376=unqualifiedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = unqualifiedPropertyReference376.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:543:4: pathedPropertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_pathedPropertyReference_in_propertyReferencePath2580);
                    pathedPropertyReference377=pathedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = pathedPropertyReference377.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:544:4: terminalIndexOperation
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_terminalIndexOperation_in_propertyReferencePath2585);
                    terminalIndexOperation378=terminalIndexOperation();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = terminalIndexOperation378.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
             retval.retPath = ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path; delegate.propertyPathCompleted( ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path ); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            propertyReferencePath_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "propertyReferencePath"


    public static class unqualifiedPropertyReference_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unqualifiedPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:547:1: unqualifiedPropertyReference returns [PathedPropertyReferenceSource propertyReferenceSource] : IDENTIFIER ;
    public final GeneratedHQLResolver.unqualifiedPropertyReference_return unqualifiedPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.unqualifiedPropertyReference_return retval = new GeneratedHQLResolver.unqualifiedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER379=null;

        CommonTree IDENTIFIER379_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:549:2: ( IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:549:4: IDENTIFIER
            {
            _last = (CommonTree)input.LT(1);
            IDENTIFIER379=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2606); 
             
            if ( _first_0==null ) _first_0 = IDENTIFIER379;


            	retval.propertyReferenceSource = delegate.normalizeUnqualifiedPropertyReference( IDENTIFIER379 ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

             ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path.appendNode( retval.propertyReferenceSource ); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unqualifiedPropertyReference"


    public static class pathedPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pathedPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:553:1: pathedPropertyReference : ^( DOT pathedPropertyReferenceSource IDENTIFIER ) ;
    public final GeneratedHQLResolver.pathedPropertyReference_return pathedPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.pathedPropertyReference_return retval = new GeneratedHQLResolver.pathedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT380=null;
        CommonTree IDENTIFIER382=null;
        GeneratedHQLResolver.pathedPropertyReferenceSource_return pathedPropertyReferenceSource381 =null;


        CommonTree DOT380_tree=null;
        CommonTree IDENTIFIER382_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:554:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:554:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DOT380=(CommonTree)match(input,DOT,FOLLOW_DOT_in_pathedPropertyReference2621); 


            if ( _first_0==null ) _first_0 = DOT380;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2623);
            pathedPropertyReferenceSource381=pathedPropertyReferenceSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = pathedPropertyReferenceSource381.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER382=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReference2625); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER382;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }



            		((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path.appendNode( delegate.normalizePropertyPathTerminus( ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path, IDENTIFIER382 ) );
            	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pathedPropertyReference"


    public static class pathedPropertyReferenceSource_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pathedPropertyReferenceSource"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:560:1: pathedPropertyReferenceSource returns [PathedPropertyReferenceSource propertyReferenceSource] : ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation );
    public final GeneratedHQLResolver.pathedPropertyReferenceSource_return pathedPropertyReferenceSource() throws RecognitionException {
        GeneratedHQLResolver.pathedPropertyReferenceSource_return retval = new GeneratedHQLResolver.pathedPropertyReferenceSource_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER383=null;
        CommonTree IDENTIFIER384=null;
        GeneratedHQLResolver.intermediatePathedPropertyReference_return intermediatePathedPropertyReference385 =null;

        GeneratedHQLResolver.intermediateIndexOperation_return intermediateIndexOperation386 =null;


        CommonTree IDENTIFIER383_tree=null;
        CommonTree IDENTIFIER384_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:562:2: ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation )
            int alt74=4;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==IDENTIFIER) && ((((delegate.isPersisterReferenceAlias()))||((delegate.isUnqualifiedPropertyReference()))))) {
                int LA74_1 = input.LA(2);

                if ( (((delegate.isPersisterReferenceAlias()))) ) {
                    alt74=1;
                }
                else if ( (((delegate.isUnqualifiedPropertyReference()))) ) {
                    alt74=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 74, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA74_0==DOT) ) {
                alt74=3;
            }
            else if ( (LA74_0==LEFT_SQUARE) ) {
                alt74=4;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 74, 0, input);

                throw nvae;

            }
            switch (alt74) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:562:4: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isPersisterReferenceAlias()))) ) {
                        throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(delegate.isPersisterReferenceAlias())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER383=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2653); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER383;


                     retval.propertyReferenceSource = delegate.normalizeQualifiedRoot( IDENTIFIER383 ); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:563:4: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isUnqualifiedPropertyReference()))) ) {
                        throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(delegate.isUnqualifiedPropertyReference())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER384=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2663); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER384;


                     retval.propertyReferenceSource = delegate.normalizeUnqualifiedRoot( IDENTIFIER384 ); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:564:4: intermediatePathedPropertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2670);
                    intermediatePathedPropertyReference385=intermediatePathedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = intermediatePathedPropertyReference385.tree;


                     retval.propertyReferenceSource = (intermediatePathedPropertyReference385!=null?intermediatePathedPropertyReference385.propertyReferenceSource:null); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:565:4: intermediateIndexOperation
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2677);
                    intermediateIndexOperation386=intermediateIndexOperation();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = intermediateIndexOperation386.tree;


                     retval.propertyReferenceSource = (intermediateIndexOperation386!=null?intermediateIndexOperation386.propertyReferenceSource:null); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
             ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path.appendNode( retval.propertyReferenceSource ); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pathedPropertyReferenceSource"


    public static class intermediatePathedPropertyReference_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intermediatePathedPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:568:1: intermediatePathedPropertyReference returns [PathedPropertyReferenceSource propertyReferenceSource] : ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) ;
    public final GeneratedHQLResolver.intermediatePathedPropertyReference_return intermediatePathedPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.intermediatePathedPropertyReference_return retval = new GeneratedHQLResolver.intermediatePathedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT387=null;
        CommonTree IDENTIFIER388=null;
        GeneratedHQLResolver.pathedPropertyReferenceSource_return source =null;


        CommonTree DOT387_tree=null;
        CommonTree IDENTIFIER388_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:569:2: ( ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:569:4: ^( DOT source= pathedPropertyReferenceSource IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DOT387=(CommonTree)match(input,DOT,FOLLOW_DOT_in_intermediatePathedPropertyReference2695); 


            if ( _first_0==null ) _first_0 = DOT387;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2699);
            source=pathedPropertyReferenceSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = source.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER388=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2701); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER388;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            	retval.propertyReferenceSource = delegate.normalizePropertyPathIntermediary( ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path, IDENTIFIER388 );	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intermediatePathedPropertyReference"


    public static class intermediateIndexOperation_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intermediateIndexOperation"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:573:1: intermediateIndexOperation returns [PathedPropertyReferenceSource propertyReferenceSource] : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
    public final GeneratedHQLResolver.intermediateIndexOperation_return intermediateIndexOperation() throws RecognitionException {
        GeneratedHQLResolver.intermediateIndexOperation_return retval = new GeneratedHQLResolver.intermediateIndexOperation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LEFT_SQUARE389=null;
        GeneratedHQLResolver.indexOperationSource_return indexOperationSource390 =null;

        GeneratedHQLResolver.indexSelector_return indexSelector391 =null;


        CommonTree LEFT_SQUARE389_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:574:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:574:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LEFT_SQUARE389=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2723); 


            if ( _first_0==null ) _first_0 = LEFT_SQUARE389;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexOperationSource_in_intermediateIndexOperation2725);
            indexOperationSource390=indexOperationSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexOperationSource390.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexSelector_in_intermediateIndexOperation2727);
            indexSelector391=indexSelector();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexSelector391.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            	retval.propertyReferenceSource = delegate.normalizeIntermediateIndexOperation( (indexOperationSource390!=null?indexOperationSource390.propertyReferenceSource:null), (indexOperationSource390!=null?indexOperationSource390.collectionProperty:null), (indexSelector391!=null?((CommonTree)indexSelector391.tree):null) );	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intermediateIndexOperation"


    public static class terminalIndexOperation_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "terminalIndexOperation"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:578:1: terminalIndexOperation : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
    public final GeneratedHQLResolver.terminalIndexOperation_return terminalIndexOperation() throws RecognitionException {
        GeneratedHQLResolver.terminalIndexOperation_return retval = new GeneratedHQLResolver.terminalIndexOperation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LEFT_SQUARE392=null;
        GeneratedHQLResolver.indexOperationSource_return indexOperationSource393 =null;

        GeneratedHQLResolver.indexSelector_return indexSelector394 =null;


        CommonTree LEFT_SQUARE392_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:579:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:579:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LEFT_SQUARE392=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2745); 


            if ( _first_0==null ) _first_0 = LEFT_SQUARE392;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexOperationSource_in_terminalIndexOperation2747);
            indexOperationSource393=indexOperationSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexOperationSource393.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexSelector_in_terminalIndexOperation2749);
            indexSelector394=indexSelector();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexSelector394.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            	delegate.normalizeTerminalIndexOperation( (indexOperationSource393!=null?indexOperationSource393.propertyReferenceSource:null), (indexOperationSource393!=null?indexOperationSource393.collectionProperty:null), (indexSelector394!=null?((CommonTree)indexSelector394.tree):null) );	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "terminalIndexOperation"


    public static class indexOperationSource_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        public Tree collectionProperty;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexOperationSource"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:583:1: indexOperationSource returns [PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty] : ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER );
    public final GeneratedHQLResolver.indexOperationSource_return indexOperationSource() throws RecognitionException {
        GeneratedHQLResolver.indexOperationSource_return retval = new GeneratedHQLResolver.indexOperationSource_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT395=null;
        CommonTree IDENTIFIER397=null;
        CommonTree IDENTIFIER398=null;
        GeneratedHQLResolver.pathedPropertyReferenceSource_return pathedPropertyReferenceSource396 =null;


        CommonTree DOT395_tree=null;
        CommonTree IDENTIFIER397_tree=null;
        CommonTree IDENTIFIER398_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:584:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER )
            int alt75=2;
            int LA75_0 = input.LA(1);

            if ( (LA75_0==DOT) ) {
                alt75=1;
            }
            else if ( (LA75_0==IDENTIFIER) && (((delegate.isUnqualifiedPropertyReference())))) {
                alt75=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 75, 0, input);

                throw nvae;

            }
            switch (alt75) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:584:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT395=(CommonTree)match(input,DOT,FOLLOW_DOT_in_indexOperationSource2770); 


                    if ( _first_0==null ) _first_0 = DOT395;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2772);
                    pathedPropertyReferenceSource396=pathedPropertyReferenceSource();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = pathedPropertyReferenceSource396.tree;


                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER397=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2774); 
                     
                    if ( _first_1==null ) _first_1 = IDENTIFIER397;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    	retval.propertyReferenceSource = (pathedPropertyReferenceSource396!=null?pathedPropertyReferenceSource396.propertyReferenceSource:null);
                    		retval.collectionProperty = IDENTIFIER397;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:587:5: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isUnqualifiedPropertyReference()))) ) {
                        throw new FailedPredicateException(input, "indexOperationSource", "(delegate.isUnqualifiedPropertyReference())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER398=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2788); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER398;


                    	retval.propertyReferenceSource = delegate.normalizeUnqualifiedPropertyReferenceSource( IDENTIFIER398 );
                    			retval.collectionProperty = IDENTIFIER398;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexOperationSource"


    public static class indexSelector_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexSelector"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:592:1: indexSelector : valueExpression ;
    public final GeneratedHQLResolver.indexSelector_return indexSelector() throws RecognitionException {
        GeneratedHQLResolver.indexSelector_return retval = new GeneratedHQLResolver.indexSelector_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression399 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:593:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:593:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_indexSelector2803);
            valueExpression399=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression399.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexSelector"


    public static class path_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "path"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:596:1: path : ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) );
    public final GeneratedHQLResolver.path_return path() throws RecognitionException {
        GeneratedHQLResolver.path_return retval = new GeneratedHQLResolver.path_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER400=null;
        CommonTree DOT401=null;
        CommonTree LEFT_SQUARE404=null;
        CommonTree LEFT_PAREN407=null;
        GeneratedHQLResolver.path_return path402 =null;

        GeneratedHQLResolver.path_return path403 =null;

        GeneratedHQLResolver.path_return path405 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression406 =null;

        GeneratedHQLResolver.path_return path408 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression409 =null;


        CommonTree IDENTIFIER400_tree=null;
        CommonTree DOT401_tree=null;
        CommonTree LEFT_SQUARE404_tree=null;
        CommonTree LEFT_PAREN407_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:597:2: ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) )
            int alt78=4;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt78=1;
                }
                break;
            case DOT:
                {
                alt78=2;
                }
                break;
            case LEFT_SQUARE:
                {
                alt78=3;
                }
                break;
            case LEFT_PAREN:
                {
                alt78=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;

            }

            switch (alt78) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:597:5: IDENTIFIER
                    {
                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER400=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_path2815); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER400;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:598:4: ^( DOT path path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT401=(CommonTree)match(input,DOT,FOLLOW_DOT_in_path2821); 


                    if ( _first_0==null ) _first_0 = DOT401;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2823);
                    path402=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path402.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2825);
                    path403=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path403.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:599:4: ^( LEFT_SQUARE path ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LEFT_SQUARE404=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_path2833); 


                    if ( _first_0==null ) _first_0 = LEFT_SQUARE404;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2835);
                    path405=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path405.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:599:23: ( valueExpression )*
                    loop76:
                    do {
                        int alt76=2;
                        int LA76_0 = input.LA(1);

                        if ( (LA76_0==ABS||(LA76_0 >= ALIAS_REF && LA76_0 <= ALL)||LA76_0==ANY||(LA76_0 >= ASTERISK && LA76_0 <= AVG)||LA76_0==BIT_LENGTH||(LA76_0 >= CAST && LA76_0 <= CHARACTER_LITERAL)||LA76_0==COALESCE||(LA76_0 >= CONCAT && LA76_0 <= COUNT)||(LA76_0 >= CURRENT_DATE && LA76_0 <= CURRENT_TIMESTAMP)||LA76_0==DECIMAL_LITERAL||(LA76_0 >= DOT_CLASS && LA76_0 <= DOUBLE_PIPE)||LA76_0==ELEMENTS||LA76_0==EXISTS||LA76_0==EXTRACT||LA76_0==FALSE||LA76_0==FLOATING_POINT_LITERAL||LA76_0==FUNCTION||LA76_0==HEX_LITERAL||(LA76_0 >= INDEX && LA76_0 <= INDICES)||LA76_0==INTEGER_LITERAL||LA76_0==JAVA_CONSTANT||LA76_0==JPA_PARAM||LA76_0==LENGTH||(LA76_0 >= LOCATE && LA76_0 <= LOWER)||(LA76_0 >= MAX && LA76_0 <= MAXINDEX)||(LA76_0 >= MIN && LA76_0 <= MINUS)||LA76_0==MOD||LA76_0==NAMED_PARAM||(LA76_0 >= NULL && LA76_0 <= NULLIF)||(LA76_0 >= OCTAL_LITERAL && LA76_0 <= OCTET_LENGTH)||(LA76_0 >= PARAM && LA76_0 <= PATH)||(LA76_0 >= PLUS && LA76_0 <= POSITION)||LA76_0==PROPERTY_REFERENCE||LA76_0==SEARCHED_CASE||(LA76_0 >= SIMPLE_CASE && LA76_0 <= SOME)||(LA76_0 >= SQRT && LA76_0 <= SUM)||(LA76_0 >= TRIM && LA76_0 <= TRUE)||(LA76_0 >= UNARY_MINUS && LA76_0 <= UNARY_PLUS)||LA76_0==UPPER||LA76_0==VECTOR_EXPR) ) {
                            alt76=1;
                        }


                        switch (alt76) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:599:23: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_path2837);
                    	    valueExpression406=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression406.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop76;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:600:4: ^( LEFT_PAREN path ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LEFT_PAREN407=(CommonTree)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_path2846); 


                    if ( _first_0==null ) _first_0 = LEFT_PAREN407;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2848);
                    path408=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path408.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:600:22: ( valueExpression )*
                    loop77:
                    do {
                        int alt77=2;
                        int LA77_0 = input.LA(1);

                        if ( (LA77_0==ABS||(LA77_0 >= ALIAS_REF && LA77_0 <= ALL)||LA77_0==ANY||(LA77_0 >= ASTERISK && LA77_0 <= AVG)||LA77_0==BIT_LENGTH||(LA77_0 >= CAST && LA77_0 <= CHARACTER_LITERAL)||LA77_0==COALESCE||(LA77_0 >= CONCAT && LA77_0 <= COUNT)||(LA77_0 >= CURRENT_DATE && LA77_0 <= CURRENT_TIMESTAMP)||LA77_0==DECIMAL_LITERAL||(LA77_0 >= DOT_CLASS && LA77_0 <= DOUBLE_PIPE)||LA77_0==ELEMENTS||LA77_0==EXISTS||LA77_0==EXTRACT||LA77_0==FALSE||LA77_0==FLOATING_POINT_LITERAL||LA77_0==FUNCTION||LA77_0==HEX_LITERAL||(LA77_0 >= INDEX && LA77_0 <= INDICES)||LA77_0==INTEGER_LITERAL||LA77_0==JAVA_CONSTANT||LA77_0==JPA_PARAM||LA77_0==LENGTH||(LA77_0 >= LOCATE && LA77_0 <= LOWER)||(LA77_0 >= MAX && LA77_0 <= MAXINDEX)||(LA77_0 >= MIN && LA77_0 <= MINUS)||LA77_0==MOD||LA77_0==NAMED_PARAM||(LA77_0 >= NULL && LA77_0 <= NULLIF)||(LA77_0 >= OCTAL_LITERAL && LA77_0 <= OCTET_LENGTH)||(LA77_0 >= PARAM && LA77_0 <= PATH)||(LA77_0 >= PLUS && LA77_0 <= POSITION)||LA77_0==PROPERTY_REFERENCE||LA77_0==SEARCHED_CASE||(LA77_0 >= SIMPLE_CASE && LA77_0 <= SOME)||(LA77_0 >= SQRT && LA77_0 <= SUM)||(LA77_0 >= TRIM && LA77_0 <= TRUE)||(LA77_0 >= UNARY_MINUS && LA77_0 <= UNARY_PLUS)||LA77_0==UPPER||LA77_0==VECTOR_EXPR) ) {
                            alt77=1;
                        }


                        switch (alt77) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:600:22: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_path2850);
                    	    valueExpression409=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression409.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop77;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "path"

    // Delegated rules


 

    public static final BitSet FOLLOW_QUERY_in_filterStatement62 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QUERY_SPEC_in_filterStatement65 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_FILTER_in_filterStatement67 = new BitSet(new long[]{0x0000000000000008L,0x0000000000002000L,0x0000400000040000L,0x0000000000080000L});
    public static final BitSet FOLLOW_selectClause_in_filterStatement73 = new BitSet(new long[]{0x0000000000000008L,0x0000000000002000L,0x0000000000040000L,0x0000000000080000L});
    public static final BitSet FOLLOW_whereClause_in_filterStatement76 = new BitSet(new long[]{0x0000000000000008L,0x0000000000002000L,0x0000000000040000L});
    public static final BitSet FOLLOW_groupByClause_in_filterStatement81 = new BitSet(new long[]{0x0000000000000008L,0x0000000000008000L,0x0000000000040000L});
    public static final BitSet FOLLOW_havingClause_in_filterStatement83 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_orderByClause_in_filterStatement88 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_updateStatementSet_in_statement102 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatementSet_in_statement107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatementSet_in_statement112 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_queryStatementSet_in_statement117 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_updateStatementSet128 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_UPDATE_in_updateStatement141 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_updateStatement143 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0008000000000000L});
    public static final BitSet FOLLOW_SET_in_updateStatement146 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_assignment_in_updateStatement148 = new BitSet(new long[]{0x0200000000000008L});
    public static final BitSet FOLLOW_whereClause_in_updateStatement152 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQUALS_in_assignment166 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_assignment168 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_assignment170 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQUALS_in_assignment177 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VERSIONED_VALUE_in_assignment179 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0400000000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_assignment181 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_deleteStatement_in_deleteStatementSet193 = new BitSet(new long[]{0x0000080000000002L});
    public static final BitSet FOLLOW_DELETE_in_deleteStatement206 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_deleteStatement208 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement210 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_insertStatement_in_insertStatementSet223 = new BitSet(new long[]{0x0000000000000002L,0x0000000002000000L});
    public static final BitSet FOLLOW_INSERT_in_insertStatement236 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_intoClause_in_insertStatement238 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000001000000000L});
    public static final BitSet FOLLOW_queryStatementSet_in_insertStatement240 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INTO_in_intoClause253 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_intoClause255 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_INSERTABILITY_SPEC_in_intoClause258 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_intoClause260 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_queryStatement_in_queryStatementSet276 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000001000000000L});
    public static final BitSet FOLLOW_QUERY_in_queryStatement289 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_queryExpression_in_queryStatement291 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_orderByClause_in_queryStatement293 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNION_in_queryExpression307 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression309 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression312 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression314 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INTERSECT_in_queryExpression321 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression323 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression326 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression328 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXCEPT_in_queryExpression335 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression337 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression340 = new BitSet(new long[]{0x1000000000000000L,0x0000000020000000L,0x0000002000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression342 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_querySpec_in_queryExpression348 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUERY_SPEC_in_querySpec360 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_selectFrom_in_querySpec362 = new BitSet(new long[]{0x0000000000000008L,0x000000000000A000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_whereClause_in_querySpec364 = new BitSet(new long[]{0x0000000000000008L,0x000000000000A000L});
    public static final BitSet FOLLOW_groupByClause_in_querySpec367 = new BitSet(new long[]{0x0000000000000008L,0x0000000000008000L});
    public static final BitSet FOLLOW_havingClause_in_querySpec370 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHERE_in_whereClause384 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_whereClause386 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GROUP_BY_in_groupByClause399 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_groupingValue_in_groupByClause401 = new BitSet(new long[]{0x0000000000000008L,0x0000000000001000L});
    public static final BitSet FOLLOW_GROUPING_VALUE_in_groupingValue415 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_groupingValue417 = new BitSet(new long[]{0x0000000008000008L});
    public static final BitSet FOLLOW_COLLATE_in_groupingValue419 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_HAVING_in_havingClause433 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_havingClause435 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SELECT_FROM_in_selectFrom448 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_fromClause_in_selectFrom450 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000400000000000L});
    public static final BitSet FOLLOW_selectClause_in_selectFrom452 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FROM_in_fromClause465 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_persisterSpaces_in_fromClause467 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000004000000L});
    public static final BitSet FOLLOW_PERSISTER_SPACE_in_persisterSpaces481 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_persisterSpace_in_persisterSpaces483 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_persisterSpaceRoot_in_persisterSpace495 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000082000000L});
    public static final BitSet FOLLOW_joins_in_persisterSpace497 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000082000000L});
    public static final BitSet FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot510 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_persisterSpaceRoot512 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_PROP_FETCH_in_persisterSpaceRoot514 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PROPERTY_JOIN_in_joins528 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_joinType_in_joins532 = new BitSet(new long[]{0x0000000000000040L,0x0000000000000004L});
    public static final BitSet FOLLOW_FETCH_in_joins536 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_joins541 = new BitSet(new long[]{0x0008000000000000L,0x0000000000800000L,0x0000000200800000L});
    public static final BitSet FOLLOW_PROP_FETCH_in_joins545 = new BitSet(new long[]{0x0008000000000000L,0x0000000000800000L,0x0000000000800000L});
    public static final BitSet FOLLOW_joinProperty_in_joins555 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_withClause_in_joins559 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PERSISTER_JOIN_in_joins571 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_joinType_in_joins573 = new BitSet(new long[]{0x0080000000000000L});
    public static final BitSet FOLLOW_persisterSpaceRoot_in_joins575 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_onClause_in_joins577 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_collectionExpression_in_joinProperty592 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_joinPropertyReference_in_joinProperty597 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_WITH_in_withClause610 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_withClause612 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ON_in_onClause625 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_onClause627 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CROSS_in_joinType643 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INNER_in_joinType650 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LEFT_in_joinType658 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_RIGHT_in_joinType664 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_FULL_in_joinType670 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_OUTER_in_joinType675 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SELECT_in_selectClause698 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_DISTINCT_in_selectClause700 = new BitSet(new long[]{0xA00BC4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF3100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rootSelectExpression_in_selectClause703 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SELECT_LIST_in_rootSelectExpression716 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression718 = new BitSet(new long[]{0xA00BC4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF3100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_SELECT_ITEM_in_rootSelectExpression726 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression728 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression735 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression737 = new BitSet(new long[]{0xA00BC4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF3100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression745 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression747 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_valueExpression_in_rootSelectExpression753 = new BitSet(new long[]{0x0000000000000042L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_rootSelectExpression755 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ORDER_BY_in_orderByClause768 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_sortSpecification_in_orderByClause770 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0100000000000000L});
    public static final BitSet FOLLOW_SORT_SPEC_in_sortSpecification784 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_sortSpecification786 = new BitSet(new long[]{0x0000000008000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_COLLATE_in_sortSpecification788 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_ORDER_SPEC_in_sortSpecification791 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OR_in_searchCondition805 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition807 = new BitSet(new long[]{0xA208C4EE05CACDA0L,0xBFDF815E08E20D12L,0x3EF0100130C2CFF4L,0x00000000000051B0L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition809 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AND_in_searchCondition818 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition820 = new BitSet(new long[]{0xA208C4EE05CACDA0L,0xBFDF815E08E20D12L,0x3EF0100130C2CFF4L,0x00000000000051B0L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition822 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_in_searchCondition831 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition833 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_predicate_in_searchCondition840 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EQUALS_in_predicate853 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate855 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate857 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_EQUAL_in_predicate866 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate868 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate870 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_in_predicate879 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate881 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate883 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_EQUAL_in_predicate892 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate894 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate896 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GREATER_in_predicate905 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate907 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate909 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GREATER_EQUAL_in_predicate918 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate920 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate922 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NULL_in_predicate931 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate933 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NOT_NULL_in_predicate942 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate944 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LIKE_in_predicate969 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_predicate971 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_predicate973 = new BitSet(new long[]{0x0400000000000008L});
    public static final BitSet FOLLOW_escapeSpecification_in_predicate975 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_LIKE_in_predicate985 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_predicate987 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_predicate989 = new BitSet(new long[]{0x0400000000000008L});
    public static final BitSet FOLLOW_escapeSpecification_in_predicate991 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BETWEEN_in_predicate1022 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1024 = new BitSet(new long[]{0x0000000000040000L});
    public static final BitSet FOLLOW_betweenList_in_predicate1026 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_BETWEEN_in_predicate1035 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1037 = new BitSet(new long[]{0x0000000000040000L});
    public static final BitSet FOLLOW_betweenList_in_predicate1039 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_in_predicate1066 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1068 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
    public static final BitSet FOLLOW_inPredicateValue_in_predicate1070 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_IN_in_predicate1079 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1081 = new BitSet(new long[]{0x0000000000000000L,0x0000000080000000L});
    public static final BitSet FOLLOW_inPredicateValue_in_predicate1083 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MEMBER_OF_in_predicate1110 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1112 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1114 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_MEMBER_OF_in_predicate1123 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1125 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1127 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_EMPTY_in_predicate1137 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1139 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NOT_EMPTY_in_predicate1148 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1150 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1157 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BETWEEN_LIST_in_betweenList1170 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1174 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1178 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_rowValueConstructor_in_comparativePredicateValue1191 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_rowValueConstructor1202 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ESCAPE_in_escapeSpecification1214 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_escapeSpecification1216 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_LIST_in_inPredicateValue1229 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_inPredicateValue1231 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_numericValueExpression1244 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_characterValueExpression1255 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_datetimeValueExpression1266 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLE_PIPE_in_valueExpression1279 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_valueExpression1281 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_UNARY_MINUS_in_valueExpression1291 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1293 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNARY_PLUS_in_valueExpression1302 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1304 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PLUS_in_valueExpression1313 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1315 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1317 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MINUS_in_valueExpression1326 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1328 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1330 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ASTERISK_in_valueExpression1339 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1341 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1343 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SOLIDUS_in_valueExpression1352 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1354 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1356 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXISTS_in_valueExpression1365 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_valueExpression1367 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SOME_in_valueExpression1375 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1377 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ALL_in_valueExpression1386 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1388 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ANY_in_valueExpression1397 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1399 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_VECTOR_EXPR_in_valueExpression1408 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1410 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpressionPrimary_in_valueExpression1418 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_caseExpression_in_valueExpressionPrimary1429 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_function_in_valueExpressionPrimary1434 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionFunction_in_valueExpressionPrimary1439 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionExpression_in_valueExpressionPrimary1444 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_valueExpressionPrimary1449 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_parameter_in_valueExpressionPrimary1454 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyReference_in_valueExpressionPrimary1459 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SUB_QUERY_in_valueExpressionPrimary1465 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_queryStatementSet_in_valueExpressionPrimary1467 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ALIAS_REF_in_valueExpressionPrimary1473 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_CLASS_in_valueExpressionPrimary1480 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_valueExpressionPrimary1482 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1490 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_valueExpressionPrimary1492 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PATH_in_valueExpressionPrimary1500 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_valueExpressionPrimary1504 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NULLIF_in_caseExpression1531 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1533 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1535 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COALESCE_in_caseExpression1542 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1544 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1546 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_SIMPLE_CASE_in_caseExpression1554 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1556 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_simpleCaseWhenClause_in_caseExpression1558 = new BitSet(new long[]{0x0010000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_elseClause_in_caseExpression1561 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SEARCHED_CASE_in_caseExpression1569 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchedWhenClause_in_caseExpression1571 = new BitSet(new long[]{0x0010000000000008L,0x0000000000000000L,0x0000000000000000L,0x0000000000040000L});
    public static final BitSet FOLLOW_elseClause_in_caseExpression1574 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHEN_in_simpleCaseWhenClause1588 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1590 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1592 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHEN_in_searchedWhenClause1605 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchedWhenClause1607 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_searchedWhenClause1609 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ELSE_in_elseClause1622 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_elseClause1624 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_setFunction_in_function1636 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_standardFunction_in_function1641 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SUM_in_setFunction1653 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1655 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AVG_in_setFunction1662 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1664 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MAX_in_setFunction1671 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1673 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MIN_in_setFunction1680 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1682 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COUNT_in_setFunction1689 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ASTERISK_in_setFunction1692 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_setFunction1696 = new BitSet(new long[]{0x0008040000000000L,0x0000000008800010L,0x0000000100000000L});
    public static final BitSet FOLLOW_countFunctionArguments_in_setFunction1702 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_functionFunction_in_standardFunction1715 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_castFunction_in_standardFunction1720 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concatFunction_in_standardFunction1725 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_substringFunction_in_standardFunction1730 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trimFunction_in_standardFunction1735 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upperFunction_in_standardFunction1740 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lowerFunction_in_standardFunction1745 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lengthFunction_in_standardFunction1750 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateFunction_in_standardFunction1755 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_absFunction_in_standardFunction1760 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sqrtFunction_in_standardFunction1765 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_modFunction_in_standardFunction1770 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sizeFunction_in_standardFunction1775 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_indexFunction_in_standardFunction1780 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentDateFunction_in_standardFunction1785 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimeFunction_in_standardFunction1790 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimestampFunction_in_standardFunction1795 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_extractFunction_in_standardFunction1800 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_positionFunction_in_standardFunction1805 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_charLengthFunction_in_standardFunction1810 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_octetLengthFunction_in_standardFunction1815 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bitLengthFunction_in_standardFunction1820 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNCTION_in_functionFunction1833 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_functionFunction1835 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_CAST_in_castFunction1850 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_castFunction1852 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_castFunction1854 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONCAT_in_concatFunction1869 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_concatFunction1871 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_SUBSTRING_in_substringFunction1885 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_substringFunction1887 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1889 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1891 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_TRIM_in_trimFunction1905 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_trimOperands_in_trimFunction1907 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_trimOperands1920 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1928 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1930 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UPPER_in_upperFunction1943 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_upperFunction1945 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOWER_in_lowerFunction1958 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lowerFunction1960 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LENGTH_in_lengthFunction1973 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lengthFunction1975 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOCATE_in_locateFunction1988 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1990 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1992 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_locateFunction1994 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_in_absFunction2008 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_absFunction2010 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SQRT_in_sqrtFunction2023 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_sqrtFunction2025 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MOD_in_modFunction2038 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_modFunction2040 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_numericValueExpression_in_modFunction2042 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SIZE_in_sizeFunction2055 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_sizeFunction2057 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INDEX_in_indexFunction2070 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALIAS_REF_in_indexFunction2072 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CURRENT_DATE_in_currentDateFunction2084 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIME_in_currentTimeFunction2095 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2106 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXTRACT_in_extractFunction2118 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_extractField_in_extractFunction2120 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_datetimeValueExpression_in_extractFunction2122 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_datetimeField_in_extractField2134 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_timeZoneField_in_extractField2139 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_POSITION_in_positionFunction2203 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2205 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2207 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2220 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_charLengthFunction2222 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OCTET_LENGTH_in_octetLengthFunction2235 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_octetLengthFunction2237 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BIT_LENGTH_in_bitLengthFunction2250 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_bitLengthFunction2252 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_collectionExpression_in_countFunctionArguments2265 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyReference_in_countFunctionArguments2270 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numeric_literal_in_countFunctionArguments2275 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_collectionFunction2287 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_collectionPropertyReference_in_collectionFunction2297 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_propertyReference_in_collectionPropertyReference2312 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ELEMENTS_in_collectionExpression2324 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_collectionExpression2326 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INDICES_in_collectionExpression2334 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_collectionExpression2336 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_literal_in_constant2369 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_constant2374 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_constant2379 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_constant2384 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numeric_literal_in_literal2395 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEX_LITERAL_in_literal2400 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OCTAL_LITERAL_in_literal2405 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal2410 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal2415 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONST_STRING_VALUE_in_literal2421 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal2423 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONST_STRING_VALUE_in_literal2430 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal2432 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ENTITY_NAME_in_entityName2465 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_entityName2467 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_propertyReference2482 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_propertyReference2486 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PATH_in_joinPropertyReference2521 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_joinPropertyReference2525 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2575 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pathedPropertyReference_in_propertyReferencePath2580 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_terminalIndexOperation_in_propertyReferencePath2585 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2606 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_pathedPropertyReference2621 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2623 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReference2625 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2653 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2663 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2670 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2677 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_intermediatePathedPropertyReference2695 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2699 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2701 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2723 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_indexOperationSource_in_intermediateIndexOperation2725 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_indexSelector_in_intermediateIndexOperation2727 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2745 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_indexOperationSource_in_terminalIndexOperation2747 = new BitSet(new long[]{0xA008C4EE05C8C9A0L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_indexSelector_in_terminalIndexOperation2749 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_indexOperationSource2770 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2772 = new BitSet(new long[]{0x0000000000000000L,0x0000000000100000L});
    public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2774 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2788 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_indexSelector2803 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_path2815 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_path2821 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2823 = new BitSet(new long[]{0x0000200000000000L,0x0000600000100000L});
    public static final BitSet FOLLOW_path_in_path2825 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_path2833 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2835 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_path2837 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_path2846 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2848 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});
    public static final BitSet FOLLOW_valueExpression_in_path2850 = new BitSet(new long[]{0xA008C4EE05C8C9A8L,0xBDD8814008C20112L,0x3EF0100130C0CC04L,0x00000000000051B0L});

}