/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.jdk;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.models.internal.TypeVariableReferenceDetailsImpl;
import org.hibernate.models.internal.jdk.JdkTrackingTypeSwitch;
import org.hibernate.models.internal.jdk.JdkTypeSwitcher;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public class JdkTrackingTypeSwitcher
implements JdkTypeSwitcher {
    private final JdkTrackingTypeSwitch typeSwitch;
    private List<String> typeVariableIdentifiers;
    private Map<String, List<TypeVariableReferenceDetailsImpl>> typeVariableRefXref;

    public static TypeDetails standardSwitchType(Type type, ModelsContext modelsContext) {
        return new JdkTrackingTypeSwitcher(modelsContext).switchType(type);
    }

    public JdkTrackingTypeSwitcher(ModelsContext modelsContext) {
        this.typeSwitch = new JdkTrackingTypeSwitch(this, modelsContext);
    }

    @Override
    public TypeDetails switchType(Type type) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            return this.typeSwitch.caseClass(classType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return this.typeSwitch.caseGenericArrayType(arrayType);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.typeSwitch.caseParameterizedType(parameterizedType);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return this.switchTypeVariable(type, typeVariable);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return this.typeSwitch.caseWildcardType(wildcardType);
        }
        return this.typeSwitch.defaultCase(type);
    }

    private TypeDetails switchTypeVariable(Type type, TypeVariable typeVariable) {
        List<TypeVariableReferenceDetailsImpl> list;
        if (this.typeVariableIdentifiers == null) {
            this.typeVariableIdentifiers = new ArrayList<String>();
        } else if (this.typeVariableIdentifiers.contains(typeVariable.getTypeName())) {
            TypeVariableReferenceDetailsImpl reference = new TypeVariableReferenceDetailsImpl(type.getTypeName());
            if (this.typeVariableRefXref == null) {
                this.typeVariableRefXref = new HashMap<String, List<TypeVariableReferenceDetailsImpl>>();
                List list2 = this.typeVariableRefXref.computeIfAbsent(type.getTypeName(), s -> new ArrayList());
                list2.add(reference);
            }
            return reference;
        }
        this.typeVariableIdentifiers.add(typeVariable.getTypeName());
        Object switched = this.typeSwitch.caseTypeVariable(typeVariable);
        assert (switched != null);
        if (this.typeVariableRefXref != null && CollectionHelper.isNotEmpty(list = this.typeVariableRefXref.get(typeVariable.getTypeName()))) {
            for (TypeVariableReferenceDetailsImpl reference : list) {
                reference.setTarget((TypeVariableDetails)switched);
            }
        }
        return switched;
    }
}

