/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.JsonJdbcType;

public class GaussDBCastingJsonJdbcType
extends JsonJdbcType {
    public static final GaussDBCastingJsonJdbcType JSON_INSTANCE = new GaussDBCastingJsonJdbcType(false, null);
    public static final GaussDBCastingJsonJdbcType JSONB_INSTANCE = new GaussDBCastingJsonJdbcType(true, null);
    private final boolean jsonb;

    public GaussDBCastingJsonJdbcType(boolean jsonb, EmbeddableMappingType embeddableMappingType) {
        super(embeddableMappingType);
        this.jsonb = jsonb;
    }

    public int getDdlTypeCode() {
        return 3001;
    }

    public AggregateJdbcType resolveAggregateJdbcType(EmbeddableMappingType mappingType, String sqlType, RuntimeModelCreationContext creationContext) {
        return new GaussDBCastingJsonJdbcType(this.jsonb, mappingType);
    }

    public void appendWriteExpression(String writeExpression, @Nullable Size size, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"cast(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)" as ");
        if (this.jsonb) {
            appender.append((CharSequence)"jsonb)");
        } else {
            appender.append((CharSequence)"json)");
        }
    }

    public boolean isWriteExpressionTyped(Dialect dialect) {
        return true;
    }
}

