/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.Metamodel;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.query.Order;
import org.hibernate.query.Page;

public abstract class AbstractQueryMethod
implements MetaAttribute {
    final @UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity;
    final @UnknownKeyFor @NonNull @Initialized String methodName;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes;
    final @Nullable @UnknownKeyFor @Initialized String returnTypeName;
    final @UnknownKeyFor @NonNull @Initialized String sessionType;
    final @UnknownKeyFor @NonNull @Initialized String sessionName;
    final @UnknownKeyFor @NonNull @Initialized boolean belongsToDao;
    final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;

    public AbstractQueryMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String returnTypeName, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation) {
        this.annotationMetaEntity = annotationMetaEntity;
        this.methodName = methodName;
        this.paramNames = paramNames;
        this.paramTypes = paramTypes;
        this.returnTypeName = returnTypeName;
        this.sessionType = sessionType;
        this.sessionName = sessionName;
        this.belongsToDao = belongsToDao;
        this.addNonnullAnnotation = addNonnullAnnotation;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMetaEntity;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int var1);

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterTypes() {
        return this.paramTypes.stream().map(paramType -> AbstractQueryMethod.isOrderParam(paramType) && paramType.endsWith("[]") ? paramType.substring(0, paramType.length() - 2) + "..." : paramType).collect(Collectors.toList());
    }

    @UnknownKeyFor @NonNull @Initialized String parameterList() {
        return this.paramTypes.stream().map(this::strip).map(this.annotationMetaEntity::importType).reduce((x, y) -> x + "," + y).orElse("");
    }

    @UnknownKeyFor @NonNull @Initialized String strip(@UnknownKeyFor @NonNull @Initialized String type) {
        int index = type.indexOf("<");
        String stripped = index > 0 ? type.substring(0, index) : type;
        return type.endsWith("...") ? stripped + "..." : stripped;
    }

    void parameters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("(");
        this.sessionParameter(declaration);
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (i > 0) {
                declaration.append(", ");
            }
            String paramType = paramTypes.get(i);
            if (!this.isNullable(i) && !TypeUtils.isPrimitive(paramType) || AbstractQueryMethod.isSessionParameter(paramType)) {
                this.notNull(declaration);
            }
            declaration.append(this.annotationMetaEntity.importType(this.importReturnTypeArgument(paramType))).append(" ").append(this.paramNames.get(i));
        }
        declaration.append(")");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isSessionParameter(@UnknownKeyFor @NonNull @Initialized String paramType) {
        return Constants.SESSION_TYPES.contains(paramType);
    }

    private @UnknownKeyFor @NonNull @Initialized String importReturnTypeArgument(@UnknownKeyFor @NonNull @Initialized String type) {
        return this.returnTypeName != null ? type.replace(this.returnTypeName, this.annotationMetaEntity.importType(this.returnTypeName)) : type;
    }

    void sessionParameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (!this.belongsToDao) {
            if (this.paramTypes.stream().noneMatch(Constants.SESSION_TYPES::contains)) {
                this.notNull(declaration);
                declaration.append(this.annotationMetaEntity.importType(this.sessionType)).append(' ').append(this.sessionName);
                if (!this.paramNames.isEmpty()) {
                    declaration.append(", ");
                }
            }
        }
    }

    void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    void see(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n * @see ").append(this.annotationMetaEntity.getQualifiedName()).append("#").append(this.methodName).append("(").append(this.parameterList()).append(")");
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingEntityManager() {
        return "jakarta.persistence.EntityManager".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingStatelessSession() {
        return "org.hibernate.StatelessSession".equals(this.sessionType);
    }

    @UnknownKeyFor @NonNull @Initialized boolean isReactive() {
        return "org.hibernate.reactive.mutiny.Mutiny.Session".equals(this.sessionType);
    }

    void setPage(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        if (this.isUsingEntityManager()) {
            declaration.append("\n\t\t\t.setFirstResult(").append(paramName).append(".getFirstResult())").append("\n\t\t\t.setMaxResults(").append(paramName).append(".getMaxResults())");
        } else {
            declaration.append("\n\t\t\t.setPage(").append(paramName).append(")");
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean setOrder(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean unwrapped, @UnknownKeyFor @NonNull @Initialized String paramName, @UnknownKeyFor @NonNull @Initialized String paramType) {
        this.unwrapQuery(declaration, unwrapped);
        if (paramType.endsWith("...")) {
            declaration.append("\n\t\t\t.setOrder(").append(this.annotationMetaEntity.importType(Constants.LIST)).append(".of(").append(paramName).append("))");
        } else {
            declaration.append("\n\t\t\t.setOrder(").append(paramName).append(")");
        }
        return true;
    }

    private void unwrapQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if (!unwrapped) {
            declaration.append("\n\t\t\t.unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.query.SelectionQuery")).append(".class)");
        }
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isPageParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return Page.class.getName().equals(parameterType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isOrderParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return parameterType.startsWith(Order.class.getName()) || parameterType.startsWith(List.class.getName() + "<" + Order.class.getName());
    }
}

