/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.EngineSpiSettings;
import org.hibernate.search.engine.common.spi.SearchIntegrationEnvironment;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.BeanRetrieval;
import org.hibernate.search.engine.environment.bean.impl.BeanConfigurationContextImpl;
import org.hibernate.search.engine.environment.bean.impl.BeanReferenceRegistryForType;
import org.hibernate.search.engine.environment.bean.impl.BeanSource;
import org.hibernate.search.engine.environment.bean.impl.ConfigurationBeanRegistry;
import org.hibernate.search.engine.environment.bean.impl.NoConfiguredBeanManagerBeanProvider;
import org.hibernate.search.engine.environment.bean.spi.BeanConfigurer;
import org.hibernate.search.engine.environment.bean.spi.BeanNotFoundException;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoaderHelper;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.ServiceResolver;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class BeanResolverImpl
implements BeanResolver {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<List<BeanReference<? extends BeanConfigurer>>> BEAN_CONFIGURERS = ConfigurationProperty.forKey("bean_configurers").asBeanReference(BeanConfigurer.class).multivalued().withDefault(EngineSpiSettings.Defaults.BEAN_CONFIGURERS).build();
    private final ClassResolver classResolver;
    private final ConfigurationBeanRegistry configurationBeanRegistry;
    private final BeanProvider beanManagerBeanProvider;

    public static BeanResolverImpl create(ClassResolver classResolver, ServiceResolver serviceResolver, BeanProvider beanManagerBeanProvider, ConfigurationPropertySource rawConfigurationPropertySource) {
        if (beanManagerBeanProvider == null) {
            beanManagerBeanProvider = new NoConfiguredBeanManagerBeanProvider();
        }
        BeanConfigurationContextImpl configurationContext = new BeanConfigurationContextImpl();
        for (BeanConfigurer beanConfigurer : serviceResolver.loadJavaServices(BeanConfigurer.class)) {
            beanConfigurer.configure(configurationContext);
        }
        ConfigurationBeanRegistry beanRegistryForConfiguration = configurationContext.buildRegistry();
        BeanResolverImpl beanResolverForConfiguration = new BeanResolverImpl(classResolver, beanRegistryForConfiguration, beanManagerBeanProvider);
        ConfigurationPropertySource configurationPropertySource = SearchIntegrationEnvironment.rootPropertySource(rawConfigurationPropertySource, beanResolverForConfiguration);
        try (BeanHolder beanConfigurersFromConfigurationProperties = BEAN_CONFIGURERS.getAndTransform(configurationPropertySource, beanResolverForConfiguration::resolve);){
            for (BeanConfigurer beanConfigurer : (List)beanConfigurersFromConfigurationProperties.get()) {
                beanConfigurer.configure(configurationContext);
            }
        }
        return new BeanResolverImpl(classResolver, configurationContext.buildRegistry(), beanManagerBeanProvider);
    }

    private BeanResolverImpl(ClassResolver classResolver, ConfigurationBeanRegistry configurationBeanRegistry, BeanProvider beanManagerBeanProvider) {
        this.classResolver = classResolver;
        this.configurationBeanRegistry = configurationBeanRegistry;
        this.beanManagerBeanProvider = beanManagerBeanProvider;
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference, BeanRetrieval retrieval) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        return this.resolveFromFirstSuccessfulSource(typeReference, retrieval);
    }

    @Override
    public <T> BeanHolder<T> resolve(Class<T> typeReference, String nameReference, BeanRetrieval retrieval) {
        Contracts.assertNotNull(typeReference, (String)"typeReference");
        Contracts.assertNotNullNorEmpty((String)nameReference, (String)"nameReference");
        return this.resolveFromFirstSuccessfulSource(typeReference, nameReference, retrieval);
    }

    @Override
    public <T> List<BeanReference<T>> allConfiguredForRole(Class<T> role) {
        Contracts.assertNotNull(role, (String)"role");
        BeanReferenceRegistryForType<T> registry = this.configurationBeanRegistry.explicitlyConfiguredBeans(role);
        if (registry == null) {
            return Collections.emptyList();
        }
        return registry.all();
    }

    @Override
    public <T> Map<String, BeanReference<T>> namedConfiguredForRole(Class<T> role) {
        Contracts.assertNotNull(role, (String)"role");
        BeanReferenceRegistryForType<T> registry = this.configurationBeanRegistry.explicitlyConfiguredBeans(role);
        if (registry == null) {
            return Collections.emptyMap();
        }
        return registry.named();
    }

    private List<BeanSource> toSources(BeanRetrieval retrieval, boolean hasName) {
        switch (retrieval) {
            case BUILTIN: {
                return Collections.singletonList(BeanSource.CONFIGURATION);
            }
            case BEAN: {
                return Collections.singletonList(BeanSource.BEAN_MANAGER);
            }
            case CLASS: {
                return Arrays.asList(BeanSource.BEAN_MANAGER_ASSUME_CLASS_NAME, BeanSource.REFLECTION);
            }
            case CONSTRUCTOR: {
                return Collections.singletonList(BeanSource.REFLECTION);
            }
            case ANY: {
                return hasName ? Arrays.asList(BeanSource.CONFIGURATION, BeanSource.BEAN_MANAGER, BeanSource.BEAN_MANAGER_ASSUME_CLASS_NAME, BeanSource.REFLECTION) : Arrays.asList(BeanSource.CONFIGURATION, BeanSource.BEAN_MANAGER, BeanSource.REFLECTION);
            }
        }
        throw new AssertionFailure("Unknown bean retrieval: " + (Object)((Object)retrieval));
    }

    private <T> BeanHolder<T> resolveFromFirstSuccessfulSource(Class<T> typeReference, BeanRetrieval retrieval) {
        List<BeanSource> sources = this.toSources(retrieval, false);
        BeanNotFoundException firstFailure = null;
        ArrayList<BeanNotFoundException> otherFailures = new ArrayList<BeanNotFoundException>();
        for (BeanSource source : sources) {
            try {
                return this.tryResolve(typeReference, source);
            }
            catch (BeanNotFoundException e) {
                if (firstFailure == null) {
                    firstFailure = e;
                    continue;
                }
                otherFailures.add(e);
            }
        }
        throw log.cannotResolveBeanReference(typeReference, this.buildFailureMessage(sources, firstFailure, otherFailures), (RuntimeException)((Object)firstFailure), (Collection<? extends RuntimeException>)otherFailures);
    }

    private <T> BeanHolder<T> resolveFromFirstSuccessfulSource(Class<T> typeReference, String nameReference, BeanRetrieval retrieval) {
        List<BeanSource> sources = this.toSources(retrieval, true);
        BeanNotFoundException firstFailure = null;
        ArrayList<BeanNotFoundException> otherFailures = new ArrayList<BeanNotFoundException>();
        for (BeanSource source : sources) {
            try {
                return this.tryResolve(typeReference, nameReference, source);
            }
            catch (BeanNotFoundException e) {
                if (firstFailure == null) {
                    firstFailure = e;
                    continue;
                }
                otherFailures.add(e);
            }
        }
        throw log.cannotResolveBeanReference(typeReference, nameReference, this.buildFailureMessage(sources, firstFailure, otherFailures), (RuntimeException)((Object)firstFailure), otherFailures);
    }

    private <T> BeanHolder<T> tryResolve(Class<T> typeReference, BeanSource source) {
        switch (source) {
            case CONFIGURATION: {
                return this.configurationBeanRegistry.resolve(typeReference, this);
            }
            case BEAN_MANAGER: 
            case BEAN_MANAGER_ASSUME_CLASS_NAME: {
                return this.beanManagerBeanProvider.forType(typeReference);
            }
            case REFLECTION: {
                return this.retrieveUsingConstructor(typeReference);
            }
        }
        throw this.unknownBeanSource(source);
    }

    private <T> BeanHolder<T> tryResolve(Class<T> typeReference, String nameReference, BeanSource source) {
        switch (source) {
            case CONFIGURATION: {
                return this.configurationBeanRegistry.resolve(typeReference, nameReference, this);
            }
            case BEAN_MANAGER: {
                return this.beanManagerBeanProvider.forTypeAndName(typeReference, nameReference);
            }
            case BEAN_MANAGER_ASSUME_CLASS_NAME: {
                return this.beanManagerBeanProvider.forType(this.toClass(typeReference, nameReference));
            }
            case REFLECTION: {
                return this.retrieveUsingConstructor(this.toClass(typeReference, nameReference));
            }
        }
        throw this.unknownBeanSource(source);
    }

    public <T> Class<? extends T> toClass(Class<T> typeReference, String nameReference) {
        try {
            return ClassLoaderHelper.classForName(typeReference, nameReference, this.classResolver);
        }
        catch (RuntimeException e) {
            throw log.unableToResolveToClassName(typeReference, nameReference, e.getMessage(), e);
        }
    }

    public <T> BeanHolder<T> retrieveUsingConstructor(Class<T> typeReference) {
        try {
            return BeanHolder.of(ClassLoaderHelper.untypedInstanceFromClass(typeReference));
        }
        catch (RuntimeException e) {
            throw log.unableToCreateBeanUsingReflection(e.getMessage(), e);
        }
    }

    private String buildFailureMessage(List<BeanSource> sources, BeanNotFoundException firstFailure, List<BeanNotFoundException> otherFailures) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.renderFailure(sources.get(0), (RuntimeException)((Object)firstFailure)));
        for (int i = 0; i < otherFailures.size(); ++i) {
            RuntimeException failure = (RuntimeException)((Object)otherFailures.get(i));
            builder.append(" ");
            builder.append(this.renderFailure(sources.get(i + 1), failure));
        }
        return builder.toString();
    }

    private String renderFailure(BeanSource source, RuntimeException failure) {
        switch (source) {
            case CONFIGURATION: {
                return log.failedToResolveBeanUsingInternalRegistry(failure.getMessage());
            }
            case BEAN_MANAGER: {
                return log.failedToResolveBeanUsingBeanManager(failure.getMessage());
            }
            case BEAN_MANAGER_ASSUME_CLASS_NAME: {
                return log.failedToResolveBeanUsingBeanManager(failure.getMessage());
            }
            case REFLECTION: {
                return log.failedToResolveBeanUsingReflection(failure.getMessage());
            }
        }
        throw this.unknownBeanSource(source);
    }

    private AssertionFailure unknownBeanSource(BeanSource source) {
        return new AssertionFailure("Unknown bean source: " + (Object)((Object)source));
    }
}

