/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.Session;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.common.spi.MultiEntityOperationExecutionReport;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.mapper.orm.automaticindexing.spi.AutomaticIndexingQueueEventSendingPlan;
import org.hibernate.search.mapper.orm.outboxpolling.avro.impl.EventPayloadSerializationUtils;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.ShardAssignment;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.Log;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexingQueueEventPayload;
import org.hibernate.search.util.common.data.impl.RangeCompatibleHashFunction;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class OutboxPollingOutboxEventSendingPlan
implements AutomaticIndexingQueueEventSendingPlan {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final RangeCompatibleHashFunction HASH_FUNCTION = ShardAssignment.HASH_FUNCTION;
    private final EntityReferenceFactory entityReferenceFactory;
    private final Session session;
    private final List<OutboxEvent> events = new ArrayList<OutboxEvent>();

    public OutboxPollingOutboxEventSendingPlan(EntityReferenceFactory entityReferenceFactory, Session session) {
        this.entityReferenceFactory = entityReferenceFactory;
        this.session = session;
    }

    public void append(String entityName, Object identifier, String serializedId, PojoIndexingQueueEventPayload payload) {
        this.events.add(new OutboxEvent(entityName, serializedId, HASH_FUNCTION.hash((CharSequence)serializedId), EventPayloadSerializationUtils.serialize(payload), identifier));
    }

    public void discard() {
        this.events.clear();
    }

    public CompletableFuture<MultiEntityOperationExecutionReport> sendAndReport(OperationSubmitter operationSubmitter) {
        if (!OperationSubmitter.blocking().equals(operationSubmitter)) {
            throw log.nonblockingOperationSubmitterNotSupported();
        }
        if (this.session.isOpen()) {
            return this.sendAndReportOnSession(this.session, this.entityReferenceFactory);
        }
        try (Session temporarySession = this.session.sessionWithOptions().connection().autoClose(false).connectionHandlingMode(PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION).openSession();){
            CompletableFuture<MultiEntityOperationExecutionReport> completableFuture = this.sendAndReportOnSession(temporarySession, this.entityReferenceFactory);
            return completableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<MultiEntityOperationExecutionReport> sendAndReportOnSession(Session currentSession, EntityReferenceFactory entityReferenceFactory) {
        try {
            MultiEntityOperationExecutionReport.Builder builder = MultiEntityOperationExecutionReport.builder();
            for (OutboxEvent event : this.events) {
                try {
                    currentSession.persist((Object)event);
                }
                catch (RuntimeException e) {
                    builder.throwable((Throwable)e);
                    builder.failingEntityReference(entityReferenceFactory, event.getEntityName(), event.getOriginalEntityId());
                }
            }
            currentSession.flush();
            log.tracef("Persisted %d outbox events: '%s'", this.events.size(), this.events);
            CompletableFuture<MultiEntityOperationExecutionReport> completableFuture = CompletableFuture.completedFuture(builder.build());
            return completableFuture;
        }
        finally {
            this.events.clear();
        }
    }
}

