/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.regexp;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ES6Iterator;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.regexp.NativeRegExp;

public final class NativeRegExpStringIterator
extends ES6Iterator {
    private static final long serialVersionUID = 1L;
    private static final String ITERATOR_TAG = "RegExpStringIterator";
    private Scriptable regexp;
    private String string;
    private boolean global;
    private boolean fullUnicode;
    private boolean nextDone;
    private Object next = null;

    public static void init(ScriptableObject scope, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeRegExpStringIterator(), ITERATOR_TAG);
    }

    private NativeRegExpStringIterator() {
    }

    public NativeRegExpStringIterator(Scriptable scope, Scriptable regexp, String string, boolean global, boolean fullUnicode) {
        super(scope, ITERATOR_TAG);
        this.regexp = regexp;
        this.string = string;
        this.global = global;
        this.fullUnicode = fullUnicode;
        this.nextDone = false;
    }

    @Override
    public String getClassName() {
        return "RegExp String Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        if (this.nextDone) {
            return true;
        }
        this.next = NativeRegExp.regExpExec(this.regexp, this.string, cx, scope);
        if (this.next == null) {
            this.next = Undefined.instance;
            this.nextDone = true;
            return true;
        }
        if (!this.global) {
            this.nextDone = true;
            return false;
        }
        String matchStr = ScriptRuntime.toString(ScriptRuntime.getObjectIndex(this.next, 0.0, cx, scope));
        if (matchStr.isEmpty()) {
            long thisIndex = ScriptRuntime.toLength(ScriptRuntime.getObjectProp(this.regexp, "lastIndex", cx));
            long nextIndex = ScriptRuntime.advanceStringIndex(this.string, thisIndex, this.fullUnicode);
            ScriptRuntime.setObjectProp(this.regexp, "lastIndex", (Object)nextIndex, cx);
        }
        return false;
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        return this.next;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }
}

