/* -*- Mode: java; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package org.htmlunit.corejs.javascript;

/**
 * A Symbol is a JavaScript object that obeys the special properties of the Symbol prototype. This
 * interface lets us possibly support multiple implementations of Symbol.
 *
 * @since 1.7.8
 */
public interface Symbol {
    /**
     * Returns the symbol's name. Returns empty string for anonymous symbol (i.e. something created
     * with <code>Symbol()</code>).
     */
    String getName();
}
