/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.io.Serializable;
import java.util.Locale;
import org.htmlunit.cssparser.dom.CSSValueImpl;
import org.htmlunit.cssparser.parser.LexicalUnit;
import org.w3c.dom.DOMException;

public class RGBColorImpl
implements Serializable {
    private final String function_;
    private CSSValueImpl red_;
    private CSSValueImpl green_;
    private CSSValueImpl blue_;
    private CSSValueImpl alpha_;
    private final boolean commaSeparated_;

    public RGBColorImpl(String function, LexicalUnit lu) throws DOMException {
        if (function == null) {
            throw new DOMException(12, "Color space rgb or rgba is required.");
        }
        String functionLC = function.toLowerCase(Locale.ROOT);
        if (!"rgb".equals(functionLC) && !"rgba".equals(functionLC)) {
            throw new DOMException(12, "Color space '" + functionLC + "' not supported.");
        }
        this.function_ = functionLC;
        LexicalUnit next = lu;
        boolean percentage = LexicalUnit.LexicalUnitType.PERCENTAGE == next.getLexicalUnitType();
        this.red_ = RGBColorImpl.getPart(next);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, this.function_ + " requires at least three values.");
        }
        boolean bl = this.commaSeparated_ = next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA;
        if (this.commaSeparated_) {
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, this.function_ + " requires at least three values.");
            }
            if (percentage && LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
                throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
            }
            if (!percentage && LexicalUnit.LexicalUnitType.PERCENTAGE == next.getLexicalUnitType()) {
                throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
            }
            this.green_ = RGBColorImpl.getPart(next);
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, this.function_ + " requires at least three values.");
            }
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, this.function_ + " parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, this.function_ + "b requires at least three values.");
            }
            if (percentage && LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
                throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
            }
            if (!percentage && LexicalUnit.LexicalUnitType.PERCENTAGE == next.getLexicalUnitType()) {
                throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
            }
            this.blue_ = RGBColorImpl.getPart(next);
            if ((next = next.getNextLexicalUnit()) == null) {
                return;
            }
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, this.function_ + " parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Missing alpha value");
            }
            this.alpha_ = RGBColorImpl.getPart(next);
            if ((next = next.getNextLexicalUnit()) != null) {
                throw new DOMException(12, "Too many parameters for " + this.function_ + " function.");
            }
            return;
        }
        if (percentage && LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
            throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
        }
        if (!percentage && LexicalUnit.LexicalUnitType.PERCENTAGE == next.getLexicalUnitType()) {
            throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
        }
        this.green_ = RGBColorImpl.getPart(next);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, this.function_ + " requires at least three values.");
        }
        if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            throw new DOMException(12, this.function_ + " requires consitent separators (blank or comma).");
        }
        if (percentage && LexicalUnit.LexicalUnitType.PERCENTAGE != next.getLexicalUnitType()) {
            throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
        }
        if (!percentage && LexicalUnit.LexicalUnitType.PERCENTAGE == next.getLexicalUnitType()) {
            throw new DOMException(12, this.function_ + " mixing numbers and percentages.");
        }
        this.blue_ = RGBColorImpl.getPart(next);
        if ((next = next.getNextLexicalUnit()) == null) {
            return;
        }
        if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_SLASH) {
            throw new DOMException(12, this.function_ + " alpha value must be separated by '/'.");
        }
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, "Missing alpha value.");
        }
        this.alpha_ = RGBColorImpl.getPart(next);
        if ((next = next.getNextLexicalUnit()) != null) {
            throw new DOMException(12, "Too many parameters for " + this.function_ + " function.");
        }
    }

    private static CSSValueImpl getPart(LexicalUnit next) {
        if (LexicalUnit.LexicalUnitType.PERCENTAGE == next.getLexicalUnitType() || LexicalUnit.LexicalUnitType.INTEGER == next.getLexicalUnitType() || LexicalUnit.LexicalUnitType.REAL == next.getLexicalUnitType()) {
            return new CSSValueImpl(next, true);
        }
        throw new DOMException(12, "Color part has to be numeric or percentage.");
    }

    public CSSValueImpl getRed() {
        return this.red_;
    }

    public void setRed(CSSValueImpl red) {
        this.red_ = red;
    }

    public CSSValueImpl getGreen() {
        return this.green_;
    }

    public void setGreen(CSSValueImpl green) {
        this.green_ = green;
    }

    public CSSValueImpl getBlue() {
        return this.blue_;
    }

    public void setBlue(CSSValueImpl blue) {
        this.blue_ = blue;
    }

    public CSSValueImpl getAlpha() {
        return this.alpha_;
    }

    public void setAlpha(CSSValueImpl alpha) {
        this.alpha_ = alpha;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.function_).append("(").append(this.red_);
        if (this.commaSeparated_) {
            sb.append(", ").append(this.green_).append(", ").append(this.blue_);
            if (null != this.alpha_) {
                sb.append(", ").append(this.alpha_);
            }
        } else {
            sb.append(" ").append(this.green_).append(" ").append(this.blue_);
            if (null != this.alpha_) {
                sb.append(" / ").append(this.alpha_);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

