/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.CustomJellyContext;
import org.kohsuke.stapler.jelly.CustomTagLibrary;
import org.kohsuke.stapler.jelly.StaplerTagLibrary;
import org.kohsuke.stapler.jelly.ThisTagLibrary;

public class JellyClassLoaderTearOff {
    private final MetaClassLoader owner;
    private volatile WeakReference<Map<String, TagLibrary>> taglibs;
    public static ExpressionFactory EXPRESSION_FACTORY = new JexlExpressionFactory();
    private static final JellyContext ROOT_CONTEXT = new CustomJellyContext();
    private static final TagLibrary NO_SUCH_TAGLIBRARY = new TagLibrary(){};

    public JellyClassLoaderTearOff(MetaClassLoader owner) {
        this.owner = owner;
    }

    public TagLibrary getTagLibrary(String nsUri) {
        TagLibrary tl;
        Map m = null;
        if (this.taglibs != null) {
            m = (Map)this.taglibs.get();
        }
        if (m == null) {
            m = new MapMaker().makeComputingMap((Function)new Function<String, TagLibrary>(){

                public TagLibrary apply(String nsUri) {
                    TagLibrary tl;
                    if (((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.parent != null && (tl = ((JellyClassLoaderTearOff)((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.parent.loadTearOff(JellyClassLoaderTearOff.class)).getTagLibrary(nsUri)) != null) {
                        return tl;
                    }
                    String taglibBasePath = JellyClassLoaderTearOff.this.trimHeadSlash(nsUri);
                    try {
                        URL res = ((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.loader.getResource(taglibBasePath + "/taglib");
                        if (res != null) {
                            return new CustomTagLibrary(JellyClassLoaderTearOff.this.createContext(), ((JellyClassLoaderTearOff)JellyClassLoaderTearOff.this).owner.loader, nsUri, taglibBasePath);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    if (nsUri.startsWith("this:")) {
                        try {
                            return new ThisTagLibrary(EXPRESSION_FACTORY.createExpression(nsUri.substring(5)));
                        }
                        catch (JellyException e) {
                            throw new IllegalArgumentException("Illegal expression in the URI: " + nsUri, e);
                        }
                    }
                    if (nsUri.equals("jelly:stapler")) {
                        return new StaplerTagLibrary();
                    }
                    return NO_SUCH_TAGLIBRARY;
                }
            });
            this.taglibs = new WeakReference<Map>(m);
        }
        if ((tl = (TagLibrary)m.get(nsUri)) == NO_SUCH_TAGLIBRARY) {
            return null;
        }
        return tl;
    }

    private String trimHeadSlash(String nsUri) {
        if (nsUri.startsWith("/")) {
            return nsUri.substring(1);
        }
        return nsUri;
    }

    public JellyContext createContext() {
        CustomJellyContext context = new CustomJellyContext(ROOT_CONTEXT);
        context.setClassLoader(this.owner.loader);
        context.setExportLibraries(false);
        return context;
    }
}

