/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.util.ArrayList;
import java.util.Collection;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarLoader;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.test.SigarTestPrinter;
import org.hyperic.sigar.test.TestCpu;
import org.hyperic.sigar.test.TestCpuInfo;
import org.hyperic.sigar.test.TestFQDN;
import org.hyperic.sigar.test.TestFileInfo;
import org.hyperic.sigar.test.TestFileSystem;
import org.hyperic.sigar.test.TestInvoker;
import org.hyperic.sigar.test.TestLoadAverage;
import org.hyperic.sigar.test.TestLog;
import org.hyperic.sigar.test.TestMem;
import org.hyperic.sigar.test.TestNetIf;
import org.hyperic.sigar.test.TestNetInfo;
import org.hyperic.sigar.test.TestNetRoute;
import org.hyperic.sigar.test.TestNetStat;
import org.hyperic.sigar.test.TestNetStatPort;
import org.hyperic.sigar.test.TestNfsClientV2;
import org.hyperic.sigar.test.TestNfsClientV3;
import org.hyperic.sigar.test.TestNfsServerV2;
import org.hyperic.sigar.test.TestNfsServerV3;
import org.hyperic.sigar.test.TestPTQL;
import org.hyperic.sigar.test.TestProcArgs;
import org.hyperic.sigar.test.TestProcEnv;
import org.hyperic.sigar.test.TestProcExe;
import org.hyperic.sigar.test.TestProcFd;
import org.hyperic.sigar.test.TestProcList;
import org.hyperic.sigar.test.TestProcMem;
import org.hyperic.sigar.test.TestProcModules;
import org.hyperic.sigar.test.TestProcStat;
import org.hyperic.sigar.test.TestProcState;
import org.hyperic.sigar.test.TestProcTime;
import org.hyperic.sigar.test.TestResourceLimit;
import org.hyperic.sigar.test.TestSignal;
import org.hyperic.sigar.test.TestSwap;
import org.hyperic.sigar.test.TestTcpStat;
import org.hyperic.sigar.test.TestThreadCpu;
import org.hyperic.sigar.test.TestUptime;
import org.hyperic.sigar.test.TestVMware;
import org.hyperic.sigar.test.TestWho;
import org.hyperic.sigar.win32.test.TestEventLog;
import org.hyperic.sigar.win32.test.TestFileVersion;
import org.hyperic.sigar.win32.test.TestLocaleInfo;
import org.hyperic.sigar.win32.test.TestMetaBase;
import org.hyperic.sigar.win32.test.TestPdh;
import org.hyperic.sigar.win32.test.TestRegistryKey;
import org.hyperic.sigar.win32.test.TestService;

public class SigarTestRunner
extends SigarCommandBase {
    private Collection completions;
    private static final Class[] TESTS;
    private static final Class[] ALL_TESTS;
    private static final Class[] WIN32_TESTS;

    public SigarTestRunner(Shell shell) {
        super(shell);
        this.completions = new ArrayList();
        for (int i = 0; i < TESTS.length; ++i) {
            String name = TESTS[i].getName();
            int ix = name.lastIndexOf(".Test");
            this.completions.add(name.substring(ix + 5));
        }
    }

    public SigarTestRunner() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getSyntaxArgs() {
        return "[testclass]";
    }

    public String getUsageShort() {
        return "Run sigar tests";
    }

    public Collection getCompletions() {
        return this.completions;
    }

    public void output(String[] args) throws SigarException {
        SigarTestPrinter.runTests(TESTS, args);
    }

    public static void main(String[] args) throws Exception {
        new SigarTestRunner().processCommand(args);
    }

    static {
        ALL_TESTS = new Class[]{TestLog.class, TestInvoker.class, TestPTQL.class, TestCpu.class, TestCpuInfo.class, TestFileInfo.class, TestFileSystem.class, TestFQDN.class, TestLoadAverage.class, TestMem.class, TestNetIf.class, TestNetInfo.class, TestNetRoute.class, TestNetStat.class, TestNetStatPort.class, TestTcpStat.class, TestNfsClientV2.class, TestNfsServerV2.class, TestNfsClientV3.class, TestNfsServerV3.class, TestProcArgs.class, TestProcEnv.class, TestProcExe.class, TestProcModules.class, TestProcFd.class, TestProcList.class, TestProcMem.class, TestProcState.class, TestProcStat.class, TestProcTime.class, TestResourceLimit.class, TestSignal.class, TestSwap.class, TestThreadCpu.class, TestUptime.class, TestVMware.class, TestWho.class};
        WIN32_TESTS = new Class[]{TestEventLog.class, TestLocaleInfo.class, TestPdh.class, TestMetaBase.class, TestRegistryKey.class, TestService.class, TestFileVersion.class};
        if (SigarLoader.IS_WIN32) {
            TESTS = new Class[ALL_TESTS.length + WIN32_TESTS.length];
            System.arraycopy(ALL_TESTS, 0, TESTS, 0, ALL_TESTS.length);
            System.arraycopy(WIN32_TESTS, 0, TESTS, ALL_TESTS.length, WIN32_TESTS.length);
        } else {
            TESTS = ALL_TESTS;
        }
    }
}

