/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Executor;
import org.apache.tools.ant.PathTokenizer;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.loader.AntClassLoader2;
import org.apache.tools.ant.types.Description;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.StringUtils;

public class Project {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String name;
    private String description;
    private Hashtable references = new AntRefTable(this);
    private String defaultTarget;
    private Hashtable targets = new Hashtable();
    private FilterSet globalFilterSet = new FilterSet();
    private FilterSetCollection globalFilters;
    private File baseDir;
    private Vector listeners;
    private ClassLoader coreLoader;
    private Hashtable threadTasks;
    private Hashtable threadGroupTasks;
    private InputHandler inputHandler;
    private InputStream defaultInputStream;
    private boolean keepGoingMode;
    private boolean loggingMessage;
    static /* synthetic */ Class class$org$apache$tools$ant$Task;
    static /* synthetic */ Class class$org$apache$tools$ant$helper$DefaultExecutor;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    public void setInputHandler(InputHandler handler) {
        this.inputHandler = handler;
    }

    public void setDefaultInputStream(InputStream defaultInputStream) {
        this.defaultInputStream = defaultInputStream;
    }

    public InputStream getDefaultInputStream() {
        return this.defaultInputStream;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public Project() {
        this.globalFilterSet.setProject(this);
        this.globalFilters = new FilterSetCollection(this.globalFilterSet);
        this.listeners = new Vector();
        this.coreLoader = null;
        this.threadTasks = new Hashtable();
        this.threadGroupTasks = new Hashtable();
        this.inputHandler = null;
        this.defaultInputStream = null;
        this.keepGoingMode = false;
        this.loggingMessage = false;
        this.inputHandler = new DefaultInputHandler();
    }

    public void initSubProject(Project subProject) {
        ComponentHelper.getComponentHelper((Project)subProject).initSubProject(ComponentHelper.getComponentHelper((Project)this));
        subProject.setKeepGoingMode(this.isKeepGoingMode());
        subProject.setExecutor(this.getExecutor().getSubProjectExecutor());
    }

    public void init() throws BuildException {
        this.setJavaVersionProperty();
        ComponentHelper.getComponentHelper((Project)this).initDefaultDefinitions();
        this.setSystemProperties();
    }

    public AntClassLoader createClassLoader(Path path) {
        AntClassLoader2 loader = new AntClassLoader2();
        loader.setProject(this);
        loader.setClassPath(path);
        return loader;
    }

    public void setCoreLoader(ClassLoader coreLoader) {
        this.coreLoader = coreLoader;
    }

    public ClassLoader getCoreLoader() {
        return this.coreLoader;
    }

    public synchronized void addBuildListener(BuildListener listener) {
        Vector newListeners = this.getBuildListeners();
        newListeners.addElement(listener);
        this.listeners = newListeners;
    }

    public synchronized void removeBuildListener(BuildListener listener) {
        Vector newListeners = this.getBuildListeners();
        newListeners.removeElement(listener);
        this.listeners = newListeners;
    }

    public Vector getBuildListeners() {
        return (Vector)this.listeners.clone();
    }

    public void log(String message) {
        this.log(message, 2);
    }

    public void log(String message, int msgLevel) {
        this.fireMessageLogged(this, message, msgLevel);
    }

    public void log(Task task, String message, int msgLevel) {
        this.fireMessageLogged(task, message, msgLevel);
    }

    public void log(Target target, String message, int msgLevel) {
        this.fireMessageLogged(target, message, msgLevel);
    }

    public FilterSet getGlobalFilterSet() {
        return this.globalFilterSet;
    }

    public void setProperty(String name, String value) {
        PropertyHelper.getPropertyHelper((Project)this).setProperty(null, name, (Object)value, true);
    }

    public void setNewProperty(String name, String value) {
        PropertyHelper.getPropertyHelper((Project)this).setNewProperty(null, name, (Object)value);
    }

    public void setUserProperty(String name, String value) {
        PropertyHelper.getPropertyHelper((Project)this).setUserProperty(null, name, (Object)value);
    }

    public void setInheritedProperty(String name, String value) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        ph.setInheritedProperty(null, name, (Object)value);
    }

    private void setPropertyInternal(String name, String value) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        ph.setProperty(null, name, (Object)value, false);
    }

    public String getProperty(String name) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        return (String)ph.getProperty(null, name);
    }

    public String replaceProperties(String value) throws BuildException {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        return ph.replaceProperties(null, value, null);
    }

    public String getUserProperty(String name) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        return (String)ph.getUserProperty(null, name);
    }

    public Hashtable getProperties() {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        return ph.getProperties();
    }

    public Hashtable getUserProperties() {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        return ph.getUserProperties();
    }

    public void copyUserProperties(Project other) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        ph.copyUserProperties(other);
    }

    public void copyInheritedProperties(Project other) {
        PropertyHelper ph = PropertyHelper.getPropertyHelper((Project)this);
        ph.copyInheritedProperties(other);
    }

    public void setDefaultTarget(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefault(String defaultTarget) {
        this.defaultTarget = defaultTarget;
    }

    public void setName(String name) {
        this.setUserProperty("ant.project.name", name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Description.getDescription((Project)this);
        }
        return this.description;
    }

    public void addFilter(String token, String value) {
        if (token == null) {
            return;
        }
        this.globalFilterSet.addFilter(new FilterSet.Filter(token, value));
    }

    public Hashtable getFilters() {
        return this.globalFilterSet.getFilterHash();
    }

    public void setBasedir(String baseD) throws BuildException {
        this.setBaseDir(new File(baseD));
    }

    public void setBaseDir(File baseDir) throws BuildException {
        if (!(baseDir = FILE_UTILS.normalize(baseDir.getAbsolutePath())).exists()) {
            throw new BuildException("Basedir " + baseDir.getAbsolutePath() + " does not exist");
        }
        if (!baseDir.isDirectory()) {
            throw new BuildException("Basedir " + baseDir.getAbsolutePath() + " is not a directory");
        }
        this.baseDir = baseDir;
        this.setPropertyInternal("basedir", this.baseDir.getPath());
        String msg = "Project base dir set to: " + this.baseDir;
        this.log(msg, 3);
    }

    public File getBaseDir() {
        block2: {
            if (this.baseDir != null) break block2;
            try {
                this.setBasedir(".");
            }
            catch (BuildException ex) {
                ex.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public void setKeepGoingMode(boolean keepGoingMode) {
        this.keepGoingMode = keepGoingMode;
    }

    public boolean isKeepGoingMode() {
        return this.keepGoingMode;
    }

    public static String getJavaVersion() {
        return JavaEnvUtils.getJavaVersion();
    }

    public void setJavaVersionProperty() throws BuildException {
        String javaVersion = JavaEnvUtils.getJavaVersion();
        this.setPropertyInternal("ant.java.version", javaVersion);
        if (JavaEnvUtils.isJavaVersion((String)JAVA_1_0)) {
            throw new BuildException("Ant cannot work on Java 1.0");
        }
        this.log("Detected Java version: " + javaVersion + " in: " + System.getProperty("java.home"), 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void setSystemProperties() {
        Properties systemP = System.getProperties();
        Enumeration<?> e = systemP.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String value = systemP.getProperty(propertyName);
            this.setPropertyInternal(propertyName, value);
        }
    }

    public void addTaskDefinition(String taskName, Class taskClass) throws BuildException {
        ComponentHelper.getComponentHelper((Project)this).addTaskDefinition(taskName, taskClass);
    }

    public void checkTaskClass(Class taskClass) throws BuildException {
        ComponentHelper.getComponentHelper((Project)this).checkTaskClass(taskClass);
        if (!Modifier.isPublic(taskClass.getModifiers())) {
            String message = taskClass + " is not public";
            this.log(message, 0);
            throw new BuildException(message);
        }
        if (Modifier.isAbstract(taskClass.getModifiers())) {
            String message = taskClass + " is abstract";
            this.log(message, 0);
            throw new BuildException(message);
        }
        try {
            taskClass.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            String message = "No public no-arg constructor in " + taskClass;
            this.log(message, 0);
            throw new BuildException(message);
        }
        catch (LinkageError e) {
            String message = "Could not load " + taskClass + ": " + e;
            this.log(message, 0);
            throw new BuildException(message, e);
        }
        if (!(class$org$apache$tools$ant$Task == null ? (class$org$apache$tools$ant$Task = Project.class$("org.apache.tools.ant.Task")) : class$org$apache$tools$ant$Task).isAssignableFrom(taskClass)) {
            TaskAdapter.checkTaskClass((Class)taskClass, (Project)this);
        }
    }

    public Hashtable getTaskDefinitions() {
        return ComponentHelper.getComponentHelper((Project)this).getTaskDefinitions();
    }

    public void addDataTypeDefinition(String typeName, Class typeClass) {
        ComponentHelper.getComponentHelper((Project)this).addDataTypeDefinition(typeName, typeClass);
    }

    public Hashtable getDataTypeDefinitions() {
        return ComponentHelper.getComponentHelper((Project)this).getDataTypeDefinitions();
    }

    public void addTarget(Target target) throws BuildException {
        this.addTarget(target.getName(), target);
    }

    public void addTarget(String targetName, Target target) throws BuildException {
        if (this.targets.get(targetName) != null) {
            throw new BuildException("Duplicate target: `" + targetName + "'");
        }
        this.addOrReplaceTarget(targetName, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addOrReplaceTarget(String targetName, Target target) {
        String msg = " +Target: " + targetName;
        this.log(msg, 4);
        target.setProject(this);
        this.targets.put(targetName, target);
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Task createTask(String taskType) throws BuildException {
        return ComponentHelper.getComponentHelper((Project)this).createTask(taskType);
    }

    public Object createDataType(String typeName) throws BuildException {
        return ComponentHelper.getComponentHelper((Project)this).createDataType(typeName);
    }

    public void setExecutor(Executor e) {
        this.addReference("ant.executor", e);
    }

    public Executor getExecutor() {
        Object o = this.getReference("ant.executor");
        if (o == null) {
            String classname = this.getProperty("ant.executor.class");
            if (classname == null) {
                classname = (class$org$apache$tools$ant$helper$DefaultExecutor == null ? (class$org$apache$tools$ant$helper$DefaultExecutor = Project.class$("org.apache.tools.ant.helper.DefaultExecutor")) : class$org$apache$tools$ant$helper$DefaultExecutor).getName();
            }
            this.log("Attempting to create object of type " + classname, 4);
            try {
                o = Class.forName(classname, true, this.coreLoader).newInstance();
            }
            catch (ClassNotFoundException seaEnEfEx) {
                try {
                    o = Class.forName(classname).newInstance();
                }
                catch (Exception ex) {
                    this.log(ex.toString(), 0);
                }
            }
            catch (Exception ex) {
                this.log(ex.toString(), 0);
            }
            if (o == null) {
                throw new BuildException("Unable to obtain a Target Executor instance.");
            }
            this.setExecutor((Executor)o);
        }
        return (Executor)o;
    }

    public void executeTargets(Vector names) throws BuildException {
        this.getExecutor().executeTargets(this, names.toArray(new String[names.size()]));
    }

    public void demuxOutput(String output, boolean isWarning) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.log(output, isWarning ? 1 : 2);
        } else if (isWarning) {
            task.handleErrorOutput(output);
        } else {
            task.handleOutput(output);
        }
    }

    public int defaultInput(byte[] buffer, int offset, int length) throws IOException {
        if (this.defaultInputStream != null) {
            System.out.flush();
            return this.defaultInputStream.read(buffer, offset, length);
        }
        throw new EOFException("No input provided for project");
    }

    public int demuxInput(byte[] buffer, int offset, int length) throws IOException {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            return this.defaultInput(buffer, offset, length);
        }
        return task.handleInput(buffer, offset, length);
    }

    public void demuxFlush(String output, boolean isError) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, output, isError ? 0 : 2);
        } else if (isError) {
            task.handleErrorFlush(output);
        } else {
            task.handleFlush(output);
        }
    }

    public void executeTarget(String targetName) throws BuildException {
        if (targetName == null) {
            String msg = "No target specified";
            throw new BuildException(msg);
        }
        this.executeSortedTargets(this.topoSort(targetName, this.targets, false));
    }

    public void executeSortedTargets(Vector sortedTargets) throws BuildException {
        HashSet<String> succeededTargets = new HashSet<String>();
        BuildException buildException = null;
        Enumeration iter = sortedTargets.elements();
        while (iter.hasMoreElements()) {
            Target curtarget = (Target)iter.nextElement();
            boolean canExecute = true;
            Enumeration depIter = curtarget.getDependencies();
            while (depIter.hasMoreElements()) {
                String dependencyName = (String)depIter.nextElement();
                if (succeededTargets.contains(dependencyName)) continue;
                canExecute = false;
                this.log(curtarget, "Cannot execute '" + curtarget.getName() + "' - '" + dependencyName + "' failed or was not executed.", 0);
                break;
            }
            if (!canExecute) continue;
            Throwable thrownException = null;
            try {
                curtarget.performTasks();
                succeededTargets.add(curtarget.getName());
            }
            catch (RuntimeException ex) {
                if (!this.keepGoingMode) {
                    throw ex;
                }
                thrownException = ex;
            }
            catch (Throwable ex) {
                if (!this.keepGoingMode) {
                    throw new BuildException(ex);
                }
                thrownException = ex;
            }
            if (thrownException == null) continue;
            if (thrownException instanceof BuildException) {
                this.log(curtarget, "Target '" + curtarget.getName() + "' failed with message '" + thrownException.getMessage() + "'.", 0);
                if (buildException != null) continue;
                buildException = (BuildException)thrownException;
                continue;
            }
            this.log(curtarget, "Target '" + curtarget.getName() + "' failed with message '" + thrownException.getMessage() + "'.", 0);
            thrownException.printStackTrace(System.err);
            if (buildException != null) continue;
            buildException = new BuildException(thrownException);
        }
        if (buildException != null) {
            throw buildException;
        }
    }

    public File resolveFile(String fileName, File rootDir) {
        return FILE_UTILS.resolveFile(rootDir, fileName);
    }

    public File resolveFile(String fileName) {
        return FILE_UTILS.resolveFile(this.baseDir, fileName);
    }

    public static String translatePath(String toProcess) {
        if (toProcess == null || toProcess.length() == 0) {
            return "";
        }
        StringBuffer path = new StringBuffer(toProcess.length() + 50);
        PathTokenizer tokenizer = new PathTokenizer(toProcess);
        while (tokenizer.hasMoreTokens()) {
            String pathComponent = tokenizer.nextToken();
            pathComponent = pathComponent.replace('/', File.separatorChar);
            pathComponent = pathComponent.replace('\\', File.separatorChar);
            if (path.length() != 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(pathComponent);
        }
        return path.toString();
    }

    public void copyFile(String sourceFile, String destFile) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering, boolean overwrite) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite);
    }

    public void copyFile(String sourceFile, String destFile, boolean filtering, boolean overwrite, boolean preserveLastModified) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite, preserveLastModified);
    }

    public void copyFile(File sourceFile, File destFile) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering, boolean overwrite) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite);
    }

    public void copyFile(File sourceFile, File destFile, boolean filtering, boolean overwrite, boolean preserveLastModified) throws IOException {
        FILE_UTILS.copyFile(sourceFile, destFile, filtering ? this.globalFilters : null, overwrite, preserveLastModified);
    }

    public void setFileLastModified(File file, long time) throws BuildException {
        FILE_UTILS.setFileLastModified(file, time);
        this.log("Setting modification time for " + file, 3);
    }

    public static boolean toBoolean(String s) {
        return "on".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s);
    }

    public final Vector topoSort(String root, Hashtable targets) throws BuildException {
        return this.topoSort(new String[]{root}, targets, true);
    }

    public final Vector topoSort(String root, Hashtable targets, boolean returnAll) throws BuildException {
        return this.topoSort(new String[]{root}, targets, returnAll);
    }

    public final Vector topoSort(String[] root, Hashtable targets, boolean returnAll) throws BuildException {
        Vector ret = new Vector();
        Hashtable state = new Hashtable();
        Stack visiting = new Stack();
        int i = 0;
        while (i < root.length) {
            String st = (String)state.get(root[i]);
            if (st == null) {
                this.tsort(root[i], targets, state, visiting, ret);
            } else if (st == VISITING) {
                throw new RuntimeException("Unexpected node in visiting state: " + root[i]);
            }
            ++i;
        }
        StringBuffer buf = new StringBuffer("Build sequence for target(s)");
        int j = 0;
        while (j < root.length) {
            buf.append(j == 0 ? " `" : ", `").append(root[j]).append('\'');
            ++j;
        }
        buf.append(" is " + ret);
        this.log(buf.toString(), 3);
        Vector complete = returnAll ? ret : new Vector(ret);
        Enumeration en = targets.keys();
        while (en.hasMoreElements()) {
            String curTarget = (String)en.nextElement();
            String st = (String)state.get(curTarget);
            if (st == null) {
                this.tsort(curTarget, targets, state, visiting, complete);
                continue;
            }
            if (st != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + curTarget);
        }
        this.log("Complete build sequence is " + complete, 3);
        return ret;
    }

    private void tsort(String root, Hashtable targets, Hashtable state, Stack visiting, Vector ret) throws BuildException {
        state.put(root, VISITING);
        visiting.push(root);
        Target target = (Target)targets.get(root);
        if (target == null) {
            StringBuffer sb = new StringBuffer("Target `");
            sb.append(root);
            sb.append("' does not exist in this project. ");
            visiting.pop();
            if (!visiting.empty()) {
                String parent = (String)visiting.peek();
                sb.append("It is used from target `");
                sb.append(parent);
                sb.append("'.");
            }
            throw new BuildException(new String(sb));
        }
        Enumeration en = target.getDependencies();
        while (en.hasMoreElements()) {
            String cur = (String)en.nextElement();
            String m = (String)state.get(cur);
            if (m == null) {
                this.tsort(cur, targets, state, visiting, ret);
                continue;
            }
            if (m != VISITING) continue;
            throw Project.makeCircularException(cur, visiting);
        }
        String p = (String)visiting.pop();
        if (root != p) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + root + " but got " + p);
        }
        state.put(root, VISITED);
        ret.addElement(target);
    }

    private static BuildException makeCircularException(String end, Stack stk) {
        String c;
        StringBuffer sb = new StringBuffer("Circular dependency: ");
        sb.append(end);
        do {
            c = (String)stk.pop();
            sb.append(" <- ");
            sb.append(c);
        } while (!c.equals(end));
        return new BuildException(new String(sb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(String name, Object value) {
        Hashtable hashtable = this.references;
        synchronized (hashtable) {
            Object old = ((AntRefTable)this.references).getReal((Object)name);
            if (old == value) {
                return;
            }
            if (old != null && !(old instanceof UnknownElement)) {
                this.log("Overriding previous definition of reference to " + name, 1);
            }
            this.log("Adding reference: " + name, 4);
            this.references.put(name, value);
        }
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Object getReference(String key) {
        return this.references.get(key);
    }

    public String getElementName(Object element) {
        return ComponentHelper.getComponentHelper((Project)this).getElementName(element);
    }

    public void fireBuildStarted() {
        BuildEvent event = new BuildEvent(this);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            BuildListener listener = (BuildListener)iter.next();
            listener.buildStarted(event);
        }
    }

    public void fireBuildFinished(Throwable exception) {
        BuildEvent event = new BuildEvent(this);
        event.setException(exception);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            BuildListener listener = (BuildListener)iter.next();
            listener.buildFinished(event);
        }
    }

    public void fireSubBuildStarted() {
        BuildEvent event = new BuildEvent(this);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object listener = iter.next();
            if (!(listener instanceof SubBuildListener)) continue;
            ((SubBuildListener)listener).subBuildStarted(event);
        }
    }

    public void fireSubBuildFinished(Throwable exception) {
        BuildEvent event = new BuildEvent(this);
        event.setException(exception);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Object listener = iter.next();
            if (!(listener instanceof SubBuildListener)) continue;
            ((SubBuildListener)listener).subBuildFinished(event);
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent event = new BuildEvent(target);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            BuildListener listener = (BuildListener)iter.next();
            listener.targetStarted(event);
        }
    }

    protected void fireTargetFinished(Target target, Throwable exception) {
        BuildEvent event = new BuildEvent(target);
        event.setException(exception);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            BuildListener listener = (BuildListener)iter.next();
            listener.targetFinished(event);
        }
    }

    protected void fireTaskStarted(Task task) {
        this.registerThreadTask(Thread.currentThread(), task);
        BuildEvent event = new BuildEvent(task);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            BuildListener listener = (BuildListener)iter.next();
            listener.taskStarted(event);
        }
    }

    protected void fireTaskFinished(Task task, Throwable exception) {
        this.registerThreadTask(Thread.currentThread(), null);
        System.out.flush();
        System.err.flush();
        BuildEvent event = new BuildEvent(task);
        event.setException(exception);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            BuildListener listener = (BuildListener)iter.next();
            listener.taskFinished(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageLoggedEvent(BuildEvent event, String message, int priority) {
        if (message.endsWith(StringUtils.LINE_SEP)) {
            int endIndex = message.length() - StringUtils.LINE_SEP.length();
            event.setMessage(message.substring(0, endIndex), priority);
        } else {
            event.setMessage(message, priority);
        }
        Project project = this;
        synchronized (project) {
            if (this.loggingMessage) {
                return;
            }
            try {
                this.loggingMessage = true;
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    BuildListener listener = (BuildListener)iter.next();
                    listener.messageLogged(event);
                }
                Object var8_8 = null;
                this.loggingMessage = false;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.loggingMessage = false;
                throw throwable;
            }
        }
    }

    protected void fireMessageLogged(Project project, String message, int priority) {
        BuildEvent event = new BuildEvent(project);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Target target, String message, int priority) {
        BuildEvent event = new BuildEvent(target);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    protected void fireMessageLogged(Task task, String message, int priority) {
        BuildEvent event = new BuildEvent(task);
        this.fireMessageLoggedEvent(event, message, priority);
    }

    public synchronized void registerThreadTask(Thread thread, Task task) {
        if (task != null) {
            this.threadTasks.put(thread, task);
            this.threadGroupTasks.put(thread.getThreadGroup(), task);
        } else {
            this.threadTasks.remove(thread);
            this.threadGroupTasks.remove(thread.getThreadGroup());
        }
    }

    public Task getThreadTask(Thread thread) {
        Task task = (Task)this.threadTasks.get(thread);
        if (task == null) {
            ThreadGroup group = thread.getThreadGroup();
            while (task == null && group != null) {
                task = (Task)this.threadGroupTasks.get(group);
                group = group.getParent();
            }
        }
        return task;
    }

    public final void setProjectReference(Object obj) {
        if (obj instanceof ProjectComponent) {
            ((ProjectComponent)obj).setProject(this);
            return;
        }
        try {
            Method method = obj.getClass().getMethod("setProject", class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = Project.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
            if (method != null) {
                method.invoke(obj, this);
            }
        }
        catch (Throwable e) {}
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

