/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.animation;

import java.io.IOException;
import java.util.Collection;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;
import org.icefaces.ace.component.animation.AnimationBehavior;
import org.icefaces.ace.component.animation.AnimationBehaviorHandlerBase;
import org.icefaces.ace.component.animation.Effect;

public class AnimationBehaviorHandler
extends AnimationBehaviorHandlerBase {
    public AnimationBehaviorHandler(BehaviorConfig config) {
        super(config);
    }

    private void setAttribute(FaceletContext context, TagAttribute tagAttribute, AnimationBehavior behavior, Class type) {
        if (tagAttribute != null) {
            behavior.setValueExpression(tagAttribute.getLocalName(), tagAttribute.getValueExpression(context, type));
        }
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (!(parent instanceof ClientBehaviorHolder)) {
            throw new TagException(this.tag, "Effect behavior can not be attach to non clientBehaviorHolder parent");
        }
        ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)parent;
        String eventName = this.getEventName();
        if (eventName == null) {
            eventName = clientBehaviorHolder.getDefaultEventName();
            if (eventName == null) {
                throw new TagException(this.tag, "Event attribute could not be determined " + eventName);
            }
        } else {
            Collection eventNames = clientBehaviorHolder.getEventNames();
            if (!eventNames.contains(eventName)) {
                throw new TagException(this.tag, "Event is not supported by this component " + clientBehaviorHolder.getClass().getSimpleName());
            }
        }
        AnimationBehavior effectBehavior = this.createEffectBehavior(context, eventName);
        clientBehaviorHolder.addClientBehavior(eventName, (ClientBehavior)effectBehavior);
    }

    private AnimationBehavior createEffectBehavior(FaceletContext context, String eventName) {
        Application application = context.getFacesContext().getApplication();
        AnimationBehavior effectBehavior = (AnimationBehavior)application.createBehavior("org.icefaces.ace.animation.Animation");
        this.setAttribute(context, this.run, effectBehavior, Boolean.class);
        this.setAttribute(context, this.effectObject, effectBehavior, Effect.class);
        this.setAttribute(context, this.name, effectBehavior, String.class);
        this.setAttribute(context, this.to, effectBehavior, String.class);
        this.setAttribute(context, this.from, effectBehavior, String.class);
        this.setAttribute(context, this.easing, effectBehavior, String.class);
        this.setAttribute(context, this.iterations, effectBehavior, Integer.class);
        this.setAttribute(context, this.duration, effectBehavior, Double.class);
        return effectBehavior;
    }
}

