/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.checkboxbutton;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.icefaces.ace.component.checkboxbutton.CheckboxButton;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.HTML;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.ScriptWriter;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(tagName="checkboxButton", value="org.icefaces.ace.component.checkboxbutton.CheckboxButton")
public class CheckboxButtonRenderer
extends CoreRenderer {
    List<UIParameter> uiParamChildren;

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        CheckboxButton checkbox = (CheckboxButton)uiComponent;
        String source = String.valueOf(requestParameterMap.get("ice.event.captured"));
        String clientId = uiComponent.getClientId();
        String hiddenValue = String.valueOf(requestParameterMap.get(clientId + "_hidden"));
        if (null == hiddenValue || hiddenValue.equals("null")) {
            return;
        }
        boolean submittedValue = this.isChecked(hiddenValue);
        checkbox.setSubmittedValue(submittedValue);
        this.decodeBehaviors(facesContext, (UIComponent)checkbox);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        CheckboxButton checkbox = (CheckboxButton)uiComponent;
        this.uiParamChildren = Utils.captureParameters((UIComponent)checkbox);
        writer.startElement("div", uiComponent);
        writer.writeAttribute("id", (Object)clientId, null);
        String styleClass = checkbox.getStyleClass();
        String styleClassVal = "";
        if (styleClass != null && styleClass.trim().length() > 0) {
            styleClassVal = " " + styleClass;
        }
        writer.writeAttribute("class", (Object)("ice-checkboxbutton" + styleClassVal), null);
        String style = checkbox.getStyle();
        if (style != null && style.trim().length() > 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)(clientId + "_span"), null);
        String yuiBaseClass = "yui-button yui-checkboxbutton-button ui-button ui-widget ui-state-default";
        writer.writeAttribute("class", (Object)yuiBaseClass, null);
        writer.startElement("span", uiComponent);
        writer.writeAttribute("class", (Object)"first-child", null);
        writer.writeAttribute("id", (Object)(clientId + "_s2"), null);
        String label = this.findCheckboxLabel(checkbox);
        writer.startElement("button", uiComponent);
        this.renderPassThruAttributes(facesContext, (UIComponent)checkbox, HTML.BUTTON_ATTRS, new String[]{"style"});
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("name", (Object)(clientId + "_button"), null);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        CheckboxButton checkbox = (CheckboxButton)uiComponent;
        String label = this.findCheckboxLabel(checkbox);
        Object val = checkbox.getValue();
        writer.endElement("button");
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("input", uiComponent);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("id", (Object)(clientId + "_hidden"), null);
        writer.writeAttribute("value", val, null);
        writer.endElement("input");
        String boxValue = String.valueOf(val);
        boolean isChecked = this.isChecked(boxValue);
        StringBuilder sb = new StringBuilder();
        sb.append(checkbox.getStyle()).append(checkbox.getStyleClass());
        boolean ariaEnabled = EnvUtils.isAriaEnabled((FacesContext)facesContext);
        Integer tabindex = checkbox.getTabindex();
        if (ariaEnabled && tabindex == null) {
            tabindex = 0;
        }
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.checkboxbutton.updateProperties").item(clientId).beginMap().entry("type", "checkbox").entry("checked", isChecked).entry("disabled", checkbox.isDisabled()).entryNonNullValue("tabindex", tabindex).entry("label", label);
        this.encodeClientBehaviors(facesContext, checkbox, jb);
        jb.endMap().beginMap().entry("hashCode", sb.toString().hashCode()).entry("ariaEnabled", ariaEnabled);
        if (this.uiParamChildren != null) {
            jb.entry("postParameters", Utils.asStringArray(this.uiParamChildren));
        }
        jb.endMap().endFunction();
        String finalScript = jb.toString();
        ScriptWriter.insertScript(facesContext, uiComponent, finalScript);
        writer.endElement("div");
    }

    private String findCheckboxLabel(CheckboxButton checkbox) {
        String label = "";
        String checkLabel = checkbox.getLabel();
        if (null != checkLabel && !checkLabel.equals("")) {
            label = checkLabel;
        }
        return label;
    }

    private boolean isChecked(String hiddenValue) {
        return hiddenValue.equalsIgnoreCase("on") || hiddenValue.equalsIgnoreCase("yes") || hiddenValue.equalsIgnoreCase("true");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        if (submittedValue instanceof Boolean) {
            return submittedValue;
        }
        return Boolean.valueOf(submittedValue.toString());
    }
}

