/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.confirmationdialog;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.confirmationdialog.ConfirmationDialog;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="confirmationDialog", value="org.icefaces.ace.component.confirmationdialog.ConfirmationDialog")
public class ConfirmationDialogRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ConfirmationDialog dialog = (ConfirmationDialog)component;
        this.encodeMarkup(context, dialog);
        this.encodeScript(context, dialog);
    }

    protected void encodeMarkup(FacesContext context, ConfirmationDialog dialog) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId(context);
        String messageText = dialog.getMessage();
        UIComponent messageFacet = dialog.getFacet("message");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String header = dialog.getHeader();
        if (header != null) {
            writer.writeAttribute("title", (Object)header, null);
        }
        writer.startElement("p", null);
        writer.startElement("span", null);
        writer.writeAttribute("style", (Object)"float: left; margin: 0pt 7px 20px 0pt;", null);
        writer.writeAttribute("class", (Object)("ui-icon ui-icon-" + dialog.getSeverity()), null);
        writer.endElement("span");
        if (messageFacet != null) {
            messageFacet.encodeAll(context);
        } else if (messageText != null) {
            writer.write(messageText);
        }
        writer.endElement("p");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_buttons"), null);
        this.renderChildren(context, (UIComponent)dialog);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ConfirmationDialog dialog) throws IOException {
        String position;
        String hideEffect;
        String showEffect;
        int zIndex;
        int height;
        int width;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dialog.getClientId();
        writer.startElement("script", (UIComponent)dialog);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSONBuilder jb = JSONBuilder.create();
        writer.write(this.resolveWidgetVar((UIComponent)dialog) + " = new ");
        jb.beginFunction("ice.ace.ConfirmDialog").item(clientId).beginMap().entry("minHeight", 0);
        String styleClass = dialog.getStyleClass();
        if (styleClass != null) {
            jb.entry("dialogClass", styleClass);
        }
        if ((width = dialog.getWidth()) != 300) {
            jb.entry("width", width);
        }
        if ((height = dialog.getHeight()) != Integer.MIN_VALUE) {
            jb.entry("height", height);
        }
        if (!dialog.isDraggable()) {
            jb.entry("draggable", false);
        }
        if (dialog.isModal()) {
            jb.entry("modal", true);
        }
        if ((zIndex = dialog.getZindex()) != 1000) {
            jb.entry("zIndex", zIndex);
        }
        if ((showEffect = dialog.getShowEffect()) != null) {
            jb.entry("show", showEffect);
        }
        if ((hideEffect = dialog.getHideEffect()) != null) {
            jb.entry("hide", hideEffect);
        }
        if (!dialog.isCloseOnEscape()) {
            jb.entry("closeOnEscape", false);
        }
        if (!dialog.isClosable()) {
            jb.entry("closable", false);
        }
        if ((position = dialog.getPosition()) != null) {
            if (position.contains(",")) {
                jb.entry("position", "[" + position + "]", true);
            } else {
                jb.entry("position", position);
            }
        }
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

