/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dataexporter;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.icefaces.ace.component.dataexporter.DataExporter;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="dataExporter", value="org.icefaces.ace.component.dataexporter.DataExporter")
public class DataExporterRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String source;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        DataExporter exporter = (DataExporter)component;
        String clientId = exporter.getClientId(facesContext);
        if (requestParameterMap.containsKey("ice.event.captured") && clientId.equals(source = String.valueOf(requestParameterMap.get("ice.event.captured")))) {
            exporter.setSource(clientId);
            exporter.queueEvent((FacesEvent)new ActionEvent((UIComponent)exporter){
                {
                    this.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
            });
        }
        this.decodeBehaviors(facesContext, (UIComponent)exporter);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String style;
        ResponseWriter writer = facesContext.getResponseWriter();
        DataExporter exporter = (DataExporter)component;
        String clientId = exporter.getClientId(facesContext);
        writer.startElement("button", null);
        writer.writeAttribute("id", (Object)clientId, null);
        StringBuilder onclick = new StringBuilder("new ice.ace.DataExporter('" + clientId + "',");
        onclick.append(" function() { ");
        Map behaviorEvents = exporter.getClientBehaviors();
        if (!behaviorEvents.isEmpty()) {
            List params = Collections.emptyList();
            for (ClientBehavior behavior : (List)behaviorEvents.get("activate")) {
                ClientBehaviorContext cbc;
                String script = behavior.getScript(cbc = ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)exporter, (String)"activate", (String)clientId, params));
                if (script == null) continue;
                onclick.append(script);
                onclick.append(";");
            }
        }
        onclick.append(" });");
        onclick.append("ice.s(event,this);return false;");
        writer.writeAttribute("onclick", (Object)onclick.toString(), null);
        String styleClass = exporter.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if ((style = exporter.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        boolean hasChildren = exporter.getChildren().size() > 0;
        String label = exporter.getLabel();
        if (!hasChildren) {
            label = label == null ? "Export" : label;
            writer.startElement("span", null);
            writer.write(label);
            writer.endElement("span");
        } else if (label != null) {
            writer.startElement("span", null);
            writer.write(label);
            writer.endElement("span");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        DataExporter exporter = (DataExporter)component;
        String clientId = exporter.getClientId(facesContext);
        writer.endElement("button");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_script"), null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(ice.ace.escapeClientId('" + clientId + "')).button();");
        String path = exporter.getPath(clientId);
        if (path != null) {
            writer.write("ice.ace.DataExporters['" + clientId + "'].url('" + path + "');");
        }
        writer.endElement("script");
        writer.endElement("span");
    }
}

