/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dataexporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.Resource;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.dataexporter.Exporter;
import org.icefaces.ace.component.dataexporter.ExporterResource;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.row.Row;
import org.icefaces.application.ResourceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends Exporter {
    @Override
    public String export(FacesContext facesContext, DataTable table, String filename, boolean pageOnly, int[] excludeColumns, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, boolean includeHeaders, boolean includeFooters, boolean selectedRowsOnly) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        Sheet sheet = wb.createSheet();
        List<UIColumn> columns = this.getColumnsToExport(table, excludeColumns);
        int numberOfColumns = columns.size();
        if (preProcessor != null) {
            preProcessor.invoke(facesContext.getELContext(), new Object[]{wb});
        }
        int rowCount = table.getRowCount();
        int first = pageOnly ? table.getFirst() : 0;
        int rowsToExport = pageOnly ? first + table.getRows() : rowCount;
        rowsToExport = rowsToExport > rowCount ? rowCount : rowsToExport;
        int sheetRowIndex = 0;
        if (includeHeaders) {
            ColumnGroup columnGroup = this.getColumnGroupHeader(table);
            if (columnGroup != null) {
                List<Row> rows = this.getRows(columnGroup);
                for (Row row : rows) {
                    List<UIColumn> rowColumns = this.getRowColumnsToExport(row, table, excludeColumns);
                    this.addFacetColumns(sheet, rowColumns, Exporter.ColumnType.HEADER, sheetRowIndex++);
                }
            } else {
                sheetRowIndex = 1;
                this.addFacetColumns(sheet, columns, Exporter.ColumnType.HEADER, 0);
            }
        }
        Object originalData = null;
        if (selectedRowsOnly) {
            originalData = table.getValue();
            table.setValue(table.getStateMap().getSelected());
            first = 0;
            rowsToExport = table.getRowCount();
        }
        for (int i = first; i < rowsToExport; ++i) {
            table.setRowIndex(i);
            org.apache.poi.ss.usermodel.Row row = sheet.createRow(sheetRowIndex++);
            for (int j = 0; j < numberOfColumns; ++j) {
                this.addColumnValue(row, columns.get(j).getChildren(), j);
            }
        }
        if (selectedRowsOnly) {
            table.setValue(originalData);
        }
        if (this.hasColumnFooter(columns) && includeFooters) {
            this.addFacetColumns(sheet, columns, Exporter.ColumnType.FOOTER, sheetRowIndex++);
        }
        table.setRowIndex(-1);
        if (postProcessor != null) {
            postProcessor.invoke(facesContext.getELContext(), new Object[]{wb});
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wb.write((OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        ExporterResource resource = new ExporterResource(bytes);
        resource.setContentType("application/vnd.ms-excel");
        Map<String, String> headers = resource.getResponseHeaders();
        headers.put("Expires", "0");
        headers.put("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        headers.put("Pragma", "public");
        headers.put("Content-disposition", "attachment;filename=" + filename + ".xls");
        String path = ResourceRegistry.addSessionResource((Resource)resource);
        return path;
    }

    private void addFacetColumns(Sheet sheet, List<UIColumn> columns, Exporter.ColumnType columnType, int rowIndex) {
        org.apache.poi.ss.usermodel.Row rowHeader = sheet.createRow(rowIndex);
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn uiColumn = columns.get(i);
            UIComponent facet = uiColumn.getFacet(columnType.facet());
            if (facet != null) {
                this.addColumnValue(rowHeader, facet, i);
                continue;
            }
            String value = "";
            if (uiColumn instanceof Column) {
                Column column = (Column)uiColumn;
                if (columnType == Exporter.ColumnType.HEADER) {
                    String headerText = column.getHeaderText();
                    value = headerText != null ? headerText : "";
                } else if (columnType == Exporter.ColumnType.FOOTER) {
                    String footerText = column.getFooterText();
                    value = footerText != null ? footerText : "";
                }
            }
            Cell cell = rowHeader.createCell(i);
            cell.setCellValue((RichTextString)new HSSFRichTextString(value));
        }
    }

    private void addColumnValue(org.apache.poi.ss.usermodel.Row rowHeader, UIComponent component, int index) {
        Cell cell = rowHeader.createCell(index);
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        cell.setCellValue((RichTextString)new HSSFRichTextString(value));
    }

    private void addColumnValue(org.apache.poi.ss.usermodel.Row rowHeader, List<UIComponent> components, int index) {
        Cell cell = rowHeader.createCell(index);
        StringBuilder builder = new StringBuilder();
        for (UIComponent component : components) {
            String value;
            if (!component.isRendered() || (value = this.exportValue(FacesContext.getCurrentInstance(), component)) == null) continue;
            builder.append(value);
        }
        cell.setCellValue((RichTextString)new HSSFRichTextString(builder.toString()));
    }
}

