/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dataexporter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.excludefromexport.ExcludeFromExport;
import org.icefaces.ace.component.expansiontoggler.ExpansionToggler;
import org.icefaces.ace.component.row.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Exporter {
    public abstract String export(FacesContext var1, DataTable var2, String var3, boolean var4, int[] var5, String var6, MethodExpression var7, MethodExpression var8, boolean var9, boolean var10, boolean var11) throws IOException;

    protected List<UIColumn> getColumnsToExport(UIData table, int[] excludedColumns) {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        int columnIndex = -1;
        for (UIComponent child : table.getChildren()) {
            if (!(child instanceof UIColumn) || this.shouldExcludeFromExport(child)) continue;
            UIColumn column = (UIColumn)child;
            ++columnIndex;
            boolean hasExpansionToggler = false;
            for (UIComponent columnChild : column.getChildren()) {
                if (!(columnChild instanceof ExpansionToggler)) continue;
                hasExpansionToggler = true;
            }
            if (hasExpansionToggler || !column.isRendered() || excludedColumns != null && Arrays.binarySearch(excludedColumns, columnIndex) >= 0) continue;
            columns.add(column);
        }
        return columns;
    }

    protected ColumnGroup getColumnGroupHeader(UIData table) {
        for (UIComponent child : table.getChildren()) {
            ColumnGroup columnGroup;
            if (!(child instanceof ColumnGroup) || this.shouldExcludeFromExport(child) || (columnGroup = (ColumnGroup)child).getType() == null || !columnGroup.getType().equalsIgnoreCase("header")) continue;
            return columnGroup;
        }
        return null;
    }

    protected List<Row> getRows(ColumnGroup columnGroup) {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (UIComponent child : columnGroup.getChildren()) {
            if (!(child instanceof Row) || this.shouldExcludeFromExport(child)) continue;
            Row row = (Row)child;
            rows.add(row);
        }
        return rows;
    }

    protected List<UIColumn> getRowColumnsToExport(Row row, UIData table, int[] excludedColumns) {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        ArrayList<UIColumn> rowColumns = new ArrayList<UIColumn>();
        int columnIndex = -1;
        int rowColumnIndex = -1;
        for (UIComponent child : row.getChildren()) {
            UIColumn uiColumn;
            if (!(child instanceof UIColumn) || this.shouldExcludeFromExport(child) || !(uiColumn = (UIColumn)child).isRendered()) continue;
            if (uiColumn instanceof Column) {
                Column column = (Column)uiColumn;
                int colspan = column.getColspan();
                for (int i = 0; i < colspan; ++i) {
                    rowColumns.add(column);
                }
                continue;
            }
            rowColumns.add(uiColumn);
        }
        for (UIComponent child : table.getChildren()) {
            UIColumn rowColumn;
            if (!(child instanceof UIColumn) || this.shouldExcludeFromExport(child)) continue;
            UIColumn column = (UIColumn)child;
            ++columnIndex;
            boolean hasExpansionToggler = false;
            for (UIComponent columnChild : column.getChildren()) {
                if (!(columnChild instanceof ExpansionToggler)) continue;
                hasExpansionToggler = true;
            }
            if (hasExpansionToggler || !column.isRendered()) continue;
            ++rowColumnIndex;
            if (excludedColumns != null && Arrays.binarySearch(excludedColumns, columnIndex) >= 0) continue;
            if (rowColumnIndex < rowColumns.size() && (rowColumn = (UIColumn)rowColumns.get(rowColumnIndex)) != null) {
                columns.add(rowColumn);
                continue;
            }
            columns.add(new UIColumn());
        }
        return columns;
    }

    protected boolean hasColumnFooter(List<UIColumn> columns) {
        for (UIColumn column : columns) {
            if (column.getFooter() != null) {
                return true;
            }
            if (!(column instanceof Column) || ((Column)column).getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldExcludeFromExport(UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof ExcludeFromExport)) continue;
            return true;
        }
        return false;
    }

    protected String exportValue(FacesContext context, UIComponent component) {
        String objectReference;
        if (this.shouldExcludeFromExport(component)) {
            return "";
        }
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return null;
        }
        if (component instanceof EditableValueHolder) {
            Converter converterForType;
            Class valueType;
            EditableValueHolder editableValueHolder = (EditableValueHolder)component;
            Object value = editableValueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (editableValueHolder.getConverter() != null) {
                return editableValueHolder.getConverter().getAsString(context, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(context.getELContext())) != null && (converterForType = context.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(context, component, value);
            }
            return value.toString();
        }
        if (component instanceof ValueHolder) {
            Converter converterForType;
            Class valueType;
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(context, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(context.getELContext())) != null && (converterForType = context.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(context, component, value);
            }
            return value.toString();
        }
        String ret = "";
        String value = component.toString();
        if (value != null && !(value = value.trim()).equals(objectReference = component.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(component)))) {
            ret = value;
        }
        if (component.getChildren().size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (UIComponent child : component.getChildren()) {
                builder.append(this.exportValue(context, child));
            }
            ret = ret + builder.toString();
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }
}

