/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datatable;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UniqueIdVendor;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.faces.render.Renderer;
import javax.faces.view.Location;
import org.icefaces.ace.component.ajax.AjaxBehavior;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.datatable.DataTableBase;
import org.icefaces.ace.component.panelexpansion.PanelExpansion;
import org.icefaces.ace.component.row.Row;
import org.icefaces.ace.component.rowexpansion.RowExpansion;
import org.icefaces.ace.component.tableconfigpanel.TableConfigPanel;
import org.icefaces.ace.event.SelectEvent;
import org.icefaces.ace.event.TableFilterEvent;
import org.icefaces.ace.event.UnselectEvent;
import org.icefaces.ace.model.MultipleExpressionComparator;
import org.icefaces.ace.model.filter.ContainsFilterConstraint;
import org.icefaces.ace.model.table.LazyDataModel;
import org.icefaces.ace.model.table.RowState;
import org.icefaces.ace.model.table.RowStateMap;
import org.icefaces.ace.model.table.SortCriteria;
import org.icefaces.ace.model.table.TreeDataModel;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.collections.AllPredicate;
import org.icefaces.ace.util.collections.AnyPredicate;
import org.icefaces.ace.util.collections.Predicate;
import org.icefaces.ace.util.collections.PropertyConstraintPredicate;
import org.icefaces.util.JavaScriptRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
extends DataTableBase {
    private static Logger log = Logger.getLogger(DataTable.class.getName());
    private static Class SQL_RESULT = null;
    private Map<String, Column> filterMap;
    private TableConfigPanel panel;
    private RowStateMap stateMap;
    private DataModel model;
    private String baseClientId = null;
    private int baseClientIdLength;
    private StringBuilder clientIdBuilder = null;
    private Boolean isNested = null;

    @Override
    public RowStateMap getStateMap() {
        if (this.stateMap != null) {
            return this.stateMap;
        }
        this.stateMap = super.getStateMap();
        if (this.stateMap == null) {
            this.stateMap = new RowStateMap();
            super.setStateMap(this.stateMap);
        }
        return this.stateMap;
    }

    protected void clearCachedStateMap() {
        this.stateMap = null;
    }

    public Object getValue() {
        List filteredValue;
        Object superValue = super.getValue();
        if (superValue == null) {
            return null;
        }
        int superValueHash = superValue.hashCode();
        if (this.getValueHashCode() == null || superValueHash != this.getValueHashCode()) {
            this.setValueHashCode(superValueHash);
            this.applySorting();
            if (this.getFilteredData() != null) {
                this.applyFilters();
            }
            if (superValue != null && superValue instanceof List) {
                List list = (List)superValue;
            }
        }
        return (filteredValue = this.getFilteredData()) != null ? filteredValue : superValue;
    }

    protected DataModel getDataModel() {
        if (this.model != null) {
            return this.model;
        }
        Object current = this.getValue();
        if (current == null) {
            this.setDataModel((DataModel)new ListDataModel(Collections.EMPTY_LIST));
        } else if (current instanceof DataModel) {
            this.setDataModel((DataModel)current);
        } else if (current instanceof List) {
            List list = (List)current;
            if (list.size() > 0 && list.get(0) instanceof Map.Entry) {
                this.setDataModel(new TreeDataModel(list));
            } else {
                this.setDataModel((DataModel)new ListDataModel(list));
            }
        } else if (Object[].class.isAssignableFrom(current.getClass())) {
            this.setDataModel((DataModel)new ArrayDataModel((Object[])current));
        } else if (current instanceof ResultSet) {
            this.setDataModel((DataModel)new ResultSetDataModel((ResultSet)current));
        } else if (null != SQL_RESULT && SQL_RESULT.isInstance(current)) {
            ResultDataModel dataModel = new ResultDataModel();
            dataModel.setWrappedData(current);
            this.setDataModel((DataModel)dataModel);
        } else {
            this.setDataModel((DataModel)new ScalarDataModel(current));
        }
        return this.model;
    }

    protected void setDataModel(DataModel dataModel) {
        this.model = dataModel;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        this.setDataModel(null);
        super.broadcast(event);
        FacesContext context = FacesContext.getCurrentInstance();
        String outcome = null;
        MethodExpression me = null;
        if (event instanceof SelectEvent) {
            me = this.getRowSelectListener();
        } else if (event instanceof UnselectEvent) {
            me = this.getRowUnselectListener();
        } else if (event instanceof TableFilterEvent) {
            me = this.getFilterListener();
        }
        if (me != null) {
            outcome = (String)me.invoke(context.getELContext(), new Object[]{event});
        }
        if (outcome != null) {
            NavigationHandler navHandler = context.getApplication().getNavigationHandler();
            navHandler.handleNavigation(context, null, outcome);
            context.renderResponse();
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        this.iterate(context, PhaseId.UPDATE_MODEL_VALUES);
        this.popComponentFromEL(context);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isAlwaysExecuteContents().booleanValue() && this.isTableFeatureRequest(context)) {
            this.decode(context);
        } else {
            if (context == null) {
                throw new NullPointerException();
            }
            if (!this.isRendered()) {
                return;
            }
            this.pushComponentToEL(context, (UIComponent)this);
            this.iterate(context, PhaseId.APPLY_REQUEST_VALUES);
            this.decode(context);
            this.popComponentFromEL(context);
        }
        if (this.isFilterValueChanged().booleanValue()) {
            Map params = context.getExternalContext().getRequestParameterMap();
            this.queueEvent(new TableFilterEvent((UIComponent)this, this.getFilterMap().get(params.get(this.getClientId(context) + "_filteredColumn"))));
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, (Object)this);
        this.iterate(context, PhaseId.PROCESS_VALIDATIONS);
        app.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    public int getFirst() {
        return this.isPaginator() ? super.getFirst() : 0;
    }

    public void setRowIndex(int index) {
        Map requestMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        super.setRowIndex(index);
        if (index > -1 && this.isRowAvailable()) {
            requestMap.put(this.getRowStateVar(), this.getStateMap().get(this.getRowData()));
        }
    }

    public DataModel getModel() {
        return this.getDataModel();
    }

    public void setModel(DataModel m) {
        try {
            this.setDataModel(null);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public Boolean hasTreeDataModel() {
        return this.model instanceof TreeDataModel;
    }

    public PanelExpansion getPanelExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof PanelExpansion)) continue;
            return (PanelExpansion)kid;
        }
        return null;
    }

    public RowExpansion getRowExpansion() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof RowExpansion)) continue;
            return (RowExpansion)kid;
        }
        return null;
    }

    public List<Column> getColumns(boolean headColumns) {
        if (headColumns) {
            ArrayList<Column> columns = new ArrayList<Column>();
            for (UIComponent child : this.getColumnGroup("header").getChildren()) {
                if (!(child instanceof Row)) continue;
                for (UIComponent gchild : child.getChildren()) {
                    if (!(gchild instanceof Column)) continue;
                    columns.add((Column)gchild);
                }
            }
            return columns;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        List<Integer> columnOrdering = this.generateColumnOrdering();
        ArrayList<Column> unordered = new ArrayList<Column>();
        Stack<DataTable> childStack = new Stack<DataTable>();
        childStack.add(this);
        while (!childStack.empty()) {
            for (UIComponent child : ((UIComponent)childStack.pop()).getChildren()) {
                if (!(child instanceof ColumnGroup || child instanceof Column || child instanceof DataTable)) {
                    if (child.getChildren().size() <= 0) continue;
                    childStack.add((DataTable)child);
                    continue;
                }
                if (!(child instanceof Column)) continue;
                unordered.add((Column)child);
            }
        }
        while (columnOrdering.size() < unordered.size()) {
            columnOrdering.add(columnOrdering.size());
        }
        for (Integer i : columnOrdering) {
            if (i >= unordered.size()) continue;
            columns.add((Column)((Object)unordered.get(i)));
        }
        return columns;
    }

    public List<Column> getColumns() {
        return this.getColumns(false);
    }

    public List<Column> getHeaderColumns() {
        return null;
    }

    public void setTableConfigPanel(TableConfigPanel panel) {
        this.panel = panel;
        FacesContext c = FacesContext.getCurrentInstance();
        this.setTableConfigPanel(panel.getClientId(c));
    }

    public void resetValue() {
        this.setValue(null);
    }

    public void resetPagination() {
        this.setFirst(0);
        this.setPage(1);
    }

    public void reset() {
        this.resetValue();
        this.resetFilters();
        this.resetPagination();
    }

    public void resetSorting() {
        for (Column c : this.getColumns()) {
            c.setSortPriority(null);
            c.setSortAscending(false);
        }
        for (Column c : this.getColumns(true)) {
            c.setSortPriority(null);
            c.setSortAscending(false);
        }
    }

    public void resetFilters() {
        for (Column c : this.getColumns()) {
            c.setFilterValue("");
        }
        for (Column c : this.getColumns(true)) {
            c.setFilterValue("");
        }
        this.setFilterValue("");
        this.setFilteredData(null);
    }

    public void applySorting() {
        this.setSortOrderChanged(true);
    }

    public void applyFilters() {
        this.setFilterValueChanged(true);
    }

    @Override
    public Boolean isFilterValueChanged() {
        return this.isConstantRefilter() ? true : super.isFilterValueChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findRow(String query, String[] fields, int startRow, SearchType searchType, boolean caseSensitive) {
        int savedRowIndex = this.getRowIndex();
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        ELResolver resolver = elContext.getELResolver();
        Application app = context.getApplication();
        String rowVar = this.getVar();
        if (!caseSensitive) {
            query = query.toLowerCase();
        }
        this.setRowIndex(startRow);
        try {
            int i;
            if (searchType.equals((Object)SearchType.CONTAINS)) {
                while (this.isRowAvailable()) {
                    for (i = 0; i < fields.length; ++i) {
                        String rowFieldString = resolver.getValue(elContext, this.getRowData(), (Object)fields[i]).toString();
                        if (!caseSensitive) {
                            rowFieldString = rowFieldString.toLowerCase();
                        }
                        if (!rowFieldString.contains(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            } else if (searchType.equals((Object)SearchType.ENDS_WITH)) {
                while (this.isRowAvailable()) {
                    for (i = 0; i < fields.length; ++i) {
                        String rowFieldString = resolver.getValue(elContext, this.getRowData(), (Object)fields[i]).toString();
                        if (!caseSensitive) {
                            rowFieldString = rowFieldString.toLowerCase();
                        }
                        if (!rowFieldString.endsWith(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            } else if (searchType.equals((Object)SearchType.STARTS_WITH)) {
                while (this.isRowAvailable()) {
                    for (i = 0; i < fields.length; ++i) {
                        String rowFieldString = resolver.getValue(elContext, this.getRowData(), (Object)fields[i]).toString();
                        if (!caseSensitive) {
                            rowFieldString = rowFieldString.toLowerCase();
                        }
                        if (!rowFieldString.startsWith(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            } else if (searchType.equals((Object)SearchType.EXACT)) {
                while (this.isRowAvailable()) {
                    for (i = 0; i < fields.length; ++i) {
                        String rowFieldString = resolver.getValue(elContext, this.getRowData(), (Object)fields[i]).toString();
                        if (!caseSensitive) {
                            rowFieldString = rowFieldString.toLowerCase();
                        }
                        if (!rowFieldString.equals(query)) continue;
                        int n = this.getRowIndex();
                        return n;
                    }
                    this.setRowIndex(this.getRowIndex() + 1);
                }
            }
            int n = -1;
            return n;
        }
        finally {
            this.setRowIndex(savedRowIndex);
        }
    }

    public int findRow(String query, String[] fields, int startRow, SearchType searchType) {
        return this.findRow(query, fields, startRow, searchType, true);
    }

    public int findRow(String query, String[] fields, int startRow) {
        return this.findRow(query, fields, startRow, SearchType.CONTAINS, true);
    }

    private void doNavigate(int row) {
        if (row >= this.getRowCount()) {
            throw new IndexOutOfBoundsException();
        }
        int rowsPerPage = this.getRows();
        if (rowsPerPage > 0) {
            int page = row / rowsPerPage;
            this.setPage(row / rowsPerPage + 1);
        }
    }

    public void navigateToRow(int row, String effect, Integer durationMillis) {
        this.doNavigate(row);
        FacesContext context = FacesContext.getCurrentInstance();
        String id = this.getClientId(context) + "_row_" + row;
        if (effect != null) {
            JavaScriptRunner.runScript((FacesContext)context, (String)("ice.ace.jq(ice.ace.escapeClientId('" + id + "'))." + "toggleClass('" + effect + "', " + durationMillis / 2 + ")." + "delay(" + durationMillis / 2 + ")." + "toggleClass('" + effect + "', " + durationMillis / 2 + ")." + "focus();"));
        }
    }

    public void navigateToRow(int row, SearchEffect effect) {
        this.doNavigate(row);
        FacesContext context = FacesContext.getCurrentInstance();
        String id = this.getClientId(context) + "_row_" + row;
        if (effect != null) {
            if (effect.equals((Object)SearchEffect.HIGHLIGHT)) {
                JavaScriptRunner.runScript((FacesContext)context, (String)("ice.ace.jq(ice.ace.escapeClientId('" + id + "')).effect('highlight'),focus();"));
            } else if (effect.equals((Object)SearchEffect.PULSATE)) {
                JavaScriptRunner.runScript((FacesContext)context, (String)("ice.ace.jq(ice.ace.escapeClientId('" + id + "')).effect('pulsate').focus();"));
            }
        }
    }

    public void navigateToRow(int row) {
        this.navigateToRow(row, SearchEffect.HIGHLIGHT);
    }

    protected boolean isPaginationRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_paging", x);
    }

    protected boolean isTableConfigurationRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_tableconf", x);
    }

    protected boolean isColumnReorderRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_columnReorder", x);
    }

    protected boolean isSortRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_sorting", x);
    }

    protected boolean isFilterRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_filtering", x);
    }

    protected boolean isInstantSelectionRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_instantSelectedRowIndex", x);
    }

    protected boolean isInstantUnselectionRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_instantUnselectedRowIndex", x);
    }

    protected boolean isScrollingRequest(FacesContext x) {
        return this.isIdPrefixedParamSet("_scrolling", x);
    }

    protected boolean isTableFeatureRequest(FacesContext x) {
        return this.isColumnReorderRequest(x) || this.isScrollingRequest(x) || this.isInstantUnselectionRequest(x) || this.isInstantSelectionRequest(x) || this.isPaginationRequest(x) || this.isFilterRequest(x) || this.isSortRequest(x) || this.isTableConfigurationRequest(x);
    }

    protected Map<String, Column> getFilterMap() {
        block5: {
            if (this.filterMap != null) break block5;
            this.filterMap = new HashMap<String, Column>();
            ColumnGroup group = this.getColumnGroup("header");
            if (group != null) {
                for (UIComponent child : group.getChildren()) {
                    if (!child.isRendered()) continue;
                    for (UIComponent grandchild : child.getChildren()) {
                        if (!grandchild.isRendered() || grandchild.getValueExpression("filterBy") == null) continue;
                        this.filterMap.put(grandchild.getClientId(FacesContext.getCurrentInstance()) + "_filter", (Column)grandchild);
                    }
                }
            } else {
                for (Column column : this.getColumns()) {
                    if (column.getValueExpression("filterBy") == null) continue;
                    this.filterMap.put(column.getClientId(FacesContext.getCurrentInstance()) + "_filter", column);
                }
            }
        }
        return this.filterMap;
    }

    protected ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            if (!(child instanceof ColumnGroup) || !target.equals((colGroup = (ColumnGroup)child).getType())) continue;
            return colGroup;
        }
        return null;
    }

    protected SortCriteria[] getSortCriteria() {
        ArrayList<Column> sortableColumns = new ArrayList<Column>();
        ColumnGroup group = this.getColumnGroup("header");
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                for (UIComponent headerRowChild : child.getChildren()) {
                    Column c;
                    if (!(headerRowChild instanceof Column) || (c = (Column)headerRowChild).getSortPriority() == null) continue;
                    sortableColumns.add(c);
                }
            }
        } else {
            for (Column c : this.getColumns()) {
                if (c.getSortPriority() == null) continue;
                sortableColumns.add(c);
            }
        }
        Collections.sort(sortableColumns, new PriorityComparator());
        SortCriteria[] criterias = new SortCriteria[sortableColumns.size()];
        int i = 0;
        for (Column c : sortableColumns) {
            Comparator comp = c.getSortFunction();
            criterias[i] = comp == null ? new SortCriteria(c.getValueExpression("sortBy"), c.isSortAscending()) : new SortCriteria(c.getValueExpression("sortBy"), c.isSortAscending(), comp);
            ++i;
        }
        return criterias;
    }

    protected Map<String, String> getFilters() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Column c : this.getColumns()) {
            String value = c.getFilterValue();
            if (value == null || value.length() <= 0) continue;
            map.put(ComponentUtils.resolveField(c.getValueExpression("filterBy")), value);
        }
        return map;
    }

    protected boolean hasHeaders() {
        for (UIComponent c : this.getChildren()) {
            if (c instanceof Column && (c.getFacet("header") != null || ((Column)c).getHeaderText() != null)) {
                return true;
            }
            if (!(c instanceof ColumnGroup) || !((ColumnGroup)c).getType().equals("header")) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelectionClientBehaviour() {
        List deselectBehaviors;
        List selectBehaviors = (List)this.getClientBehaviors().get("select");
        if (selectBehaviors != null) {
            for (ClientBehavior b : selectBehaviors) {
                if (!(b instanceof AjaxBehavior) || ((AjaxBehavior)b).isDisabled()) continue;
                return true;
            }
        }
        if ((deselectBehaviors = (List)this.getClientBehaviors().get("deselect")) != null) {
            for (ClientBehavior b : deselectBehaviors) {
                if (!(b instanceof AjaxBehavior) || ((AjaxBehavior)b).isDisabled()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasFooterColumn(List<Column> columns) {
        for (Column column : columns) {
            if (column.getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    protected boolean isCellSelection() {
        String selectionMode = this.getSelectionMode();
        if (selectionMode != null) {
            return selectionMode.indexOf("cell") != -1;
        }
        return false;
    }

    protected boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        if (selectionMode != null) {
            return selectionMode.equalsIgnoreCase("single") || selectionMode.equalsIgnoreCase("singlecell");
        }
        return false;
    }

    protected TableConfigPanel findTableConfigPanel(FacesContext context) {
        if (this.panel == null & this.getTableConfigPanel() != null) {
            this.panel = (TableConfigPanel)this.findComponent(this.getTableConfigPanel());
            if (this.panel == null) {
                for (UIComponent child : this.getChildren()) {
                    if (!(child instanceof TableConfigPanel)) continue;
                    this.panel = (TableConfigPanel)child;
                }
            }
        }
        return this.panel;
    }

    protected void setColumnOrdering(String[] indexes) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String index : indexes) {
            ints.add(Integer.parseInt(index));
        }
        this.setColumnOrdering(ints);
    }

    protected void calculatePage() {
        int numberOfPages;
        int rows = this.getRows();
        int currentPage = this.getPage();
        if (currentPage > (numberOfPages = (int)Math.ceil((double)this.getRowCount() * 1.0 / (double)rows)) && numberOfPages > 0) {
            this.setPage(numberOfPages);
        } else if (currentPage < 1) {
            this.setPage(1);
        }
        this.setFirst((this.getPage() - 1) * rows);
    }

    protected void processSorting() {
        Object value = this.getValue();
        if (value instanceof List) {
            List list = (List)value;
            SortCriteria[] criterias = this.getSortCriteria();
            String rowVar = this.getVar();
            if (criterias != null && criterias.length > 0) {
                if (list.size() > 0 && list.get(0) instanceof Map.Entry) {
                    Collections.sort(list, new EntryKeyComparatorWrapper(new MultipleExpressionComparator(criterias, rowVar)));
                } else {
                    Collections.sort(list, new MultipleExpressionComparator(criterias, rowVar));
                }
            }
        }
        this.setForcedUpdateCounter(this.getForcedUpdateCounter() + 1);
        this.setSortOrderChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List processFilters(FacesContext context) {
        try {
            boolean hasGlobalFilter;
            Map<String, Column> filterMap = this.getFilterMap();
            String globalFilter = this.getFilterValue();
            ArrayList<Predicate> columnPredicates = new ArrayList<Predicate>();
            ArrayList<PropertyConstraintPredicate> globalPredicates = new ArrayList<PropertyConstraintPredicate>();
            boolean bl = hasGlobalFilter = globalFilter != null && !globalFilter.equals("");
            if (hasGlobalFilter) {
                globalFilter = globalFilter.toLowerCase();
            }
            for (Column c : filterMap.values()) {
                if (c.getFilterValue() != null && !c.getFilterValue().equals("")) {
                    columnPredicates.add(new PropertyConstraintPredicate(context, c.getValueExpression("filterBy"), c.getFilterValue(), c.getFilterConstraint()));
                }
                if (!hasGlobalFilter) continue;
                globalPredicates.add(new PropertyConstraintPredicate(context, c.getValueExpression("filterBy"), globalFilter, new ContainsFilterConstraint()));
            }
            if (globalPredicates.size() + columnPredicates.size() == 0) {
                Iterator<Column> i$ = null;
                return i$;
            }
            ArrayList<Object> filteredData = new ArrayList<Object>();
            this.setFilteredData(null);
            this.setModel(null);
            DataModel model = this.getDataModel();
            TreeDataModel treeModel = this.hasTreeDataModel() != false ? (TreeDataModel)model : null;
            String rowVar = this.getVar();
            String rowStateVar = this.getRowStateVar();
            if (globalPredicates.size() > 0) {
                columnPredicates.add(AnyPredicate.getInstance(globalPredicates));
            }
            Predicate filterSet = AllPredicate.getInstance(columnPredicates);
            int index = 0;
            model.setRowIndex(index);
            while (model.isRowAvailable()) {
                Object rowData = model.getRowData();
                RowState rowState = this.getStateMap().get(rowData);
                if (rowVar != null) {
                    context.getExternalContext().getRequestMap().put(rowVar, rowData);
                }
                context.getExternalContext().getRequestMap().put(rowStateVar, rowState);
                if (filterSet.evaluate(rowData)) {
                    if (treeModel != null) {
                        filteredData.add(treeModel.getRowEntry());
                    } else {
                        filteredData.add(model.getRowData());
                    }
                }
                model.setRowIndex(++index);
            }
            this.setRowIndex(-1);
            if (rowVar != null) {
                context.getExternalContext().getRequestMap().remove(rowVar);
            }
            context.getExternalContext().getRequestMap().remove(this.getRowStateVar());
            ArrayList<Object> arrayList = filteredData;
            return arrayList;
        }
        finally {
            this.setForcedUpdateCounter(this.getForcedUpdateCounter() + 1);
            this.setFilterValueChanged(false);
        }
    }

    protected void loadLazyData() {
        LazyDataModel model = (LazyDataModel)this.getDataModel();
        model.setPageSize(this.getRows());
        model.setWrappedData(model.load(this.getFirst(), this.getRows(), this.getSortCriteria(), this.getFilters()));
    }

    private boolean isIdPrefixedParamSet(String param, FacesContext x) {
        return x.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(x) + param);
    }

    private List<Integer> generateColumnOrdering() {
        List superOrder = super.getColumnOrdering();
        if (superOrder == null || superOrder.size() == 0) {
            ArrayList<Column> columns = new ArrayList<Column>();
            Stack<DataTable> childStack = new Stack<DataTable>();
            childStack.add(this);
            while (!childStack.empty()) {
                for (UIComponent child : ((UIComponent)childStack.pop()).getChildren()) {
                    if (!(child instanceof ColumnGroup) && !(child instanceof Column)) {
                        if (child.getChildren().size() <= 0) continue;
                        childStack.add((DataTable)child);
                        continue;
                    }
                    if (!(child instanceof Column)) continue;
                    columns.add((Column)child);
                }
            }
            ArrayList<Integer> ordering = new ArrayList<Integer>();
            int i = 0;
            for (Column o : columns) {
                ordering.add(i++);
            }
            this.setColumnOrdering(ordering);
            return ordering;
        }
        return superOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        boolean ret = false;
        if (this.isVisitable(context)) {
            boolean visitRows = this.requiresRowIteration(context);
            int savedIndex = -1;
            if (visitRows) {
                savedIndex = this.getRowIndex();
                this.setRowIndex(-1);
            }
            this.pushComponentToEL(FacesContext.getCurrentInstance(), (UIComponent)this);
            try {
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result.equals((Object)VisitResult.COMPLETE)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.doVisitChildren(context, visitRows) & result == VisitResult.ACCEPT) {
                    if (this.visitFacets(context, callback, visitRows)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (this.visitColumnsAndColumnFacets(context, callback, visitRows)) {
                        boolean bl = true;
                        return bl;
                    }
                    if (this.visitRowsAndExpandedRows(context, callback, visitRows)) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                this.popComponentFromEL(FacesContext.getCurrentInstance());
                this.setRowIndex(savedIndex);
                if (visitRows) {
                    this.setRowIndex(savedIndex);
                }
            }
        }
        return ret;
    }

    private boolean requiresRowIteration(VisitContext ctx) {
        try {
            return !ctx.getHints().contains(VisitHint.SKIP_ITERATION);
        }
        catch (NoSuchFieldError e) {
            FacesContext fctx = FacesContext.getCurrentInstance();
            return !PhaseId.RESTORE_VIEW.equals(fctx.getCurrentPhaseId());
        }
    }

    private boolean visitFacets(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (!facet.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean visitColumnsAndColumnFacets(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        if (this.getChildCount() > 0) {
            for (UIComponent column : this.getChildren()) {
                if (column instanceof Column || column instanceof PanelExpansion) {
                    VisitResult result = context.invokeVisitCallback(column, callback);
                    if (result == VisitResult.COMPLETE) {
                        return true;
                    }
                    if (column.getFacetCount() <= 0) continue;
                    for (UIComponent columnFacet : column.getFacets().values()) {
                        if (!columnFacet.visitTree(context, callback)) continue;
                        return true;
                    }
                    continue;
                }
                if (!(column instanceof ColumnGroup)) continue;
                UIComponent columnGroup = column;
                for (UIComponent row : columnGroup.getChildren()) {
                    for (UIComponent c : row.getChildren()) {
                        if (!(c instanceof Column)) continue;
                        VisitResult result = context.invokeVisitCallback(c, callback);
                        if (result == VisitResult.COMPLETE) {
                            return true;
                        }
                        if (c.getFacetCount() <= 0) continue;
                        for (UIComponent columnFacet : c.getFacets().values()) {
                            if (!columnFacet.visitTree(context, callback)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitRowsAndExpandedRows(VisitContext context, VisitCallback callback, boolean visitRows) {
        int rows = 0;
        int offset = 0;
        int first = this.getFirst();
        this.setDataModel(null);
        DataModel model = this.getDataModel();
        PanelExpansion panelExpansion = this.getPanelExpansion();
        RowExpansion rowExpansion = this.getRowExpansion();
        boolean hasPanelExpansion = panelExpansion != null;
        boolean hasRowExpansion = rowExpansion != null;
        RowStateMap stateMap = null;
        if (visitRows) {
            stateMap = this.getStateMap();
            rows = this.getRows();
            if (rows == 0) {
                rows = this.getRowCount();
            }
        }
        while (true) {
            if (visitRows) {
                if (offset >= rows) break;
                this.setRowIndex(first + offset);
            }
            if (!visitRows || this.isRowAvailable()) {
                RowState rowState = null;
                if (visitRows) {
                    rowState = stateMap.get(this.getRowData());
                }
                if (this.hasTreeDataModel().booleanValue()) {
                    String currentRootId = "";
                    TreeDataModel dataModel = (TreeDataModel)this.getDataModel();
                    try {
                        do {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Visiting Row Id: " + dataModel.getRowIndex());
                            }
                            if (this.getChildCount() > 0) {
                                for (UIComponent kid : this.getChildren()) {
                                    if (!(kid instanceof UIColumn) && !(kid instanceof PanelExpansion) || kid.getChildCount() <= 0) continue;
                                    for (UIComponent grandkid : kid.getChildren()) {
                                        if (!grandkid.visitTree(context, callback)) continue;
                                        boolean bl = true;
                                        return bl;
                                    }
                                }
                            }
                            if (rowState != null && rowState.isExpanded() && dataModel.getCurrentRowChildCount() > 0) {
                                currentRootId = currentRootId.equals("") ? this.getRowIndex() + "" : currentRootId + "." + this.getRowIndex();
                                dataModel.setRootIndex(currentRootId);
                                this.setRowIndex(0);
                                continue;
                            }
                            if (dataModel.getRowIndex() < dataModel.getRowCount() - 1) {
                                this.setRowIndex(dataModel.getRowIndex() + 1);
                                continue;
                            }
                            if (currentRootId.equals("")) continue;
                            this.setRowIndex(dataModel.pop() + 1);
                            String string = currentRootId = currentRootId.lastIndexOf(46) != -1 ? currentRootId.substring(0, currentRootId.lastIndexOf(46)) : "";
                            if (!log.isLoggable(Level.FINEST)) continue;
                            log.finest("Popping Root: " + currentRootId);
                        } while (!currentRootId.equals(""));
                    }
                    finally {
                        dataModel.setRootIndex(null);
                    }
                }
                if (this.getChildCount() > 0) {
                    for (UIComponent kid : this.getChildren()) {
                        if (!(kid instanceof UIColumn) && !(kid instanceof PanelExpansion) || kid.getChildCount() <= 0) continue;
                        for (UIComponent grandkid : kid.getChildren()) {
                            if (!grandkid.visitTree(context, callback)) continue;
                            return true;
                        }
                    }
                }
            } else {
                return false;
            }
            if (!visitRows) break;
            ++offset;
        }
        return false;
    }

    private boolean doVisitChildren(VisitContext context, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        Collection idsToVisit = context.getSubtreeIdsToVisit((UIComponent)this);
        assert (idsToVisit != null);
        return !idsToVisit.isEmpty();
    }

    public String getBaseClientId(FacesContext context) {
        if (this.baseClientId == null && this.clientIdBuilder == null) {
            if (!this.isNestedWithinUIData().booleanValue()) {
                this.clientIdBuilder = new StringBuilder(this.UIComponentBase_getClientId(context));
                this.baseClientId = this.clientIdBuilder.toString();
                this.baseClientIdLength = this.baseClientId.length() + 1;
                this.clientIdBuilder.append(UINamingContainer.getSeparatorChar((FacesContext)context));
                this.clientIdBuilder.setLength(this.baseClientIdLength);
            } else {
                this.clientIdBuilder = new StringBuilder();
            }
        }
        return this.baseClientId;
    }

    public String getContainerClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return this.getClientId(context);
    }

    public String getClientId(FacesContext context) {
        int rowIndex;
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.baseClientId == null && this.clientIdBuilder == null) {
            if (!this.isNestedWithinUIData().booleanValue()) {
                this.clientIdBuilder = new StringBuilder(this.UIComponentBase_getClientId(context));
                this.baseClientId = this.clientIdBuilder.toString();
                this.baseClientIdLength = this.baseClientId.length() + 1;
                this.clientIdBuilder.append(UINamingContainer.getSeparatorChar((FacesContext)context));
                this.clientIdBuilder.setLength(this.baseClientIdLength);
            } else {
                this.clientIdBuilder = new StringBuilder();
            }
        }
        if ((rowIndex = this.getRowIndex()) >= 0) {
            String cid;
            if (!this.isNestedWithinUIData().booleanValue()) {
                if (this.hasTreeDataModel().booleanValue()) {
                    String rootIndex = ((TreeDataModel)this.getDataModel()).getRootIndex();
                    rootIndex = rootIndex != null && !rootIndex.equals("") ? rootIndex + "." + rowIndex : "" + rowIndex;
                    cid = this.clientIdBuilder.append(rootIndex).toString();
                } else {
                    cid = this.clientIdBuilder.append(rowIndex).toString();
                }
                this.clientIdBuilder.setLength(this.baseClientIdLength);
            } else {
                if (this.hasTreeDataModel().booleanValue()) {
                    String rootIndex = ((TreeDataModel)this.getDataModel()).getRootIndex();
                    rootIndex = rootIndex != null && !rootIndex.equals("") ? rootIndex + "." + rowIndex : "" + rowIndex;
                    cid = this.clientIdBuilder.append(this.UIComponentBase_getClientId(context)).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(rootIndex).toString();
                } else {
                    cid = this.clientIdBuilder.append(this.UIData_getContainerClientId(context)).toString();
                }
                this.clientIdBuilder.setLength(0);
            }
            return cid;
        }
        if (!this.isNestedWithinUIData().booleanValue()) {
            return this.baseClientId;
        }
        return this.UIData_getContainerClientId(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String UIComponentBase_getClientId(FacesContext context) {
        String clientId;
        UIComponent namingContainer;
        if (context == null) {
            throw new NullPointerException();
        }
        String id = this.getId();
        if (id == null) {
            block10: {
                UniqueIdVendor parentUniqueIdVendor = DataTable.findParentUniqueIdVendor((UIComponent)this);
                if (parentUniqueIdVendor == null) {
                    UIViewRoot viewRoot = context.getViewRoot();
                    if (viewRoot != null) {
                        id = viewRoot.createUniqueId();
                        break block10;
                    } else {
                        String string;
                        String location = this.getComponentLocation((UIComponent)this);
                        StringBuilder stringBuilder = new StringBuilder().append("Cannot create clientId. No id is assigned for component to create an id and UIViewRoot is not defined: ").append(this.getPathToComponent((UIComponent)this));
                        if (location != null) {
                            string = " created from: " + location;
                            throw new FacesException(stringBuilder.append(string).toString());
                        }
                        string = "";
                        throw new FacesException(stringBuilder.append(string).toString());
                    }
                }
                id = parentUniqueIdVendor.createUniqueId(context, null);
            }
            this.setId(id);
        }
        if ((namingContainer = DataTable.findParentNamingContainer((UIComponent)this, false)) != null) {
            String containerClientId = namingContainer.getContainerClientId(context);
            if (containerClientId != null) {
                StringBuilder bld = new StringBuilder(containerClientId.length() + 1 + id.length());
                clientId = bld.append(containerClientId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(id).toString();
            } else {
                clientId = id;
            }
        } else {
            clientId = id;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer == null) return clientId;
        return renderer.convertClientId(context, clientId);
    }

    protected String UIData_getContainerClientId(FacesContext facesContext) {
        String clientId = this.UIComponentBase_getClientId(facesContext);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return clientId;
        }
        StringBuilder bld = new StringBuilder(clientId.length() + 4);
        String ret = bld.append(clientId).append(UINamingContainer.getSeparatorChar((FacesContext)facesContext)).append(rowIndex).toString();
        return ret;
    }

    private String getComponentLocation(UIComponent component) {
        Location location = (Location)component.getAttributes().get("javax.faces.component.VIEW_LOCATION_KEY");
        if (location != null) {
            return location.toString();
        }
        return null;
    }

    private String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        this.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        this.getPathToComponent(component.getParent(), buf);
    }

    static UniqueIdVendor findParentUniqueIdVendor(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UniqueIdVendor)) continue;
            return (UniqueIdVendor)parent;
        }
        return null;
    }

    static UIComponent findParentNamingContainer(UIComponent component, boolean returnRootIfNotFound) {
        UIComponent parent = component.getParent();
        if (returnRootIfNotFound && parent == null) {
            return component;
        }
        while (parent != null) {
            if (parent instanceof NamingContainer) {
                return parent;
            }
            if (returnRootIfNotFound) {
                UIComponent nextParent = parent.getParent();
                if (nextParent == null) {
                    return parent;
                }
                parent = nextParent;
                continue;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private Boolean isNestedWithinUIData() {
        if (this.isNested == null) {
            DataTable parent = this;
            while (null != (parent = parent.getParent())) {
                if (!(parent instanceof UIData) && !"facelets.ui.Repeat".equals(parent.getRendererType())) continue;
                this.isNested = Boolean.TRUE;
                break;
            }
            if (this.isNested == null) {
                this.isNested = Boolean.FALSE;
            }
            return this.isNested;
        }
        return this.isNested;
    }

    private void iterate(FacesContext context, PhaseId phaseId) {
        this.setDataModel(null);
        this.getDataModel();
        this.setRowIndex(-1);
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    facet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    facet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    facet.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        this.setRowIndex(-1);
        if (this.getChildCount() > 0) {
            for (UIComponent column : this.getChildren()) {
                if (!(column instanceof UIColumn) || !column.isRendered() || column.getFacetCount() <= 0) continue;
                for (UIComponent columnFacet : column.getFacets().values()) {
                    if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                        columnFacet.processDecodes(context);
                        continue;
                    }
                    if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                        columnFacet.processValidators(context);
                        continue;
                    }
                    if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                        columnFacet.processUpdates(context);
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
        this.setRowIndex(-1);
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof TableConfigPanel) || !kid.isRendered()) continue;
            if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                kid.processDecodes(context);
                continue;
            }
            if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                kid.processValidators(context);
                continue;
            }
            if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                kid.processUpdates(context);
                continue;
            }
            throw new IllegalArgumentException();
        }
        int processed = 0;
        int rowIndex = this.getFirst() - 1;
        int rows = this.getRows();
        boolean inSubrows = false;
        PanelExpansion panelExpansion = this.getPanelExpansion();
        RowStateMap map = this.getStateMap();
        while (true) {
            TreeDataModel treeDataModel;
            if (!inSubrows) {
                ++processed;
            }
            if (rows > 0 && processed > rows) break;
            this.setRowIndex(++rowIndex);
            if (!this.isRowAvailable()) {
                if (!(this.model instanceof TreeDataModel) || !(treeDataModel = (TreeDataModel)this.model).isRootIndexSet()) break;
                rowIndex = treeDataModel.pop() + 1;
                this.setRowIndex(rowIndex);
                if (!treeDataModel.isRootIndexSet()) {
                    inSubrows = false;
                }
            }
            RowState rowState = map.get(this.getRowData());
            Boolean expanded = rowState.isExpanded();
            if (this.getChildCount() > 0) {
                for (UIComponent kid : this.getChildren()) {
                    if (!(kid instanceof UIColumn) && !(kid instanceof PanelExpansion) || !kid.isRendered() || kid instanceof PanelExpansion && !expanded.booleanValue() || kid.getChildCount() <= 0) continue;
                    for (UIComponent grandkid : kid.getChildren()) {
                        if (!grandkid.isRendered()) continue;
                        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                            grandkid.processDecodes(context);
                            continue;
                        }
                        if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                            grandkid.processValidators(context);
                            continue;
                        }
                        if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                            grandkid.processUpdates(context);
                            continue;
                        }
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (!expanded.booleanValue() || !this.hasTreeDataModel().booleanValue() || panelExpansion != null && rowState.getExpansionType() != RowState.ExpansionType.ROW || (treeDataModel = (TreeDataModel)this.model).getCurrentRowChildCount() <= 0) continue;
            inSubrows = true;
            treeDataModel.setRootIndex(treeDataModel.getRootIndex().equals("") ? "" + this.getRowIndex() : treeDataModel.getRootIndex() + "." + this.getRowIndex());
            rowIndex = -1;
        }
        this.setRowIndex(-1);
    }

    static {
        try {
            SQL_RESULT = Class.forName("javax.servlet.jsp.jstl.sql.Result");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PriorityComparator
    implements Comparator<Column> {
        private PriorityComparator() {
        }

        @Override
        public int compare(Column object, Column object1) {
            return object.getSortPriority().compareTo(object1.getSortPriority());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryKeyComparatorWrapper<T>
    implements Comparator {
        Comparator<T> comparator;

        public EntryKeyComparatorWrapper(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        public int compare(Object o1, Object o2) {
            return this.comparator.compare(((Map.Entry)o1).getKey(), ((Map.Entry)o2).getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchEffect {
        HIGHLIGHT,
        PULSATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchType {
        CONTAINS,
        ENDS_WITH,
        STARTS_WITH,
        EXACT;

    }
}

