/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datetimeentry;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.icefaces.ace.component.datetimeentry.DateTimeEntry;
import org.icefaces.ace.component.datetimeentry.DateTimeEntryUtils;
import org.icefaces.ace.renderkit.InputRenderer;
import org.icefaces.ace.util.HTML;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="dateTimeEntry", value="org.icefaces.ace.component.datetimeentry.DateTimeEntry")
public class DateTimeEntryRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        if (dateTimeEntry.isDisabled() || dateTimeEntry.isReadonly()) {
            return;
        }
        String param = dateTimeEntry.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(param);
        if (submittedValue != null) {
            dateTimeEntry.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, (UIComponent)dateTimeEntry);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        String value = DateTimeEntryUtils.getValueAsString(context, dateTimeEntry);
        this.encodeMarkup(context, dateTimeEntry, value);
        this.encodeScript(context, dateTimeEntry, value);
    }

    protected void encodeMarkup(FacesContext context, DateTimeEntry dateTimeEntry, String value) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dateTimeEntry.getClientId(context);
        String inputId = clientId + "_input";
        boolean popup = dateTimeEntry.isPopup();
        writer.startElement("span", (UIComponent)dateTimeEntry);
        writer.writeAttribute("id", (Object)clientId, null);
        String style = dateTimeEntry.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = dateTimeEntry.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (!popup) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        String type = popup ? "text" : "hidden";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)type, null);
        if (!this.isValueBlank(value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (popup) {
            if (this.themeForms()) {
                writer.writeAttribute("class", (Object)"ui-inputfield ui-widget ui-state-default ui-corner-all", null);
            }
            if (dateTimeEntry.isReadOnlyInputText()) {
                writer.writeAttribute("readonly", (Object)"readonly", null);
            }
            if (dateTimeEntry.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            this.renderPassThruAttributes(context, (UIComponent)dateTimeEntry, HTML.INPUT_TEXT_ATTRS);
        }
        writer.endElement("input");
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, DateTimeEntry dateTimeEntry, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dateTimeEntry.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String showOn = dateTimeEntry.getShowOn();
        StringBuilder script = new StringBuilder();
        JSONBuilder json = JSONBuilder.create();
        script.append("jQuery(function(){").append(this.resolveWidgetVar((UIComponent)dateTimeEntry)).append(" = new ");
        json.beginFunction("ice.ace.Calendar").item(clientId).beginMap().entry("popup", dateTimeEntry.isPopup()).entry("locale", dateTimeEntry.calculateLocale(context).toString());
        if (!this.isValueBlank(value)) {
            json.entry("defaultDate", value);
        }
        json.entryNonNullValue("pattern", DateTimeEntryUtils.convertPattern(dateTimeEntry.getPattern()));
        if (dateTimeEntry.getPages() != 1) {
            json.entry("numberOfMonths", dateTimeEntry.getPages());
        }
        json.entryNonNullValue("minDate", DateTimeEntryUtils.getDateAsString(dateTimeEntry, dateTimeEntry.getMindate())).entryNonNullValue("maxDate", DateTimeEntryUtils.getDateAsString(dateTimeEntry, dateTimeEntry.getMaxdate()));
        json.entryNonNullValue("showButtonPanel", dateTimeEntry.isShowButtonPanel());
        if (dateTimeEntry.isShowWeek()) {
            json.entry("showWeek", true);
        }
        if (dateTimeEntry.isDisabled()) {
            json.entry("disabled", true);
        }
        json.entryNonNullValue("yearRange", dateTimeEntry.getYearRange());
        if (dateTimeEntry.isNavigator()) {
            json.entry("changeMonth", true).entry("changeYear", true);
        }
        if (dateTimeEntry.getEffect() != null) {
            json.entry("showAnim", dateTimeEntry.getEffect()).entry("duration", dateTimeEntry.getEffectDuration());
        }
        if (!showOn.equalsIgnoreCase("focus")) {
            String iconSrc = dateTimeEntry.getPopupIcon() != null ? this.getResourceURL(context, dateTimeEntry.getPopupIcon()) : this.getResourceRequestPath(context, DateTimeEntry.POPUP_ICON);
            json.entry("showOn", showOn).entry("buttonImage", iconSrc).entry("buttonImageOnly", dateTimeEntry.isPopupIconOnly());
        }
        if (dateTimeEntry.isShowOtherMonths()) {
            json.entry("showOtherMonths", true).entry("selectOtherMonths", dateTimeEntry.isSelectOtherMonths());
        }
        if (dateTimeEntry.hasTime()) {
            json.entry("timeOnly", dateTimeEntry.isTimeOnly()).entry("stepHour", dateTimeEntry.getStepHour()).entry("stepMinute", dateTimeEntry.getStepMinute()).entry("stepSecond", dateTimeEntry.getStepSecond()).entry("hourMin", dateTimeEntry.getMinHour()).entry("hourMax", dateTimeEntry.getMaxHour()).entry("minuteMin", dateTimeEntry.getMinMinute()).entry("minuteMax", dateTimeEntry.getMaxMinute()).entry("secondMin", dateTimeEntry.getMinSecond()).entry("secondMax", dateTimeEntry.getMaxSecond());
        }
        this.encodeClientBehaviors(context, dateTimeEntry, json);
        if (!this.themeForms()) {
            json.entry("theme", false);
        }
        json.entry("disableHoverStyling", dateTimeEntry.isDisableHoverStyling());
        json.entry("showCurrentAtPos", 0 - dateTimeEntry.getLeftMonthOffset());
        json.endMap();
        json.endFunction();
        script.append(json.toString()).append("});");
        writer.write(script.toString());
        writer.endElement("script");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        String submittedValue = (String)value;
        Converter converter = dateTimeEntry.getConverter();
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)dateTimeEntry, submittedValue);
        }
        try {
            Locale locale = dateTimeEntry.calculateLocale(context);
            SimpleDateFormat format = new SimpleDateFormat(dateTimeEntry.getPattern(), locale);
            format.setTimeZone(dateTimeEntry.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

