/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.expansiontoggler;

import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.expansiontoggler.ExpansionTogglerBase;
import org.icefaces.ace.event.ExpansionChangeEvent;
import org.icefaces.ace.model.table.RowState;
import org.icefaces.ace.model.table.TreeDataModel;

public class ExpansionToggler
extends ExpansionTogglerBase {
    private boolean isRowExpansionRequest(FacesContext x, String tableId) {
        return this.isIdPrefixedParamSet(tableId, "_rowExpansion", x);
    }

    private boolean isIdPrefixedParamSet(String tableId, String param, FacesContext x) {
        return x.getExternalContext().getRequestParameterMap().containsKey(tableId + param);
    }

    public void decode(FacesContext context) {
        RowState rowState;
        super.decode(context);
        UIComponent parent = this.getParent();
        while (!(parent instanceof DataTable)) {
            parent = parent.getParent();
        }
        DataTable table = (DataTable)parent;
        String tableId = table.getClientId(context);
        if (this.isRowExpansionRequest(context, tableId) && (rowState = (RowState)context.getExternalContext().getRequestMap().get(table.getRowStateVar())).isExpandable()) {
            rowState.setExpanded(!rowState.isExpanded());
            if (table.hasTreeDataModel().booleanValue()) {
                this.queueEvent(new ExpansionChangeEvent((UIComponent)this, table.getRowData(), rowState.isExpanded(), ((TreeDataModel)table.getModel()).getRowEntry().getValue()));
            } else {
                this.queueEvent(new ExpansionChangeEvent((UIComponent)this, table.getRowData(), rowState.isExpanded()));
            }
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext context = FacesContext.getCurrentInstance();
        MethodExpression me = null;
        if (event instanceof ExpansionChangeEvent) {
            me = this.getChangeListener();
        }
        if (me != null) {
            me.invoke(context.getELContext(), new Object[]{event});
        }
    }
}

