/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.icefaces.ace.component.fileentry.FileEntry;
import org.icefaces.ace.component.fileentry.FileEntryCallback;
import org.icefaces.ace.component.fileentry.FileEntryConfig;
import org.icefaces.ace.component.fileentry.FileEntryResults;
import org.icefaces.ace.component.fileentry.FileEntryStatuses;
import org.icefaces.ace.component.fileentry.ProgressListenerResourcePusher;
import org.icefaces.apache.commons.fileupload.FileItemIterator;
import org.icefaces.apache.commons.fileupload.FileItemStream;
import org.icefaces.apache.commons.fileupload.servlet.ServletFileUpload;
import org.icefaces.apache.commons.fileupload.util.Streams;
import org.icefaces.impl.context.DOMPartialViewContext;
import org.icefaces.impl.util.CoreUtils;
import org.icefaces.util.EnvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntryPhaseListener
implements PhaseListener {
    private static Logger log = Logger.getLogger(FileEntryPhaseListener.class.getName());
    static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
            FileEntry.removeResults(phaseEvent.getFacesContext());
        }
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        if (!phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            // empty if block
        }
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            final Map<String, FacesEvent> clientId2FacesEvent = FileEntry.removeEventsForPreRender(phaseEvent.getFacesContext());
            if (clientId2FacesEvent != null) {
                Set<String> clientIds = clientId2FacesEvent.keySet();
                EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)phaseEvent.getFacesContext(), clientIds, hints);
                VisitCallback vcall = new VisitCallback(){

                    public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
                        FacesContext facesContext = visitContext.getFacesContext();
                        String clientId = uiComponent.getClientId(facesContext);
                        FacesEvent event = (FacesEvent)clientId2FacesEvent.get(clientId);
                        if (event != null) {
                            uiComponent.broadcast(event);
                        }
                        return VisitResult.REJECT;
                    }
                };
                phaseEvent.getFacesContext().getViewRoot().visitTree(visitContext, vcall);
            }
            return;
        }
        if (!phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            return;
        }
        Object requestObject = phaseEvent.getFacesContext().getExternalContext().getRequest();
        HttpServletRequest request = EnvUtils.getSafeRequest((FacesContext)phaseEvent.getFacesContext());
        boolean isPortlet = EnvUtils.instanceofPortletRequest((Object)requestObject);
        boolean isMultipart = ServletFileUpload.isMultipartContent(request);
        if (isMultipart) {
            List parameterList;
            ServletFileUpload uploader = new ServletFileUpload();
            HashMap<String, FileEntryResults> clientId2Results = new HashMap<String, FileEntryResults>(6);
            ProgressListenerResourcePusher progressListenerResourcePusher = new ProgressListenerResourcePusher(clientId2Results);
            uploader.setProgressListener(progressListenerResourcePusher);
            HashMap<String, FileEntryCallback> clientId2Callbacks = new HashMap<String, FileEntryCallback>(6);
            HashMap<String, ArrayList<String>> parameterListMap = new HashMap<String, ArrayList<String>>();
            byte[] buffer = new byte[16384];
            try {
                FileItemIterator iter = uploader.getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (item.isFormField()) {
                        String name = item.getFieldName();
                        String value = Streams.asString(item.openStream());
                        parameterList = (ArrayList<String>)parameterListMap.get(name);
                        if (parameterList == null) {
                            parameterList = new ArrayList<String>(6);
                            parameterListMap.put(name, (ArrayList<String>)parameterList);
                        }
                        parameterList.add(value);
                        continue;
                    }
                    FileEntryPhaseListener.uploadFile(phaseEvent.getFacesContext(), item, clientId2Results, clientId2Callbacks, progressListenerResourcePusher, buffer);
                }
            }
            catch (Exception e) {
                FacesMessage fm = FileEntryStatuses.PROBLEM_READING_MULTIPART.getFacesMessage(phaseEvent.getFacesContext(), null, null);
                phaseEvent.getFacesContext().addMessage(null, fm);
                System.out.println("Problem: " + e);
                e.printStackTrace();
            }
            FileEntry.storeResultsForLaterInLifecycle(phaseEvent.getFacesContext(), clientId2Results);
            progressListenerResourcePusher.clear();
            clientId2Callbacks.clear();
            Arrays.fill(buffer, (byte)0);
            buffer = null;
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(parameterListMap.size() > 0 ? parameterListMap.size() : 1);
            boolean ajaxResponse = false;
            for (String key : parameterListMap.keySet()) {
                if (key.equals("ice.fileEntry.ajaxResponse")) {
                    ajaxResponse = true;
                }
                parameterList = (List)parameterListMap.get(key);
                String[] values = new String[parameterList.size()];
                values = parameterList.toArray(values);
                parameterMap.put(key, values);
            }
            if (!parameterMap.isEmpty()) {
                Object wrapper = null;
                if (isPortlet) {
                    wrapper = FileEntryPhaseListener.getPortletRequestWrapper(requestObject, parameterMap);
                    FileEntryPhaseListener.setPortletRequestWrapper(wrapper);
                } else {
                    wrapper = new FileUploadRequestWrapper((HttpServletRequest)requestObject, parameterMap);
                }
                phaseEvent.getFacesContext().getExternalContext().setRequest(wrapper);
                if (ajaxResponse) {
                    PartialViewContext pvc = phaseEvent.getFacesContext().getPartialViewContext();
                    if (pvc instanceof DOMPartialViewContext) {
                        ((DOMPartialViewContext)pvc).setAjaxRequest(true);
                    }
                    pvc.setPartialRequest(true);
                }
            }
        }
    }

    private static Object getPortletRequestWrapper(Object requestObject, Map map) {
        Object wrapper = null;
        try {
            Class<?> wrapperClass = Class.forName("org.icefaces.ace.component.fileentry.FileUploadPortletRequestWrapper");
            Class[] paramClasses = new Class[]{Object.class, Map.class};
            Constructor<?> constructor = wrapperClass.getConstructor(paramClasses);
            wrapper = constructor.newInstance(requestObject, map);
        }
        catch (Exception e) {
            throw new RuntimeException("problem getting FileUploadPortletRequestWrapper", e);
        }
        return wrapper;
    }

    private static void setPortletRequestWrapper(Object wrappedRequest) {
        FacesContext fc = FacesContext.getCurrentInstance();
        ExternalContext ec = fc.getExternalContext();
        Map requestMap = ec.getRequestMap();
        try {
            Object bridgeContext = requestMap.get("javax.portlet.faces.bridgeContext");
            Class<?> requestClass = Class.forName("javax.portlet.PortletRequest");
            Class[] paramClasses = new Class[]{requestClass};
            Method setPortletRequestMethod = bridgeContext.getClass().getMethod("setPortletRequest", paramClasses);
            Object[] paramObj = new Object[]{wrappedRequest};
            setPortletRequestMethod.invoke(bridgeContext, paramObj);
        }
        catch (Exception e) {
            throw new RuntimeException("problem setting FileUploadPortletRequestWrapper", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadFile(FacesContext facesContext, FileItemStream item, Map<String, FileEntryResults> clientId2Results, Map<String, FileEntryCallback> clientId2Callbacks, ProgressListenerResourcePusher progressListenerResourcePusher, byte[] buffer) {
        FileEntryStatuses status;
        long fileSizeRead;
        File file;
        FileEntryConfig config;
        FileEntryResults.FileInfo fileInfo;
        FileEntryCallback callback;
        FileEntryResults results;
        block35: {
            results = null;
            callback = null;
            fileInfo = null;
            config = null;
            file = null;
            fileSizeRead = 0L;
            status = FileEntryStatuses.UPLOADING;
            try {
                String name = item.getName();
                String fieldName = item.getFieldName();
                String contentType = item.getContentType();
                String fileName = null;
                if (name != null && name.length() > 0) {
                    fileName = FileEntryPhaseListener.trimInternetExplorerPath(name);
                }
                if (fileName != null && fileName.length() > 0) {
                    String identifier = fieldName;
                    config = FileEntry.retrieveConfigFromPreviousLifecycle(facesContext, identifier);
                    if (config == null) break block35;
                    results = clientId2Results.get(config.getClientId());
                    if (results == null) {
                        results = new FileEntryResults(config.isViaCallback());
                        clientId2Results.put(config.getClientId(), results);
                    }
                    fileInfo = new FileEntryResults.FileInfo();
                    fileInfo.begin(fileName, contentType);
                    progressListenerResourcePusher.setPushResourcePathAndGroupName(facesContext, config.getProgressResourcePath(), config.getProgressGroupName());
                    if (config.isViaCallback() && (callback = clientId2Callbacks.get(config.getClientId())) == null) {
                        try {
                            callback = FileEntryPhaseListener.evaluateCallback(facesContext, config);
                        }
                        catch (ELException e) {
                            status = FileEntryStatuses.PROBLEM_WITH_CALLBACK;
                            throw e;
                        }
                    }
                    long availableTotalSize = results.getAvailableTotalSize(config.getMaxTotalSize());
                    long availableFileSize = config.getMaxFileSize();
                    int maxFileCount = config.getMaxFileCount();
                    if (results.getFiles().size() >= maxFileCount) {
                        status = FileEntryStatuses.MAX_FILE_COUNT_EXCEEDED;
                        fileInfo.prefail(status);
                        InputStream in = item.openStream();
                        while (in.read(buffer) >= 0) {
                        }
                        if (callback == null) break block35;
                        try {
                            callback.begin(fileInfo);
                            callback.end(fileInfo);
                            break block35;
                        }
                        catch (RuntimeException e) {
                            status = FileEntryStatuses.PROBLEM_WITH_CALLBACK;
                            FileEntryPhaseListener.handleCallbackException(facesContext, config.getClientId(), e);
                            throw e;
                        }
                    }
                    FileOutputStream output = null;
                    if (callback != null) {
                        try {
                            callback.begin(fileInfo);
                        }
                        catch (RuntimeException e) {
                            status = FileEntryStatuses.PROBLEM_WITH_CALLBACK;
                            FileEntryPhaseListener.handleCallbackException(facesContext, config.getClientId(), e);
                            throw e;
                        }
                    } else {
                        String folder = FileEntryPhaseListener.calculateFolder(facesContext, config);
                        file = FileEntryPhaseListener.makeFile(config, folder, fileName);
                        output = new FileOutputStream(file);
                    }
                    InputStream in = item.openStream();
                    try {
                        int read;
                        boolean overQuota = false;
                        while ((read = in.read(buffer)) >= 0) {
                            fileSizeRead += (long)read;
                            if (overQuota) continue;
                            if (fileSizeRead > availableFileSize) {
                                overQuota = true;
                                status = FileEntryStatuses.MAX_FILE_SIZE_EXCEEDED;
                            } else if (fileSizeRead > availableTotalSize) {
                                overQuota = true;
                                status = FileEntryStatuses.MAX_TOTAL_SIZE_EXCEEDED;
                            }
                            if (overQuota) continue;
                            if (callback != null) {
                                try {
                                    callback.write(buffer, 0, read);
                                    continue;
                                }
                                catch (RuntimeException e) {
                                    status = FileEntryStatuses.PROBLEM_WITH_CALLBACK;
                                    FileEntryPhaseListener.handleCallbackException(facesContext, config.getClientId(), e);
                                    throw e;
                                }
                            }
                            if (output == null) continue;
                            ((OutputStream)output).write(buffer, 0, read);
                        }
                        if (status == FileEntryStatuses.UPLOADING) {
                            status = FileEntryStatuses.SUCCESS;
                        }
                        break block35;
                    }
                    finally {
                        if (output != null) {
                            output.flush();
                            ((OutputStream)output).close();
                        }
                    }
                }
                status = FileEntryStatuses.UNSPECIFIED_NAME;
                InputStream in = item.openStream();
                while (in.read(buffer) >= 0) {
                }
            }
            catch (Exception e) {
                if (status == FileEntryStatuses.UPLOADING || status == FileEntryStatuses.SUCCESS) {
                    status = FileEntryStatuses.INVALID;
                }
                if (!facesContext.isProjectStage(ProjectStage.Development)) break block35;
                log.log(Level.SEVERE, "Problem processing uploaded file", e);
            }
        }
        if (file != null && !status.isSuccess()) {
            file.delete();
            file = null;
        }
        if (results != null && fileInfo != null) {
            fileInfo.finish(file, fileSizeRead, status);
            results.addCompletedFile(fileInfo);
            if (callback != null) {
                try {
                    callback.end(fileInfo);
                }
                catch (RuntimeException e) {
                    status = FileEntryStatuses.PROBLEM_WITH_CALLBACK;
                    fileInfo.postfail(status);
                    FileEntryPhaseListener.handleCallbackException(facesContext, config.getClientId(), e);
                }
            }
        }
    }

    protected static FileEntryCallback evaluateCallback(FacesContext facesContext, FileEntryConfig config) {
        String callbackEL = config.getCallbackEL();
        FileEntryCallback callback = null;
        try {
            callback = (FileEntryCallback)facesContext.getApplication().evaluateExpressionGet(facesContext, callbackEL, FileEntryCallback.class);
            if (callbackEL != null && callback == null && facesContext.isProjectStage(ProjectStage.Development)) {
                log.warning("For the fileEntry component with the clientId of '" + config.getClientId() + "', the callback " + "property is set but resolves to null. This might " + "indicate an application error. The uploaded file " + "will be saved to the server file-system.");
            }
        }
        catch (ELException e) {
            if (facesContext.isProjectStage(ProjectStage.Development)) {
                log.log(Level.SEVERE, "For the fileEntry component with the clientId of '" + config.getClientId() + "'", e);
            }
            throw e;
        }
        return callback;
    }

    protected static void handleCallbackException(FacesContext facesContext, String clientId, RuntimeException e) {
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            log.log(Level.SEVERE, "An exception was thrown by the callback for the fileEntry component with clientId of '" + clientId + "'", e);
        }
    }

    protected static String calculateFolder(FacesContext facesContext, FileEntryConfig config) {
        String sessionId;
        String folder = null;
        folder = config.getAbsolutePath() != null && config.getAbsolutePath().length() > 0 ? config.getAbsolutePath() : CoreUtils.getRealPath((FacesContext)facesContext, (String)config.getRelativePath());
        if (folder == null) {
            folder = "";
        }
        if (config.isUseSessionSubdir() && (sessionId = CoreUtils.getSessionId((FacesContext)facesContext)) != null && sessionId.length() > 0) {
            String FILE_SEPARATOR = System.getProperty("file.separator");
            if (folder != null && folder.trim().length() > 0) {
                folder = folder + FILE_SEPARATOR;
            }
            folder = folder + sessionId;
        }
        return folder;
    }

    protected static File makeFile(FileEntryConfig config, String folder, String fileName) throws IOException {
        File file = null;
        File folderFile = new File(folder);
        if (!folderFile.exists()) {
            folderFile.mkdirs();
        }
        file = config.isUseOriginalFilename() ? new File(folderFile, fileName) : File.createTempFile("ice_file_", null, folderFile);
        return file;
    }

    protected static String trimInternetExplorerPath(String path) {
        String[] seps;
        for (String sep : seps = new String[]{File.separator, "/", "\\"}) {
            String ret = FileEntryPhaseListener.afterLast(path, sep);
            if (path.equals(ret)) continue;
            return ret;
        }
        return path;
    }

    protected static String afterLast(String str, String seek) {
        int index = str.lastIndexOf(seek);
        if (index >= 0) {
            return str.substring(index + seek.length());
        }
        return str;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileUploadRequestWrapper
    extends HttpServletRequestWrapper {
        private static final String FACES_REQUEST = "Faces-Request";
        private static final String PARTIAL_AJAX = "partial/ajax";
        private static final String CONTENT_TYPE = "content-type";
        private Map<String, String[]> parameterMap;

        public FileUploadRequestWrapper(HttpServletRequest httpServletRequest, Map<String, String[]> parameterMap) {
            super(httpServletRequest);
            this.parameterMap = parameterMap;
        }

        public String getHeader(String name) {
            if (name != null) {
                if (name.equals(FACES_REQUEST)) {
                    return PARTIAL_AJAX;
                }
                if (name.equals(CONTENT_TYPE)) {
                    return FileEntryPhaseListener.APPLICATION_FORM_URLENCODED;
                }
            }
            return super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            if (name != null) {
                if (name.equals(FACES_REQUEST)) {
                    Vector<String> list = new Vector<String>(1);
                    list.add(PARTIAL_AJAX);
                    return list.elements();
                }
                if (name.equals(CONTENT_TYPE)) {
                    Vector<String> list = new Vector<String>(1);
                    list.add(FileEntryPhaseListener.APPLICATION_FORM_URLENCODED);
                    return list.elements();
                }
            }
            return super.getHeaders(name);
        }

        public int getIntHeader(String name) {
            if (name != null) {
                if (name.equals(FACES_REQUEST)) {
                    throw new NumberFormatException("Can not convert Faces-Request to integer");
                }
                if (name.equals(CONTENT_TYPE)) {
                    throw new NumberFormatException("Can not convert content-type to integer");
                }
            }
            return super.getIntHeader(name);
        }

        public Enumeration<String> getHeaderNames() {
            Vector list = new Vector();
            Enumeration names = super.getHeaderNames();
            while (names != null && names.hasMoreElements()) {
                list.add(names.nextElement());
            }
            if (!list.contains(FACES_REQUEST)) {
                list.add(FACES_REQUEST);
            }
            if (!list.contains(CONTENT_TYPE)) {
                list.add(CONTENT_TYPE);
            }
            return list.elements();
        }

        public Map<String, String[]> getParameterMap() {
            if (this.parameterMap != null) {
                return Collections.unmodifiableMap(this.parameterMap);
            }
            return super.getParameterMap();
        }

        public Enumeration<String> getParameterNames() {
            if (this.parameterMap != null) {
                Vector<String> keyVec = new Vector<String>(this.parameterMap.keySet());
                return keyVec.elements();
            }
            return super.getParameterNames();
        }

        public String getParameter(String name) {
            if (this.parameterMap != null) {
                if (!this.parameterMap.containsKey(name)) {
                    return null;
                }
                String[] values = this.parameterMap.get(name);
                if (values != null && values.length >= 1) {
                    return values[0];
                }
                return null;
            }
            return super.getParameter(name);
        }

        public String[] getParameterValues(String name) {
            if (this.parameterMap != null) {
                if (!this.parameterMap.containsKey(name)) {
                    return null;
                }
                return this.parameterMap.get(name);
            }
            return super.getParameterValues(name);
        }

        public String getContentType() {
            return FileEntryPhaseListener.APPLICATION_FORM_URLENCODED;
        }
    }
}

