/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.fileentry.FileEntryStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileEntryResults
implements Serializable,
Cloneable {
    private ArrayList<FileInfo> fileInfos = new ArrayList(6);
    private boolean viaCallback;
    private long totalSize;

    FileEntryResults(boolean viaCallback) {
        this.viaCallback = viaCallback;
    }

    public ArrayList<FileInfo> getFiles() {
        return this.fileInfos;
    }

    public boolean isViaCallback() {
        return this.viaCallback;
    }

    public Object clone() {
        FileEntryResults results = new FileEntryResults(this.viaCallback);
        int numFileEntries = this.fileInfos.size();
        results.fileInfos = new ArrayList(Math.max(1, numFileEntries));
        for (FileInfo fi : this.fileInfos) {
            results.fileInfos.add((FileInfo)fi.clone());
        }
        return results;
    }

    public String toString() {
        String pre = "FileEntryResults: {\n  viaCallback=" + this.viaCallback + ",\n  totalSize=" + this.totalSize + ",\n  files:\n";
        StringBuilder mid = new StringBuilder();
        for (FileInfo fi : this.fileInfos) {
            mid.append(fi.toString());
        }
        String post = "\n}";
        return pre + mid + post;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof FileEntryResults)) {
            return false;
        }
        FileEntryResults results = (FileEntryResults)ob;
        if (this.viaCallback != results.viaCallback) {
            return false;
        }
        if (this.fileInfos == null && results.fileInfos != null || this.fileInfos != null && results.fileInfos == null) {
            return false;
        }
        if (this.fileInfos != null) {
            int isz;
            int sz = this.fileInfos.size();
            if (sz != (isz = results.fileInfos.size())) {
                return false;
            }
            for (int i = 0; i < sz; ++i) {
                FileInfo ifi;
                FileInfo fi = this.fileInfos.get(i);
                if (fi.equals(ifi = results.fileInfos.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    void addCompletedFile(FileInfo fileInfo) {
        this.fileInfos.add(fileInfo);
        this.totalSize += fileInfo.getSize();
    }

    long getAvailableTotalSize(long maxTotalSize) {
        return Math.max(0L, maxTotalSize - this.totalSize);
    }

    boolean isLifecycleAndUploadsSuccessful(FacesContext context) {
        if (context.isValidationFailed()) {
            return false;
        }
        for (FileInfo fi : this.fileInfos) {
            if (fi.isSaved()) continue;
            return false;
        }
        return true;
    }

    public static class FileInfo
    implements Serializable,
    Cloneable {
        private String fileName;
        private String contentType;
        private File file;
        private long size;
        private FileEntryStatus status;

        FileInfo() {
        }

        void begin(String fileName, String contentType) {
            this.fileName = fileName;
            this.contentType = contentType;
        }

        void prefail(FileEntryStatus status) {
            this.status = status;
        }

        void postfail(FileEntryStatus status) {
            this.status = status;
        }

        void finish(File file, long size, FileEntryStatus status) {
            this.file = file;
            this.size = size;
            this.status = status;
        }

        public void updateStatus(FileEntryStatus newStatus, boolean invalidate, boolean deleteFile) {
            this.updateStatus(newStatus, invalidate);
            if (deleteFile && this.file != null && this.file.exists()) {
                this.file.delete();
            }
        }

        public void updateStatus(FileEntryStatus newStatus, boolean invalidate) {
            if (newStatus != null) {
                this.status = newStatus;
            }
            if (invalidate) {
                FacesContext context = FacesContext.getCurrentInstance();
                context.validationFailed();
                context.renderResponse();
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getContentType() {
            return this.contentType;
        }

        public File getFile() {
            return this.file;
        }

        public long getSize() {
            return this.size;
        }

        public FileEntryStatus getStatus() {
            return this.status;
        }

        public boolean isSaved() {
            return this.status.isSuccess();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            if (this.fileName != null ? !this.fileName.equals(fileInfo.fileName) : fileInfo.fileName != null) {
                return false;
            }
            if (this.contentType != null ? !this.contentType.equals(fileInfo.contentType) : fileInfo.contentType != null) {
                return false;
            }
            if (this.file != null ? !this.file.equals(fileInfo.file) : fileInfo.file != null) {
                return false;
            }
            if (this.size != fileInfo.size) {
                return false;
            }
            return this.status == fileInfo.status;
        }

        public int hashCode() {
            int result = (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }

        public Object clone() {
            FileInfo fileInfo = new FileInfo();
            fileInfo.fileName = this.fileName;
            fileInfo.contentType = this.contentType;
            fileInfo.file = this.file;
            fileInfo.size = this.size;
            fileInfo.status = this.status;
            return fileInfo;
        }

        public String toString() {
            return "FileEntryResults.FileInfo: {\n  fileName=" + this.fileName + ",\n  contentType=" + this.contentType + ",\n  file=" + this.file + ",\n  size=" + this.size + ",\n  status=" + this.status + "\n}";
        }
    }
}

