/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.menu;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.menu.AbstractMenu;
import org.icefaces.ace.component.menu.BaseMenuRenderer;
import org.icefaces.ace.component.menu.Menu;
import org.icefaces.ace.component.menuitem.MenuItem;
import org.icefaces.ace.component.submenu.Submenu;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="menu", value="org.icefaces.ace.component.menu.Menu")
public class MenuRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        String widgetVar = this.resolveWidgetVar((UIComponent)menu);
        String position = menu.getPosition();
        String type = menu.getType();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSONBuilder json = JSONBuilder.create();
        writer.write(widgetVar + " = new ");
        json.beginFunction("ice.ace.Menu").item(clientId).beginMap().entry("position", menu.getPosition()).entry("zindex", menu.getZindex()).beginMap("animation").entry("animated", menu.getEffect()).entry("duration", menu.getEffectDuration()).endMap();
        if (type.equalsIgnoreCase("sliding")) {
            json.entry("mode", "sliding").entry("backLinkText", menu.getBackLabel()).entry("maxHeight", menu.getMaxHeight());
        }
        if (position.equalsIgnoreCase("dynamic")) {
            json.entry("my", menu.getMy()).entry("at", menu.getAt());
            UIComponent trigger = menu.findComponent(menu.getTrigger());
            if (trigger != null) {
                json.entry("trigger", trigger.getClientId(context)).entry("triggerEvent", menu.getTriggerEvent());
            } else {
                json.entry("trigger", menu.getTrigger());
            }
        }
        json.entryNonNullValue("styleClass", menu.getStyleClass()).entryNonNullValue("style", menu.getStyle()).endMap().endFunction();
        writer.write(json.toString());
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        boolean tiered = menu.isTiered() || !menu.getType().equalsIgnoreCase("plain");
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
        if (tiered) {
            this.encodeTieredMenuContent(context, (UIComponent)menu);
        } else {
            this.encodePlainMenuContent(context, (UIComponent)menu);
        }
        writer.endElement("ul");
        writer.endElement("span");
    }

    protected void encodeTieredMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement("li", null);
            if (child instanceof MenuItem) {
                this.encodeMenuItem(context, (MenuItem)child);
            } else if (child instanceof Submenu) {
                this.encodeTieredSubmenu(context, (Submenu)child);
            }
            writer.endElement("li");
        }
    }

    protected void encodeTieredSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String label = submenu.getLabel();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
            writer.endElement("span");
        }
        if (label != null) {
            writer.startElement("span", null);
            String style = submenu.getStyle();
            if (style != null && style.trim().length() > 0) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            Utils.writeConcatenatedStyleClasses(writer, "wijmo-wijmenu-text", submenu.getStyleClass());
            writer.write(submenu.getLabel());
            writer.endElement("span");
        }
        writer.endElement("a");
        if (submenu.getChildCount() > 0) {
            writer.startElement("ul", null);
            this.encodeTieredMenuContent(context, (UIComponent)submenu);
            writer.endElement("ul");
        }
    }

    protected void encodePlainMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (child instanceof MenuItem) {
                writer.startElement("li", null);
                this.encodeMenuItem(context, (MenuItem)child);
                writer.endElement("li");
                continue;
            }
            if (!(child instanceof Submenu)) continue;
            this.encodePlainSubmenu(context, (Submenu)child);
        }
    }

    protected void encodePlainSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        writer.startElement("li", null);
        writer.startElement("h3", null);
        if (label != null) {
            String style = submenu.getStyle();
            if (style != null && style.trim().length() > 0) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            Utils.writeConcatenatedStyleClasses(writer, "", submenu.getStyleClass());
            writer.write(label);
        }
        writer.endElement("h3");
        writer.endElement("li");
        this.encodePlainMenuContent(context, (UIComponent)submenu);
    }
}

