/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.tableconfigpanel;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.tableconfigpanel.TableConfigPanel;
import org.icefaces.ace.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableConfigPanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TableConfigPanel panel = (TableConfigPanel)component;
        this.encodePopup(context, panel);
        super.encodeEnd(context, component);
    }

    private void encodePopup(FacesContext context, TableConfigPanel component) throws IOException {
        DataTable table = component.getTargetedDatatable();
        String tableId = table.getClientId(context);
        String clientId = component.getClientId(context);
        String jsId = this.resolveWidgetVar((UIComponent)component);
        ResponseWriter writer = context.getResponseWriter();
        List<Column> columns = table.getColumns();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"ui-tableconf ui-widget", null);
        writer.writeAttribute("style", (Object)"display:none;", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-tableconf-header ui-widget-header ui-corner-tr ui-corner-tl", null);
        writer.writeText((Object)"Column Settings", null);
        this.writeConfigPanelOkButton(writer, clientId);
        this.writeConfigPanelCloseButton(writer, clientId, jsId);
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-tableconf-body ui-widget-content ui-corner-br ui-corner-bl", null);
        writer.startElement("table", null);
        this.writeHeaderRow(writer, component);
        writer.startElement("tbody", null);
        this.writeColumnConfigRows(writer, component, clientId, columns);
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("div");
        this.writeJavascript(writer, clientId, tableId, component);
        writer.endElement("div");
    }

    private void writeColumnConfigRows(ResponseWriter writer, TableConfigPanel component, String tableId, List<Column> columns) throws IOException {
        boolean ordering = component.isColumnOrderingConfigurable();
        boolean naming = component.isColumnNameConfigurable();
        boolean sizing = false;
        boolean visibility = component.isColumnVisibilityConfigurable();
        boolean sorting = component.isColumnSortingConfigurable();
        boolean firstCol = component.getType().equals("first-col");
        boolean lastCol = component.getType().equals("last-col");
        List columnOrdering = component.getTargetedDatatable().getColumnOrdering();
        for (int i = 0; i < columns.size(); ++i) {
            boolean disableVisibilityControl;
            Column column = columns.get(i);
            String rowClass = "ui-tableconf-row-" + columnOrdering.get(i);
            if (!column.isConfigurable()) {
                rowClass = rowClass + " ui-disabled ui-opacity-40";
            }
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)rowClass, null);
            if (!column.isConfigurable() && component.isHideDisabledRows()) {
                writer.writeAttribute("style", (Object)"display:none;", null);
            }
            boolean bl = disableVisibilityControl = firstCol && i == 0 || lastCol && i == columns.size() - 1;
            if (ordering) {
                this.writeColumnOrderingControl(writer, column, i, tableId);
            }
            this.writeColumnNameControl(writer, column, i, tableId, naming);
            if (sizing) {
                this.writeColumnSizingControl(writer, column, i, tableId);
            }
            if (visibility) {
                this.writeColumnVisibilityControl(writer, column, i, tableId, disableVisibilityControl);
            }
            if (sorting) {
                this.writeSortControl(writer, column);
            }
            writer.endElement("tr");
        }
    }

    private void writeHeaderRow(ResponseWriter writer, TableConfigPanel component) throws IOException {
        writer.startElement("thead", null);
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"ui-state-default", null);
        writer.writeAttribute("style", (Object)"border:0;", null);
        if (component.isColumnOrderingConfigurable()) {
            writer.startElement("th", null);
            writer.writeText((Object)"Ordering", null);
            writer.endElement("th");
        }
        writer.startElement("th", null);
        writer.writeText((Object)"Name", null);
        writer.endElement("th");
        if (component.isColumnVisibilityConfigurable()) {
            writer.startElement("th", null);
            writer.writeText((Object)"Visibility", null);
            writer.endElement("th");
        }
        if (component.isColumnSortingConfigurable()) {
            writer.startElement("th", null);
            writer.writeText((Object)"Sorting", null);
            writer.endElement("th");
        }
        writer.endElement("tr");
        writer.endElement("thead");
    }

    private void writeConfigPanelOkButton(ResponseWriter writer, String clientId) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("style", (Object)"float:right;", null);
        writer.startElement("a", null);
        String style = "display:inline-block; padding:2px 4px 4px 2px; margin:0px 2px; text-align:left;";
        writer.writeAttribute("style", (Object)style, null);
        writer.writeAttribute("class", (Object)"ui-state-default ui-corner-all", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)("ice.ace.jq(ice.ace.escapeClientId('" + clientId + "')).toggle()"), null);
        writer.writeAttribute("id", (Object)(clientId + "_tableconf_ok"), null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-check", null);
        writer.writeText((Object)"table", null);
        writer.endElement("span");
        writer.endElement("a");
        writer.endElement("span");
    }

    private void writeConfigPanelCloseButton(ResponseWriter writer, String clientId, String jsId) throws IOException {
        writer.startElement("span", null);
        writer.writeAttribute("style", (Object)"float:right;", null);
        writer.startElement("a", null);
        String style = "display:inline-block; padding:2px 4px 4px 2px; margin:0px 2px; text-align:left;";
        writer.writeAttribute("style", (Object)style, null);
        writer.writeAttribute("class", (Object)"ui-state-default ui-corner-all", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("onclick", (Object)("ice.ace.jq(ice.ace.escapeClientId('" + clientId + "')).toggle(); if (" + jsId + ".behavior) if (" + jsId + ".behavior.close) " + jsId + ".behavior.close();"), null);
        writer.writeAttribute("id", (Object)(clientId + "_tableconf_close"), null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
        writer.writeText((Object)"table", null);
        writer.endElement("span");
        writer.endElement("a");
        writer.endElement("span");
    }

    private void writeJavascript(ResponseWriter writer, String clientId, String tableId, TableConfigPanel component) throws IOException {
        String jsId = this.resolveWidgetVar((UIComponent)component);
        boolean isSortable = component.isColumnSortingConfigurable();
        boolean isReorderable = component.isColumnOrderingConfigurable();
        boolean isSingleSort = component.getTargetedDatatable().isSingleSort();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)("ice.ace.jq(function () {\n\tice.ace.jq(ice.ace.escapeClientId(\"" + clientId + "_tableconf_ok\"))" + ".hover(function (event) {ice.ace.jq(event.currentTarget)" + ".toggleClass('ui-state-hover');})" + ".click(function (event) {ice.ace.jq(ice.ace.escapeClientId(\"" + clientId + "_tableconf_launch\")).toggleClass('ui-state-active');\n" + "var panel = ice.ace.jq(ice.ace.escapeClientId('" + clientId + "'));\n" + "if (panel.is(':not(:visible)')) " + jsId + ".submitTableConfig(event.currentTarget);\n" + "}\n" + ");\n" + "\tice.ace.jq(ice.ace.escapeClientId(\"" + clientId + "_tableconf_close\"))" + ".hover(function (event) {ice.ace.jq(event.currentTarget)" + ".toggleClass('ui-state-hover');})" + ".click(function (event) {ice.ace.jq(ice.ace.escapeClientId(\"" + clientId + "_tableconf_launch\")).toggleClass('ui-state-active');});\n" + "\t var cfg = {reorderable :" + isReorderable + ", sortable :" + isSortable + ", singleSort:" + isSingleSort + ", tableId:'" + tableId + "'"), null);
        this.encodeClientBehaviors(FacesContext.getCurrentInstance(), component);
        writer.writeText((Object)("};\t" + jsId + " = new ice.ace.TableConf('" + clientId + "', cfg);\n" + "});"), null);
        writer.endElement("script");
    }

    private void writeSortControl(ResponseWriter writer, Column column) throws IOException {
        writer.startElement("td", null);
        if (column.getValueExpression("sortBy") != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-tableconf-sort-cont", null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-sortable-control", null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-sortable-column-icon", null);
            writer.startElement("a", null);
            if (column.getSortPriority() != null && column.isSortAscending()) {
                writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-n ui-toggled", null);
            } else {
                writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-n", null);
            }
            writer.writeAttribute("tabindex", (Object)0, null);
            writer.endElement("a");
            writer.startElement("a", null);
            if (column.getSortPriority() != null && !column.isSortAscending()) {
                writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s ui-toggled", null);
            } else {
                writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
            }
            writer.writeAttribute("tabindex", (Object)0, null);
            writer.endElement("a");
            writer.endElement("span");
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-sortable-column-order", null);
            if (column.getSortPriority() != null) {
                writer.writeText((Object)column.getSortPriority(), null);
            } else {
                writer.write("&#160;");
            }
            writer.endElement("span");
            writer.endElement("span");
            writer.endElement("span");
        }
        writer.endElement("td");
    }

    private void writeColumnOrderingControl(ResponseWriter writer, Column column, int i, String tableId) throws IOException {
        writer.startElement("td", null);
        writer.startElement("a", null);
        String style = "display:inline-block; padding:0 1px 0 0; margin:0px 10px; text-align:left;";
        String styleClass = "ui-state-default ui-corner-all ui-sortable-handle";
        if (!column.isConfigurable()) {
            styleClass = styleClass + " ui-disabled";
        }
        writer.writeAttribute("style", (Object)style, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("id", (Object)(tableId + "_tableconf_close"), null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-arrow-2-n-s", null);
        writer.writeText((Object)"table", null);
        writer.endElement("span");
        writer.endElement("a");
        writer.endElement("td");
    }

    private void writeColumnSizingControl(ResponseWriter writer, Column column, int i, String clientId) throws IOException {
        writer.writeText((Object)"DataTable Settings", null);
    }

    private void writeColumnVisibilityControl(ResponseWriter writer, Column column, int i, String clientId, boolean disable) throws IOException {
        writer.startElement("td", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (disable || !column.isConfigurable()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.writeAttribute("name", (Object)(clientId + "_colvis_" + i), null);
        if (column.isRendered()) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        writer.endElement("input");
        writer.endElement("td");
    }

    private void writeColumnNameControl(ResponseWriter writer, Column column, int i, String clientId, boolean naming) throws IOException {
        writer.startElement("td", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        if (!naming || !column.isConfigurable()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.writeAttribute("name", (Object)(clientId + "_head_" + i), null);
        writer.writeAttribute("value", (Object)column.getHeaderText(), null);
        writer.endElement("input");
        writer.endElement("td");
    }
}

