/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.accordion;

import java.io.Serializable;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.icefaces.ace.component.accordion.AccordionBase;
import org.icefaces.ace.component.accordion.AccordionPane;
import org.icefaces.ace.event.AccordionPaneChangeEvent;

public class Accordion
extends AccordionBase {
    private static final String OPTIMIZED_PACKAGE = "org.icefaces.ace.component.";

    public boolean isTabChangeRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_tabChange");
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.isTabChangeRequest(context) || this.isContentLoadRequest(context);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        MethodExpression me = this.getPaneChangeListener();
        if (me != null && event instanceof AccordionPaneChangeEvent) {
            me.invoke(facesContext.getELContext(), new Object[]{event});
        }
    }

    public AccordionPane findTabToLoad(FacesContext context) {
        String newTabId = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_newTab");
        for (UIComponent component : this.getChildren()) {
            if (!component.getClientId().equals(newTabId)) continue;
            return (AccordionPane)component;
        }
        return null;
    }

    public void processDecodes(FacesContext context) {
        if (this.isSelfRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        ValueExpression expr;
        if (!this.isSelfRequest(context)) {
            super.processUpdates(context);
        }
        if ((expr = this.getValueExpression("activeIndex")) != null) {
            expr.setValue(this.getFacesContext().getELContext(), (Object)this.getActiveIndex());
            this.resetActiveIndex();
        }
    }

    protected void resetActiveIndex() {
        this.getStateHelper().remove((Serializable)((Object)AccordionBase.PropertyKeys.activeIndex));
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }
}

