/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.chart;

import java.io.Serializable;
import java.util.Date;
import org.icefaces.ace.component.chart.AxisType;
import org.icefaces.ace.util.JSONBuilder;

public class Axis
implements Serializable {
    private Boolean forceTickAt0;
    private Boolean forceTickAt100;
    private Boolean show;
    private String label;
    private Object min;
    private Object max;
    private Boolean autoscale;
    private Boolean sortMergedLabels;
    private Boolean drawMajorGridlines;
    private String[] ticks;
    private Integer tickAngle;
    private String tickFontSize;
    private AxisType type;
    private Double pad;
    private Double padMin;
    private Double padMax;
    private String formatString;
    private String tickInterval;
    private String tickPrefix;

    public String toString() {
        JSONBuilder json = JSONBuilder.create();
        Object max = this.getMax();
        Object min = this.getMin();
        Double pad = this.getPad();
        Double padMin = this.getPadMin();
        Double padMax = this.getPadMax();
        Boolean show = this.getShow();
        Integer tickAngle = this.getTickAngle();
        Boolean autoscale = this.getAutoscale();
        String tickInterval = this.getTickInterval();
        String[] ticks = this.getTicks();
        Boolean drawMajorGridlines = this.getDrawMajorGridlines();
        json.beginMap();
        if (this.label != null) {
            json.entry("label", this.label);
        }
        if (drawMajorGridlines != null) {
            json.entry("drawMajorGridLines", drawMajorGridlines);
        }
        if (max != null) {
            if (max instanceof Number) {
                json.entry("max", ((Number)max).doubleValue());
            } else if (max instanceof Date) {
                json.entry("max", ((Date)max).getTime());
            } else {
                json.entry("max", max.toString());
            }
        }
        if (min != null) {
            if (min instanceof Number) {
                json.entry("min", ((Number)min).doubleValue());
            } else if (min instanceof Date) {
                json.entry("min", ((Date)min).getTime());
            } else {
                json.entry("min", min.toString());
            }
        }
        if (show != null) {
            json.entry("show", show);
        }
        if (autoscale != null) {
            json.entry("autoscale", autoscale);
        }
        if (pad != null) {
            json.entry("pad", pad);
        }
        if (padMin != null) {
            json.entry("padMin", padMin);
        }
        if (padMax != null) {
            json.entry("padMax", padMax);
        }
        if (this.type != null) {
            json.entry("renderer", this.type.toString(), true);
        }
        if (this.hasRendererOptionsSet()) {
            json.beginMap("rendererOptions");
            if (this.type == AxisType.CATEGORY && this.isSortMergedLabels() != null) {
                json.entry("sortMergedLabels", this.isSortMergedLabels());
            }
            if (this.isForceTickAt0() != null) {
                json.entry("forceTickAt0", this.isForceTickAt0());
            }
            if (this.isForceTickAt100() != null) {
                json.entry("forceTickAt100", this.isForceTickAt100());
            }
            json.endMap();
        }
        if (tickInterval != null) {
            json.entry("tickInterval", tickInterval);
        }
        if (ticks != null) {
            this.encodeTicks(json);
        }
        if (this.hasTickOptionsSet()) {
            if (this.getType() != AxisType.DATE) {
                json.entry("tickRenderer", "ice.ace.jq.jqplot.CanvasAxisTickRenderer", true);
            }
            this.encodeTickOptions(json);
        }
        json.endMap();
        return json.toString();
    }

    private void encodeTickOptions(JSONBuilder json) {
        json.beginMap("tickOptions");
        String fontSize = this.getTickFontSize();
        Integer angle = this.getTickAngle();
        String formatString = this.getFormatString();
        String prefix = this.getTickPrefix();
        if (prefix != null) {
            json.entry("prefix", prefix);
        }
        if (formatString != null) {
            json.entry("formatString", this.getFormatString());
        }
        if (angle != null) {
            json.entry("angle", angle);
        }
        if (fontSize != null) {
            json.entry("fontSize", fontSize);
        }
        json.endMap();
    }

    private boolean hasTickOptionsSet() {
        return this.getTickAngle() != null || this.getTickFontSize() != null || this.getTickPrefix() != null || this.getFormatString() != null;
    }

    private boolean hasRendererOptionsSet() {
        return this.type == AxisType.CATEGORY && this.sortMergedLabels != null || this.forceTickAt0 != null || this.forceTickAt100 != null || this.formatString != null;
    }

    private void encodeTicks(JSONBuilder json) {
        json.beginArray("ticks");
        Class tickType = null;
        for (String tick : this.getTicks()) {
            if (tickType == null) {
                if (tick instanceof Number) {
                    tickType = Number.class;
                } else if (tick instanceof String) {
                    tickType = String.class;
                } else if (tick instanceof Date) {
                    tickType = Date.class;
                }
            }
            if (tickType == Number.class) {
                json.item(((Number)((Object)tick)).doubleValue());
                continue;
            }
            if (tickType == String.class) {
                json.item(tick.toString());
                continue;
            }
            if (tickType != Date.class) continue;
            json.item(((Date)((Object)tick)).getTime());
        }
        json.endArray();
    }

    public Boolean isForceTickAt0() {
        return this.forceTickAt0;
    }

    public void setForceTickAt0(Boolean forceTickAt0) {
        this.forceTickAt0 = forceTickAt0;
    }

    public Boolean isForceTickAt100() {
        return this.forceTickAt100;
    }

    public void setForceTickAt100(Boolean forceTickAt100) {
        this.forceTickAt100 = forceTickAt100;
    }

    public Boolean getShow() {
        return this.show;
    }

    public void setShow(Boolean show) {
        this.show = show;
    }

    public Object getMin() {
        return this.min;
    }

    public void setMin(Object min) {
        this.min = min;
    }

    public Object getMax() {
        return this.max;
    }

    public void setMax(Object max) {
        this.max = max;
    }

    public AxisType getType() {
        return this.type;
    }

    public void setType(AxisType type) {
        this.type = type;
    }

    public String[] getTicks() {
        return this.ticks;
    }

    public void setTicks(String[] ticks) {
        this.ticks = ticks;
    }

    public Boolean isSortMergedLabels() {
        return this.sortMergedLabels;
    }

    public void setSortMergedLabels(Boolean sortMergedLabels) {
        this.sortMergedLabels = sortMergedLabels;
    }

    public Double getPad() {
        return this.pad;
    }

    public void setPad(Double pad) {
        this.pad = pad;
    }

    public Double getPadMax() {
        return this.padMax;
    }

    public void setPadMax(Double padMax) {
        this.padMax = padMax;
    }

    public Double getPadMin() {
        return this.padMin;
    }

    public void setPadMin(Double padMin) {
        this.padMin = padMin;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Integer getTickAngle() {
        return this.tickAngle;
    }

    public void setTickAngle(Integer tickAngle) {
        this.tickAngle = tickAngle;
    }

    public String getTickFontSize() {
        return this.tickFontSize;
    }

    public void setTickFontSize(String tickFontSize) {
        this.tickFontSize = tickFontSize;
    }

    public Boolean getAutoscale() {
        return this.autoscale;
    }

    public void setAutoscale(Boolean autoscale) {
        this.autoscale = autoscale;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getTickInterval() {
        return this.tickInterval;
    }

    public void setTickInterval(String tickInterval) {
        this.tickInterval = tickInterval;
    }

    public String getTickPrefix() {
        return this.tickPrefix;
    }

    public void setTickPrefix(String tickPrefix) {
        this.tickPrefix = tickPrefix;
    }

    public Boolean getDrawMajorGridlines() {
        return this.drawMajorGridlines;
    }

    public void setDrawMajorGridlines(Boolean drawMajorGridlines) {
        this.drawMajorGridlines = drawMajorGridlines;
    }
}

