/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datatable;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.columngroup.ColumnGroup;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.datatable.DataTableRendererUtil;
import org.icefaces.ace.component.row.Row;

public class DataTableFootRenderer {
    protected static void encodeTableFoot(FacesContext context, DataTable table, List<Column> columns, boolean staticHeaders) throws IOException {
        boolean shouldRender;
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = table.getColumnGroup("footer");
        boolean bl = shouldRender = table.hasFooterColumn(columns) || group != null;
        if (!shouldRender) {
            return;
        }
        if (staticHeaders) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datatable-scrollable-footer", null);
            writer.startElement("table", null);
        }
        writer.startElement("tfoot", null);
        if (table.isInDuplicateSegment().booleanValue()) {
            writer.writeAttribute("style", (Object)"display:none;", null);
        }
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row footerRow = (Row)child;
                writer.startElement("tr", null);
                List footerRowChildren = footerRow.getChildren();
                for (UIComponent footerRowChild : footerRowChildren) {
                    if (!footerRowChild.isRendered() || !(footerRowChild instanceof Column)) continue;
                    DataTableFootRenderer.encodeColumnFooter(context, table, footerRowChildren, (Column)footerRowChild, true);
                }
                writer.endElement("tr");
            }
        } else {
            writer.startElement("tr", null);
            for (Column column : columns) {
                DataTableFootRenderer.encodeColumnFooter(context, table, columns, column, false);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
        if (staticHeaders) {
            writer.endElement("table");
            writer.endElement("div");
        }
    }

    private static void encodeColumnFooter(FacesContext context, DataTable table, List columnSiblings, Column column, boolean subRows) throws IOException {
        boolean isNextStacked;
        ResponseWriter writer = context.getResponseWriter();
        Column nextColumn = DataTableRendererUtil.getNextColumn(column, columnSiblings);
        boolean isCurrStacked = DataTableRendererUtil.isCurrColumnStacked(columnSiblings, column);
        boolean bl = nextColumn == null ? false : (isNextStacked = nextColumn.isRendered() && nextColumn.isStacked());
        if (!isCurrStacked) {
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            String footerClass = styleClass != null ? "ui-widget-header " + styleClass : "ui-widget-header";
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)footerClass, null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (column.getRowspan() != 1) {
                writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
            }
            if (column.getColspan() != 1) {
                writer.writeAttribute("colspan", (Object)column.getColspan(), null);
            }
        } else {
            writer.startElement("hr", null);
            writer.endElement("hr");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-footer-column", null);
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (facet != null) {
            facet.encodeAll(context);
        } else if (text != null) {
            writer.write(text);
        } else if (subRows) {
            for (UIComponent c : column.getChildren()) {
                c.encodeAll(context);
            }
        }
        writer.endElement("div");
        if (!isNextStacked) {
            writer.endElement("td");
        } else if (subRows) {
            if (!DataTableRendererUtil.areBothSingleColumnSpan(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked footer columns, with colspan values greater than 1.");
            }
            if (!DataTableRendererUtil.isNextColumnRowSpanEqual(column, nextColumn)) {
                throw new FacesException("DataTable : \"" + table.getClientId(context) + "\" must not have stacked footer columns, with unequal rowspan values.");
            }
        }
    }
}

