/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datatable;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.datatable.DataTableDecoder;
import org.icefaces.ace.component.datatable.DataTableFootRenderer;
import org.icefaces.ace.component.datatable.DataTableHeadRenderer;
import org.icefaces.ace.component.datatable.DataTableRowRenderer;
import org.icefaces.ace.component.tableconfigpanel.TableConfigPanel;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="dataTable", value="org.icefaces.ace.component.datatable.DataTable")
public class DataTableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        DataTable table = (DataTable)component;
        if (table.isSelectionEnabled()) {
            DataTableDecoder.decodeSelection(context, table);
        }
        if (table.isFilterRequest(context)) {
            DataTableDecoder.decodeFilters(context, table);
        } else if (table.isSortRequest(context)) {
            DataTableDecoder.decodeSortRequest(context, table, null, null);
        } else if (table.isPaginationRequest(context)) {
            DataTableDecoder.decodePageRequest(context, table);
        } else if (table.isColumnReorderRequest(context)) {
            DataTableDecoder.decodeColumnReorderRequest(context, table);
        } else if (table.isTableConfigurationRequest(context)) {
            DataTableDecoder.decodeTableConfigurationRequest(context, table);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        if (table.isPaginator()) {
            table.calculatePage();
        }
        if (table.isSortOrderChanged().booleanValue()) {
            table.processSorting();
        }
        if (table.isFilterValueChanged().booleanValue()) {
            table.setFilteredData(table.processFilters(context));
        }
        table.setModel(null);
        if (table.isScrollingRequest(context)) {
            this.encodeLiveRows(context, table);
        } else {
            this.encodeEntirety(context, table);
        }
    }

    private void encodeEntirety(FacesContext context, DataTable table) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String style = null;
        String paginatorPosition = table.getPaginatorPosition();
        String containerClass = "ui-datatable ui-widget";
        boolean hasPaginator = table.isPaginator();
        boolean staticHeaders = table.isScrollable() && table.isStaticHeaders() != false;
        table.getStateMap();
        if (staticHeaders) {
            containerClass = containerClass + " ui-datatable-scrollable";
        }
        if ((styleClass = table.getStyleClass()) != null) {
            containerClass = containerClass + " " + styleClass;
        }
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        style = table.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, table, table.getHeader(), "ui-datatable-header ui-widget-header ui-corner-tl ui-corner-tr");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            this.encodePaginatorMarkup(context, table, "top");
        }
        this.encodeConfigPanel(context, table);
        this.encodeTable(context, table, staticHeaders);
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            this.encodePaginatorMarkup(context, table, "bottom");
        }
        this.encodeFacet(context, table, table.getFooter(), "ui-datatable-footer ui-widget-header ui-corner-bl ui-corner-br");
        if (table.isSelectionEnabled()) {
            this.encodeSelectionAndDeselectionHolder(context, table);
        }
        this.encodeScript(context, table);
        table.clearCachedStateMap();
        if ("true".equals(context.getExternalContext().getInitParameter("ForceFullTableDOMUpdates"))) {
            writer.startElement("div", null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            writer.writeText((Object)table.getForcedUpdateCounter(), null);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    private void encodeTable(FacesContext context, DataTable table, boolean staticHeaders) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<Column> columns = table.getColumns();
        if (!staticHeaders) {
            Integer height;
            writer.startElement("div", null);
            if (table.isScrollable() && (height = table.getScrollHeight()) != null) {
                writer.writeAttribute("style", (Object)("max-height:" + height + "px; overflow:auto;"), null);
            }
            writer.startElement("table", null);
        }
        DataTableHeadRenderer.encodeTableHead(context, table, columns, staticHeaders);
        this.encodeTableBody(context, table, columns, staticHeaders);
        DataTableFootRenderer.encodeTableFoot(context, table, columns, staticHeaders);
        if (!staticHeaders) {
            writer.endElement("table");
            writer.endElement("div");
        }
    }

    private void encodeTableBody(FacesContext context, DataTable table, List<Column> columns, boolean scrollable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        if (scrollable) {
            writer.startElement("div", null);
            String scrollClass = "ui-datatable-scroll-x ui-datatable-scrollable-body";
            writer.writeAttribute("class", (Object)scrollClass, null);
            writer.writeAttribute("style", (Object)("max-height:" + table.getScrollHeight() + "px"), null);
            writer.startElement("table", null);
            if (table.hasHeaders()) {
                table.setInDuplicateSegment(true);
                DataTableHeadRenderer.encodeTableHead(context, table, columns, false);
                table.setInDuplicateSegment(false);
            }
        }
        if (table.isLazy()) {
            table.loadLazyData();
        }
        int rows = table.getRows();
        int first = table.getFirst();
        int page = table.getPage();
        int rowCount = table.getRowCount();
        int rowCountToRender = rows == 0 ? rowCount : rows;
        boolean renderedTopVisible = false;
        boolean hasData = rowCount > 0;
        String tbodyClass = hasData ? "ui-datatable-data ui-widget-content" : "ui-datatable-data-empty";
        writer.startElement("tbody", null);
        writer.writeAttribute("class", (Object)tbodyClass, null);
        Map rowToSelectedFieldsMap = table.getRowToSelectedFieldsMap();
        if (hasData) {
            for (int i = first; i < first + rowCountToRender; ++i) {
                if (!DataTableRowRenderer.encodeRow(context, table, columns, rowToSelectedFieldsMap, clientId, i, null, rowIndexVar, renderedTopVisible)) continue;
                renderedTopVisible = true;
            }
        } else {
            this.encodeEmptyMessage(table, writer, columns);
        }
        writer.endElement("tbody");
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
        if (scrollable) {
            table.setInDuplicateSegment(true);
            DataTableFootRenderer.encodeTableFoot(context, table, columns, false);
            table.setInDuplicateSegment(false);
            writer.endElement("table");
            writer.endElement("div");
        }
    }

    private void encodeFacet(FacesContext context, DataTable table, UIComponent facet, String styleClass) throws IOException {
        if (facet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String filterEvent = table.getFilterEvent();
        UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)table);
        JSONBuilder json = new JSONBuilder();
        if (form == null) {
            throw new FacesException("DataTable : \"" + clientId + "\" must be inside a form element.");
        }
        boolean paging = table.isPaginator();
        boolean select = table.isSelectionEnabled();
        boolean dblSelect = select && table.isDoubleClickSelect();
        boolean ajaxSelect = select && table.hasSelectionClientBehaviour() || table.getRowSelectListener() != null || table.getRowUnselectListener() != null;
        boolean rowExp = table.getRowExpansion() != null;
        boolean pnlExp = table.getPanelExpansion() != null;
        boolean clkHdrSrt = table.isClickableHeaderSorting();
        boolean resize = table.isResizableColumns();
        boolean reorder = table.isReorderableColumns();
        boolean snglSrt = table.isSingleSort();
        boolean disable = table.isDisabled();
        boolean scroll = table.isScrollable();
        boolean hiddenScrollableSizing = table.isHiddenScrollableSizing();
        boolean height = scroll && table.getScrollHeight() != Integer.MIN_VALUE;
        boolean scrollIE8Like7 = Boolean.parseBoolean(context.getExternalContext().getInitParameter("org.icefaces.ace.datatable.scroll.ie8like7"));
        boolean noIEHover = Boolean.parseBoolean(context.getExternalContext().getInitParameter("org.icefaces.ace.datatable.selection.noiehover"));
        json.beginMap();
        json.entry("formId", form.getClientId(context));
        json.entry("filterEvent", filterEvent);
        json.entryNonNullValue("configPanel", table.getTableConfigPanel());
        if (paging) {
            this.encodePaginatorConfig(context, json, table);
        }
        if (pnlExp) {
            json.entry("panelExpansion", true);
        }
        if (rowExp) {
            json.entry("rowExpansion", true);
        }
        if (clkHdrSrt) {
            json.entry("clickableHeaderSorting", true);
        }
        if (height) {
            json.entry("height", table.getScrollHeight());
        }
        if (select) {
            json.entry("selectionMode", table.getSelectionMode());
        }
        if (dblSelect) {
            json.entry("dblclickSelect", true);
        }
        if (ajaxSelect) {
            json.entry("instantSelect", true);
        }
        if (resize) {
            json.entry("resizableColumns", true);
        }
        if (reorder) {
            json.entry("reorderableColumns", true);
        }
        if (snglSrt) {
            json.entry("singleSort", true);
        }
        if (disable) {
            json.entry("disable", true);
        }
        if (noIEHover) {
            json.entry("noiehover", true);
        }
        if (scroll) {
            json.entry("scrollable", true);
            json.entry("liveScroll", table.isLiveScroll());
            json.entry("scrollStep", table.getRows());
            json.entry("scrollLimit", table.getRowCount());
            json.entry("scrollIE8Like7", scrollIE8Like7);
            if (!hiddenScrollableSizing) {
                json.entry("disableHiddenSizing", true);
            }
        }
        this.encodeClientBehaviors(context, table, json);
        json.endMap();
        String widgetVar = DataTableRenderer.resolveWidgetVar((UIComponent)table);
        writer.startElement("script", (UIComponent)table);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("var " + widgetVar + " = new ice.ace.DataTable('" + clientId + "', " + json + ");");
        writer.endElement("script");
    }

    private void encodePaginatorConfig(FacesContext context, JSONBuilder scriptJson, DataTable table) throws IOException {
        String[] rowCountArray;
        JSONBuilder configJson = new JSONBuilder();
        String clientId = table.getClientId(context);
        String paginatorPosition = table.getPaginatorPosition();
        String paginatorContainers = paginatorPosition.equalsIgnoreCase("both") ? "'" + clientId + "_paginatortop','" + clientId + "_paginatorbottom'" : "'" + clientId + "_paginator" + paginatorPosition + "'";
        boolean disabled = table.isDisabled();
        String template = table.getPaginatorTemplate();
        String rowCounts = table.getRowsPerPageTemplate();
        String currPgTemplate = table.getCurrentPageReportTemplate();
        boolean notAlwaysVis = !table.isPaginatorAlwaysVisible();
        configJson.beginMap();
        configJson.entry("rowsPerPage", table.getRows());
        configJson.entry("totalRecords", table.getRowCount());
        configJson.entry("initialPage", table.getPage());
        configJson.entry("containers", "[" + paginatorContainers + "]", true);
        configJson.entryNonNullValue("template", template);
        configJson.entryNonNullValue("pageReportTemplate", currPgTemplate);
        if (notAlwaysVis) {
            configJson.entry("alwaysVisible", false);
        }
        if (disabled) {
            configJson.entry("pageLinks", 1);
        } else {
            configJson.entry("pageLinks", table.getPageCount());
        }
        if (rowCounts != null && !"".equals(rowCounts) && (rowCountArray = rowCounts.split(",")).length > 0) {
            configJson.beginArray("rowsPerPageOptions");
            for (String i : rowCountArray) {
                configJson.item(Integer.parseInt(i.trim()));
            }
            configJson.endArray();
        }
        configJson.endMap();
        scriptJson.entry("paginator", "new YAHOO.widget.Paginator(" + configJson + ")", true);
    }

    private void encodeConfigPanel(FacesContext context, DataTable table) throws IOException {
        for (UIComponent child : table.getChildren()) {
            if (!(child instanceof TableConfigPanel)) continue;
            child.encodeAll(context);
        }
    }

    private void encodeEmptyMessage(DataTable table, ResponseWriter writer, List<Column> columns) throws IOException {
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"", null);
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)columns.size(), null);
        String emptyMessage = table.getEmptyMessage();
        if (emptyMessage != null) {
            writer.write(emptyMessage);
        }
        writer.endElement("td");
        writer.endElement("tr");
    }

    private void encodePaginatorMarkup(FacesContext context, DataTable table, String position) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        String styleClass = "ui-paginator ui-paginator-" + position + " ui-widget-header";
        if (!position.equals("top") && table.getFooter() == null) {
            styleClass = styleClass + " ui-corner-bl ui-corner-br";
        } else if (!position.equals("bottom") && table.getHeader() == null) {
            styleClass = styleClass + " ui-corner-tl ui-corner-tr";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_paginator" + position), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        TableConfigPanel panel = table.findTableConfigPanel(context);
        if (panel != null && panel.getType().equals("paginator-button")) {
            DataTableHeadRenderer.encodeConfigPanelLaunchButton(writer, table, false);
        }
        writer.endElement("div");
    }

    private void encodeSelectionAndDeselectionHolder(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = table.getClientId(context) + "_selection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.endElement("input");
        id = table.getClientId(context) + "_deselection";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.endElement("input");
    }

    private void encodeLiveRows(FacesContext context, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int scrollOffset = Integer.parseInt((String)params.get(table.getClientId(context) + "_scrollOffset"));
        String clientId = table.getClientId(context);
        String rowIndexVar = table.getRowIndexVar();
        Map rowToSelectedFieldsMap = table.getRowToSelectedFieldsMap();
        Boolean topVisibleRowRendered = false;
        for (int i = scrollOffset; i < scrollOffset + table.getRows(); ++i) {
            if (!DataTableRowRenderer.encodeRow(context, table, table.getColumns(), rowToSelectedFieldsMap, clientId, i, null, rowIndexVar, topVisibleRowRendered)) continue;
            topVisibleRowRendered = true;
        }
    }
}

