/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.datatable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.DataModel;
import org.icefaces.ace.component.celleditor.CellEditor;
import org.icefaces.ace.component.column.Column;
import org.icefaces.ace.component.datatable.DataTable;
import org.icefaces.ace.component.datatable.DataTableRendererUtil;
import org.icefaces.ace.component.panelexpansion.PanelExpansion;
import org.icefaces.ace.component.row.Row;
import org.icefaces.ace.component.rowexpansion.RowExpansion;
import org.icefaces.ace.model.table.RowState;
import org.icefaces.ace.model.table.TreeDataModel;

public class DataTableRowRenderer {
    protected static boolean encodeRow(FacesContext context, DataTable table, List<Column> columns, Map<Object, List<String>> rowToSelectedFieldsMap, String clientId, int rowIndex, String parentIndex, String rowIndexVar, boolean topVisibleRowRendered) throws IOException {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return false;
        }
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
        }
        RowState rowState = table.getStateMap().get(table.getRowData());
        boolean selected = rowState.isSelected();
        boolean unselectable = !rowState.isSelectable();
        boolean expanded = rowState.isExpanded();
        boolean visible = rowState.isVisible();
        List<String> selectedCellExpressions = rowToSelectedFieldsMap != null ? rowToSelectedFieldsMap.get(table.getRowData()) : null;
        context.getExternalContext().getRequestMap().put(table.getRowStateVar(), rowState);
        if (visible) {
            String rowStyleClass;
            ResponseWriter writer = context.getResponseWriter();
            List<Row> leadingRows = table.getConditionalRows(rowIndex, true);
            for (Row r : leadingRows) {
                DataTableRowRenderer.encodeConditionalRow(context, r);
            }
            String userRowStyleClass = table.getRowStyleClass();
            String expandedClass = expanded ? "ui-expanded-row" : "";
            String unselectableClass = unselectable ? "ui-unselectable" : "";
            String string = rowStyleClass = rowIndex % 2 == 0 ? " ui-datatable-even" : " ui-datatable-odd";
            if (selected && table.getSelectionMode() != null) {
                rowStyleClass = rowStyleClass + " ui-selected ui-state-active";
            }
            if (userRowStyleClass != null) {
                rowStyleClass = rowStyleClass + " " + userRowStyleClass;
            }
            writer.startElement("tr", null);
            parentIndex = parentIndex != null ? parentIndex + "." : "";
            writer.writeAttribute("id", (Object)(clientId + "_row_" + parentIndex + rowIndex), null);
            writer.writeAttribute("class", (Object)(rowStyleClass + " " + expandedClass + " " + unselectableClass), null);
            writer.writeAttribute("tabindex", (Object)"0", null);
            boolean innerTdDivRequired = (table.isScrollable() || table.isResizableColumns()) & !topVisibleRowRendered;
            for (Column kid : columns) {
                if (!kid.isRendered()) continue;
                boolean cellSelected = false;
                if (selectedCellExpressions != null) {
                    ValueExpression ve;
                    ValueExpression valueExpression = ve = kid.getValueExpression("selectBy") != null ? kid.getValueExpression("selectBy") : kid.getValueExpression("value");
                    if (ve != null) {
                        cellSelected = selectedCellExpressions.contains(ve.getExpressionString());
                    }
                }
                DataTableRowRenderer.encodeRegularCell(context, columns, kid, cellSelected, innerTdDivRequired);
            }
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
            }
            writer.endElement("tr");
            if (expanded) {
                context.getExternalContext().getRequestMap().put(clientId + "_expandedRowId", "" + rowIndex);
                boolean isPanel = table.getPanelExpansion() != null;
                boolean isRow = table.getRowExpansion() != null;
                table.setRowIndex(-1);
                if (isPanel && isRow) {
                    if (rowState.getExpansionType() == RowState.ExpansionType.ROW) {
                        DataTableRowRenderer.encodeRowExpansion(context, table, columns, writer);
                    } else if (rowState.getExpansionType() == RowState.ExpansionType.PANEL) {
                        DataTableRowRenderer.encodeRowPanelExpansion(context, table);
                    }
                } else if (isPanel) {
                    DataTableRowRenderer.encodeRowPanelExpansion(context, table);
                } else if (isRow) {
                    DataTableRowRenderer.encodeRowExpansion(context, table, columns, writer);
                }
                table.setRowIndex(rowIndex);
            }
            List<Row> tailingRows = table.getConditionalRows(rowIndex, false);
            for (Row r : tailingRows) {
                DataTableRowRenderer.encodeConditionalRow(context, r);
            }
            return innerTdDivRequired;
        }
        return false;
    }

    private static void encodeConditionalRow(FacesContext context, Row r) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        if (r.getStyle() != null) {
            writer.writeAttribute("style", (Object)r.getStyle(), null);
        }
        if (r.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)("dt-cond-row " + r.getStyleClass()), null);
        }
        List children = r.getChildren();
        ArrayList<Column> rowColumns = new ArrayList<Column>(children.size());
        for (UIComponent uIComponent : children) {
            if (!(uIComponent instanceof Column)) continue;
            rowColumns.add((Column)uIComponent);
        }
        for (Column column : rowColumns) {
            if (!column.isRendered()) continue;
            DataTableRowRenderer.encodeConditionalRowCell(context, column);
        }
        writer.endElement("tr");
    }

    private static void encodeConditionalRowCell(FacesContext context, Column c) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)c.getColspan(), null);
        if (c.getStyle() != null) {
            writer.writeAttribute("style", (Object)c.getStyle(), null);
        }
        if (c.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)c.getStyleClass(), null);
        }
        c.encodeAll(context);
        writer.endElement("td");
    }

    private static void encodeRegularCell(FacesContext context, List columnSiblings, Column column, boolean selected, boolean resizable) throws IOException {
        boolean isNextGrouped;
        ResponseWriter writer = context.getResponseWriter();
        Column nextColumn = DataTableRendererUtil.getNextColumn(column, columnSiblings);
        boolean isCurrStacked = DataTableRendererUtil.isCurrColumnStacked(columnSiblings, column);
        boolean isNextStacked = nextColumn == null ? false : nextColumn.isRendered() && nextColumn.isStacked();
        boolean isCurrGrouped = column.getCurrGroupLength() > 0;
        boolean bl = isNextGrouped = isCurrGrouped ? false : column.isNextColumnGrouped();
        if (isCurrGrouped) {
            column.setCurrGroupLength(column.getCurrGroupLength() - 1);
        } else {
            if (!isCurrStacked) {
                writer.startElement("td", null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (isNextGrouped) {
                    writer.writeAttribute("rowspan", (Object)(column.findCurrGroupLength() + 1), null);
                }
                CellEditor editor = column.getCellEditor();
                String columnStyleClass = column.getStyleClass();
                if (editor != null) {
                    String string = columnStyleClass = columnStyleClass == null ? "ui-editable-column" : "ui-editable-column " + columnStyleClass;
                }
                if (column.getValueExpression("groupBy") != null) {
                    if (column.isLastGroupDifferent()) {
                        column.setOddGroup(!column.isOddGroup());
                    }
                    if (columnStyleClass == null) {
                        columnStyleClass = "";
                    }
                    columnStyleClass = columnStyleClass + (column.isOddGroup() ? " ui-datatable-group-odd" : " ui-datatable-group-even");
                }
                if (selected) {
                    String string = columnStyleClass = columnStyleClass == null ? "ui-state-active ui-selected" : columnStyleClass + " ui-state-active ui-selected";
                }
                if (columnStyleClass != null) {
                    writer.writeAttribute("class", (Object)columnStyleClass, null);
                }
                if (resizable) {
                    writer.startElement("div", null);
                }
            } else {
                writer.startElement("hr", null);
                writer.endElement("hr");
            }
            column.encodeAll(context);
            if (!isNextStacked) {
                if (resizable) {
                    writer.endElement("div");
                }
                writer.endElement("td");
            }
        }
    }

    private static void encodeRowExpansion(FacesContext context, DataTable table, List<Column> columns, ResponseWriter writer) throws IOException {
        String rowVar = table.getVar();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        String expandedRowId = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_expandedRowId");
        if (expandedRowId == null) {
            expandedRowId = (String)context.getExternalContext().getRequestMap().get(clientId + "_expandedRowId");
        }
        DataModel model = table.getDataModel();
        if (!table.hasTreeDataModel().booleanValue()) {
            throw new FacesException("DataTable : \"" + clientId + "\" must be bound to an instance of TreeDataModel when using sub-row expansion.");
        }
        TreeDataModel rootModel = (TreeDataModel)model;
        rootModel.setRootIndex(expandedRowId);
        table.getStateMap().get(rootModel.getRootData()).setExpanded(true);
        table.setRowIndex(0);
        if (rootModel.getRowCount() > 0) {
            while (rootModel.getRowIndex() < rootModel.getRowCount()) {
                String unselectableClass;
                if (rowVar != null) {
                    context.getExternalContext().getRequestMap().put(rowVar, rootModel.getRowData());
                }
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().put(rowIndexVar, rootModel.getRowIndex());
                }
                RowState rowState = table.getStateMap().get(rootModel.getRowData());
                boolean selected = rowState.isSelected();
                boolean expanded = rowState.isExpanded();
                boolean unselectable = !rowState.isSelectable();
                boolean visible = rowState.isVisible();
                Map rowToSelectedFieldsMap = table.getRowToSelectedFieldsMap();
                List selectedCellExpressions = null;
                if (rowToSelectedFieldsMap != null) {
                    selectedCellExpressions = (List)rowToSelectedFieldsMap.get(table.getRowData());
                }
                context.getExternalContext().getRequestMap().put(table.getRowStateVar(), rowState);
                String expandedClass = expanded ? "ui-expanded-row" : "";
                String alternatingClass = rootModel.getRowIndex() % 2 == 0 ? "ui-datatable-even" : "ui-datatable-odd";
                String selectionClass = selected && table.getSelectionMode() != null ? "ui-selected ui-state-active" : "";
                String string = unselectableClass = unselectable ? "ui-unselectable" : "";
                if (visible) {
                    writer.startElement("tr", null);
                    writer.writeAttribute("id", (Object)(clientId + "_row_" + expandedRowId + "." + rootModel.getRowIndex()), null);
                    writer.writeAttribute("class", (Object)(" " + alternatingClass + " " + selectionClass + " " + expandedClass + " " + unselectableClass), null);
                    for (Column kid : columns) {
                        if (!kid.isRendered()) continue;
                        boolean cellSelected = false;
                        if (selectedCellExpressions != null) {
                            ValueExpression ve;
                            ValueExpression valueExpression = ve = kid.getValueExpression("selectBy") != null ? kid.getValueExpression("selectBy") : kid.getValueExpression("value");
                            if (ve != null) {
                                cellSelected = selectedCellExpressions.contains(ve.getExpressionString());
                            }
                        }
                        DataTableRowRenderer.encodeRegularCell(context, columns, kid, cellSelected, false);
                    }
                    writer.endElement("tr");
                    if (expanded) {
                        int rowIndex = rootModel.getRowIndex();
                        context.getExternalContext().getRequestMap().put(clientId + "_expandedRowId", expandedRowId + "." + rowIndex);
                        PanelExpansion panelExpansion = table.getPanelExpansion();
                        RowExpansion rowExpansion = table.getRowExpansion();
                        boolean isPanel = panelExpansion != null;
                        boolean isRow = rowExpansion != null;
                        table.setRowIndex(-1);
                        if (isPanel && isRow) {
                            if (rowState.getExpansionType() == RowState.ExpansionType.ROW) {
                                DataTableRowRenderer.encodeRowExpansion(context, table, columns, writer);
                            } else if (rowState.getExpansionType() == RowState.ExpansionType.PANEL) {
                                DataTableRowRenderer.encodeRowPanelExpansion(context, table);
                            }
                        } else if (isPanel) {
                            DataTableRowRenderer.encodeRowPanelExpansion(context, table);
                        } else if (isRow) {
                            DataTableRowRenderer.encodeRowExpansion(context, table, columns, writer);
                        }
                        rootModel = (TreeDataModel)table.getDataModel();
                        rootModel.setRootIndex(expandedRowId);
                        table.setRowIndex(rowIndex);
                        context.getExternalContext().getRequestMap().put(clientId + "_expandedRowId", expandedRowId);
                    }
                }
                table.setRowIndex(rootModel.getRowIndex() + 1);
                if (rowIndexVar != null) {
                    context.getExternalContext().getRequestMap().remove(rowIndexVar);
                }
                if (rowVar == null) continue;
                context.getExternalContext().getRequestMap().remove(rowVar);
            }
        }
        rootModel.setRootIndex(null);
        table.setRowIndex(-1);
    }

    private static void encodeRowPanelExpansion(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        DataModel model = table.getDataModel();
        String expandedRowId = (String)params.get(clientId + "_expandedRowId");
        if (expandedRowId == null) {
            expandedRowId = (String)context.getExternalContext().getRequestMap().get(clientId + "_expandedRowId");
        }
        int sepIndex = expandedRowId.lastIndexOf(46);
        String rootIndex = null;
        if (sepIndex >= 0) {
            rootIndex = expandedRowId.substring(0, sepIndex);
            expandedRowId = expandedRowId.substring(sepIndex + 1);
        }
        if (rootIndex != null) {
            ((TreeDataModel)model).setRootIndex(rootIndex);
        }
        table.setRowIndex(Integer.parseInt(expandedRowId));
        table.getStateMap().get(table.getRowData()).setExpanded(true);
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"ui-expanded-row-content ui-widget-content ui-unselectable", null);
        writer.startElement("td", null);
        int enabledColumns = 0;
        for (Column c : table.getColumns()) {
            if (!c.isRendered() || c.isStacked()) continue;
            ++enabledColumns;
        }
        writer.writeAttribute("colspan", (Object)enabledColumns, null);
        table.getPanelExpansion().encodeAll(context);
        writer.endElement("td");
        writer.endElement("tr");
        table.setRowIndex(-1);
    }
}

