/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.dnd;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.dnd.Draggable;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="draggable", value="org.icefaces.ace.component.dnd.Draggable")
public class DraggableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Draggable draggable = (Draggable)component;
        String clientId = draggable.getClientId(facesContext);
        String target = this.findTarget(facesContext, draggable);
        writer.startElement("span", (UIComponent)draggable);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("script", (UIComponent)draggable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(function() {");
        writer.write(DraggableRenderer.resolveWidgetVar((UIComponent)draggable) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.Draggable");
        jb.item(clientId);
        jb.beginMap();
        jb.entry("target", target);
        System.out.println("* " + draggable.getCursor());
        jb.entryNonNullValue("cursor", draggable.getCursor());
        if (draggable.isDisabled()) {
            jb.entry("disabled", true);
        }
        if (draggable.getAxis() != null) {
            jb.entry("axis", draggable.getAxis());
        }
        if (draggable.getContainment() != null) {
            jb.entry("containment", draggable.getContainment());
        }
        if (draggable.getHelper() != null) {
            jb.entry("helper", draggable.getHelper());
        }
        if (draggable.isRevert()) {
            jb.entry("revert", "invalid");
        }
        if (draggable.getZindex() != -1) {
            jb.entry("zIndex", draggable.getZindex());
        }
        if (draggable.getHandle() != null) {
            jb.entry("handle", draggable.getHandle());
        }
        if (draggable.getOpacity() != 1.0) {
            jb.entry("opacity", draggable.getOpacity());
        }
        if (draggable.getStack() != null) {
            jb.entry("stack", draggable.getStack());
        }
        if (draggable.getGrid() != null) {
            jb.entry("grid", "[" + draggable.getGrid() + "]", true);
        }
        if (draggable.getScope() != null) {
            jb.entry("scope", draggable.getScope());
        }
        if (draggable.isSnap()) {
            jb.entry("snap", true);
            jb.entry("snapTolerance", draggable.getSnapTolerance());
            if (draggable.getSnapMode() != null) {
                jb.entry("snapMode", draggable.getSnapMode());
            }
        }
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.write("});");
        writer.endElement("script");
        writer.endElement("span");
    }

    protected String findTarget(FacesContext facesContext, Draggable draggable) {
        String _for = draggable.getFor();
        if (_for != null) {
            UIComponent component = draggable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component.getClientId(facesContext);
        }
        return draggable.getParent().getClientId(facesContext);
    }
}

