/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.fileentry;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.fileentry.PushUtils;

public class ProgressResource
extends Resource
implements Serializable {
    private String uniqueIdentifier;
    private String progressInfo;
    private int deltaGottenPushed;

    ProgressResource(String identifier) {
        this.uniqueIdentifier = identifier + ".txt";
        this.progressInfo = "";
        this.deltaGottenPushed = 0;
        this.setContentType("text/plain");
        this.setResourceName(PushUtils.PROGRESS_PREFIX + this.uniqueIdentifier);
    }

    int updateProgressInfo(String progressInfo) {
        this.progressInfo = progressInfo;
        return ++this.deltaGottenPushed;
    }

    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> responseHeaders = new HashMap<String, String>(1);
        responseHeaders.put("Content-type", "text/plain; charset=utf-8");
        responseHeaders.put("Cache-Control", "no-cache, no-store, must-revalidate");
        responseHeaders.put("Pragma", "no-cache");
        responseHeaders.put("Expires", "0");
        return responseHeaders;
    }

    public String getRequestPath() {
        return PushUtils.PROGRESS_PREFIX + this.uniqueIdentifier;
    }

    public URL getURL() {
        return null;
    }

    public boolean userAgentNeedsUpdate(FacesContext facesContext) {
        return true;
    }

    public InputStream getInputStream() {
        --this.deltaGottenPushed;
        if (this.progressInfo == null) {
            return null;
        }
        try {
            byte[] progressBytes = this.progressInfo.getBytes("UTF-8");
            return new ByteArrayInputStream(progressBytes);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

