/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.icefaces.ace.component.list.ACEList;
import org.icefaces.ace.component.list.ImmigrationRecord;
import org.icefaces.ace.event.ListSelectEvent;
import org.icefaces.ace.json.JSONArray;
import org.icefaces.ace.json.JSONException;

public class ListDecoder {
    private ACEList list;
    private List<ImmigrationRecord> emigrants;

    public ListDecoder(ACEList list) {
        this.list = list;
    }

    public ListDecoder processSelections(String raw) throws JSONException {
        if (raw == null || raw.length() == 0) {
            return this;
        }
        JSONArray array = new JSONArray(raw);
        Set<Object> selections = this.list.getSelections();
        HashSet<Object> newSelections = new HashSet<Object>();
        for (int i = 0; i < array.length(); ++i) {
            int index = array.getInt(i);
            this.list.setRowIndex(index);
            newSelections.add(this.list.getRowData());
        }
        this.list.queueEvent(new ListSelectEvent((UIComponent)this.list, newSelections));
        selections.addAll(newSelections);
        this.list.setRowIndex(-1);
        return this;
    }

    public ListDecoder processDeselections(String raw) throws JSONException {
        if (raw == null || raw.length() == 0) {
            return this;
        }
        JSONArray array = new JSONArray(raw);
        Set<Object> selections = this.list.getSelections();
        for (int i = 0; i < array.length(); ++i) {
            int index = array.getInt(i);
            this.list.setRowIndex(index);
            selections.remove(this.list.getRowData());
        }
        this.list.setRowIndex(-1);
        return this;
    }

    public ListDecoder processReorderings(String raw) throws JSONException {
        if (raw == null || raw.length() == 0) {
            return this;
        }
        JSONArray array = new JSONArray(raw);
        Object value = this.list.getValue();
        List<Object> collection = null;
        if (value instanceof List) {
            collection = (List<Object>)value;
        } else if (value.getClass().isArray()) {
            collection = Arrays.asList(value);
        }
        for (int i = 0; i < array.length(); ++i) {
            JSONArray record = array.getJSONArray(i);
            int from = record.getInt(0);
            int to = record.getInt(1);
            Collections.swap(collection, from, to);
        }
        return this;
    }

    public ListDecoder attachEmigrants(FacesContext context, String destListId) throws JSONException {
        if (destListId == null || destListId.length() == 0) {
            return this;
        }
        this.emigrants = new ArrayList<ImmigrationRecord>();
        context.getViewRoot().visitTree(VisitContext.createVisitContext((FacesContext)context, Arrays.asList(destListId), EnumSet.of(VisitHint.SKIP_TRANSIENT, VisitHint.SKIP_UNRENDERED)), (VisitCallback)new EmigrantAttachingVisit(this.list, this.emigrants));
        return this;
    }

    public ListDecoder removeEmigrants(FacesContext context, String destListId) {
        if (destListId == null || destListId.length() == 0) {
            return this;
        }
        Object value = this.list.getValue();
        List<Object> collection = null;
        Set<Object> selected = this.list.getSelections();
        if (value instanceof List) {
            collection = (List<Object>)value;
        } else if (value.getClass().isArray()) {
            collection = Arrays.asList(value);
        }
        for (ImmigrationRecord r : this.emigrants) {
            collection.remove(r.getValue());
            selected.remove(r.getValue());
        }
        return this;
    }

    public ListDecoder fetchImmigrants(FacesContext context, String raw) throws JSONException {
        if (raw == null || raw.length() == 0) {
            return this;
        }
        if (this.list.getImmigrants() != null) {
            return this;
        }
        JSONArray array = new JSONArray(raw);
        String sourceListId = array.getString(0);
        ArrayList<ImmigrationRecord> immigrants = new ArrayList<ImmigrationRecord>();
        context.getViewRoot().visitTree(VisitContext.createVisitContext((FacesContext)context, Arrays.asList(sourceListId), EnumSet.of(VisitHint.SKIP_TRANSIENT, VisitHint.SKIP_UNRENDERED)), (VisitCallback)new ImmigrantFetchingVisit(immigrants, array.getJSONArray(1)));
        this.list.setImmigrants(immigrants);
        return this;
    }

    public ListDecoder insertImmigrants() {
        Object value = this.list.getValue();
        List<Object> collection = null;
        Set<Object> selected = this.list.getSelections();
        List<ImmigrationRecord> records = this.list.getImmigrants();
        if (value instanceof List) {
            collection = (List<Object>)value;
        } else if (value.getClass().isArray()) {
            collection = Arrays.asList(value);
        }
        if (records != null) {
            for (ImmigrationRecord record : records) {
                collection.add(record.getDestination(), record.getValue());
                if (!record.isSelected()) continue;
                selected.add(record.getValue());
            }
        }
        return this;
    }

    private class ImmigrantFetchingVisit
    implements VisitCallback {
        List<ImmigrationRecord> immigrants;
        JSONArray records;
        JSONArray sourceSelections;
        JSONArray sourceDeselections;

        public ImmigrantFetchingVisit(List<ImmigrationRecord> immigrants, JSONArray records) {
            this.immigrants = immigrants;
            this.records = records;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uiComponent) {
            ACEList sourceList = (ACEList)uiComponent;
            String sourceListId = sourceList.getClientId();
            FacesContext context = visitContext.getFacesContext();
            Set<Object> sourceSelected = sourceList.getSelections();
            try {
                for (int i = 0; i < this.records.length(); ++i) {
                    boolean selected;
                    JSONArray record = this.records.getJSONArray(i);
                    int from = record.getInt(0);
                    int to = record.getInt(1);
                    sourceList.setRowIndex(from);
                    Object value = sourceList.getRowData();
                    boolean bl = selected = !this.indexDeselectedThisRequest(context, sourceListId, from);
                    if (selected) {
                        selected = sourceSelected.contains(value) || this.indexSelectedThisRequest(context, sourceListId, from);
                    }
                    this.immigrants.add(new ImmigrationRecord(value, to, selected));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            sourceList.setRowIndex(-1);
            return VisitResult.COMPLETE;
        }

        private boolean indexSelectedThisRequest(FacesContext context, String listId, int from) throws JSONException {
            if (this.sourceSelections == null) {
                String raw = (String)context.getExternalContext().getRequestParameterMap().get(listId + "_selections");
                if (raw == null || raw.length() == 0) {
                    return false;
                }
                this.sourceSelections = new JSONArray(raw);
            }
            for (int i = 0; i < this.sourceSelections.length(); ++i) {
                if (this.sourceSelections.getInt(i) != from) continue;
                return true;
            }
            return false;
        }

        private boolean indexDeselectedThisRequest(FacesContext context, String listId, int from) throws JSONException {
            if (this.sourceDeselections == null) {
                String raw = (String)context.getExternalContext().getRequestParameterMap().get(listId + "_deselections");
                if (raw == null || raw.length() == 0) {
                    return false;
                }
                this.sourceDeselections = new JSONArray(raw);
            }
            for (int i = 0; i < this.sourceDeselections.length(); ++i) {
                if (this.sourceDeselections.getInt(i) != from) continue;
                return true;
            }
            return false;
        }
    }

    private class EmigrantAttachingVisit
    implements VisitCallback {
        ACEList sourceList;
        List<ImmigrationRecord> migrants;

        private EmigrantAttachingVisit(ACEList sourceList, List<ImmigrationRecord> migrants) {
            this.migrants = migrants;
            this.sourceList = sourceList;
        }

        public VisitResult visit(VisitContext visitContext, UIComponent targetComponent) {
            ACEList destList = (ACEList)targetComponent;
            if (destList.getImmigrants() != null) {
                this.migrants.addAll(destList.getImmigrants());
                return null;
            }
            FacesContext context = visitContext.getFacesContext();
            Map params = context.getExternalContext().getRequestParameterMap();
            String raw = (String)params.get(destList.getClientId() + "_immigration");
            try {
                JSONArray records = new JSONArray(raw).getJSONArray(1);
                Set<Object> selected = this.sourceList.getSelections();
                Object value = this.sourceList.getValue();
                List<Object> collection = null;
                if (value instanceof List) {
                    collection = (List<Object>)value;
                } else if (value.getClass().isArray()) {
                    collection = Arrays.asList(value);
                }
                if (records != null) {
                    for (int i = 0; i < records.length(); ++i) {
                        JSONArray record = records.getJSONArray(i);
                        Object val = collection.get((Integer)record.get(0));
                        this.migrants.add(new ImmigrationRecord(val, (Integer)record.get(1), selected.contains(val)));
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            destList.setImmigrants(this.migrants);
            return VisitResult.COMPLETE;
        }
    }
}

