/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.maskedentry;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.maskedentry.MaskedEntry;
import org.icefaces.ace.renderkit.InputRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.HTML;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="maskedEntry", value="org.icefaces.ace.component.maskedentry.MaskedEntry")
public class MaskedEntryRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        MaskedEntry maskedEntry = (MaskedEntry)component;
        if (maskedEntry.isDisabled() || maskedEntry.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)maskedEntry);
        String clientId = maskedEntry.getClientId(context) + "_field";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            maskedEntry.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        MaskedEntry maskedEntry = (MaskedEntry)component;
        ResponseWriter writer = context.getResponseWriter();
        Map<String, Object> labelAttributes = this.getLabelAttributes(component);
        this.writeLabelAndIndicatorBefore(labelAttributes);
        this.encodeMarkup(context, maskedEntry, labelAttributes);
        this.writeLabelAndIndicatorAfter(labelAttributes);
    }

    protected void encodeScript(FacesContext context, MaskedEntry maskedEntry, String label, boolean hasLabel, String labelPosition, String indicator, boolean hasIndicator, String indicatorPosition) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = maskedEntry.getClientId(context);
        String inFieldLabel = "";
        if (hasLabel && labelPosition.equals("inField")) {
            inFieldLabel = label;
            if (hasIndicator) {
                if (indicatorPosition.equals("labelLeft")) {
                    inFieldLabel = indicator + inFieldLabel;
                } else if (indicatorPosition.equals("labelRight")) {
                    inFieldLabel = inFieldLabel + indicator;
                }
            }
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(MaskedEntryRenderer.resolveWidgetVar((UIComponent)maskedEntry) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.InputMask").item(clientId).beginMap().entry("mask", maskedEntry.getMask());
        String placeHolder = maskedEntry.getPlaceHolder();
        if (placeHolder != null) {
            jb.entry("placeholder", placeHolder);
        }
        jb.entry("inFieldLabel", inFieldLabel);
        jb.entry("inFieldLabelStyleClass", "ui-input-label-infield");
        if (this.isValueBlank(ComponentUtils.getStringValueToRender(context, (UIComponent)maskedEntry))) {
            jb.entry("labelIsInField", true);
        } else {
            jb.entry("labelIsInField", false);
        }
        this.encodeClientBehaviors(context, maskedEntry, jb);
        if (!this.themeForms()) {
            jb.entry("theme", false);
        }
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, MaskedEntry maskedEntry, Map labelAttributes) throws IOException {
        String style;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = maskedEntry.getClientId(context);
        String fieldClientId = clientId + "_field";
        String defaultClass = this.themeForms() ? "ui-inputfield ui-inputmask ui-widget ui-state-default ui-corner-all" : "ui-inputmask";
        String styleClass = maskedEntry.getStyleClass();
        defaultClass = defaultClass + this.getStateStyleClasses((UIInput)maskedEntry);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("input", null);
        writer.writeAttribute("name", (Object)fieldClientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        String valueToRender = ComponentUtils.getStringValueToRender(context, (UIComponent)maskedEntry);
        boolean hasLabel = (Boolean)labelAttributes.get("hasLabel");
        String labelPosition = (String)labelAttributes.get("labelPosition");
        String label = (String)labelAttributes.get("label");
        boolean hasIndicator = (Boolean)labelAttributes.get("hasIndicator");
        String indicatorPosition = (String)labelAttributes.get("indicatorPosition");
        String indicator = (String)labelAttributes.get("indicator");
        if (this.isValueBlank(valueToRender) && hasLabel && labelPosition.equals("inField")) {
            valueToRender = label;
            if (hasIndicator) {
                if (indicatorPosition.equals("labelLeft")) {
                    valueToRender = indicator + valueToRender;
                } else if (indicatorPosition.equals("labelRight")) {
                    valueToRender = valueToRender + indicator;
                }
            }
            defaultClass = defaultClass + " ui-input-label-infield";
        }
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderPassThruAttributes(context, (UIComponent)maskedEntry, HTML.INPUT_TEXT_ATTRS);
        if (maskedEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (maskedEntry.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if ((style = maskedEntry.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        Utils.writeConcatenatedStyleClasses(writer, defaultClass, styleClass);
        writer.endElement("input");
        this.encodeScript(context, maskedEntry, label, hasLabel, labelPosition, indicator, hasIndicator, indicatorPosition);
        writer.endElement("span");
    }
}

