/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.menubar;

import java.io.IOException;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.menu.AbstractMenu;
import org.icefaces.ace.component.menu.BaseMenuRenderer;
import org.icefaces.ace.component.menubar.MenuBar;
import org.icefaces.ace.component.menuitem.MenuItem;
import org.icefaces.ace.component.menuseparator.MenuSeparator;
import org.icefaces.ace.component.multicolumnsubmenu.MultiColumnSubmenu;
import org.icefaces.ace.component.submenu.Submenu;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="menuBar", value="org.icefaces.ace.component.menubar.MenuBar")
public class MenuBarRenderer
extends BaseMenuRenderer {
    private static final Logger logger = Logger.getLogger(MenuBarRenderer.class.getName());

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AbstractMenu menu = (AbstractMenu)component;
        if (menu.shouldBuildFromModel()) {
            menu.buildMenuFromModel();
        }
        this.encodeMarkup(context, menu);
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuBar menubar = (MenuBar)abstractMenu;
        String clientId = menubar.getClientId(context);
        String widgetVar = MenuBarRenderer.resolveWidgetVar((UIComponent)menubar);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSONBuilder json = JSONBuilder.create();
        writer.write(widgetVar + " = new ");
        json.beginFunction("ice.ace.Menubar").item(clientId).beginMap().entry("autoSubmenuDisplay", menubar.isAutoSubmenuDisplay()).entry("direction", menubar.getDirection()).beginMap("animation").entry("animated", menubar.getEffect()).entry("duration", menubar.getEffectDuration()).endMap().entryNonNullValue("styleClass", menubar.getStyleClass()).entryNonNullValue("style", menubar.getStyle()).endMap().endFunction();
        writer.write(json.toString());
        writer.endElement("script");
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        MenuBar menubar = (MenuBar)abstractMenu;
        String clientId = menubar.getClientId(context);
        writer.startElement("div", (UIComponent)menubar);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("ul", null);
        this.encodeMenuContent(context, (UIComponent)menubar);
        writer.endElement("ul");
        this.encodeScript(context, menubar);
        writer.endElement("div");
    }

    protected void encodeMenuContent(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            writer.startElement("li", null);
            if (child instanceof MenuItem) {
                this.encodeMenuItem(context, (MenuItem)child);
            } else if (!(child instanceof MenuSeparator)) {
                if (child instanceof Submenu) {
                    this.encodeSubmenu(context, (Submenu)child);
                } else if (child instanceof MultiColumnSubmenu) {
                    this.encodeMultiColumnSubmenu(context, (MultiColumnSubmenu)child);
                }
            }
            writer.endElement("li");
        }
    }

    protected void encodeSubmenu(FacesContext context, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent labelFacet = submenu.getFacet("label");
        String icon = submenu.getIcon();
        boolean disabled = submenu.isDisabled();
        if (labelFacet == null) {
            String label = submenu.getLabel();
            writer.startElement("a", null);
            if (disabled) {
                writer.writeAttribute("class", (Object)"ui-state-disabled", null);
            } else {
                writer.writeAttribute("href", (Object)"#", null);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)(icon + " wijmo-wijmenu-icon-left"), null);
                writer.endElement("span");
            }
            if (label != null) {
                writer.startElement("span", null);
                String style = submenu.getStyle();
                if (style != null && style.trim().length() > 0) {
                    writer.writeAttribute("style", (Object)style, "style");
                }
                Utils.writeConcatenatedStyleClasses(writer, "wijmo-wijmenu-text", submenu.getStyleClass());
                writer.write(submenu.getLabel());
                writer.endElement("span");
            }
            writer.endElement("a");
        } else {
            logger.info("label facet of a menubar item is deprecated, use a menuitem instead instead of a submenu.");
            this.encodeMenuItem(context, (MenuItem)labelFacet);
        }
        if (submenu.getChildCount() > 0 && !disabled) {
            writer.startElement("ul", null);
            this.encodeMenuContent(context, (UIComponent)submenu);
            writer.endElement("ul");
        }
    }
}

