/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.textentry;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.textentry.TextEntry;
import org.icefaces.ace.renderkit.InputRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.HTML;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.ace.util.Utils;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="textEntry", value="org.icefaces.ace.component.textentry.TextEntry")
public class TextEntryRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        TextEntry textEntry = (TextEntry)component;
        if (textEntry.isDisabled() || textEntry.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)textEntry);
        String clientId = textEntry.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        String submittedValue = (String)requestParameterMap.get(clientId + "_input");
        if (submittedValue == null && requestParameterMap.get(clientId + "_label") != null) {
            submittedValue = "";
        }
        if (submittedValue != null) {
            textEntry.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String style;
        TextEntry textEntry = (TextEntry)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = textEntry.getClientId(context);
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        String defaultClass = this.themeForms() ? "ui-inputfield ui-textentry ui-widget ui-state-default ui-corner-all" : "ui-textentry";
        String styleClass = textEntry.getStyleClass();
        defaultClass = defaultClass + this.getStateStyleClasses((UIInput)textEntry);
        Map<String, Object> labelAttributes = this.getLabelAttributes(component);
        writer.startElement("span", (UIComponent)textEntry);
        this.writeLabelAndIndicatorBefore(labelAttributes);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        String embeddedLabel = null;
        String nameToRender = clientId + "_input";
        String valueToRender = ComponentUtils.getStringValueToRender(context, (UIComponent)textEntry);
        boolean hasLabel = (Boolean)labelAttributes.get("hasLabel");
        String labelPosition = (String)labelAttributes.get("labelPosition");
        String label = (String)labelAttributes.get("label");
        boolean hasIndicator = (Boolean)labelAttributes.get("hasIndicator");
        String indicatorPosition = (String)labelAttributes.get("indicatorPosition");
        String indicator = (String)labelAttributes.get("indicator");
        if ((valueToRender == null || valueToRender.trim().length() <= 0) && hasLabel && labelPosition.equals("inField")) {
            nameToRender = clientId + "_label";
            valueToRender = embeddedLabel = label;
            if (hasIndicator) {
                if (indicatorPosition.equals("labelLeft")) {
                    valueToRender = embeddedLabel = indicator + valueToRender;
                } else if (indicatorPosition.equals("labelRight")) {
                    valueToRender = embeddedLabel = valueToRender + indicator;
                }
            }
            defaultClass = defaultClass + " ui-input-label-infield";
        }
        writer.writeAttribute("name", (Object)nameToRender, null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        this.renderPassThruAttributes(context, (UIComponent)textEntry, HTML.INPUT_TEXT_ATTRS);
        if (textEntry.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (textEntry.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if ((style = textEntry.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        Utils.writeConcatenatedStyleClasses(writer, defaultClass, styleClass);
        writer.endElement("input");
        this.writeLabelAndIndicatorAfter(labelAttributes);
        writer.endElement("span");
        writer.startElement("span", (UIComponent)textEntry);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(TextEntryRenderer.resolveWidgetVar((UIComponent)textEntry) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.TextEntry").item(clientId).beginMap().entryNonNullValue("embeddedLabel", embeddedLabel);
        this.encodeClientBehaviors(context, textEntry, jb);
        if (!this.themeForms()) {
            jb.entry("theme", false);
        }
        jb.entry("autoTab", textEntry.isAutoTab() && textEntry.getMaxlength() > 0);
        StringBuilder sb = new StringBuilder();
        sb.append(indicatorPosition).append(labelPosition);
        jb.entry("hashCode", sb.toString().hashCode());
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.endElement("script");
        writer.endElement("span");
        writer.endElement("span");
    }
}

