/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.component.tooltip;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.ace.component.tooltip.Tooltip;
import org.icefaces.ace.renderkit.CoreRenderer;
import org.icefaces.ace.util.ComponentUtils;
import org.icefaces.ace.util.JSONBuilder;
import org.icefaces.render.MandatoryResourceComponent;

@MandatoryResourceComponent(tagName="tooltip", value="org.icefaces.ace.component.tooltip.Tooltip")
public class TooltipRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Tooltip tooltip = (Tooltip)component;
        String clientId = tooltip.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId + "_displayListener") && tooltip.getDisplayListener() != null) {
            tooltip.getDisplayListener().invoke(facesContext.getELContext(), null);
        }
        this.decodeBehaviors(facesContext, (UIComponent)tooltip);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Tooltip tooltip = (Tooltip)component;
        this.encodeScript(facesContext, tooltip);
        if (tooltip.getValue() == null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            String clientId = tooltip.getClientId(facesContext);
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), null);
            writer.writeAttribute("style", (Object)"display:none;", null);
            this.renderChildren(facesContext, (UIComponent)tooltip);
            writer.endElement("div");
        }
    }

    protected void encodeScript(FacesContext facesContext, Tooltip tooltip) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean global = tooltip.isGlobal();
        Object owner = this.getTarget(facesContext, tooltip);
        String clientId = tooltip.getClientId(facesContext);
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("ice.ace.jq(function() {");
        writer.write(TooltipRenderer.resolveWidgetVar((UIComponent)tooltip) + " = new ");
        JSONBuilder jb = JSONBuilder.create();
        jb.beginFunction("ice.ace.Tooltip").beginMap().entry("global", global).entry("id", clientId).entry("displayListener", tooltip.getDisplayListener() != null);
        if (tooltip.isSpeechBubble()) {
            jb.entry("speechBubble", true);
        }
        if (!global) {
            if (owner instanceof ArrayList) {
                jb.beginArray("forComponents");
                ArrayList clientIds = (ArrayList)owner;
                int size = clientIds.size();
                for (int i = 0; i < size; ++i) {
                    jb.item((String)clientIds.get(i));
                }
                jb.endArray();
            } else {
                jb.entry("forComponent", (String)owner);
            }
            writer.write(jb.toString());
            writer.write(",content:");
            if (tooltip.getValue() == null) {
                writer.write("document.getElementById('" + clientId + "_content').innerHTML");
            } else {
                writer.write("'");
                writer.write(ComponentUtils.getStringValueToRender(facesContext, (UIComponent)tooltip).replaceAll("'", "\\\\'"));
                writer.write("'");
            }
            writer.write(",");
        } else {
            writer.write(jb.toString());
            writer.write(",");
        }
        jb = JSONBuilder.create();
        jb.beginMap("show").beginMap("when").entry("event", tooltip.getShowEvent()).endMap().entry("delay", tooltip.getShowDelay()).beginMap("effect").entry("length", tooltip.getShowEffectLength()).entry("type", tooltip.getShowEffect()).endMap().endMap();
        jb.beginMap("hide").beginMap("when").entry("event", tooltip.getHideEvent()).endMap().entry("delay", tooltip.getHideDelay()).entry("fixed", true).beginMap("effect").entry("length", tooltip.getHideEffectLength()).entry("type", tooltip.getHideEffect()).endMap().endMap();
        jb.beginMap("position");
        String container = owner == null || owner instanceof ArrayList ? "document.body" : "ice.ace.jq(ice.ace.escapeClientId('" + owner + "')).parent()";
        jb.entry("container", container, true).beginMap("corner").entry("target", tooltip.getTargetPosition()).entry("tooltip", tooltip.getPosition()).endMap().endMap();
        this.encodeClientBehaviors(facesContext, tooltip, jb);
        jb.endMap().endFunction();
        writer.write(jb.toString());
        writer.write("});");
        writer.endElement("script");
        writer.endElement("span");
    }

    protected Object getTarget(FacesContext facesContext, Tooltip tooltip) {
        if (tooltip.isGlobal()) {
            return null;
        }
        String _for = tooltip.getFor();
        String forElement = tooltip.getForElement();
        if (_for != null) {
            UIComponent forComponent = tooltip.findComponent(_for);
            if (forComponent == null) {
                String containerId = tooltip.getForContainer();
                UIComponent container = null;
                if (containerId != null) {
                    container = this.findComponentCustom((UIComponent)facesContext.getViewRoot(), containerId);
                }
                if (container != null) {
                    return this.collectClientIds(facesContext, container, _for);
                }
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return forComponent.getClientId(facesContext);
        }
        if (forElement != null) {
            return forElement;
        }
        return tooltip.getParent().getClientId(facesContext);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private UIComponent findComponentCustom(UIComponent base, String id) {
        UIComponent child;
        if (base.getId().equals(id)) {
            return base;
        }
        List children = base.getChildren();
        UIComponent result = null;
        Iterator i$ = children.iterator();
        while (i$.hasNext() && (result = this.findComponentCustom(child = (UIComponent)i$.next(), id)) == null) {
        }
        return result;
    }

    private ArrayList<String> collectClientIds(FacesContext context, UIComponent container, String id) {
        ArrayList<String> clientIds = new ArrayList<String>();
        container.visitTree(VisitContext.createVisitContext((FacesContext)context, null, EnumSet.of(VisitHint.SKIP_TRANSIENT, VisitHint.SKIP_UNRENDERED)), (VisitCallback)new IdCollectionVisitCallback(clientIds, id));
        return clientIds;
    }

    private class IdCollectionVisitCallback
    implements VisitCallback {
        private ArrayList<String> clientIds;
        private String id;

        private IdCollectionVisitCallback(ArrayList<String> clientIds, String id) {
            this.clientIds = clientIds;
            this.id = id;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (this.id.equals(target.getId())) {
                this.clientIds.add(target.getClientId());
            }
            return VisitResult.ACCEPT;
        }
    }
}

