/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.model.chart;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import org.icefaces.ace.model.chart.LineCap;
import org.icefaces.ace.model.chart.LineJoin;
import org.icefaces.ace.util.JSONBuilder;

public abstract class ChartSeries {
    List<Object> data;
    ChartType type;
    Boolean show;
    Integer xAxis;
    Integer yAxis;
    String label;
    Boolean showLabel;
    String color;
    Integer lineWidth;
    LineJoin lineJoin;
    LineCap lineCap;
    Boolean shadow;
    Integer shadowAngle;
    Integer shadowOffset;
    Integer shadowDepth;
    Integer shadowAlpha;
    Boolean showMarker;
    Boolean fill;
    String fillColor;
    Integer fillAlpha;
    Boolean fillAndStroke;
    Boolean disableStack;
    Boolean fillToZero;
    String fillToValue;
    String fillAxis;
    Boolean useNegativeColors;

    public Boolean getShow() {
        return this.show;
    }

    public void setShow(Boolean show) {
        this.show = show;
    }

    public Boolean getShowMarker() {
        return this.showMarker;
    }

    public void setShowMarker(Boolean showMarker) {
        this.showMarker = showMarker;
    }

    public Integer getXAxis() {
        return this.xAxis;
    }

    public void setXAxis(Integer xAxis) {
        this.xAxis = xAxis;
    }

    public Integer getYAxis() {
        return this.yAxis;
    }

    public void setYAxis(Integer yAxis) {
        this.yAxis = yAxis;
    }

    public Boolean getFillToZero() {
        return this.fillToZero;
    }

    public void setFillToZero(Boolean fillToZero) {
        this.fillToZero = fillToZero;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<Object> getData() {
        if (this.data == null) {
            this.data = new ArrayList<Object>();
        }
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    public ChartType getType() {
        return this.type;
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    public Boolean getUseNegativeColors() {
        return this.useNegativeColors;
    }

    public void setUseNegativeColors(Boolean useNegativeColors) {
        this.useNegativeColors = useNegativeColors;
    }

    public Boolean getFill() {
        return this.fill;
    }

    public void setFill(Boolean fill) {
        this.fill = fill;
    }

    public Integer getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(Integer lineWidth) {
        this.lineWidth = lineWidth;
    }

    public LineJoin getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(LineJoin lineJoin) {
        this.lineJoin = lineJoin;
    }

    public LineCap getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(LineCap lineCap) {
        this.lineCap = lineCap;
    }

    public Boolean getShadow() {
        return this.shadow;
    }

    public void setShadow(Boolean shadow) {
        this.shadow = shadow;
    }

    public Integer getShadowAngle() {
        return this.shadowAngle;
    }

    public void setShadowAngle(Integer shadowAngle) {
        this.shadowAngle = shadowAngle;
    }

    public Integer getShadowOffset() {
        return this.shadowOffset;
    }

    public void setShadowOffset(Integer shadowOffset) {
        this.shadowOffset = shadowOffset;
    }

    public Integer getShadowDepth() {
        return this.shadowDepth;
    }

    public void setShadowDepth(Integer shadowDepth) {
        this.shadowDepth = shadowDepth;
    }

    public Integer getShadowAlpha() {
        return this.shadowAlpha;
    }

    public void setShadowAlpha(Integer shadowAlpha) {
        this.shadowAlpha = shadowAlpha;
    }

    public JSONBuilder getDataJSON(UIComponent chart) {
        return JSONBuilder.create().beginArray();
    }

    public JSONBuilder getConfigJSON(UIComponent component) {
        JSONBuilder cfg = JSONBuilder.create();
        String label = this.getLabel();
        LineCap cap = this.getLineCap();
        LineJoin join = this.getLineJoin();
        Boolean show = this.getShow();
        Boolean shadow = this.getShadow();
        Boolean showMarker = this.getShowMarker();
        Boolean useNegativeColors = this.getUseNegativeColors();
        Boolean ftz = this.getFillToZero();
        Boolean fill = this.getFill();
        Integer width = this.getLineWidth();
        Integer xAxis = this.getXAxis();
        Integer yAxis = this.getYAxis();
        Integer shadowDepth = this.getShadowDepth();
        Integer shadowAlpha = this.getShadowAlpha();
        Integer shadowOffset = this.getShadowOffset();
        Integer shadowAngle = this.getShadowAngle();
        cfg.beginMap();
        if (show != null) {
            cfg.entry("show", show);
        }
        if (width != null) {
            cfg.entry("lineWidth", this.lineWidth);
        }
        if (cap != null) {
            cfg.entry("lineCap", this.lineCap.toString());
        }
        if (join != null) {
            cfg.entry("lineJoin", this.lineJoin.toString());
        }
        if (label != null) {
            cfg.entry("label", label);
        }
        if (xAxis != null) {
            cfg.entry("xaxis", "x" + xAxis + "axis");
        }
        if (yAxis != null) {
            cfg.entry("yaxis", "y" + yAxis + "axis");
        }
        if (useNegativeColors != null) {
            cfg.entry("useNegativeColors", useNegativeColors);
        }
        if (showMarker != null) {
            cfg.entry("showMarker", showMarker);
        }
        if (ftz != null) {
            cfg.entry("fillToZero", ftz);
        }
        if (fill != null) {
            cfg.entry("fill", fill);
        }
        if (shadow != null) {
            cfg.entry("shadow", shadow);
        }
        if (shadowAlpha != null) {
            Double alphaPercentile = shadowAlpha.doubleValue() / 100.0;
            cfg.entry("shadowAlpha", alphaPercentile);
        }
        if (shadowDepth != null) {
            cfg.entry("shadowDepth", shadowDepth);
        }
        if (shadowAngle != null) {
            cfg.entry("shadowAngle", shadowAngle);
        }
        if (shadowOffset != null) {
            cfg.entry("shadowOffset", shadowOffset);
        }
        return cfg;
    }

    public abstract ChartType getDefaultType();

    public void clear() {
        this.data.clear();
    }

    public static interface ChartType {
    }
}

