/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.model.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.faces.model.DataModel;

public class TreeDataModel
extends DataModel
implements Serializable {
    private Stack<List<Map.Entry<Object, List>>> mapStack = new Stack();
    private List<Integer> rootIndex = null;
    private List<Map.Entry<Object, List>> rootMap;
    private List<Map.Entry<Object, List>> currentMap;
    private Integer rowIndex = -1;

    public TreeDataModel() {
        this.setWrappedData(null);
    }

    public TreeDataModel(List<Map.Entry<Object, List>> inputModel) {
        this.rootMap = inputModel;
        this.currentMap = this.rootMap;
    }

    public Object getWrappedData() {
        return this.rootMap;
    }

    public int getRowCount() {
        return this.currentMap.size();
    }

    public Map.Entry<Object, List> getRowEntry() {
        return this.currentMap.get(this.rowIndex);
    }

    public Object getRowData() {
        if (this.currentMap == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.currentMap.get(this.rowIndex).getKey();
    }

    public Object getRootData() {
        return this.mapStack.peek().get(this.rootIndex.get(this.rootIndex.size() - 1)).getKey();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public boolean isRowAvailable() {
        return this.rowIndex >= 0 && this.rowIndex.compareTo(this.currentMap.size()) < 0;
    }

    public void setWrappedData(Object wrappedData) {
        Object testObj;
        if (wrappedData instanceof List && (testObj = ((List)wrappedData).get(0)) instanceof Map.Entry) {
            this.rootMap = (List)wrappedData;
            this.currentMap = this.rootMap;
        }
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setRootIndex(String expandedRowId) {
        if (expandedRowId == null) {
            this.currentMap = this.rootMap;
            this.rootIndex = null;
            while (!this.mapStack.empty()) {
                this.mapStack.pop();
            }
            return;
        }
        if (expandedRowId.contains(".")) {
            String[] split = expandedRowId.split("\\.");
            this.rootIndex = new ArrayList<Integer>();
            for (int i = 0; i < split.length; ++i) {
                this.rootIndex.add(Integer.parseInt(split[i]));
            }
        } else {
            this.rootIndex = new ArrayList<Integer>();
            this.rootIndex.add(Integer.parseInt(expandedRowId));
        }
        Iterator<Integer> indexIterator = this.rootIndex.iterator();
        Integer target = null;
        this.currentMap = this.rootMap;
        while (indexIterator.hasNext()) {
            target = indexIterator.next();
            this.mapStack.push(this.currentMap);
            this.currentMap = this.currentMap.get(target).getValue();
        }
    }

    public boolean isRootIndexSet() {
        return this.rootIndex != null && this.rootIndex.size() != 0;
    }

    public String getRootIndex() {
        if (this.rootIndex == null) {
            return "";
        }
        return this.join(this.rootIndex, ".");
    }

    public int pop() {
        this.currentMap = this.mapStack.pop();
        return this.rootIndex.remove(this.rootIndex.size() - 1);
    }

    private String join(Collection<Integer> strCollection, String delimiter) {
        String joined = "";
        int noOfItems = 0;
        for (Integer item : strCollection) {
            joined = joined + item;
            if (++noOfItems >= strCollection.size()) continue;
            joined = joined + delimiter;
        }
        return joined;
    }

    public int getCurrentRowChildCount() {
        List value = this.currentMap.get(this.rowIndex).getValue();
        if (value == null) {
            return 0;
        }
        return value.size();
    }
}

