/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.ace.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.icefaces.ace.renderkit.CoreRenderer;

public class ComponentUtils {
    private static final Logger logger = Logger.getLogger(ComponentUtils.class.getName());

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component) {
        if (component instanceof ValueHolder) {
            Converter converterForType;
            Class valueType;
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            if (valueHolder.getConverter() != null) {
                return valueHolder.getConverter().getAsString(facesContext, component, value);
            }
            ValueExpression expr = component.getValueExpression("value");
            if (expr != null && (valueType = expr.getType(facesContext.getELContext())) != null && (converterForType = facesContext.getApplication().createConverter(valueType)) != null) {
                return converterForType.getAsString(facesContext, component, value);
            }
            return value.toString();
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public static String resolveField(ValueExpression expression) {
        String expressionString = expression.getExpressionString();
        return expressionString.substring(expressionString.indexOf(".") + 1, expressionString.length() - 1);
    }

    public static String getStringValueToRender(FacesContext facesContext, UIComponent component, Object value) {
        if (value == null) {
            return null;
        }
        ValueHolder valueHolder = (ValueHolder)component;
        Converter converter = valueHolder.getConverter();
        if (converter != null) {
            return converter.getAsString(facesContext, component, value);
        }
        ValueExpression expr = component.getValueExpression("value");
        if (expr != null) {
            Class valueType = expr.getType(facesContext.getELContext());
            Converter converterForType = facesContext.getApplication().createConverter(valueType);
            if (converterForType != null) {
                return converterForType.getAsString(facesContext, component, value);
            }
        }
        return value.toString();
    }

    public static UIComponent findParentForm(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component; parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        return parent;
    }

    public static void decorateAttribute(UIComponent component, String attribute, String value) {
        String attributeValue = (String)component.getAttributes().get(attribute);
        if (attributeValue != null) {
            if (attributeValue.indexOf(value) == -1) {
                String decoratedValue = attributeValue + ";" + value;
                component.getAttributes().put(attribute, decoratedValue);
            } else {
                component.getAttributes().put(attribute, attributeValue);
            }
        } else {
            component.getAttributes().put(attribute, value);
        }
    }

    public static List<SelectItem> createSelectItems(UIComponent component) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                UISelectItem selectItem = (UISelectItem)child;
                items.add(new SelectItem(selectItem.getItemValue(), selectItem.getItemLabel()));
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            Object selectItems = ((UISelectItems)child).getValue();
            if (selectItems instanceof SelectItem[]) {
                SelectItem[] itemsArray;
                for (SelectItem item : itemsArray = (SelectItem[])selectItems) {
                    items.add(new SelectItem(item.getValue(), item.getLabel()));
                }
                continue;
            }
            if (!(selectItems instanceof Collection)) continue;
            Collection collection = (Collection)selectItems;
            for (SelectItem item : collection) {
                items.add(new SelectItem(item.getValue(), item.getLabel()));
            }
        }
        return items;
    }

    public static String escapeJQueryId(String id) {
        return "#" + id.replaceAll(":", "\\\\\\\\:");
    }

    public static String findClientIds(FacesContext context, UIComponent component, String list) {
        if (list == null) {
            return "@none";
        }
        String[] ids = list.split("[,\\s]+");
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            String id;
            if (i != 0) {
                buffer.append(" ");
            }
            if ((id = ids[i].trim()).equals("@all") || id.equals("@none")) {
                buffer.append(id);
                continue;
            }
            if (id.equals("@this")) {
                buffer.append(component.getClientId(context));
                continue;
            }
            if (id.equals("@parent")) {
                buffer.append(component.getParent().getClientId(context));
                continue;
            }
            if (id.equals("@form")) {
                UIComponent form = ComponentUtils.findParentForm(context, component);
                if (form == null) {
                    throw new FacesException("Component " + component.getClientId(context) + " needs to be enclosed in a form");
                }
                buffer.append(form.getClientId(context));
                continue;
            }
            UIComponent comp = component.findComponent(id);
            if (comp != null) {
                buffer.append(comp.getClientId(context));
                continue;
            }
            if (context.getApplication().getProjectStage().equals((Object)ProjectStage.Development)) {
                logger.log(Level.INFO, "Cannot find component with identifier \"{0}\" in view.", id);
            }
            buffer.append(id);
        }
        return buffer.toString();
    }

    public static String findComponentClientId(String id) {
        UIComponent component = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        component = ComponentUtils.findComponent((UIComponent)facesContext.getViewRoot(), id);
        return component.getClientId(facesContext);
    }

    public static UIComponent findComponent(UIComponent base, String id) {
        if (id.equals(base.getId())) {
            return base;
        }
        UIComponent kid = null;
        UIComponent result = null;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && result == null) {
            kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                result = kid;
                break;
            }
            result = ComponentUtils.findComponent(kid, id);
            if (result == null) continue;
            break;
        }
        return result;
    }

    public static String getWidgetVar(String id) {
        UIComponent component = ComponentUtils.findComponent((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), id);
        Renderer renderer = FacesContext.getCurrentInstance().getRenderKit().getRenderer(component.getFamily(), component.getRendererType());
        if (component == null) {
            throw new FacesException("Cannot find component " + id + " in view.");
        }
        if (!(renderer instanceof CoreRenderer)) {
            throw new FacesException("Component with id " + id + " is not derived from CoreRenderer.");
        }
        CoreRenderer cfr_ignored_0 = (CoreRenderer)renderer;
        return CoreRenderer.resolveWidgetVar(component);
    }

    public static boolean isLiteralText(UIComponent component) {
        return component.getFamily().equalsIgnoreCase("facelets.LiteralText");
    }
}

