/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.menubar;

import com.icesoft.faces.component.CSS_DEFAULT;
import com.icesoft.faces.component.ExtendedAttributeConstants;
import com.icesoft.faces.component.menubar.MenuBar;
import com.icesoft.faces.component.menupopup.MenuPopup;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.w3c.dom.Element;

public class MenuBarRenderer
extends DomBasicRenderer {
    private static final String[] passThruAttributes = ExtendedAttributeConstants.getAttributes(42);
    public static final String PATH_DELIMITER = "-";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        MenuBarRenderer.validateParameters(facesContext, uiComponent, MenuBar.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        if (!domContext.isInitialized()) {
            domContext.createRootElement("div");
        }
        Element menuDiv = (Element)domContext.getRootNode();
        menuDiv.setAttribute("id", uiComponent.getClientId(facesContext));
        MenuBar menuComponent = (MenuBar)uiComponent;
        if (!(uiComponent instanceof MenuPopup) && !((MenuBar)uiComponent).isDisplayOnClick()) {
            menuDiv.setAttribute("onmouseout", "Ice.Menu.hideOnMouseOut('" + uiComponent.getClientId(facesContext) + "',event);");
        }
        String defaultStyle = menuComponent.getComponentRootStyle();
        if ("vertical".equalsIgnoreCase(menuComponent.getOrientation())) {
            defaultStyle = defaultStyle + CSS_DEFAULT.MENU_BAR_VERTICAL_SUFFIX_STYLE;
        }
        String styleClass = menuComponent.getStyleClass();
        menuDiv.setAttribute("class", CoreUtils.addPortletStyleClassToQualifiedClass(styleClass, defaultStyle, "portlet-menu"));
        String style = menuComponent.getStyle();
        if (style != null && style.length() > 0) {
            menuDiv.setAttribute("style", style);
        } else {
            menuDiv.removeAttribute("style");
        }
        DOMContext.removeChildren(menuDiv);
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, passThruAttributes);
        domContext.stepInto(uiComponent);
        this.trailingEncodeBegin(facesContext, uiComponent);
    }

    protected void trailingEncodeBegin(FacesContext facesContext, UIComponent uiComponent) {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        for (int i = 0; i < component.getChildCount(); ++i) {
            MenuBarRenderer.encodeParentAndChildren(context, (UIComponent)component.getChildren().get(i));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        super.encodeEnd(facesContext, uiComponent);
        String call = ((MenuBar)uiComponent).getJsCall(facesContext);
        if (call != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("script", uiComponent);
            writer.write(call);
            writer.endElement("script");
        }
    }
}

