/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.util.Debug;
import com.icesoft.util.pooling.ClientIdPool;
import java.beans.Beans;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlMessage;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public abstract class DomBasicRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog(DomBasicRenderer.class);
    public static final String ATTRIBUTES_THAT_ARE_SET_KEY = "javax.faces.component.UIComponentBase.attributesThatAreSet";
    public static final String ICESUBMITPARTIAL = "iceSubmitPartial(form, this, event);";
    public static final String ICESUBMIT = "iceSubmit(form,this,event);";
    public static final String WEB_UIFORM = "com.sun.rave.web.ui.Form";
    public static final String UIFORM = "javax.faces.form";
    public static final String WEB_UIJSFFORM = "com.sun.webui.jsf.Form";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        CurrentStyle.decode(facesContext, uiComponent);
        DomBasicRenderer.validateParameters(facesContext, uiComponent, null);
        if (!(uiComponent instanceof UIInput)) {
            return;
        }
        if (DomBasicRenderer.isStatic(uiComponent)) {
            return;
        }
        String clientId = uiComponent.getClientId(facesContext);
        Debug.assertTrue(clientId != null, "Client id is not defined for decoding");
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            String decodedValue = (String)requestMap.get(clientId);
            this.setSubmittedValue(uiComponent, decodedValue);
        }
    }

    public void setSubmittedValue(UIComponent uiComponent, Object value) {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DomBasicRenderer.validateParameters(facesContext, uiComponent, null);
        CoreUtils.recoverFacesMessages(facesContext, uiComponent);
        this.renderEnd(facesContext, uiComponent, this.getValue(facesContext, uiComponent));
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        domContext.stepOver();
        JavascriptContext.fireEffect(uiComponent, facesContext);
    }

    public String getValue(FacesContext facesContext, UIComponent uiComponent) {
        Object submittedValue;
        if (uiComponent instanceof UIInput && (submittedValue = ((UIInput)uiComponent).getSubmittedValue()) != null && submittedValue instanceof String) {
            return (String)submittedValue;
        }
        return this.formatComponentValue(facesContext, uiComponent, this.getValue(uiComponent));
    }

    Object getValue(UIComponent uiComponent) {
        return null;
    }

    protected void renderEnd(FacesContext facesContext, UIComponent uiComponent, String currentValue) throws IOException {
    }

    protected String formatComponentValue(FacesContext facesContext, UIComponent uiComponent, Object currentValue) throws ConverterException {
        return DomBasicRenderer.converterGetAsString(facesContext, uiComponent, currentValue);
    }

    public static String converterGetAsString(FacesContext facesContext, UIComponent uiComponent, Object currentValue) {
        if (!(uiComponent instanceof ValueHolder)) {
            if (currentValue != null) {
                return currentValue.toString();
            }
            return null;
        }
        Converter converter = ((ValueHolder)uiComponent).getConverter();
        if (converter == null) {
            if (currentValue == null) {
                return "";
            }
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            converter = DomBasicRenderer.getConverterForClass(currentValue.getClass());
            if (converter == null) {
                return currentValue.toString();
            }
        }
        String ret = converter.getAsString(facesContext, uiComponent, currentValue);
        return ret;
    }

    public static UIComponent findForComponent(FacesContext facesContext, UIComponent uiComponent) {
        String forComponentId = null;
        forComponentId = uiComponent instanceof UIMessage ? ((UIMessage)uiComponent).getFor() : (String)uiComponent.getAttributes().get("for");
        if (forComponentId == null) {
            return null;
        }
        if (forComponentId.length() == 0) {
            return null;
        }
        UIComponent forComponent = uiComponent.findComponent(forComponentId);
        if (forComponent == null) {
            UIComponent nextParent = uiComponent;
            do {
                for (nextParent = nextParent.getParent(); nextParent != null && !(nextParent instanceof NamingContainer); nextParent = nextParent.getParent()) {
                }
            } while (nextParent != null && (forComponent = nextParent.findComponent(forComponentId)) == null);
        }
        if (forComponent == null) {
            forComponent = DomBasicRenderer.searchDownwardsForChildComponentWithId((UIComponent)facesContext.getViewRoot(), forComponentId);
        }
        return forComponent;
    }

    public static String[] getExcludesArray(Set excludes) {
        String[] excludesArray = new String[excludes.size()];
        excludes.toArray(excludesArray);
        return excludesArray;
    }

    private static UIComponent searchDownwardsForChildComponentWithId(UIComponent parent, String searchChildId) {
        UIComponent foundChild = null;
        if (parent.getChildCount() == 0) {
            return foundChild;
        }
        Iterator children = parent.getChildren().iterator();
        UIComponent nextChild = null;
        while (children.hasNext()) {
            nextChild = (UIComponent)children.next();
            if (nextChild instanceof NamingContainer) {
                foundChild = nextChild.findComponent(searchChildId);
            }
            if (foundChild == null) {
                DomBasicRenderer.searchDownwardsForChildComponentWithId(nextChild, searchChildId);
            }
            if (foundChild == null) continue;
            break;
        }
        return foundChild;
    }

    public static void encodeParentAndChildren(FacesContext facesContext, UIComponent parent) throws IOException {
        parent.encodeBegin(facesContext);
        if (parent.getRendersChildren()) {
            parent.encodeChildren(facesContext);
        } else if (parent.getChildCount() > 0) {
            for (UIComponent nextChild : parent.getChildren()) {
                if (!nextChild.isRendered()) continue;
                DomBasicRenderer.encodeParentAndChildren(facesContext, nextChild);
            }
        }
        parent.encodeEnd(facesContext);
    }

    protected static UIComponent getFacetByName(UIComponent uiComponent, String name) {
        UIComponent facet = uiComponent.getFacet(name);
        if (facet == null) {
            return null;
        }
        if (!facet.isRendered()) {
            return null;
        }
        return facet;
    }

    static boolean idNotNull(UIComponent uiComponent) {
        return uiComponent.getId() != null;
    }

    public static void setRootElementId(FacesContext facesContext, Element rootElement, UIComponent uiComponent) {
        if (DomBasicRenderer.idNotNull(uiComponent)) {
            rootElement.setAttribute("id", uiComponent.getClientId(facesContext));
        }
    }

    public static void renderAttribute(UIComponent uiComponent, Element targetElement, String attrNameInComponent, String attrNameInDom) {
        Object attrValue = uiComponent.getAttributes().get(attrNameInComponent);
        if (attrValue != null && !attrValue.equals("")) {
            boolean trueValue;
            if ((attrValue.toString().equalsIgnoreCase("true") || attrValue.toString().equalsIgnoreCase("false")) && !(trueValue = new Boolean(attrValue.toString()).booleanValue())) {
                targetElement.removeAttribute(attrNameInDom.toString());
                return;
            }
            targetElement.setAttribute(attrNameInDom.toString(), attrValue.toString());
        }
    }

    protected static Map getParameterMap(UIComponent uiComponent) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (uiComponent.getChildCount() > 0) {
            for (UIComponent nextChild : uiComponent.getChildren()) {
                if (!(nextChild instanceof UIParameter)) continue;
                UIParameter uiParam = (UIParameter)nextChild;
                parameterMap.put(uiParam.getName(), uiParam.getValue());
            }
        }
        return parameterMap;
    }

    public static void validateParameters(FacesContext facesContext, UIComponent uiComponent, Class validComponentType) {
        if (facesContext == null) {
            throw new NullPointerException("Invalid Parameter - FacesContext instance must not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("Invalid Parameter - UIComponent instance must not be null");
        }
        if (!Beans.isDesignTime() && validComponentType != null && !validComponentType.isInstance(uiComponent)) {
            throw new IllegalArgumentException("Invalid Parameter - UIComponent class should be [" + validComponentType + "] but it is an instance of [" + uiComponent.getClass() + "]");
        }
        if (log.isDebugEnabled() && (uiComponent instanceof UIInput || uiComponent instanceof UICommand) && DomBasicRenderer.findForm(uiComponent) == null) {
            log.debug((Object)("Missing Form - the UIComponent of type [" + uiComponent.getClass() + "] requires a containing form."));
        }
    }

    public static boolean isStatic(UIComponent uiComponent) {
        boolean isStatic = false;
        Object disabled = uiComponent.getAttributes().get("disabled");
        Object readonly = uiComponent.getAttributes().get("readonly");
        if (disabled != null) {
            if (disabled instanceof Boolean) {
                isStatic = (Boolean)disabled;
            } else if (disabled instanceof String) {
                isStatic = ((String)disabled).equalsIgnoreCase("true");
            }
        }
        if (isStatic) {
            return isStatic;
        }
        if (readonly != null) {
            if (readonly instanceof Boolean) {
                return (Boolean)readonly;
            }
            if (readonly instanceof String) {
                return ((String)readonly).equalsIgnoreCase("true");
            }
        }
        return isStatic;
    }

    public static UIComponent findNamingContainer(UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof NamingContainer); parent = parent.getParent()) {
        }
        return parent;
    }

    public static UIComponent findForm(UIComponent uiComponent) {
        UIComponent parent = uiComponent.getParent();
        while (parent != null && !(parent instanceof UIForm)) {
            parent = DomBasicRenderer.findNamingContainer(parent);
        }
        UIComponent form = null;
        if (parent != null && (parent.getFamily().equalsIgnoreCase(WEB_UIFORM) || parent.getFamily().equalsIgnoreCase(UIFORM) || parent.getFamily().equalsIgnoreCase(WEB_UIJSFFORM))) {
            form = parent;
        }
        if (form == null && Beans.isDesignTime()) {
            form = uiComponent.getParent();
        }
        return form;
    }

    String fabricateClientId(UIComponent uiComponent, FacesContext facesContext, String uiComponentId) {
        UIComponent parentNamingContainer = DomBasicRenderer.findNamingContainer(uiComponent);
        String parentNamingContainerClientId = null;
        if (parentNamingContainer == null) {
            return uiComponentId;
        }
        parentNamingContainerClientId = parentNamingContainer.getClientId(facesContext);
        return parentNamingContainerClientId + ':' + uiComponentId;
    }

    protected String[] getColumnStyleClasses(UIComponent uiComponent) {
        return this.getStyleClasses(uiComponent, "columnClasses");
    }

    public String[] getRowStyleClasses(UIComponent uiComponent) {
        return this.getStyleClasses(uiComponent, "rowClasses");
    }

    public String[] getStyleClasses(UIComponent uiComponent, String styleClassAttributeName) {
        String allStyleClasses = (String)uiComponent.getAttributes().get(styleClassAttributeName);
        if (allStyleClasses == null) {
            return new String[0];
        }
        String separator = ",";
        if (allStyleClasses.indexOf(separator) <= 0) {
            separator = " ";
        }
        String[] styleClassesArray = allStyleClasses.trim().split(separator);
        int numberOfStyles = styleClassesArray.length;
        for (int i = 0; i < numberOfStyles; ++i) {
            styleClassesArray[i] = styleClassesArray[i].trim();
        }
        return styleClassesArray;
    }

    static String[] getStyleAndStyleClass(UIComponent uiComponent, FacesMessage facesMessage) {
        String severityStyle = null;
        String severityStyleClass = null;
        String baseStyle = null;
        FacesMessage.Severity messageSeverity = facesMessage.getSeverity();
        if (messageSeverity == FacesMessage.SEVERITY_INFO) {
            severityStyle = (String)uiComponent.getAttributes().get("infoStyle");
            if (uiComponent instanceof HtmlMessage) {
                severityStyleClass = ((HtmlMessage)uiComponent).getInfoClass();
                baseStyle = "iceMsg";
            } else if (uiComponent instanceof HtmlMessages) {
                severityStyleClass = ((HtmlMessages)uiComponent).getInfoClass();
                baseStyle = "iceMsgs";
            }
            if (uiComponent.getRendererType().startsWith("com.icesoft.faces.Message")) {
                severityStyleClass = CoreUtils.addPortletStyleClassToQualifiedClass(severityStyleClass, baseStyle + "Info", "portlet-msg-info");
            }
        } else if (messageSeverity == FacesMessage.SEVERITY_WARN) {
            severityStyle = (String)uiComponent.getAttributes().get("warnStyle");
            if (uiComponent instanceof HtmlMessage) {
                severityStyleClass = ((HtmlMessage)uiComponent).getWarnClass();
                baseStyle = "iceMsg";
            } else if (uiComponent instanceof HtmlMessages) {
                severityStyleClass = ((HtmlMessages)uiComponent).getWarnClass();
                baseStyle = "iceMsgs";
            }
            if (uiComponent.getRendererType().startsWith("com.icesoft.faces.Message")) {
                severityStyleClass = CoreUtils.addPortletStyleClassToQualifiedClass(severityStyleClass, baseStyle + "Warn", "portlet-msg-alert");
            }
        } else if (messageSeverity == FacesMessage.SEVERITY_ERROR) {
            severityStyle = (String)uiComponent.getAttributes().get("errorStyle");
            if (uiComponent instanceof HtmlMessage) {
                severityStyleClass = ((HtmlMessage)uiComponent).getErrorClass();
                baseStyle = "iceMsg";
            } else if (uiComponent instanceof HtmlMessages) {
                severityStyleClass = ((HtmlMessages)uiComponent).getErrorClass();
                baseStyle = "iceMsgs";
            }
            if (uiComponent.getRendererType().startsWith("com.icesoft.faces.Message")) {
                severityStyleClass = CoreUtils.addPortletStyleClassToQualifiedClass(severityStyleClass, baseStyle + "Error", "portlet-msg-error");
            }
        } else if (messageSeverity == FacesMessage.SEVERITY_FATAL) {
            severityStyle = (String)uiComponent.getAttributes().get("fatalStyle");
            if (uiComponent instanceof HtmlMessage) {
                severityStyleClass = ((HtmlMessage)uiComponent).getFatalClass();
            } else if (uiComponent instanceof HtmlMessages) {
                severityStyleClass = ((HtmlMessages)uiComponent).getFatalClass();
            }
        }
        String style = null;
        style = severityStyle != null ? severityStyle : (String)uiComponent.getAttributes().get("style");
        String styleClass = null;
        if (severityStyleClass != null) {
            styleClass = severityStyleClass;
        } else if (uiComponent instanceof HtmlMessage) {
            styleClass = ((HtmlMessage)uiComponent).getStyleClass();
        } else if (uiComponent instanceof HtmlMessages) {
            styleClass = ((HtmlMessages)uiComponent).getStyleClass();
        }
        return new String[]{style, styleClass};
    }

    String[] getSummaryAndDetail(FacesMessage facesMessage) {
        String detail;
        String summary = facesMessage.getSummary();
        if (summary == null) {
            summary = "";
        }
        if ((detail = facesMessage.getDetail()) == null) {
            detail = "";
        }
        return new String[]{summary, detail};
    }

    boolean getToolTipAttribute(UIComponent uiComponent) {
        boolean tooltip = false;
        Object tooltipAttribute = uiComponent.getAttributes().get("tooltip");
        if (tooltipAttribute instanceof Boolean && ((Boolean)tooltipAttribute).booleanValue()) {
            tooltip = true;
        }
        return tooltip;
    }

    static Converter getConverterForClass(Class converterClass) {
        if (converterClass == null) {
            return null;
        }
        try {
            FacesContext ctx = FacesContext.getCurrentInstance();
            Application application = ctx.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getResourceURL(FacesContext context, String path) {
        return CoreUtils.resolveResourceURL(context, path);
    }

    public static String combinedPassThru(String passThru, String renderer) {
        int rendererLen;
        int passThruLen = passThru == null ? 0 : passThru.length();
        int n = rendererLen = renderer == null ? 0 : renderer.length();
        if (passThruLen == 0 && rendererLen == 0) {
            return null;
        }
        if (passThruLen == 0) {
            return renderer;
        }
        if (rendererLen == 0) {
            return passThru;
        }
        return passThru + renderer;
    }

    public String convertClientId(FacesContext context, String clientId) {
        return ClientIdPool.get(clientId);
    }
}

