/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.CurrentStyle;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.RendererUtil;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.util.Arrays;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.icefaces.util.EnvUtils;
import org.w3c.dom.Element;

public class PassThruAttributeRenderer {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String[] passThruAttributeNames = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rows", "rules", "shape", "size", "style", "summary", "tabindex", "target", "title", "usemap", "width", "width", "autocomplete"};
    public static final String[] booleanPassThruAttributeNames = new String[]{"disabled", "ismap", "readonly"};

    public static void renderAttributes(FacesContext facesContext, UIComponent uiComponent, String[] excludedAttributes) {
        PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null, null, excludedAttributes);
    }

    public static void renderAttributes(FacesContext facesContext, UIComponent uiComponent, Element attributeElement, Element styleElement, String[] excludedAttributes) {
        if (excludedAttributes == null) {
            excludedAttributes = new String[]{};
        }
        if (excludedAttributes.length > 0) {
            Arrays.sort(excludedAttributes);
        }
        String[] supportedAttributes = (String[])uiComponent.getAttributes().get(RendererUtil.SUPPORTED_PASSTHRU_ATT);
        attributeElement = PassThruAttributeRenderer.getTargetElement(facesContext, uiComponent, attributeElement);
        if (supportedAttributes == null) {
            PassThruAttributeRenderer.renderNonBooleanAttributes(facesContext, uiComponent, attributeElement, excludedAttributes);
        } else {
            for (int i = 0; i < supportedAttributes.length; ++i) {
                if (excludedAttributes.length > 0 && Arrays.binarySearch(excludedAttributes, supportedAttributes[i]) > -1) continue;
                Object value = null;
                Object v = uiComponent.getAttributes().get(supportedAttributes[i]);
                value = v;
                if (v == null || PassThruAttributeRenderer.attributeValueIsSentinel(value)) continue;
                attributeElement.setAttribute(supportedAttributes[i], value.toString());
            }
        }
        PassThruAttributeRenderer.renderBooleanAttributes(facesContext, uiComponent, attributeElement, excludedAttributes);
        CurrentStyle.apply(facesContext, uiComponent, styleElement, null);
        if (attributeElement == null) {
            Element rootElement;
            DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
            attributeElement = rootElement = (Element)domContext.getRootNode();
        }
        LocalEffectEncoder.encodeLocalEffects(uiComponent, attributeElement, facesContext);
        PassThruAttributeRenderer.renderOnFocus(uiComponent, attributeElement);
        PassThruAttributeRenderer.renderOnBlur(attributeElement);
    }

    public static void renderOnFocus(UIComponent uiComponent, Element root) {
        String nodeName = root.getNodeName();
        if (nodeName.equalsIgnoreCase("a") || nodeName.equalsIgnoreCase("input") || nodeName.equalsIgnoreCase("select")) {
            String original = (String)uiComponent.getAttributes().get("onfocus");
            String onfocus = "setFocus(this.id);";
            String together = DomBasicRenderer.combinedPassThru(original, onfocus);
            root.setAttribute("onfocus", together);
        }
    }

    public static void renderOnBlur(Element root) {
        String nodeName = root.getNodeName();
        if (nodeName.equalsIgnoreCase("a") || nodeName.equalsIgnoreCase("input") || nodeName.equalsIgnoreCase("select")) {
            String original = root.getAttribute("onblur");
            String onblur = "setFocus('');";
            String together = DomBasicRenderer.combinedPassThru(original, onblur);
            root.setAttribute("onblur", together);
        }
    }

    public static void renderBooleanAttributes(FacesContext facesContext, UIComponent uiComponent, Element targetElement, String[] excludedAttributes) {
        Object nextPassThruAttributeValue = null;
        for (int i = 0; i < booleanPassThruAttributeNames.length; ++i) {
            boolean primitiveAttributeValue;
            String nextPassThruAttributeName = booleanPassThruAttributeNames[i];
            if (excludedAttributes.length > 0 && Arrays.binarySearch(excludedAttributes, nextPassThruAttributeName) > -1 || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName)) == null) continue;
            if (nextPassThruAttributeValue instanceof Boolean) {
                primitiveAttributeValue = (Boolean)nextPassThruAttributeValue;
            } else {
                if (!(nextPassThruAttributeValue instanceof String)) {
                    nextPassThruAttributeValue = nextPassThruAttributeValue.toString();
                }
                primitiveAttributeValue = new Boolean((String)nextPassThruAttributeValue);
            }
            if (!primitiveAttributeValue) continue;
            targetElement.setAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeName.toString());
        }
    }

    private static void renderNonBooleanAttributes(FacesContext facesContext, UIComponent uiComponent, Element targetElement, String[] excludedAttributes) {
        String nextPassThruAttributeName = null;
        Object nextPassThruAttributeValue = null;
        for (int i = 0; i < passThruAttributeNames.length; ++i) {
            nextPassThruAttributeName = passThruAttributeNames[i];
            if (excludedAttributes.length > 0 && Arrays.binarySearch(excludedAttributes, nextPassThruAttributeName) > -1 || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName)) == null || PassThruAttributeRenderer.attributeValueIsSentinel(nextPassThruAttributeValue)) continue;
            targetElement.setAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeValue.toString());
        }
    }

    public static boolean attributeValueIsSentinel(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return (Integer)value == Integer.MIN_VALUE;
            }
            if (value instanceof Long) {
                return (Long)value == Long.MIN_VALUE;
            }
            if (value instanceof Short) {
                return (Short)value == Short.MIN_VALUE;
            }
            if (value instanceof Float) {
                return ((Float)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Double) {
                return (Double)value == Double.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return (Byte)value == -128;
            }
        }
        if (value instanceof Character) {
            return ((Character)value).charValue() == '\u0000';
        }
        return false;
    }

    static final String[] getpassThruAttributeNames() {
        return passThruAttributeNames;
    }

    static Element getTargetElement(FacesContext facesContext, UIComponent uiComponent, Element targetElement) {
        if (targetElement == null) {
            DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
            Element rootElement = (Element)domContext.getRootNode();
            if (rootElement == null) {
                throw new FacesException("DOMContext is null");
            }
            targetElement = rootElement;
        }
        return targetElement;
    }

    public static void renderHtmlAttributes(FacesContext facesContext, UIComponent uiComponent, String[] nonBooleanHtmlAttributes) {
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, null, null, nonBooleanHtmlAttributes);
    }

    public static void renderHtmlAttributes(FacesContext facesContext, UIComponent uiComponent, Element attributeElement, Element styleElement, String[] htmlAttributes) {
        boolean stockAttribTracking;
        if (attributeElement == null) {
            DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
            if (domContext == null) {
                throw new FacesException("DOMContext is null");
            }
            Element rootElement = (Element)domContext.getRootNode();
            if (rootElement == null) {
                throw new FacesException("DOMContext is null");
            }
            attributeElement = rootElement;
        }
        boolean attribTracking = (stockAttribTracking = EnvUtils.isStockAttributeTracking()) && uiComponent.getClass().getName().startsWith("javax.faces.component.");
        List attributesThatAreSet = !attribTracking ? null : (List)uiComponent.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        PassThruAttributeRenderer.renderNonBooleanHtmlAttributes(uiComponent, attributeElement, htmlAttributes, attribTracking, attributesThatAreSet);
        CurrentStyle.apply(facesContext, uiComponent, styleElement, null);
        LocalEffectEncoder.encodeLocalEffects(uiComponent, attributeElement, facesContext, null, attribTracking, attributesThatAreSet);
        PassThruAttributeRenderer.renderOnFocus(uiComponent, attributeElement);
        PassThruAttributeRenderer.renderOnBlur(attributeElement);
    }

    private static boolean valueIsIntegerSentinelValue(Object value) {
        if (value instanceof String) {
            return false;
        }
        if (value instanceof Number && value instanceof Integer) {
            return (Integer)value == Integer.MIN_VALUE;
        }
        return false;
    }

    public static void renderNonBooleanHtmlAttributes(UIComponent uiComponent, Element targetElement, String[] nonBooleanhtmlAttributes) {
        PassThruAttributeRenderer.renderNonBooleanHtmlAttributes(uiComponent, targetElement, nonBooleanhtmlAttributes, false, null);
    }

    public static void renderNonBooleanHtmlAttributes(UIComponent uiComponent, Element targetElement, String[] nonBooleanhtmlAttributes, boolean attribTracking, List attributesThatAreSet) {
        if (attribTracking && (attributesThatAreSet == null || attributesThatAreSet.size() == 0)) {
            return;
        }
        String nextPassThruAttributeName = null;
        Object nextPassThruAttributeValue = null;
        for (int i = 0; i < nonBooleanhtmlAttributes.length; ++i) {
            nextPassThruAttributeName = nonBooleanhtmlAttributes[i];
            if (attribTracking && (attributesThatAreSet == null || !attributesThatAreSet.contains(nextPassThruAttributeName)) || (nextPassThruAttributeValue = (Object)uiComponent.getAttributes().get(nextPassThruAttributeName)) == null || PassThruAttributeRenderer.valueIsIntegerSentinelValue(nextPassThruAttributeValue)) continue;
            targetElement.setAttribute(nextPassThruAttributeName.toString(), nextPassThruAttributeValue.toString());
        }
    }

    static {
        Arrays.sort(passThruAttributeNames);
        Arrays.sort(booleanPassThruAttributeNames);
    }
}

